#include <SM.h>//state machine library
#include <SPI.h>
#include <Ethernet.h>
#include "Mudbus.h"

Mudbus Mb;
SM Master(&State10);//add & before the initial state on IDE 1.6.8 and above
SM Machine1(&State20);
SM Machine2(&State30);
SM Machine3(&State40);

int etat = 0;

void setup() {
  uint8_t mac[]     = { 0x90, 0xA2, 0xDA, 0x00, 0x51, 0x06 };
  uint8_t ip[]      = { 192, 168, 1, 8 };
  uint8_t gateway[] = { 192, 168, 1, 1 };
  uint8_t subnet[]  = { 255, 255, 255, 0 };
  Ethernet.begin(mac, ip, gateway, subnet); //Avoid SPI pins, pin 4 and pin 10 when using ethernet shield
  //delay(5000);  //Time to open the terminal
  //Serial.begin(9600); NO!! IF YOU USE tx d0 AS INPUT!!!!!
  pinMode(4, OUTPUT);
  pinMode(5, OUTPUT);
  pinMode(6, OUTPUT);
  pinMode(7, OUTPUT);
  pinMode(26, OUTPUT);
  pinMode(28, OUTPUT);
  pinMode(30, OUTPUT);
  pinMode(32, OUTPUT);
  pinMode(34, OUTPUT);
  pinMode(A0, OUTPUT);
  pinMode(A1, OUTPUT);
  pinMode(A7, OUTPUT);

  DDRE = DDRE | B00001001; //D0 as output and then input, unless: not running
  DDRE = DDRE | B00001000;
  pinMode(14, INPUT);
  pinMode(9, INPUT);
  pinMode(8, INPUT);
  pinMode(15, INPUT);
  pinMode(16, INPUT);
  pinMode(17, INPUT);
  DDRD = DDRD | B00001111; //d18 d19 d20 d21 as output and then input, unless: not running
  DDRD = DDRD | B00000000;
  //pinMode(18, INPUT);//not needed!!!!!
  //pinMode(19, INPUT);
  //pinMode(20, INPUT);
  //pinMode(21, INPUT);
  pinMode(A15, INPUT);
  pinMode(A2, INPUT);
  pinMode(A3, INPUT);
  pinMode(A4, INPUT);
  pinMode(A5, INPUT);
  pinMode(A6, INPUT);
  //Mb.R[20] = 1500;
}
void loop() {
  /*Mb.Run();
  Mb.R[30] = analogRead(A4);
  digitalWrite(3, Mb.R[40]);
  Mb.R[50] = digitalRead(14);*/

  EXEC(Master);
  if (digitalRead(0) == LOW) {
    Machine1.Finish(); Machine2.Finish(); Machine3.Finish();
  }
  if ((digitalRead(0) == HIGH) && Machine1.Finished && Machine2.Finished && Machine3.Finished) {
    EXEC(Machine1);
    Machine1.Set(State20);
    EXEC(Machine2);
    Machine2.Set(State30);
    EXEC(Machine3);
    Machine3.Set(State40);
  }
}

//The Master machine////////////////////////////////////////////////
State State10() {
  digitalWrite(4, LOW);
  digitalWrite(5, LOW);
  digitalWrite(28, LOW);
  digitalWrite(A7, LOW);
  digitalWrite(6, LOW);
  analogWrite(44,0);
  analogWrite(46,0);
  if (digitalRead(0) == HIGH) Master.Set(State11);
}

State State11() {
  digitalWrite(6, HIGH);
  analogWrite(44,(analogRead(A9))/4);
  analogWrite(46,(analogRead(A8))/4);
  EXEC(Machine1);
  EXEC(Machine2);
  EXEC(Machine3);
  if (digitalRead(0) == LOW) Master.Set(State10);
}

//The Machine1////////////////////////////////////////////////////
State State20() {
  digitalWrite(4, LOW);
  
  if (Machine1.Timeout(300)) Machine1.Set(State21) ;
}
State State21() {
  digitalWrite(4, HIGH);
  if (Machine1.Timeout(500)) Machine1.Set(State20) ;
}

//The Machine2////////////////////////////////////////////////////////
State State30() {
  digitalWrite(5, LOW);
  if (Machine2.Timeout(700)) Machine2.Set(State31) ;
}
State State31() {
  digitalWrite(5, HIGH);
  if (Machine2.Timeout(700)) Machine2.Set(State30) ;
}

//The Machine3////////////////////////////////////////////////////////
State State40() {
  digitalWrite(28, LOW);
  if ((RE(digitalRead(1), etat) == 1)) Machine3.Set(State41) ;
}
State State41() {
  digitalWrite(28, HIGH);
  if ((digitalRead(A4) == HIGH))
    digitalWrite(A7, HIGH);
  else digitalWrite(A7, LOW);
  if ((RE(digitalRead(18), etat) == 1)) Machine3.Set(State40) ;
}

