/******************************************************
 Test -  DigiBoard ATtiny-85 Pref 
    from: https://www.instructables.com/member/RonM9

 Ron Miller Jan 2018
*******************************************************/

//#include <EEPROM.h>
// the address in the EEPROM we're going to write to
//int eePerfAddr = 80;   //some what arbitary address
//unsigned long perfCnt;

/*************** DigiBoard ATtiny-85 Active HIGH configuration ************************/
#include "DigiKeyboard.h"          //    (~950 bytes of code overhead w/ DigiKeyboard.h) 
    // some DigiSparks have the onboard Led on pin 0 not 1
    #define ONBOARD_LED  1  
    #define UNUSED_A0 0
    #define PROBE 0
    const byte BEEPPIN = 5;
//    const int button[] = {PB0, PB1, PB2, PB2}; //The four button input pins
    #define PRESSED_STATE 1
    #define BTN_ENB 0
    const int nleds=4;
    const int lites[]  = {PB0, PB1, PB2, PB2};     //the LED pins
    #define ON_STATE 1
//    const byte colorSet[] = { 0, 0x1, 0x2, 0x4, 0x8, 0x0F };
   

bool btn1,btn2,btn3,btn4;
#define btn1Pressed (1 && btn1)
#define btn2Pressed (1 && btn2)
#define btn3Pressed (1 && btn3)
#define btn4Pressed (1 && btn4)
bool ESC = false;
bool time2Escape = false;
//bool lit[14], dim[14], brt[14];  // 12 (1-12) plus [0] &[13] for over flow calculations
//byte levelOn[14]; // for lighting 0-10 levels
unsigned long t0;
//int litPeriod, period, cnt, maxCnt, lastMaxCnt, savedCnt;
int period;

// =====================================================
// Button stuff
/******
bool btnChanged = false;
bool btn1Changed = false;
bool btn2Changed = false;
bool btn3Changed = false;
bool btn4Changed = false;

// made into a function: #define btnPressed (btnChanged && Btn)
#define btn1Pressed (btn1Changed && btn1)
#define btn2Pressed (btn2Changed && btn2)
#define btn3Pressed (btn3Changed && btn3)
#define btn4Pressed (btn4Changed && btn4)

#define  DEBOUNCE_CNT 2
int debounceCnt;
byte btnState = 0, btnNum, priorBtn;
bool btn1;
bool btn2;
bool btn3;
bool btn4;
bool Btn=false; // Buttons collectively
bool ESC = false;
bool time2Escape = false;
int x;

volatile unsigned long myMillis=0; 
//#define myMillis millis()
unsigned long msec, usecs; 
unsigned int mySecs=0, secsIdle=0;

unsigned int msCnt;
unsigned long t0,t1,t2;
int litPeriod, period, cnt, maxCnt, lastMaxCnt, savedCnt;
bool isLit, incDone = false, decDue = false;
byte level, goal;
#define STARTPERIOD 330;

int escCnt=0;
unsigned int idleCnt=0, loopCnt;

// =====================================================
//   LED display stuff

bool lit[14], dim[14], brt[14];  // 12 (1-12) plus [0] &[13] for over flow calculations
byte levelOn[14]; // for lighting 0-10 levels
byte cell[14];  // working buffer
bool dimOn; // true if any led is 'dim' on
int spriteOne, spriteTwo; // mobile hightlights
int heartBeat=0;
int darkOne;      // a mobile dark spot, normally momentary
int spritePtr;    // sprite that is not seen
int cursorPtr;
int litLED=0; // the number of The 'lit' Led
int dimIt=0; // the number of the led to 'dim' off 
int flashLed, blinkLed;
byte allColor=0;  //  0: none, bits: 1:RED, 2:YEL, 3:GRN, 4:BLUE, 5:ALL

/*******  IF we Find enough memory space, reinstate ....
int Vcc, v3;
//======================================================
long readVcc() {
  ADMUX = _BV(REFS0) | _BV(MUX3) | _BV(MUX2) | _BV(MUX1);
  delay(2); // Wait for Vref to settle typical: +/-.03 (1) is good @ +/-.06
  ADCSRA |= _BV(ADSC); // Start conversion
  while (bit_is_set(ADCSRA,ADSC)); // measuring

  delay(2); // settling
  uint8_t low  = ADCL; // must read ADCL first - it then locks ADCH  
  uint8_t high = ADCH; // unlocks both
 
  long result = (high<<8) | low;
 
  result = 1125300L / result; // Calculate Vcc (in mV); 1125300 = 1.1*1023*1000
//  result = 1126400L / result; // Calculate Vcc (in mV); 1126400 = 1.1*1024*1000
  return result; // Vcc in millivolts
}

//======================================================
int checkVoltage() {
  Vcc=readVcc();  // print out the voltage (Vcc) value
  DigiKeyboard.print("Vcc = "); DigiKeyboard.print(Vcc/1000); DigiKeyboard.print("."); Serial.println(Vcc%1000); 
  return (Vcc);
}
********/

byte litLED, brtLED;
unsigned int ledCnt;

// the setup routine runs once on power up or when you press reset:
//===============================================================================
void setup() {
  // initialize serial communication and its Baud rate
  //  Serial.begin(9600);

DigiKeyboard.println("        ATtiny-85 Perf Test ");

  pinMode(ONBOARD_LED, OUTPUT);
  pinMode(PROBE, INPUT);

}


// the loop routine runs over and over again forever:
// ===============================================================================
void loop() {
  PerfTest();
  //VOMeter();
  //EEPROM.write(eePerfAddr, perfCnt & 0xFF); 
  //EEPROM.write(eePerfAddr, perfCnt >> 8);  
}

// =====================================================================
void PerfTest() {  // ==============  BENCHMARK Testing    (~950 bytes of code w/ DigiKeyboard.h)
  // This code is intensionally not optimized, due to benchmarking purposes.    Rons "MCU Marks"
  // AtMega328 16MHz:     MPU Marks = 5100
  // ATtiny-85 16.5MHz:    "    "     4200  apparently it has some compromizes in performance      
  
  int n;
  bool audLvl=LOW, audio=false, prtEnb=true;
  // without =assignment auLvl may have been true||false But may have been 0x10 (or Undefined?) and not worked for digitalWrite
  unsigned long readings, msecs, mStart, ms, lastms;
  int tenths, rawA, oneCnt, secs=0;
  float v;
  long avgA=0;  // were long
//  double floatA=0.0;
  float floatA=0.0;

//  clearDisp();
///  wait_BtnRelease();
  while (!ESC) {
    mStart = 0;
    while (mStart<100)  {  // One second loop
      lastms=msecs = millis();
      while (msecs == millis()) ; // scyn to a starting tick
      while ((ms=millis())-msecs <= 10) {      // Ten milliSec testing loop
        readings++;
        // continuous Analog Reading
        rawA = analogRead(PROBE);
        avgA = (15 * avgA + rawA) >> 4;  // running average math
        floatA = sqrt(((floatA*floatA)  + (float) avgA*avgA) / 2.0);
        // have Analog In directly drive audio in real time
        // digial write to our Analog In, switching in/out the pull-up to keep line active, for consistent calculation load
        digitalWrite(PROBE, !digitalRead(PROBE)); // do both a digital Read & Write

        if (ms!=lastms) {   // every One millisec
          lastms=ms;
//          digitalWrite(BEEPPIN, ms&1);  // always output even when you get no audio
          digitalWrite(ONBOARD_LED, rawA<floatA);  // flash the on board led
        }
      }
      mStart++;

      // ------------------------------  once every Ten milliSec ...
      v = (((float)4.6 * avgA) / 1024.0);
      // reflect reading on Led display
//      digitalWrite(lites[litLED-1], !ON_STATE);
//      litLED = brtLED;
//      brtLED = avgA/(1024/nleds)+1;
//      updateLEDs();
    }
    
    // --------------------------------  once a Second ...
    // the following is outside the test loop, & dont effect results 
//    clearDisp();
//    delay(333);
//    showLevel(readings/1000);
//    for (int i=0; i<readings/1000; i++) {
//      digitalWrite(ONBOARD_LED,1);
//      delay(500);
//      digitalWrite(ONBOARD_LED,0);
//      delay(500);
//    }
    
    
    
//    perfCnt = readings;
//    if (4==secs++) {
//      EEPROM.write(eePerfAddr, perfCnt & 0xFF); 
//      EEPROM.write(eePerfAddr+1, perfCnt >> 8);
//      delay(10); 
//    }
    
     // output updated readings and stats
      DigiKeyboard.print("Avg  Ain = "); DigiKeyboard.print(floatA);
      DigiKeyboard.print("  Vin = "); DigiKeyboard.print(v); //DigiKeyboard.print("v  ");
      DigiKeyboard.println(readings);
      DigiKeyboard.delay(1000);    // allow time for the SIO to complete

    readings=0;
  }
}

//****/

// ===================================================================================
//        Display Output Processing

// ----------------------
/**************
void clearDisp() {
  if (litLED!=0) digitalWrite(lites[litLED-1], !ON_STATE);
  if (brtLED!=0) digitalWrite(lites[brtLED-1], !ON_STATE);
  litLED = brtLED = 0;
}  

void updateLEDs() {
    ledCnt++;
    int lit = (ledCnt%3)==0;
    digitalWrite(lites[litLED-1], lit);
    digitalWrite(lites[brtLED-1], ON_STATE);
}

// -----------------------

void showLevel(byte level) {
  int n, dur;
  clearDisp();
  for (int i=0; i<level; i++) {
    n = (i%nleds)+1;
//    dim[n]=true;
//    spriteOne=n;
    litLED = brtLED;
    brtLED = n;
    dur=200;
    while (dur>0) {
      dur--; 
      delay(1);
      updateLEDs();
    }
  }
  delay(200);
}
*****************/
