package com.example.germt.autojoystick;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.view.View;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.Toast;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ajSettingsActivity extends AppCompatActivity {

    //наименование файла настроек и параметров для сохранения в настройках
    public static final String APPSETTINGS = "ajsettings";
    public static final String SRVRIP = "server_ip";
    public static final String SRVPRT = "server_port";
    public static final String AUTOCONNECT = "autoconnect";
    public static final String MYWIFISSID = "wifi_ssid";

    private SharedPreferences mPrefs;//объект, который отвечает за сохранение настроек
    private String mwfSSID="ESP8266";//имя сети
    private String mSrvIp="192.168.4.1";//IP-адрес машинки
    private int mSrvPrt=333;//номер порта, на котором машинка общается с нами
    private boolean mSrvAutoconn = false;

    private EditText mIPaddrEditText, mPORTnumEditText, mWFSSIDEditText;
    private CheckBox mAuCoCheckBox;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_aj_settings);

        Toolbar toolbar = (Toolbar) findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        toolbar.setNavigationOnClickListener(new View.OnClickListener() {//без этого вылетает приложение при нажатии кнопки "домой" в тулбаре
            @Override
            public void onClick(View v) {
                // perform whatever you want on back arrow click
                finish();
            }
        });

        mPrefs = getSharedPreferences(APPSETTINGS, Context.MODE_PRIVATE);

        //считываем настройки
        mwfSSID = mPrefs.getString(MYWIFISSID, "ESP8266");
        mSrvIp = mPrefs.getString(SRVRIP, "192.168.4.1");
        mSrvPrt = mPrefs.getInt(SRVPRT, 333);
        mSrvAutoconn = mPrefs.getBoolean(AUTOCONNECT, false);

        mWFSSIDEditText = (EditText) findViewById(R.id.wifi_ssid_edit);
        mWFSSIDEditText.setText(mwfSSID);
        mIPaddrEditText = (EditText) findViewById(R.id.ip_address_edit);
        mIPaddrEditText.setText(mSrvIp);
        mPORTnumEditText = (EditText) findViewById(R.id.port_number_edit);
        mPORTnumEditText.setText(String.valueOf(mSrvPrt));
        mAuCoCheckBox = (CheckBox) findViewById(R.id.autoconnect_en);
        mAuCoCheckBox.setChecked(mSrvAutoconn);
    }

    public void onWriteSettingsClick(View view) {
        Resources res = getResources();
        String str = mIPaddrEditText.getText().toString().trim();
        if (validIPaddr(str)){
            mSrvIp = str;
        }else {
            str = str + " - " + res.getString(R.string.toast_pref_ip_error);
            Toast.makeText(getApplicationContext(), str, Toast.LENGTH_LONG).show();
            mIPaddrEditText.setText(mSrvIp);
            return;
        }
        str = mPORTnumEditText.getText().toString().trim();
        int tmp = takeNumPrtStr(str);
        if (tmp == 0){
            str = str + " - " + res.getString(R.string.toast_pref_port_error);
            Toast.makeText(getApplicationContext(), str, Toast.LENGTH_LONG).show();
            mPORTnumEditText.setText(mSrvPrt);
            return;
        } else {
            mSrvPrt = tmp;
        }
        mSrvAutoconn = mAuCoCheckBox.isChecked();
        mwfSSID = mWFSSIDEditText.getText().toString();

        SharedPreferences.Editor editor = mPrefs.edit();
        editor.putString(MYWIFISSID, mwfSSID);
        editor.putString(SRVRIP, mSrvIp);
        editor.putInt(SRVPRT, mSrvPrt);
        editor.putBoolean(AUTOCONNECT, mSrvAutoconn);
        editor.apply();

        finish();//можно выходить из настроек
    }
    //проверяем правильность ввода IP адреса
    private boolean validIPaddr(String ip){
        Pattern p = Pattern.compile("^([01]?\\d\\d?|2[0-4]\\d|225[0-5])\\."+
                "([01]?\\d\\d?|2[0-4]\\d|225[0-5])\\." +
                "([01]?\\d\\d?|2[0-4]\\d|225[0-5])\\." +
                "([01]?\\d\\d?|2[0-4]\\d|225[0-5])$");
        Matcher m = p.matcher(ip);
        return m.matches();
    }
    //вытаскиваем из строки номер порта
    private int takeNumPrtStr(String port){
        int r;
        try{
            r = Integer.parseInt(port);
        }catch (Exception e){
            return 0;
        }
        if (r>0 && r<65535) {
            return r;
        }else {
            return 0;
        }
    }
}
