package com.example.germt.autojoystick;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Message;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import java.io.*;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;

/**
 * Created by germt on 17.02.2018.
 */

public class TCPClient {

    public static final String HNDLKEY = "SRV_MSG";//ключ, по которому определяется сообщение от машинки
    public static final String SKT_ERR = "skt_error";//ошибка создания сокета
    public static final String SKT_RD_ERR = "skt_read_error";//ошибка чтения данных с сокета
    public static final String NOCONNTOMYWIFI = "no_conn_mywifi";//нет подключения к требуемой WiFi сети

    //точка подключения
    private String MYWIFISSID;
    private String SRVIP;
    private int SRVPRT;
    //строка сообщения от сервера
    private String mSrvMsg;
    //флаг наличия соединения
    private boolean mRun=false;
    //буфер передачи сообщений серверу
    private PrintWriter mBufOut;
    //буфер приёма сообений от сервера
    private BufferedReader mBufIn;

    //конструктор класса
    public TCPClient(String ip, int port, String wf_ssid){
        SRVIP = ip;
        SRVPRT = port;
        MYWIFISSID = wf_ssid;
    }
    public boolean testConnection(){
        return mRun;
    }

    //разорвать соединение и освободить ресурсы
    public void stopClient(){
        mRun=false;
        if (mBufOut!=null){
            mBufOut.flush();
            mBufOut.close();
        }
        mBufOut=null;
        mBufIn=null;
        mSrvMsg=null;
    }

    //функция отправки сообщения серверу, в качестве параметра ппринимает строку сообщения
    public int SendMessage(String msg){
        if (mBufOut!=null && !mBufOut.checkError()){
            mBufOut.println(msg);
            //mBufOut.write(msg);
            //mBufOut.flush();
            return 0;
        }else {
            if (mBufOut==null){
                return 1;//ошибка 1 - mBufOut is null
            } else {
                return 2;//ошибка 2 - какая то ошибка mBufOut
            }
        }
    }

    //подключение к серверу
    public void runClient(Handler hndlr, Context context){
        Message message;
        Bundle bundle = new Bundle();

        //проверяем имя подключенной WiFi сети
        if (!getwifiName(context).equalsIgnoreCase(MYWIFISSID)){
            //отправляем сообщение об ошибке для UIThread посредством android.os.Handler
            message = hndlr.obtainMessage();//сообщение
            bundle.putString(HNDLKEY, NOCONNTOMYWIFI);
            message.setData(bundle);
            hndlr.sendMessage(message);
            return;
        }

        mRun=true;
        try{
            InetAddress srvAddr=InetAddress.getByName(SRVIP);
            //Log.e("TCP Client", "Соединение...");
            //создаём соединение
            Socket sckt = new Socket(srvAddr, SRVPRT);
            try {
                //подключаем буфер отправки
                mBufOut = new PrintWriter(new BufferedWriter(new OutputStreamWriter(sckt.getOutputStream())), true);
                //подключаем буфер приёма
                mBufIn = new BufferedReader(new InputStreamReader(sckt.getInputStream()));

                //пока соединение есть слушаем входящие сообщения от сервера
                while (mRun){
                    mSrvMsg = mBufIn.readLine();
                    if (!mSrvMsg.isEmpty()){
                        //отправляем сообщение для UIThread посредством android.os.Handler
                        message = hndlr.obtainMessage();//сообщение
                        bundle.putString(HNDLKEY, mSrvMsg);
                        message.setData(bundle);
                        hndlr.sendMessage(message);
                    }
                }
                //Log.e("MESSAGE FROM SERVER", "Получено сообщение: '" + mSrvMsg + "'");
            } catch (Exception e){
                Log.e("TCP", "Ошибка", e);
                //отправляем сообщение об ошибке для UIThread посредством android.os.Handler
                message = hndlr.obtainMessage();//сообщение
                bundle.putString(HNDLKEY, SKT_RD_ERR);
                message.setData(bundle);
                hndlr.sendMessage(message);
            } finally {
                //сокет должен быть закрыт, невозможно подключиться
                sckt.close();
            }
        } catch (Exception e){
            Log.e("TCP", "Ошибка", e);
            //отправляем сообщение об ошибке для UIThread посредством android.os.Handler
            message = hndlr.obtainMessage();//сообщение
            bundle.putString(HNDLKEY, SKT_ERR);
            message.setData(bundle);
            hndlr.sendMessage(message);
        }
    }
    public String getwifiName(Context context){
        //проверяем наличие подключения к нужной WiFi сети
        String wf_ssid = "---";
        WifiManager manager = (WifiManager) context.getSystemService(Context.WIFI_SERVICE);
        if (manager.isWifiEnabled()) {
            WifiInfo wifiInfo = manager.getConnectionInfo();
            if (wifiInfo != null) {
                NetworkInfo.DetailedState state = WifiInfo.getDetailedStateOf(wifiInfo.getSupplicantState());
                if (state == NetworkInfo.DetailedState.CONNECTED || state == NetworkInfo.DetailedState.OBTAINING_IPADDR) {
                    wf_ssid = wifiInfo.getSSID();
                    wf_ssid = wf_ssid.replace("\"", "");
                }
            }
        }
        return wf_ssid;
    }

}