package com.example.germt.autojoystick;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.view.MotionEvent;
import android.view.View;
import android.view.Menu;
import android.view.MenuItem;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;

public class MainActivity extends AppCompatActivity {

    //наименование файла настроек и параметров для сохранения в настройках
    public static final String APPSETTINGS = "ajsettings";
    public static final String SRVRIP = "server_ip";
    public static final String SRVPRT = "server_port";
    public static final String AUTOCONNECT = "autoconnect";
    public static final String MYWIFISSID = "wifi_ssid";

    public static final String HNDLKEY = "SRV_MSG";//ключ, по которому определяется сообщение от машинки
    public static final String SKT_ERR = "skt_error";//ошибка создания сокета
    public static final String SKT_RD_ERR = "skt_read_error";//ошибка чтения данных с сокета
    public static final String NOCONNTOMYWIFI = "no_conn_mywifi";//нет подключения к требуемой WiFi сети
    public static final String READY = "ready";//машина готова принять команду

    private TextView mTxtView;//для отладки

    private TCPClient mTcpClient;//объект, который отвечает за сетевой обмен с ардуино по WiFi
    private SharedPreferences mPrefs;//объект, который отвечает за сохранение настроек
    private String mwfSSID;
    private String mSrvIp;
    private int mSrvPrt;
    private boolean mSrvAutoconn;

    private ImageView mImageView;
    private String mDrive;//куда едем: A - вперёд, B - назад
    private int mDvol;//как быстро едем 0...9
    private String mPov;//куда поворачиваем: С - вправо, D - влево
    private int mPvol;//как быстро поворачиваем 0...9
    private int mCntrX, mCntrY;//центральная точка джойстика
    private int mRmaX, mRmaY;//максимальный размер джойстика

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        Toolbar toolbar = (Toolbar) findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);

        mTxtView = (TextView) findViewById(R.id.textView1);

        mImageView = (ImageView) findViewById(R.id.imageView1);//джойстик
        mPrefs = getSharedPreferences(APPSETTINGS, Context.MODE_PRIVATE);

        //считываем настройки
        mwfSSID = mPrefs.getString(MYWIFISSID, "ESP8266");
        mSrvIp = mPrefs.getString(SRVRIP, "192.168.4.1");
        mSrvPrt = mPrefs.getInt(SRVPRT, 333);
        mSrvAutoconn = mPrefs.getBoolean(AUTOCONNECT, false);

        //инициализируем движение, как A0C0 - то есть стоим на месте
        mDrive = "A";
        mDvol = 0;
        mPov = "C";
        mPvol = 0;

        View.OnTouchListener handleTouch = new View.OnTouchListener() {
            @Override
            public boolean onTouch(View view, MotionEvent motionEvent) {
                double alfa=0;
                //инииализируем начальные данные для расчёта команды движения
                mRmaX = mImageView.getWidth() / 2;
                mRmaY = mImageView.getHeight() / 2;
                if (Build.VERSION.SDK_INT>=Build.VERSION_CODES.KITKAT) {
                    //вычисление центра для андроид 4.4 и выше
                    mCntrX = (int) mImageView.getPivotX();
                    mCntrY = (int) mImageView.getPivotY();
                } else {
                    //вычисление центра для андроид 4.3 и ниже
                    mCntrX = (int) mImageView.getPivotX() + mRmaX;
                    mCntrY = (int) mImageView.getPivotY() + mRmaY;
                }
                int x = (int) motionEvent.getX();
                int y = (int) motionEvent.getY();
                switch (motionEvent.getAction()) {
                    case MotionEvent.ACTION_MOVE:
                        //выбираем направление движения
                        if ((y - mCntrY) > 0) {
                            mDrive = "B";
                        } else {
                            mDrive = "A";
                        }
                        if ((x - mCntrX) < 0) {
                            mPov = "D";
                        } else {
                            mPov = "C";
                        }
                        //вычисляем запрашиваемую скорость и величину поворота в проекции на круг
                        if(((x-mCntrX)==0) || ((y-mCntrY)==0)){
                            if((y-mCntrY)==0){
                                mDvol = 0;
                                if((x-mCntrX)==0){
                                    mPvol = 0;
                                }else {
                                    mPvol = (int) Math.floor(10*Math.abs(x-mCntrX)/mRmaX);
                                }
                            }else {
                                mPvol = 0; //т.к. (x-mCntrX)=0
                                mDvol = (int) Math.floor(10*Math.abs(y-mCntrY)/mRmaY);
                            }
                        }else {
                            alfa = Math.toDegrees(Math.atan(Math.abs((float) (y-mCntrY)/ (float) (x-mCntrX))));
                            if ((alfa>=0) && (alfa<=45)){
                                mDvol = (int) Math.floor(10f*Math.abs((float)(y-mCntrY))/((float)mRmaY*Math.cos(Math.toRadians(alfa))));
                                mPvol = (int) Math.floor(10f*Math.abs((float)(x-mCntrX))/((float)mRmaX*Math.cos(Math.toRadians(alfa))));
                            }else {
                                mDvol = (int) Math.floor(10f*Math.abs((float)(y-mCntrY))/((float)mRmaY*Math.sin(Math.toRadians(alfa))));
                                mPvol = (int) Math.floor(10f*Math.abs((float)(x-mCntrX))/((float)mRmaX*Math.sin(Math.toRadians(alfa))));
                            }
                        }
                        //вычисляем запрашиваемую скорость
                        //mDvol = (int) Math.round(10 * Math.abs(y - mCntrY) / mRmaY);//-это квадрат
                        if (mDvol > 9) {
                            mDvol = 9;
                        }
                        //вычисляем запрашиваемую величину поворота
                        //mPvol = (int) Math.round(10 * Math.abs(x - mCntrX) / mRmaX);//-это квадрат
                        if (mPvol > 9) {
                            mPvol = 9;
                        }
                        break;
                    case MotionEvent.ACTION_UP:
                        mDrive = "A";
                        mDvol = 0;
                        mPov = "C";
                        mPvol = 0;
                        break;
                }
                // для отладки
                //String msg = mDrive + mDvol + mPov + mPvol;
                //mTxtView.setText(msg);
                return true;
            }
        };
        mImageView.setOnTouchListener(handleTouch);
    }

    @Override
    protected void onDestroy(){
        //разрываем соединение, если оно создано
        if (mTcpClient != null) {
            mTcpClient.stopClient();// останавливаем обмен и разрываем соединение
            mTcpClient = null;
            Toast.makeText(getApplicationContext(), R.string.toast_conn_broken, Toast.LENGTH_SHORT).show();
        }

        super.onDestroy();
    }

    @Override
    protected void onResume() {
        super.onResume();

        //если настройки изменились, нужно создать соединение заново
        String wf = mwfSSID;//запомнили старые настройки
        String si = mSrvIp;//запомнили старые настройки
        int sp = mSrvPrt;//запомнили старые настройки

        //считываем настройки
        mwfSSID = mPrefs.getString(MYWIFISSID, "ESP8266");
        mSrvIp = mPrefs.getString(SRVRIP, "192.168.4.1");
        mSrvPrt = mPrefs.getInt(SRVPRT, 333);
        mSrvAutoconn = mPrefs.getBoolean(AUTOCONNECT, false);


        if(mSrvAutoconn && mTcpClient==null){//автозапуск соединения
            wf = mwfSSID;//во избежание лишних переподключений
            si = mSrvIp;//во избежание лишних переподключений
            sp = mSrvPrt;//во избежание лишних переподключений
            Runnable runnable = new Runnable() {
                        @Override
                        public void run() {
                            mTcpClient = new TCPClient(mSrvIp, mSrvPrt, mwfSSID);//создаём экземпляр класса
                            mTcpClient.runClient(mHndlr, getApplicationContext());//запускаем процесс обмена
                        }
            };
            Thread thread = new Thread(runnable); //создаём новый поток
            thread.start();//запускаем соединение и обмен данными
        }
        if(si.compareTo(mSrvIp)!=0 || sp!=mSrvPrt || wf!=mwfSSID){//если настройки изменились то отключаемся
            if (mTcpClient!=null){
                mTcpClient.stopClient();// останавливаем обмен и разрываем соединение
                mTcpClient = null;
            }
        }
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.menu_main, menu);
        return true;
    }

    @Override
    public boolean onPrepareOptionsMenu(Menu menu) {
        if (mTcpClient != null) {
            if (mTcpClient.testConnection()){
                menu.getItem(1).setEnabled(true);
                menu.getItem(0).setEnabled(false);
            }else {
                menu.getItem(1).setEnabled(false);
                menu.getItem(0).setEnabled(true);
            }
        } else {
            menu.getItem(1).setEnabled(false);
            menu.getItem(0).setEnabled(true);
        }
        return super.onPrepareOptionsMenu(menu);
    }
    Handler mHndlr = new Handler() {
        @Override
        public void handleMessage(Message msg) {
            Bundle bundle = msg.getData();
            String zprs = bundle.getString(HNDLKEY).trim();
            if (zprs.substring(0, 5).equals(READY)) {
                if (mTcpClient != null) {
                    //отвечаем на запрос
                    Runnable runnable = new Runnable() {
                        @Override
                        public void run() {
                            mTcpClient.SendMessage(mDrive + mDvol + mPov + mPvol); //отвечаем на запрос
                        }
                    };
                    Thread thread = new Thread(runnable); //создаём новый поток
                    thread.start();//запускаем соединение и обмен данными
                } else {
                    Toast.makeText(getApplicationContext(), R.string.toast_err_no_connection, Toast.LENGTH_LONG).show();
                }
                if (zprs.length()>=14) {//формат сообщения от машинки: readyXXXYYYZ.Z
                    String tmp = String.format(getResources().getString(R.string.textView_text),
                            zprs.substring(5, 8), zprs.substring(8, 11), zprs.substring(11, 14));
                    mTxtView.setText(tmp);
                }else{
                    mTxtView.setText(zprs);//если сообщение слишком короткое, то посмотрим, что пришло
                }
            } else if (zprs.equals(NOCONNTOMYWIFI)){
                Toast.makeText(getApplicationContext(), R.string.toast_err_no_conn_mywifi, Toast.LENGTH_LONG).show();
                if (mTcpClient != null){
                    mTcpClient.stopClient();// останавливаем обмен и разрываем соединение
                }
                mTcpClient = null;
            } else if (zprs.equals(SKT_ERR)) {//опаньки! ошибка создания сокета
                Toast.makeText(getApplicationContext(), R.string.toast_err_skt_err, Toast.LENGTH_LONG).show();
                if (mTcpClient != null){
                    mTcpClient.stopClient();// останавливаем обмен и разрываем соединение
                }
                mTcpClient = null;
            }else if (zprs.equals(SKT_RD_ERR)) {//опаньки! ошибка чтения из сокета
                Toast.makeText(getApplicationContext(), R.string.toast_err_skt_read_err, Toast.LENGTH_LONG).show();
                if (mTcpClient != null){
                    mTcpClient.stopClient();// останавливаем обмен и разрываем соединение
                }
                mTcpClient = null;
            }
        }
    };

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        switch (item.getItemId()) {
            case R.id.action_connect:
                Runnable runnable = new Runnable() {
                    @Override
                    public void run() {
                        mTcpClient = new TCPClient(mSrvIp, mSrvPrt, mwfSSID);//создаём экземпляр класса
                        mTcpClient.runClient(mHndlr, getApplicationContext());//запускаем процесс обмена
                    }
                };
                Thread thread = new Thread(runnable); //создаём новый поток
                thread.start();//запускаем соединение и обмен данными
                return true;
            case R.id.action_disconnect:
                if (mTcpClient != null){
                    mTcpClient.stopClient();// останавливаем обмен и разрываем соединение
                    mTcpClient = null;
                }
                return true;
            case R.id.action_settings://вызываем окно настроек
                Intent intent = new Intent(this, ajSettingsActivity.class);
                startActivity(intent);
                return true;
            default:
                return super.onOptionsItemSelected(item);
        }
    }
}