#include "FastLED.h"

#define NUM_STRIPS 6 // number of strips
#define NUM_LEDS 6 // number of leds per strip

CRGB leds[NUM_STRIPS][NUM_LEDS]; // sets up LED object
CRGB edgeLEDs[8];

// DEFINE COLORS (note: R B G, NOT R G B)
// basic colors
#define red 0xff0000
#define coral 0xff3333
#define pink 0xff7700
#define purple 0x99ff00
#define indigo 0x55ff00
#define blue 0x00ff00
#define teal 0x0077ff
#define green 0x0000ff
#define lime 0x6600ff
#define yellow 0xbb008f //0x8f008f
#define orange 0xff0077

// pale means lightly colored
#define paleBlue 0x11ff99//0x33ff99
#define paleOrange 0x883399//0xff3399
#define paleYellow 0x58338f//0x8f338f

// dim means faintly lit
#define dimPurple 0x226600//0x224400
#define dimIndigo 0x118800//0x114400

// various white tones
#define white 0x7affff//0xffffff
#define whiteHalf 0x234444//0x444444
#define whiteQuarter 0x001111
#define coolWhite 0xccffcc
#define warmWhite 0xff66cc

#define nolight 0x000000


// variables for running patterns
unsigned long pattern[5];
int length;
int frames;
int framerate;
int edgeLength;


// variables for button stuff (has debounce)
const int buttonPin = 2;    // the number of the pushbutton pin
volatile const int limit = 7; // for reseting the button counter; highest case code will go to
volatile int counter = 0;
volatile int state = LOW;
int old_counter = 0;


void setup(){
  FastLED.addLeds<TM1803, 8>(leds[0], NUM_LEDS); // assigns pin 8 to control leds in first row of array
  FastLED.addLeds<TM1803, 9>(leds[1], NUM_LEDS);
  FastLED.addLeds<TM1803, 10>(leds[2], NUM_LEDS);
  FastLED.addLeds<TM1803, 11>(leds[3], NUM_LEDS);
  FastLED.addLeds<TM1803, 12>(leds[4], NUM_LEDS);
  FastLED.addLeds<TM1803, 13>(leds[5], NUM_LEDS);
  
  FastLED.addLeds<TM1803, 7>(edgeLEDs, 8); // edge leds
  
  pinMode(buttonPin, INPUT);
  attachInterrupt(0, changeLED, RISING); // interrupt increases counter when button is pushed
  
  Serial.begin(9600);
  delay(100);
}


void loop() {
  
  Serial.println(counter);
  Serial.println(old_counter);
  
  if (old_counter != counter){ // if case is changing, clear leds to keep color from carrying over
    clearLEDs();
    if (counter ==4){
        for (int i = 0; i<NUM_STRIPS; i++){ // loop through strips
          for (int y = 0; y<NUM_LEDS; y++){ // loop through leds
            leds[i][y] = whiteHalf; // automatically set color for specific led from array
          }
        }
        for (int z = 0; z<8; z++){
          edgeLEDs[z] = whiteHalf;
        }
     }
    delay(100);     
  }
  
  old_counter = counter;
  
  switch (counter){ 
  // case for each pattern; define colors and framerate
  
  case 0: // cool broken wave: edge is wave of same colors
      {long pattern[] = {purple, indigo, blue, teal, green, teal, blue, indigo};
      length = sizeof(pattern)/sizeof(long); // calculates length of array
      frames = length; // assuming that patterns are one complete rotation of array
      framerate = 200;
    
      for(int x = 0; x < frames; x++) { // loop through frames
       for (int i = 0; i<NUM_STRIPS; i++){ // loop through strips
         // set top colors
         for (int y = 0; y<NUM_LEDS; y++){ // loop through leds

           leds[i][y] = pattern[(x+y+i)%length]; // automatically set color for specific led from array
         }
       }
        
       //if (state == HIGH){ // exits case when button is pressed
          //state = LOW;
          //break; } 
          
       // set edge colors
       for (int z = 0; z<8; z++){
        edgeLEDs[z] = pattern[(x+z)%length];
       }
       
       if (state == HIGH){ // exits case when button is pressed
          state = LOW;
          break; }         
        
       FastLED.show();
       delay(framerate);               
        }}
      break;
      
  case 1: // warm solid wave: edge is wave of same colors
      {long pattern[] = {coral, red, orange, yellow, orange, red};
      length = sizeof(pattern)/sizeof(long); // calculates length of array
      frames = length; // assuming that patterns are one complete rotation of array
      framerate = 200;

      for(int x = 0; x < frames; x++) { // loop through frames
       for (int i = 0; i<NUM_STRIPS; i++){ // loop through strips
         for (int y = 0; y<NUM_LEDS; y++){ // loop through leds

           leds[i][y] = pattern[(x+y)%length]; // automatically set color for specific led from array
           }
         }
       //if (state == HIGH){ 
          //state = LOW;
         // break; }
          
       // set edge colors
       for (int z = 0; z<8; z++){
        edgeLEDs[z] = pattern[(x+z)%length];
       }
       
       if (state == HIGH){ // exits case when button is pressed
          state = LOW;
          break; } 
        
       FastLED.show();
       delay(framerate);
        }}
      break;
      
  case 2: // comet-type pattern (back and forth): edge is wave of same colors as in comet
      {long pattern[] = {nolight, nolight, nolight, nolight, nolight, nolight, white, paleYellow, paleOrange, nolight, nolight, nolight, nolight, nolight, nolight};//nolight, nolight, nolight, nolight, nolight, nolight, whiteQuarter, whiteHalf, white, nolight};
      length = sizeof(pattern)/sizeof(long); // calculates length of array
      frames = length; // assuming that patterns are one complete rotation of array
      framerate = 75;
      
      long edgePattern[] = {white, white, paleYellow, paleYellow, paleOrange, paleOrange};
      edgeLength = sizeof(edgePattern)/sizeof(long);
      
      
      for (int i = 0; i<NUM_STRIPS; i++){ // loop through strips
        for(int x = 0; x < frames; x++) { // loop through frames
          // even strips
          if (i%2 == 0){ 
            for (int y = 0; y<NUM_LEDS; y++){ // loop through leds

             leds[i][y] = pattern[(x+y)%length]; // automatically set color for specific led from array
             }
           
            //FastLED.show();
           // delay(framerate);  
         }
         
         if (state == HIGH){
            break; }
         
         // odd strips   
         if (i%2 != 0){ 
             for (int y = 0; y<NUM_LEDS; y++){ // loop through leds

             leds[i][NUM_LEDS-y-1] = pattern[(x+y)%length]; // automatically set color for specific led from array
             }
           
            //FastLED.show();
           // delay(framerate);  
         }
         
         if (state == HIGH){
          break; }
        
        // edge leds
        for (int z = 0; z<8; z++){
          edgeLEDs[z] = edgePattern[(x+z)%edgeLength];
        }   
 
        if (state == HIGH){
          //state = LOW;
          break; }
          
        FastLED.show();
        delay(framerate);
      }
      
      if (state == HIGH){
          state = LOW;
          break; }  
      }}
      break;
      
   case 3: // ripples of white - works: edge is continuation of ripples
      {long pattern[][10]={{nolight, nolight, nolight, nolight, nolight, nolight},
                          {nolight, nolight, nolight, nolight, nolight, nolight},
                          {nolight, nolight, white,   white,   nolight, nolight},
                          {nolight, white,   nolight, nolight, white,   nolight},
                          {white,   nolight, nolight, nolight, nolight, white},
                          {nolight, nolight, nolight, nolight, nolight, nolight}};
                          
      /*long pattern[][10]={nolight, nolight, nolight, nolight, nolight, nolight},
                          {nolight, nolight, nolight, nolight, nolight, nolight},
                          {nolight, nolight, white,   white,   nolight, nolight},
                          {nolight, white,   nolight, nolight, white,   nolight},
                          {white,   nolight, nolight, nolight, nolight, white},
                          {nolight, nolight, nolight, nolight, nolight, nolight}};  works, length = 10, frames = 6*/                  
                          
      length = 6; 
      frames = 6;
      framerate = 200;
      
      for(int x = 0; x < frames; x++) { // loop through frames
         for (int i = 0; i<NUM_STRIPS/2; i++){ // loop through strips
           for (int y = 0; y<NUM_LEDS; y++){ // loop through leds
            // set mirror strands to be on the same frames
             leds[i][y] = pattern[(x+i)%frames][(y)%length]; // correct for strands 0-2
             leds[(NUM_STRIPS -1) - i][y] = pattern[(x+i)%frames][(y)%length]; // correct for strands 3-5
             }
         }
         for (int z = 0; z<8; z++){ // edge leds
           if (x == (frames-1)){
             edgeLEDs[z] = white;
           }
           else{
             edgeLEDs[z] = nolight;
           }
          } 

       if (state == HIGH){
           state = LOW;
           break; }
          
       FastLED.show();
       delay(framerate);
          }
        }
      break;

  case 4: // psuedo-random twinkling - sustained: edge is included in twinkling
      {framerate = 200;
      
      int i = random(NUM_STRIPS+1); // pick a random led from a random strip
      int y = random(NUM_LEDS);
      
      int z = random(10);
      
      if (z%2 == 0){ 
        if (i<=NUM_STRIPS){ 
          leds[i][y] = dimIndigo; // sometimes turn led on
        }
        else{
          edgeLEDs[y%8] = dimIndigo;
        }
      }
      else{
        if (i<=NUM_STRIPS){ 
          leds[i][y] = whiteHalf; // sometimes turn led off
        }
        else{
          edgeLEDs[y%8] = whiteHalf;
        } 
      }
      
      FastLED.show();
      delay(framerate);}

      break;
      
  case 5: // psuedo-random twinkling - brief: edge is included in twinkling
      {framerate = 200;
      
      int i = random(NUM_STRIPS+1); // pick a random led from a random strip
      int y = random(NUM_LEDS);
      
      if (i<=NUM_STRIPS){ 
          leds[i][y] = paleBlue; // turn LED on
        }
      else{
          edgeLEDs[y%8] = paleBlue;
        } 
      //leds[i][y] = paleBlue; // turn led on
      
      FastLED.show(); // show color
      delay(framerate);
      
      if (i<=NUM_STRIPS){ 
          leds[i][y] = nolight; 
        }
      else{
          edgeLEDs[y%8] = nolight;
        } 
      //leds[i][y] = nolight; // turn led off
          
      FastLED.show();
      delay(framerate);}

      break;      
      
  case 6: // "rain": edge is solid soft white
    {long pattern[] = {white, whiteHalf, whiteQuarter, nolight, nolight, nolight, nolight, nolight, nolight, nolight, nolight, nolight, nolight};
 
    length = sizeof(pattern)/sizeof(long); // calculates length of array
    frames = length-1;   
    framerate = 100;
    
    int i = random(NUM_STRIPS); // pick a random strip
    int j = random(10);
    

    
    for(int x = 0; x < frames; x++) { // loop through frames
      if (j%2 ==0){ // even, along strips
        for (int y = 0; y<NUM_LEDS; y++){ // loop through leds
          leds[i][y] = pattern[(x+y+5)%length]; // automatically set color for specific led from array
         }
      }
    
      else { // odd, across strips
        for (int y = 0; y<NUM_LEDS; y++){ 
          leds[y][i] = pattern[(x+y+5)%length]; // automatically set color for specific led from array
        }
      }
       
       /*for (int y = 0; y<NUM_LEDS; y++){ // loop through leds

          leds[i][y] = pattern[(x+y+5)%length]; // automatically set color for specific led from array
          }
       */
       
       for (int z = 0; z<8; z++){ //loop through edge leds
          edgeLEDs[z] = whiteHalf;
        }
        
       if (state == HIGH){
         state = LOW;
         break; }
          
       FastLED.show();
       delay(framerate);  
       }}
    break;

  /*case 7: // color testing (NOT A PATTERN)
    leds[0][1] = 0x99ffcc;
  
    FastLED.show();
    delay(100);
    break;


   case 8: // ripples of white - NOT WORKING; trying to reduce to one array; need more strands....
      {long pattern[]={white, nolight, nolight, nolight, nolight, nolight};
      
      length = sizeof(pattern)/sizeof(long); 
      frames = length;
      framerate = 200;
      
      for(int x = 0; x < frames; x++) { // loop through frames
       for (int i = 0; i<NUM_STRIPS/2; i++){ // loop through strips
         for (int y = 0; y<NUM_LEDS/2; y++){ // loop through leds
            // set mirror strands to be on the same frames
           leds[i][y] = pattern[(x+i+y)%length]; // correct for strands 0-2
           leds[(NUM_STRIPS -1) - i][(NUM_LEDS-y)] = pattern[(x+i+y)%length]; // correct for strands 3-5
           }
       }
        FastLED.show();
        delay(framerate);
        }}
      break;*/
  
  case 7: // rainbow mode: edge is continuation of patterns
      {long pattern[] = {red, orange, yellow, green, blue, indigo, purple};
      length = sizeof(pattern)/sizeof(long); // calculates length of array
      frames = length; // assuming that patterns are one complete rotation of array
      framerate = 100;
      
      // solid wave    
      for(int x = 0; x < frames; x++) { // loop through frames
       for (int i = 0; i<NUM_STRIPS; i++){ // loop through strips
         for (int y = 0; y<NUM_LEDS; y++){ // loop through leds

           leds[i][y] = pattern[(x+y)%length]; // automatically set color for specific led from array
           }
         }
        
         for (int z = 0; z<8; z++){
          edgeLEDs[z] = pattern[(x+z)%length];
         }
        
        if (state == HIGH){ // exits case when button is pressed
          state = LOW;
          break; }
        
        FastLED.show();
        delay(framerate);               
        }
  
       // broken wave 
      for(int x = 0; x < frames; x++) { // loop through frames
       for (int i = 0; i<NUM_STRIPS; i++){ // loop through strips
         for (int y = 0; y<NUM_LEDS; y++){ // loop through leds

           leds[i][y] = pattern[(x+y+i)%length]; // automatically set color for specific led from array
           }
         }
        
       for (int z = 0; z<8; z++){
        edgeLEDs[z] = pattern[(x+z)%length];
       }        
        
       if (state == HIGH){ // exits case when button is pressed
          state = LOW;
          break; }
        
       FastLED.show();
       delay(framerate);               
        }}
       break;
  
}
}


void changeLED(){ // interrupt function
  static unsigned long last_interrupt_time = 0;
  static unsigned int debounce_delay = 300;
  unsigned long interrupt_time = millis();
  
  if (interrupt_time - last_interrupt_time > debounce_delay){ // delay for debounce
    counter ++;   // increase counter
    state = HIGH; // change state so cases will exit
      if (counter > limit){ // keeps counter w/in limit (could do % instead)
        counter = 0;
      }
  last_interrupt_time = interrupt_time;
}
}


void clearLEDs(){ // turns off all leds
  for (int i = 0; i<NUM_STRIPS; i++){ // loop through strips
    for (int y = 0; y<NUM_LEDS; y++){ // loop through leds
      leds[i][y] = nolight; // automatically set color for specific led from array
      }
    FastLED.show();
       }
  for (int z = 0; z<8; z++){ //loop through edge leds
    edgeLEDs[z] = nolight;
  }
  FastLED.show();
}


