
/*
  The STP16CP control is define on PIN 2 / 3 / 4
  The three transistors I used are on PIN 6 / 8 / 9 (you can also add transistor on PIN 5 / 7 on the board)
  The button is on PIN 10
  I used msTIMER2 to manage the multiplexing. Every 1ms the timer is called and alternate the transistor value
  If you use the 5 transistors you will probably have to reduce the Timer call to 500us and the transistor blink to 100us
*/

#include <stdio.h>
#include <MsTimer2.h>


#define RIEN MAP[0]
#define RIEN MAP[1]
#define ATLANTIQUE_NORD_2 MAP[2]
#define LIMA MAP[3]
#define LOS_ANGELES MAP[4]
#define LAS_VEGAS MAP[5]
#define ATLANTIQUE_NORD_1 MAP[6]
#define CAMPO_GRANDE MAP[7]
#define VOL_US MAP[8]
#define LEGENDE_ROSE MAP[9]       
#define MEXIQUE MAP[10]            
#define RIEN MAP[11]
#define PACIFIQUE_4 MAP[12]
#define SAN_FRANCISCO MAP[13]
#define LEGENDE_BLEU MAP[14]      
#define LEGENDE_VERT MAP[15]      
#define SEATTLE MAP[16]
#define MER_ANTILLE MAP[17]      
#define CARTAGENE MAP[18]
#define CHICLAYO MAP[19]
#define QUITO MAP[20] 
#define CALI MAP[21] 
#define USHUAIYA MAP[22]     
#define SENEGAL MAP[23]     
#define BOGOTA MAP[24]

#define MIAMI MAP[25]     
#define TORONTO MAP[26]
#define MONTREAL MAP[27]
#define REKJAVIC MAP[28]
#define NORD_NORVEGE MAP[29] 
#define SUD_NORVEGE MAP[30]
#define LA_PAZ MAP[31]
#define UYUNI MAP[32]
#define PACIFIQUE_3 MAP[33]
#define VANCOUVER MAP[34]
#define CALGARY MAP[35]
#define NEW_YORK MAP[36]
#define CENTRE_US MAP[37]
#define PACIFIQUE_2 MAP[38]
#define PACIFIQUE_1 MAP[39]
#define AUCKLAND_PACIFIQUE MAP[40]
#define CARACAS MAP[41]
#define VENEZUELA_DELTA MAP[42]
#define GUADELOUPE MAP[43]
#define ATLANTIQUE_CENTRE_1 MAP[44]
#define ATLANTIQUE_SUD_1 MAP[45]
#define BAHIA MAP[46]
#define RIO MAP[47]
#define IGUAZU MAP[48]

#define RIEN MAP[49]
#define PRAGUE MAP[50]
#define SLOVENIE MAP[51]
#define AFRIQUE_DU_SUD MAP[52]  
#define MADAGASCAR MAP[53]
#define NAMIBIE MAP[54]
#define QATAR MAP[55]
#define MUNICH MAP[56]
#define ATLANTIQUE_CENTRE_2 MAP[57]
#define MAROC_SUD MAP[58]
#define MAROC_NORD MAP[59]
#define LONDON MAP[60]
#define BARCELONE MAP[61]
#define PARIS MAP[62]
#define BRUXELLE MAP[63]
#define GRENOBLE MAP[64]
#define RIEN MAP[65]
#define TOMSK MAP[66]
#define KRASNOYARSK MAP[67]
#define KAZAN MAP[68]
#define IEKATERINBOURG MAP[69]
#define MOSCOU MAP[70]
#define TALLIN MAP[71]
#define OMSK MAP[72]

#define LA_CRETE MAP[73] 
#define ISTANBUL MAP[74]
#define VIENNE MAP[75]
#define BUDAPEST MAP[76]
#define ATHENE MAP[77]    
#define CRACOVIE MAP[78]
#define LVIV MAP[79]
#define KIEV MAP[80]
#define MER_DUBAI MAP[81]  
#define AMSTERDAM MAP[82]
#define CORSE MAP[83]
#define TUNISIE MAP[84]
#define COPENHAGE MAP[85]
#define MEDITERANEE MAP[86]  
#define LE_CAIRE MAP[87]
#define LOUXOR MAP[88]
#define OSLO MAP[89] 
#define RIGA MAP[90]
#define ERLIAN MAP[91]
#define OULAN_BATOR MAP[92]
#define VILNIUS MAP[93]
#define KARKORIN MAP[94]
#define OULAN_OUDE MAP[95]
#define IRKUTSK MAP[96]

#define INVERCARGILL MAP[97]
#define FRANZ_JOSEPH MAP[98]
#define INDIEN_2 MAP[99]      
#define WELLINGTON MAP[100]
#define INDIEN_3 MAP[101]
#define AUCKLAND MAP[102]
#define RIEN MAP[103]
#define RIEN MAP[104]
#define COCHIN MAP[105]
#define BOMBAY MAP[106]
#define JAISALMER MAP[107]
#define UDAIPUR MAP[108]
#define AMRITSAR MAP[109]
#define DELHI MAP[110]
#define RIEN MAP[111]
#define RIEN MAP[112]
#define SRI_LANKA MAP[113]
#define NEPAL MAP[114]
#define NORD_YUNAN MAP[115]
#define DALI MAP[116]
#define XIAN MAP[117]
#define CHENGDU MAP[118]
#define RIEN MAP[119]
#define RIEN MAP[120]

#define KHO_PHI_PHI MAP[121]
#define KUALA_LUMPUR MAP[122]
#define SINGAPOUR MAP[123]
#define MER_PHILIPPINES_1 MAP[124]
#define MER_PHILIPPINES_2 MAP[125]
#define PALAWAN MAP[126]
#define MANILLE MAP[127]
#define INDIEN_1 MAP[128]   
#define BENGALE_1 MAP[129]  
#define BANKOK MAP[130]
#define ANGKOR MAP[131]
#define MER_VIETNAM MAP[132] 
#define BALI MAP[133]    
#define TAIWAN MAP[134]    
#define TOKYO MAP[135]    
#define BENGALE_2 MAP[136] 
#define VIENTIAN MAP[137]
#define HANOI MAP[138]
#define PINGYAO MAP[139]
#define PEKIN MAP[140]
#define MER_COREE MAP[141]
#define SHANGAI MAP[142]
#define SEOUL MAP[143]
#define NORD_LAOS MAP[144]

int SDI = 2; 
int CLK = 3;
int LE = 4;
int Pin_Interrupteur = 10; 
char MAP[145]; // With 3 STP and 3 transistors you can control 144 LEDs (48 * 3)
int flag_layer = 0; // Altarnate the value of the transistor when the timer is called
boolean flag_interrupteur = 1; // flag storing the button value

char  ctrl1_A_1, ctrl1_A_2, ctrl1_A_3, ctrl1_B_1, ctrl1_B_2, ctrl1_B_3, 
      ctrl2_A_1, ctrl2_A_2, ctrl2_A_3, ctrl2_B_1, ctrl2_B_2, ctrl2_B_3, 
      ctrl3_A_1, ctrl3_A_2, ctrl3_A_3, ctrl3_B_1, ctrl3_B_2, ctrl3_B_3;
      // The three STP16CP have two interface of 8 bits and three state each depending on the transistor activation
      //ctrl1_A_1 is the first STP, _A is the first 8 bits interface, _1 is the first transistor activated

void flash()
{
  
    flag_interrupteur = digitalRead(Pin_Interrupteur);
    
    if(flag_layer == 0){
      send_data(ctrl1_A_1);send_data(ctrl1_B_1);
      send_data(ctrl2_A_1);send_data(ctrl2_B_1);
      send_data(ctrl3_A_1);send_data(ctrl3_B_1);
      latch();
      digitalWrite(6, LOW);
      delayMicroseconds(200);
      digitalWrite(6, HIGH);
    }
    if(flag_layer == 1){
      send_data(ctrl1_A_2);send_data(ctrl1_B_2);
      send_data(ctrl2_A_2);send_data(ctrl2_B_2);
      send_data(ctrl3_A_2);send_data(ctrl3_B_2);
      latch();
      digitalWrite(8, LOW);
      delayMicroseconds(200);
      digitalWrite(8, HIGH);       
    }
    if(flag_layer == 2){
      send_data(ctrl1_A_3);send_data(ctrl1_B_3);
      send_data(ctrl2_A_3);send_data(ctrl2_B_3);
      send_data(ctrl3_A_3);send_data(ctrl3_B_3);
      latch();
      digitalWrite(9, LOW);
      delayMicroseconds(200);
      digitalWrite(9, HIGH);       
    }
    flag_layer++;
    if(flag_layer == 3){flag_layer = 0;}
}

void setup(void){
  ini(); // initiate the PIN
  clearMAP(); // shut down all the LED
  MsTimer2::set(1, flash); // 1ms period
  MsTimer2::start();
}

void loop(void){ 

  if(flag_interrupteur == 0){
    path_animation(600);// the LED turn on in order. 600 is the speed
  }
  
  if(flag_interrupteur == 0){
    colors_animation(20000); // all the colors blink separatly. 20000 is the speed
  }
  else{ // If the button is pushed, show only the LED of the place I have been to (pink one)
    pink_animation();
  }
}


/*
FREE SPOTS on the map
   MAP[0]=1;
   MAP[1]=1;
   MAP[11]=1;
   MAP[49]=1;
   MAP[65]=1;
   MAP[103]=1;
   MAP[104]=1;
   MAP[111]=1;
   MAP[112]=1;
   MAP[119]=1;
   MAP[120]=1;
*/
