/************************************************************************/
/*				                        		*/
/*	LS1Demo -- PmodLS1 Demo		                                */
/*						                  	*/
/*					                        	*/
/************************************************************************/
/*	Author: Eric Marsh      					*/
/*	Copyright 2016, Digilent Inc.					*/
/************************************************************************/
/*      File Description: 			             		*/
/*					                        	*/
/* This file implements a simple demo application that demonstrates     */
/* how to use LS1 library functions.				        */
/* Tested with 4 IROS sensors plugged into PmodLS1			*/
/*									*/
/*	Functionality:							*/
/*									*/
/* In this demo it is shown how to command a LS1 to check and return    */
/* the status of the sensors connected to it.                           */
/*                                                             		*/
/************************************************************************/
/*      Revision History:			        		*/
/*					                        	*/
/* 6/22/2016 (EricM): created	    	       			        */
/*						                     	*/
/************************************************************************/

/* ------------------------------------------------------------ */
/*                Include File Definitions                      */
/* ------------------------------------------------------------ */
#include <LS1.h>
#include <DSPI.h>

/* ------------------------------------------------------------ */
/*                Global Variables                              */
/* ------------------------------------------------------------ */

LS1 myLS1;
byte sensor_status;

/* ------------------------------------------------------------ */
/*                Procedure Definitions                         */
/* ------------------------------------------------------------ */
/***  void setup()
**
**  Parameters:
**    none
**
**  Return Value:
**    none
**
**  Errors:
**    none
**
**  Description:
**    Initialize the system.
*/

void setup() {
  Serial.begin(9600);
  myLS1.begin(PAR_ACCESS_SPI0);
  
}

/* ------------------------------------------------------------ */
/***  void loop();
**
**  Parameters:
**    none
**
**  Return Value:
**    none
**
**  Errors:
**    none
**
**  Description:
**    Main application loop.
*/
void loop()
{
  // check if every sensor outputs a 1
  if(myLS1.AllSensorsEnabled() == true){
   Serial.println("All sensors activated"); 
  }
  
  // check if every sensor outputs a 0
  if(myLS1.AllSensorsDisabled() == true){
   //Serial.println("All sensors deactivated"); 
  }
  
  // check status of each sensor individually
  for(int i = 0; i <= 3; i++)
  {
    if(myLS1.SensorIsEnabled(i))
    {
      Serial.print("Sensor "); Serial.print(i); Serial.print(" is activated."); Serial.print("\n");
    }
  }
  
  // get sensor byte
  sensor_status = myLS1.GetSensorsStatus();
  Serial.println(sensor_status);
  
  // wait some time
  delay(100);
}
