/************************************************************************/
/*																		*/
/*	LS1.h	--	Declaration for DACSPI4 library 	    				*/
/*																		*/
/************************************************************************/
/*	Author:		Eric Marsh												*/
/*	Copyright 2016, Digilent Inc.										*/
/************************************************************************/
/*  File Description:													*/
/*	This file declares the PmodLS1 library functions and the constants	*/
/*	involved.															*/
/*																		*/
/************************************************************************/
/*  Revision History:													*/
/*																		*/
/*	06/21/2016(EricM): created											*/
/*																		*/
/************************************************************************/
#if !defined(LS1_H)
#define LS1_H


/* ------------------------------------------------------------ */
/*				Include File Definitions						*/
/* ------------------------------------------------------------ */
#include <inttypes.h>
#include <DSPI.h>

/* ------------------------------------------------------------ */
/*					Definitions									*/
/* ------------------------------------------------------------ */

#define LS1_SPI_FREQ	1000000 // 1 MHz - default spi freq
#define	PAR_ACCESS_SPI0			0
#define	PAR_ACCESS_SPI1			1
#define	PAR_ACCESS_I2C			2	


/* ------------------------------------------------------------ */
/*					Errors Definitions							*/
/* ------------------------------------------------------------ */



/* ------------------------------------------------------------ */
/*					Procedure Declarations						*/
/* ------------------------------------------------------------ */


class LS1 {
private: 
	DSPI *pdspi;
	uint8_t m_SSPin;
	byte sensor_status;
	int S1;
	int S2;
	int S3;
	int S4;

public:
	LS1();
	void begin(uint8_t bAccessType, uint32_t spd = LS1_SPI_FREQ);
	byte GetSensorsStatus();
	void UpdateSensorsStatus();
	bool SensorIsEnabled(int sensor_num);
	bool AllSensorsEnabled();
	bool AllSensorsDisabled();
};

#endif
