

#include <AlphaLCD.h>
#include <Streaming.h>

// Include the LCD helper and the application string
#include "LCD.h"
#include "Strings.h"
#include "Version.h"

//! AlphaLCD class instance for display hardware control
int dataPin = 2;   // pin 14 on the 74hc595
int clockPin = 3;  // pin 11 on the 74hc595
int latchPin = 4;   // pin  12 on the 74hc595

AlphaLCD lcd(2,3,4);

// Your setup initialization here
void setup() 
{

	// Initializes the LCD library
	lcd.begin(LCDCHARS, LCDROWS);

	// Turn LCD On
	lcd.display();

	welcome();
  
}

// Your Arduino application here
void loop(void)
{

  lcd.setCursor(LCDCHARS,0);
  lcd.print(_WEB);
  lcd.setCursor(LCDCHARS,1);
  lcd.print(_INSTRUCTABLES);
  
  // scroll 
  for (int positionCounter = 0; positionCounter < (LCDCHARS * 2); positionCounter++) {
    lcd.scrollDisplayLeft(); 
    delay(200);
  }

  lcd.clear();
  lcd.setCursor(0, 0);
  lcd.print(_WEB);
  lcd.setCursor(0, 1);
  lcd.print(_INSTRUCTABLES);
  delay(3500);
  lcd.clear();

}


// -------- LCD Control functions

/**
 * \brief Welcome message shown at device power-on
 */
void welcome() {

	lcd.clear();
	lcd.setCursor(0, LCDTOPROW);
	lcd << project();
	lcd.setCursor(0, LCDBOTTOMROW);
        lcd << _VERSION << _SPACING << version() << _SPACING << _BUILD << _SPACING << build(); 
	delay(LCDMESSAGE_DELAY);
	lcd.clear();

}

/**
 * \brief Display a string on the LCD at the cursor position
 *
 * \param m the message string
 */
void message(String m) {
	lcd.print(m);
}

/**
 * \brief Display an integer value in decimal format at the cursor position
 *
 * \param n the integer to show in decimal format
 */
void dec(int n) {
	lcd.print(n, DEC);
}

/**
 * \brief Display an integer value in hex format at the cursor position
 *
 * \param n the integer to show in hexadecimal format
 */
void hex(int n) {
	lcd.print("0x");
        lcd.print(n, HEX);
}

/**
 * \brief Display an error message at the specified cursor coordinates
 *
 * The error message is shown for a LCDERROR_DELAY milliseconds.
 * After the timeout expires the screen is not cleared so the next steps should be managed
 * by the program flow. It is expected that error messages are shown in a calling code that
 * manages the error conditions.
 *
 * \param m the message string
 * \param x the cursor column zero based
 * \param y the row number zero based
 */
void error(String m, int x, int y) {
	message(m, x, y);
	delay(LCDERROR_DELAY);
}

/**
* \brief Display an error message at the cursor position
*
* The error message is shown for a LCDERROR_DELAY milliseconds.
* After the timeout expires the screen is not cleared so the next steps should be managed
* by the program flow. It is expected that error messages are shown in a calling code that
* manages the error conditions.
 *
 * \param m the string message
*/
void error(String m) {
	message(m);
	delay(LCDERROR_DELAY);
}

/**
 * \brief Display a string on the LCD at the specified cursor coordinates
 *
 * \param m the string message
 * \param x the cursor column zero based
 * \param y the row number zero based
 */
void message(String m, int x, int y) {
	lcd.setCursor(x, y);
	message(m);
}

/**
 * \brief Clean the display
 *
 * A delay of 100 ms is added after the hardware clear() call to give the display the time
 * to complete the operation.
 */
void clean() {
	lcd.clear();
	delay(LCDCLEAR_DELAY);
}

/**
 * \brief Creates a menu screen.
 *
 * The 2-lines LCD screen is divided in four sectors, that can be used or not. The LCD
 * sectors length and position are defined and based on the LCD size.
 * Every sector is filled with one of the four parameters string.
 * Sectors 1 & 2 are in the top row, sectors 3 & 4 in the bottom row
 *
 * \param sect1 The Upper Left display sector
 * \param sect2 The Upper Right display sector
 * \param sect3 The Lower Left display sector
 * \param sect4 The Lower Right display sector
 */
void menu(String sect1, String sect2, String sect3, String sect4) {
	clean();
	message(sect1, LCD_SECTOR1, LCDTOPROW);
	message(sect2, LCD_SECTOR2, LCDTOPROW);
	message(sect3, LCD_SECTOR3, LCDBOTTOMROW);
	message(sect4, LCD_SECTOR4, LCDBOTTOMROW);
}

