/*
    Arduino code for Custom made Helmet Light with Side-Visibility
    The modes for the helmet light are high powered strobe, fade, low powered strobe, and battery saving.
    Long presses turn on or off the light.
    Short presses cycle through its modes.
    Low battery voltage triggers the battery saving mode for 2 LiFePO4 cells (Vin=7.2V).
*/

#include <avr/sleep.h>

// Utility macros
#define adc_disable() (ADCSRA &= ~(1<<ADEN)) // disable ADC
#define adc_enable()  (ADCSRA |=  (1<<ADEN)) // re-enable ADC

const int buttonPin = 2;
const int PWMPin = 1;
const int currentFeedbackPin = A3;
const int lowBattPin = A2;

// Recalls last setting.
int mode = 0;
int modeTop = 3;

// LED driver parameters
const int PWMPeriod = 255 ; // Sets the PWM frequency to 62.5 kHz
const int maxOnTime = 0.65 * PWMPeriod; // Sets the maximum duty cycle. Maximum output voltage is 2.9 times the input's.
const int minOnTime = 0;
int PWMOnTime = minOnTime; // Soft starts LED driver
int currentSenseReading;
int desiredLEDCurrent;

unsigned long prevMillis = 0;
unsigned long elapsedMillis = 0;
// Button parameters
boolean buttonState;
const int debounceDelay = 300; // 300 ms
int delayCounts;

// Pattern parameters
int state = LOW;
boolean lampState = LOW;
int stepTime = 3000; // Actual time in milliseconds is stepTime/68. Fade frequency is approximately 1 Hz.
int stepLevel;
int stepTop = 19;
int fadeLevels[20] = { // Brightness values for the fade-in-fade-out patterns
  0,  22,  44,  67,  89,  111, 133, 156, 178, 200, 222, 200, 178, 156, 133, 111, 89,  67,  44,  22
};

//Battery parameters
int batteryReading = 0;
const int batteryCutoffADC = 423; // Selected to go to battery saver mode if the battery voltage falls below 5V for R1 = 2.2M, and R2 = 220k.

void setup() {
  pinMode(buttonPin, INPUT_PULLUP);
  pinMode(lowBattPin, INPUT);
  pinMode(currentFeedbackPin, INPUT);

  analogReference(INTERNAL);
  sleepNow(); // Start in sleep mode
}

void loop() {

  if (mode == 0) {
    powerSaverMode();
  }
  else if (mode == 1) {
    nightStrobe();
  }
  else if (mode == 2) {
    fade();
  }
  else if (mode == 3) {
    rapidStrobe();
  }

  readButtons();
  driver();

}

void monitorBattery() {
  // Measures the battery voltage
  batteryReading = analogRead(lowBattPin);

  if (batteryReading < batteryCutoffADC) { // If battery is low, go to low power mode. If you are using AA cells, you may comment it out.
    mode = 0;
  }
}

