boolean establishContact() {
  int LASER = 10;
  int potRead = 14;
  const byte buttonInput = 12;
  pinMode(buttonInput, INPUT_PULLUP);
  pinMode(potRead, INPUT);
  while (Serial.available() <= 0) {
    int potValue = analogRead(potRead);
    int val = map (potValue, 0, 1023, 0, 255);
    if(digitalRead(buttonInput) == LOW){analogWrite(LASER, val);
        Serial.println("LASER ON");}
        Serial.print("potReads: ");
        Serial.println(potValue);
        Serial.println(val);
  Serial.println("A");  // send a capital A
  delay(300);
     digitalWrite(LASER,0);}
  }

//*******************************SET LASING PARAMETERS*****************
//Set LASER POWER -- SET POWER-PERCENTAGE THEN CONVERT TO "ON" for "LASER ON" function using analogWrite (PWM)/// 
int laserPercentage = 100; // enter Power percentage 0-100%
const unsigned int longdelay = 1500; //Set burn time depending on the target material
const unsigned int shortdelay = 1500; //go as low as your motors will allow without locking up/making bad noise. Should sound nice and smooth. If image is skewed or worse, make larger b/c your motors are skipping steps
const float stepsPerPixel = 10;  // ALSO KNOWN AS SCALE FACTOR*****************

//*********************************END SET LASER PARAMETERS******************

// Depending on you setup 
//For me: (200 steps /rot)*(18 rot / inch)*(1 inch / 25.4 mm) -> .007 mmPerStep
const float mmPerStep = 1/(200*18/25.4); 
const float mmPerPixel = mmPerStep * stepsPerPixel;// NOT yet used

const byte ledPin =  13;      // the number of the LED pin
boolean ledState = LOW; //to toggle our LED
const byte OFF = 0;
const byte ON = map(laserPercentage, 0, 100, 0, 255);// IF Laser pin is PWM then then convert for analogWrite PWM

const byte XmotorDIR = 5;
const byte XmotorPULSE = 2;
const byte YmotorDIR = 6;
const byte YmotorPULSE = 3;
const byte LASER = 10; //PWM on Arduino Uno ************************************
byte xsleep = 8;//SLEEP HIGH TO ENABLE MOTORS
byte ysleep = 9;//SLEEP HIGH TO ENABLE MOTORS

// Variables that will change:
byte a = 0;
byte initialmode = 0;
byte lasermode = 0;
byte byteCounter=0; //counting each instruction byte (also tells if data was received)
int setCounter=0; //counting the instruction blocks'
byte linelength;
long xpositioncount = 0;
long ypositioncount = 0;

//***********************************************************************************************************
//Initialisation Function
//***********************************************************************************************************


void setup() 
{
  // set the digital pin as output:
  pinMode(ledPin, OUTPUT);
  pinMode(LASER, OUTPUT);
  pinMode(xsleep, OUTPUT);
  pinMode(ysleep, OUTPUT);
  pinMode(YmotorPULSE, OUTPUT);
  pinMode(YmotorDIR, OUTPUT);
  pinMode(XmotorPULSE, OUTPUT);
  pinMode(XmotorDIR, OUTPUT);

  digitalWrite(xsleep, LOW); //Set motors to sleep Mode until Connection with Processing is established
  digitalWrite(ysleep, LOW);

  pinMode(ledPin, OUTPUT); // Set pin as OUTPUT
  //initialize serial communications at a 9600 baud rate
  Serial.begin(9600);
  Serial.println("Establishing contact..");
  establishContact();// send a byte "A" to establish contact until receiver responds
   //Contact established
  digitalWrite(xsleep, HIGH); //Enable motors
  digitalWrite(ysleep, HIGH); //Enable motors
  
  Serial.println("Uncomment print commands in both sketches to understand how it works: ");
  Serial.println("Processing will only display Arduino print commands if println(val) is uncommented in SerialEvent(), which runs whenever something is sent via Serial to it and waits until line break '\n'");
  Serial.println("Arduino sends commands to Processing via Serial.println() where the line break denotes end of command");
  Serial.println("After Handshake is established via sharing an ""A""...");
  Serial.println("Arduino first sends a ""1"" to ask for the number of bytes in the next set of instructions to ensure all are read");
  Serial.println("Next, Arduino asks for the set of instructions by sending a ""2"" ");
  delay(2000);
  //READY...OK
  Serial.print("Arduino is Ready for ");
  Serial.println("linelength ");//Send READY signal to processing to get next instruction block
    Serial.println("1"); //Printing takes up precious milliseconds!
  while(Serial.available()){Serial.read();}//clear serial buffer
}

//**********LOOP**********************

void loop(){
  byte byteRead;
  //Serial.println("Arduino waiting");
  if (Serial.available() > 0) { // If Serial data is available to read, 
    if(byteCounter == 0){    //linelength incoming because instruction set (bytes received = 0) is not received yet     
                          //Serial.println("Arduino waiting for linelength");  
                           linelength = Serial.read() ; 
                           //linelength = linelength + Serial.read();
                           linelength = linelength - 10; // I had to add 10 to this before it send in Processing so it had two digits.... should be fixed later
                           /*
                          Serial.print("Arduino received linelength: ");
                          Serial.println((int)linelength );
                           */
                             while(Serial.available()){Serial.read();}// Clear buffer
                             
                           //Serial.print("Arduino is Ready for ");
                           //Serial.print("Instructions ");
                           Serial.println("2"); //Printing takes up precious milliseconds!
                           
                          while(!Serial.available()){}//wait for something to be received
                             /*
                             Serial.print("Arduino received Instruction set ");
                             Serial.println(setCounter);
                             */
                           } //end if(bytecouter)
    while(byteCounter < linelength){
    
    byteRead = Serial.read();
    if (byteRead != 'r'){byteRead=byteRead-'0';}
    
    //Serial.print(byteRead);
    
    if((byteRead < 10) || (byteRead == 'r')){   // RANDOMLY GETING BYTES "207"??? SKIP THOSE *******But don't ignore the reset command!
    byteCounter++;
        
      //Serial.print(byteRead);
     /* 
    Serial.print("Arduino received byte ");
    Serial.print(byteCounter);
    Serial.print(": ");
    Serial.println(byteRead);
    */
            
    //Move motors
    if(byteRead==1){
      //Move right FAST
      fastright();         
    }
    if(byteRead==2){
      //Move right SLOW
      slowright();
    }
    if(byteRead==3){
      //Move left FAST
      fastleft();         
    }
    if(byteRead==4){
      //Move left SLOW
      slowleft();         
    }
    if(byteRead==5){
      //Move up FAST
      fastup();
    }
    if(byteRead==6){
      //Move up SLOW
      slowup();
    }
    if(byteRead==7){
      //Move down FAST
      fastdown();
    }
    if(byteRead==8){
      //Move down SLOW
      slowdown();
    }
    if(byteRead==9){
      analogWrite (LASER, ON);
    }
    if(byteRead==0){
      analogWrite (LASER, OFF);
    }
    if (byteRead=='r'){
      //reset position
      xresetposition();
      yresetposition();
      delay(1000);
      digitalWrite(xsleep, LOW);
      digitalWrite(ysleep, LOW);
    }
  }
  }// END while bytecount
  }//END while (serial.avail
 if(byteCounter != 0){//ONLY SEND READY SIGNAL IF YOU'VE RECEIVED DATA SINCE THE LAST TIME
       setCounter++;
       
       //Serial.println();
       /*
       Serial.print("Arduino received ");
       Serial.print(byteCounter);
       Serial.println(" bytes. ");
       */
       //Serial.println(byteRead);
       
       while(Serial.available()){Serial.read();}//clear buffer
       /*
       Serial.print("byteCounter: ");
        Serial.println(byteCounter);
        */
               
       //Serial.println();
     //Serial.print("Arduino is Ready for ");
     //Serial.print("linelength ");//Send READY signal to processing to get next instruction block
    Serial.println("1"); //Printing takes up precious milliseconds! READY SIGNAL
    byteCounter=0;
    
   }

} 




//************************************************************************************************************
// Main Motor functions
//************************************************************************************************************

void fastright()
{digitalWrite (XmotorDIR, ON);
  for (a=0; a<stepsPerPixel; a++)
  {
    digitalWrite (XmotorPULSE, ON);
    digitalWrite (XmotorPULSE, OFF);
    delayMicroseconds(shortdelay);
    }
  xpositioncount++;
}

void slowright()
{digitalWrite (XmotorDIR, ON);
  for (a=0; a<stepsPerPixel; a++)
  {
    
    digitalWrite (XmotorPULSE, ON);
    //digitalWrite (ledPin, ON);
    digitalWrite (XmotorPULSE, OFF);
    delayMicroseconds(longdelay);
    //digitalWrite (ledPin, OFF);
  }
  xpositioncount++;
}

void fastleft()
{digitalWrite (XmotorDIR, OFF);
  for (a=0; a<stepsPerPixel; a++)
  {
    
    digitalWrite (XmotorPULSE, ON);
    //digitalWrite (ledPin, ON);
    digitalWrite (XmotorPULSE, OFF);
    delayMicroseconds(shortdelay);
    //digitalWrite (ledPin, OFF);
  }
  xpositioncount--;
}

void slowleft()
{digitalWrite (XmotorDIR, OFF);
  for (a=0; a<stepsPerPixel; a++)
  {
    
    digitalWrite (XmotorPULSE, ON);
    //digitalWrite (ledPin, ON);
    digitalWrite (XmotorPULSE, OFF);
    delayMicroseconds(longdelay);
    //digitalWrite (ledPin, OFF);
  }
  xpositioncount--;
}

void fastup()
{digitalWrite (YmotorDIR, ON);
  for (a=0; a<stepsPerPixel; a++)
  {
    
    digitalWrite (YmotorPULSE, ON);
    //digitalWrite (ledPin, ON);
    digitalWrite (YmotorPULSE, OFF);
    delayMicroseconds (shortdelay);
    //digitalWrite (ledPin, OFF);
  }
  ypositioncount++;
}

void slowup()
{digitalWrite (YmotorDIR, ON);
  for (a=0; a<stepsPerPixel; a++)
  {
    
    digitalWrite (YmotorPULSE, ON);
    //digitalWrite (ledPin, ON);
    digitalWrite (YmotorPULSE, OFF);
    delayMicroseconds (longdelay);
    //digitalWrite (ledPin, OFF);
  }
  ypositioncount++;
}

void fastdown()
{digitalWrite (YmotorDIR, OFF);
  for (a=0; a<stepsPerPixel; a++)
  {
    
    digitalWrite (YmotorPULSE, ON);
    //digitalWrite (ledPin, ON);
    digitalWrite (YmotorPULSE, OFF);
    delayMicroseconds (shortdelay);
    //digitalWrite (ledPin, OFF);
  }
  ypositioncount--;
}

void slowdown()
{digitalWrite (YmotorDIR, OFF);
  for (a=0; a<stepsPerPixel; a++)
  {
    
    digitalWrite (YmotorPULSE, ON);
    //digitalWrite (ledPin, ON);
    digitalWrite (YmotorPULSE, OFF);
    delayMicroseconds (longdelay);
    //digitalWrite (ledPin, OFF);
  }
  ypositioncount--;
}

void xresetposition()
{
  while (xpositioncount!=0){
    if (xpositioncount > 0){
      fastleft();
    }
    if (xpositioncount < 0){
      fastright();
    }
  }
}


void yresetposition()
{
  while (ypositioncount!=0){
    if (ypositioncount > 0){
      fastdown();
    }
    if (ypositioncount < 0){
      fastup();
    }
  }
}


