import processing.serial.*; //import the Serial library
Serial myPort;  //the Serial port object
String val;
// since we're doing serial handshaking, 
// we need to check if we've heard from the microcontroller
boolean firstContact = false;

int totalsteps;
String [] output;
int counter = 0;
int senddata = 1;
String[] lines;

int a = 0;
//int linelength = 0;

void setup() {
  size(200, 200); //make our canvas 200 x 200 pixels big
  //  initialize your serial port and set the baud rate to 9600
  myPort = new Serial(this, "COM3", 9600);
  myPort.bufferUntil('\n'); 
  lines = loadStrings("cncinstructions.txt");
  println("Setup End");
  delay(1000);
  myPort.clear();
}


void draw() {
  //we can leave the draw method empty, 
  //because all our programming happens in the serialEvent (see below)
}


void serialEvent( Serial myPort) {//runs when processing receives serial data
  //println("serial event start");
  //put the incoming data into a String - 
  //the '\n' is our end delimiter indicating the end of a complete packet
  val = myPort.readStringUntil('\n');
    if (val != null) {
    //print("Processing received: ");
    //trim whitespace and formatting characters (like carriage return)
    val = trim(val);
    //println(val); //**********************ENABLE THIS TO VIEW INCOMING PRINTS FROM ARDUINO*************************
    myPort.clear();}
  
  if (firstContact == false) {
    if (val.equals("A")) {
      myPort.clear();
      firstContact = true;
      myPort.write("A");
      println("Established contact");
      println();
      delay(1000);
    }
  }
  //make sure our data isn't empty before continuing

    else if (val.equals("1")) { //Command from Arduino to send linelength
      //println(millis());
      myPort.clear();
      output = splitTokens(lines[0], ",");
      int linelength = output[counter].length();
      totalsteps = output.length;
      //println("Sending linelength of " + linelength);
      linelength = linelength + 10;// ADDING 10 so it is 2 digits for Arduino to read - Arduino then subtracts 10 before printing again
      myPort.write(linelength);
      print("Instruction set ");
      println(counter + " of " + (totalsteps-1) + " (" + (int)counter*100/(totalsteps -1) + "%)");
      
    }
    
    else if (val.equals("2")) {//Arduino command to send Instruction set
      if (senddata==1) {
        myPort.clear();
        myPort.write(output[counter]);
        //print("Sending Instructions: ");
        //println(output[counter] );
      }
      counter++;

      if (counter>=totalsteps) {senddata = 0;
                print("DONE! Seconds elapsed: " + millis()/1000);}
    }
  }


