#ifndef fonts_h
#define fonts_h
#include <avr/pgmspace.h>
#include "Arduino.h"


typedef struct _font_info 
{ 
   byte CharacterHeight; 
   char StartCharacter; 
   char EndCharacter; 
   const unsigned int *Descriptors; 
   const byte *Bitmaps; 
   //int Bitmaps;
}FONT_INFO; 



/* Character bitmaps for small fixed width font (Terminal_8pt) */
const PROGMEM byte Terminal_8pt[] = 
{
	// @0 ' ' (8 pixels wide)
	//         
	//         
	//         
	//         
	//         
	//         
	//         
	//         
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @8 '!' (2 pixels wide)
	// ##
	// ##
	// ##
	// ##
	//   
	//   
	// ##
	//   
	0x4F, 0x4F, 

	// @10 '"' (5 pixels wide)
	// ## ##
	// ## ##
	// ## ##
	//      
	//      
	//      
	//      
	//      
	0x07, 0x07, 0x00, 0x07, 0x07, 

	// @15 '#' (7 pixels wide)
	//  ## ## 
	//  ## ## 
	// #######
	//  ## ## 
	// #######
	//  ## ## 
	//  ## ## 
	//        
	0x14, 0x7F, 0x7F, 0x14, 0x7F, 0x7F, 0x14, 

	// @22 '$' (6 pixels wide)
	//   ##  
	//  #####
	// ####  
	//  #### 
	//   ####
	// ##### 
	//   ##  
	//       
	0x24, 0x2E, 0x7F, 0x7F, 0x3A, 0x12, 

	// @28 '%' (7 pixels wide)
	//        
	// ###  ##
	// ### ## 
	//    ##  
	//   ##   
	//  ## ###
	// ##  ###
	//        
	0x46, 0x66, 0x36, 0x18, 0x6C, 0x66, 0x62, 

	// @35 '&' (7 pixels wide)
	//  ###   
	// ## ##  
	// ## ##  
	//  ###   
	// ## ####
	// ##  ## 
	//  ######
	//        
	0x36, 0x7F, 0x49, 0x5F, 0x76, 0x70, 0x50, 

	// @42 ''' (4 pixels wide)
	//   ##
	//  ## 
	// ##  
	//     
	//     
	//     
	//     
	//     
	0x04, 0x06, 0x03, 0x01, 

	// @46 '(' (4 pixels wide)
	//   ##
	//  ## 
	// ##  
	// ##  
	// ##  
	//  ## 
	//   ##
	//     
	0x1C, 0x3E, 0x63, 0x41, 

	// @50 ')' (4 pixels wide)
	// ##  
	//  ## 
	//   ##
	//   ##
	//   ##
	//  ## 
	// ##  
	//     
	0x41, 0x63, 0x3E, 0x1C, 

	// @54 '*' (6 pixels wide)
	//   ##  
	// ######
	//  #### 
	// ######
	//  #### 
	// ######
	//   ##  
	//       
	0x2A, 0x3E, 0x7F, 0x7F, 0x3E, 0x2A, 

	// @60 '+' (6 pixels wide)
	//       
	//   ##  
	//   ##  
	// ######
	//   ##  
	//   ##  
	//       
	//       
	0x08, 0x08, 0x3E, 0x3E, 0x08, 0x08, 

	// @66 ',' (3 pixels wide)
	//    
	//    
	//    
	//    
	//    
	//  ##
	//  ##
	// ## 
	0x80, 0xE0, 0x60, 

	// @69 '-' (7 pixels wide)
	//        
	//        
	//        
	// #######
	//        
	//        
	//        
	//        
	0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 

	// @76 '.' (3 pixels wide)
	//    
	//    
	//    
	//    
	//    
	// ###
	// ###
	//    
	0x60, 0x60, 0x60, 

	// @79 '/' (7 pixels wide)
	//        
	//      ##
	//     ## 
	//    ##  
	//   ##   
	//  ##    
	// ##     
	//        
	0x40, 0x60, 0x30, 0x18, 0x0C, 0x06, 0x02, 

	// @86 '0' (7 pixels wide)
	//  ##### 
	// ##   ##
	// ##  ###
	// #######
	// ###  ##
	// ##   ##
	//  ##### 
	//        
	0x3E, 0x7F, 0x59, 0x49, 0x4D, 0x7F, 0x3E, 

	// @93 '1' (6 pixels wide)
	//   ##  
	//  ###  
	// ####  
	//   ##  
	//   ##  
	//   ##  
	// ######
	//       
	0x44, 0x46, 0x7F, 0x7F, 0x40, 0x40, 

	// @99 '2' (7 pixels wide)
	//  ##### 
	// ##   ##
	//      ##
	//    ### 
	//  ###   
	// ##     
	// #######
	//        
	0x62, 0x73, 0x51, 0x59, 0x49, 0x4F, 0x46, 

	// @106 '3' (7 pixels wide)
	//  ##### 
	// ##   ##
	//      ##
	//   #### 
	//      ##
	// ##   ##
	//  ##### 
	//        
	0x22, 0x63, 0x49, 0x49, 0x49, 0x7F, 0x36, 

	// @113 '4' (7 pixels wide)
	//     ## 
	//    ### 
	//   #### 
	//  ## ## 
	// #######
	//     ## 
	//     ## 
	//        
	0x10, 0x18, 0x1C, 0x16, 0x7F, 0x7F, 0x10, 

	// @120 '5' (7 pixels wide)
	// #######
	// ##     
	// #####  
	//     ## 
	//      ##
	// ##  ## 
	//  ####  
	//        
	0x27, 0x67, 0x45, 0x45, 0x6D, 0x39, 0x11, 

	// @127 '6' (7 pixels wide)
	//   #### 
	//  ##    
	// ##     
	// ###### 
	// ##   ##
	// ##   ##
	//  ##### 
	//        
	0x3C, 0x7E, 0x4B, 0x49, 0x49, 0x79, 0x30, 

	// @134 '7' (7 pixels wide)
	// #######
	// ##   ##
	//     ## 
	//    ##  
	//   ##   
	//   ##   
	//   ##   
	//        
	0x03, 0x03, 0x71, 0x79, 0x0D, 0x07, 0x03, 

	// @141 '8' (7 pixels wide)
	//  ##### 
	// ##   ##
	// ##   ##
	//  ##### 
	// ##   ##
	// ##   ##
	//  ##### 
	//        
	0x36, 0x7F, 0x49, 0x49, 0x49, 0x7F, 0x36, 

	// @148 '9' (7 pixels wide)
	//  ##### 
	// ##   ##
	// ##   ##
	//  ######
	//      ##
	//     ## 
	//  ####  
	//        
	0x06, 0x4F, 0x49, 0x49, 0x69, 0x3F, 0x1E, 

	// @155 ':' (2 pixels wide)
	//   
	//   
	// ##
	//   
	//   
	// ##
	//   
	//   
	0x24, 0x24, 

	// @157 ';' (3 pixels wide)
	//    
	//    
	//  ##
	//    
	//    
	//  ##
	//  ##
	// ## 
	0x80, 0xE4, 0x64, 

	// @160 '<' (7 pixels wide)
	//    ####
	//   ###  
	//  ###   
	// ###    
	//  ###   
	//   ###  
	//    ####
	//        
	0x08, 0x1C, 0x3E, 0x77, 0x63, 0x41, 0x41, 

	// @167 '=' (7 pixels wide)
	//        
	//        
	// #######
	//        
	// #######
	//        
	//        
	//        
	0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 

	// @174 '>' (7 pixels wide)
	// ####   
	//   ###  
	//    ### 
	//     ###
	//    ### 
	//   ###  
	// ####   
	//        
	0x41, 0x41, 0x63, 0x77, 0x3E, 0x1C, 0x08, 

	// @181 '?' (7 pixels wide)
	//  ##### 
	// ##   ##
	//      ##
	//    ### 
	//   ##   
	//        
	//   ##   
	//        
	0x02, 0x03, 0x51, 0x59, 0x09, 0x0F, 0x06, 

	// @188 '@' (7 pixels wide)
	//   #### 
	//  ##  ##
	// ## ####
	// #######
	// ## ### 
	//  ##    
	//   #####
	//        
	0x1C, 0x3E, 0x6B, 0x5D, 0x5D, 0x5F, 0x4E, 

	// @195 'A' (7 pixels wide)
	//   ###  
	//  ## ## 
	// ##   ##
	// #######
	// ##   ##
	// ##   ##
	// ##   ##
	//        
	0x7C, 0x7E, 0x0B, 0x09, 0x0B, 0x7E, 0x7C, 

	// @202 'B' (7 pixels wide)
	// ###### 
	//  ##  ##
	//  ##  ##
	//  ##### 
	//  ##  ##
	//  ##  ##
	// ###### 
	//        
	0x41, 0x7F, 0x7F, 0x49, 0x49, 0x7F, 0x36, 

	// @209 'C' (7 pixels wide)
	//   #### 
	//  ##  ##
	// ##     
	// ##     
	// ##     
	//  ##  ##
	//   #### 
	//        
	0x1C, 0x3E, 0x63, 0x41, 0x41, 0x63, 0x22, 

	// @216 'D' (7 pixels wide)
	// #####  
	//  ## ## 
	//  ##  ##
	//  ##  ##
	//  ##  ##
	//  ## ## 
	// #####  
	//        
	0x41, 0x7F, 0x7F, 0x41, 0x63, 0x3E, 0x1C, 

	// @223 'E' (7 pixels wide)
	// #######
	// ##     
	// ##     
	// #####  
	// ##     
	// ##     
	// #######
	//        
	0x7F, 0x7F, 0x49, 0x49, 0x49, 0x41, 0x41, 

	// @230 'F' (7 pixels wide)
	// #######
	// ##     
	// ##     
	// #####  
	// ##     
	// ##     
	// ##     
	//        
	0x7F, 0x7F, 0x09, 0x09, 0x09, 0x01, 0x01, 

	// @237 'G' (7 pixels wide)
	//   #### 
	//  ##  ##
	// ##     
	// ## ####
	// ##   ##
	//  ##  ##
	//   #### 
	//        
	0x1C, 0x3E, 0x63, 0x49, 0x49, 0x7B, 0x3A, 

	// @244 'H' (7 pixels wide)
	// ##   ##
	// ##   ##
	// ##   ##
	// #######
	// ##   ##
	// ##   ##
	// ##   ##
	//        
	0x7F, 0x7F, 0x08, 0x08, 0x08, 0x7F, 0x7F, 

	// @251 'I' (4 pixels wide)
	// ####
	//  ## 
	//  ## 
	//  ## 
	//  ## 
	//  ## 
	// ####
	//     
	0x41, 0x7F, 0x7F, 0x41, 

	// @255 'J' (7 pixels wide)
	//    ####
	//     ## 
	//     ## 
	//     ## 
	//     ## 
	// ##  ## 
	//  ####  
	//        
	0x20, 0x60, 0x40, 0x41, 0x7F, 0x3F, 0x01, 

	// @262 'K' (7 pixels wide)
	// ##   ##
	// ##  ## 
	// ## ##  
	// ####   
	// ## ##  
	// ##  ## 
	// ##   ##
	//        
	0x7F, 0x7F, 0x08, 0x1C, 0x36, 0x63, 0x41, 

	// @269 'L' (7 pixels wide)
	// ##     
	// ##     
	// ##     
	// ##     
	// ##     
	// ##     
	// #######
	//        
	0x7F, 0x7F, 0x40, 0x40, 0x40, 0x40, 0x40, 

	// @276 'M' (7 pixels wide)
	// ##   ##
	// ### ###
	// #######
	// #######
	// ##   ##
	// ##   ##
	// ##   ##
	//        
	0x7F, 0x7F, 0x0E, 0x0C, 0x0E, 0x7F, 0x7F, 

	// @283 'N' (7 pixels wide)
	// ##   ##
	// ###  ##
	// #### ##
	// ## ####
	// ##  ###
	// ##   ##
	// ##   ##
	//        
	0x7F, 0x7F, 0x06, 0x0C, 0x18, 0x7F, 0x7F, 

	// @290 'O' (7 pixels wide)
	//   ###  
	//  ## ## 
	// ##   ##
	// ##   ##
	// ##   ##
	//  ## ## 
	//   ###  
	//        
	0x1C, 0x3E, 0x63, 0x41, 0x63, 0x3E, 0x1C, 

	// @297 'P' (7 pixels wide)
	// ###### 
	// ##   ##
	// ##   ##
	// ###### 
	// ##     
	// ##     
	// ##     
	//        
	0x7F, 0x7F, 0x09, 0x09, 0x09, 0x0F, 0x06, 

	// @304 'Q' (7 pixels wide)
	//   ###  
	//  ## ## 
	// ##   ##
	// ##   ##
	// ## ####
	//  ## ## 
	//   #####
	//        
	0x1C, 0x3E, 0x63, 0x51, 0x73, 0x7E, 0x5C, 

	// @311 'R' (7 pixels wide)
	// ###### 
	// ##   ##
	// ##   ##
	// ###### 
	// ## ##  
	// ##  ## 
	// ##   ##
	//        
	0x7F, 0x7F, 0x09, 0x19, 0x39, 0x6F, 0x46, 

	// @318 'S' (7 pixels wide)
	//  ##### 
	// ##   ##
	// ##     
	//  ##### 
	//      ##
	// ##   ##
	//  ##### 
	//        
	0x26, 0x6F, 0x49, 0x49, 0x49, 0x7B, 0x32, 

	// @325 'T' (6 pixels wide)
	// ######
	//   ##  
	//   ##  
	//   ##  
	//   ##  
	//   ##  
	//   ##  
	//       
	0x01, 0x01, 0x7F, 0x7F, 0x01, 0x01, 

	// @331 'U' (7 pixels wide)
	// ##   ##
	// ##   ##
	// ##   ##
	// ##   ##
	// ##   ##
	// ##   ##
	//  ##### 
	//        
	0x3F, 0x7F, 0x40, 0x40, 0x40, 0x7F, 0x3F, 

	// @338 'V' (7 pixels wide)
	// ##   ##
	// ##   ##
	// ##   ##
	//  ## ## 
	//  ## ## 
	//   ###  
	//   ###  
	//        
	0x07, 0x1F, 0x78, 0x60, 0x78, 0x1F, 0x07, 

	// @345 'W' (7 pixels wide)
	// ##   ##
	// ##   ##
	// ##   ##
	// #######
	// #######
	// ### ###
	// ##   ##
	//        
	0x7F, 0x7F, 0x38, 0x18, 0x38, 0x7F, 0x7F, 

	// @352 'X' (7 pixels wide)
	// ##   ##
	// ##   ##
	//  ## ## 
	//   ###  
	//  ## ## 
	// ##   ##
	// ##   ##
	//        
	0x63, 0x77, 0x1C, 0x08, 0x1C, 0x77, 0x63, 

	// @359 'Y' (6 pixels wide)
	// ##  ##
	// ##  ##
	// ##  ##
	//  #### 
	//   ##  
	//   ##  
	//   ##  
	//       
	0x07, 0x0F, 0x78, 0x78, 0x0F, 0x07, 

	// @365 'Z' (7 pixels wide)
	// #######
	//      ##
	//     ## 
	//   ###  
	//  ##    
	// ##     
	// #######
	//        
	0x61, 0x71, 0x59, 0x49, 0x4D, 0x47, 0x43, 

	// @372 '[' (5 pixels wide)
	// #####
	// ##   
	// ##   
	// ##   
	// ##   
	// ##   
	// #####
	//      
	0x7F, 0x7F, 0x41, 0x41, 0x41, 

	// @377 '\' (7 pixels wide)
	//        
	// ##     
	//  ##    
	//   ##   
	//    ##  
	//     ## 
	//      ##
	//        
	0x02, 0x06, 0x0C, 0x18, 0x30, 0x60, 0x40, 

	// @384 ']' (5 pixels wide)
	// #####
	//    ##
	//    ##
	//    ##
	//    ##
	//    ##
	// #####
	//      
	0x41, 0x41, 0x41, 0x7F, 0x7F, 

	// @389 '^' (6 pixels wide)
	//       
	//   ##  
	//  #### 
	// ##  ##
	//       
	//       
	//       
	//       
	0x08, 0x0C, 0x06, 0x06, 0x0C, 0x08, 

	// @395 '_' (9 pixels wide)
	//          
	//          
	//          
	//          
	//          
	//          
	//          
	// #########
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 

	// @404 '`' (4 pixels wide)
	// ##  
	//  ## 
	//   ##
	//     
	//     
	//     
	//     
	//     
	0x01, 0x03, 0x06, 0x04, 

	// @408 'a' (7 pixels wide)
	//        
	//        
	//  ####  
	//     ## 
	//  ##### 
	// ##  ## 
	//  ######
	//        
	0x20, 0x74, 0x54, 0x54, 0x7C, 0x78, 0x40, 

	// @415 'b' (7 pixels wide)
	// ##     
	// ##     
	// ###### 
	// ###  ##
	// ##   ##
	// ###  ##
	// ###### 
	//        
	0x7F, 0x7F, 0x6C, 0x44, 0x44, 0x7C, 0x38, 

	// @422 'c' (7 pixels wide)
	//        
	//        
	//  ##### 
	// ##   ##
	// ##     
	// ##   ##
	//  ##### 
	//        
	0x38, 0x7C, 0x44, 0x44, 0x44, 0x6C, 0x28, 

	// @429 'd' (7 pixels wide)
	//      ##
	//      ##
	//  ######
	// ##  ###
	// ##   ##
	// ##  ###
	//  ######
	//        
	0x38, 0x7C, 0x44, 0x44, 0x6C, 0x7F, 0x7F, 

	// @436 'e' (7 pixels wide)
	//        
	//        
	//  ##### 
	// ##   ##
	// #######
	// ##     
	//  ##### 
	//        
	0x38, 0x7C, 0x54, 0x54, 0x54, 0x5C, 0x18, 

	// @443 'f' (7 pixels wide)
	//    ### 
	//   ## ##
	//   ##   
	// ###### 
	//   ##   
	//   ##   
	//   ##   
	//        
	0x08, 0x08, 0x7E, 0x7F, 0x09, 0x0B, 0x02, 

	// @450 'g' (7 pixels wide)
	//        
	//        
	//  ######
	// ##  ###
	// ##  ###
	//  ######
	//      ##
	//  ##### 
	0x18, 0xBC, 0xA4, 0xA4, 0xBC, 0xFC, 0x7C, 

	// @457 'h' (7 pixels wide)
	// ##     
	// ##     
	// ###### 
	// ###  ##
	// ##   ##
	// ##   ##
	// ##   ##
	//        
	0x7F, 0x7F, 0x0C, 0x04, 0x04, 0x7C, 0x78, 

	// @464 'i' (4 pixels wide)
	//  ## 
	//     
	// ### 
	//  ## 
	//  ## 
	//  ## 
	// ####
	//     
	0x44, 0x7D, 0x7D, 0x40, 

	// @468 'j' (6 pixels wide)
	//     ##
	//       
	//    ###
	//     ##
	//     ##
	//     ##
	// ##  ##
	//  #### 
	0x40, 0xC0, 0x80, 0x84, 0xFD, 0x7D, 

	// @474 'k' (6 pixels wide)
	// ##    
	// ##    
	// ##  ##
	// ## ## 
	// ####  
	// ##### 
	// ##  ##
	//       
	0x7F, 0x7F, 0x30, 0x38, 0x6C, 0x44, 

	// @480 'l' (4 pixels wide)
	// ### 
	//  ## 
	//  ## 
	//  ## 
	//  ## 
	//  ## 
	// ####
	//     
	0x41, 0x7F, 0x7F, 0x40, 

	// @484 'm' (8 pixels wide)
	//         
	//         
	// ####### 
	// ## ## ##
	// ## ## ##
	// ## ## ##
	// ## ## ##
	//         
	0x7C, 0x7C, 0x04, 0x7C, 0x7C, 0x04, 0x7C, 0x78, 

	// @492 'n' (7 pixels wide)
	//        
	//        
	// ###### 
	// ###  ##
	// ##   ##
	// ##   ##
	// ##   ##
	//        
	0x7C, 0x7C, 0x0C, 0x04, 0x04, 0x7C, 0x78, 

	// @499 'o' (7 pixels wide)
	//        
	//        
	//  ##### 
	// ##   ##
	// ##   ##
	// ##   ##
	//  ##### 
	//        
	0x38, 0x7C, 0x44, 0x44, 0x44, 0x7C, 0x38, 

	// @506 'p' (7 pixels wide)
	//        
	//        
	// ###### 
	// ###  ##
	// ###  ##
	// ###### 
	// ##     
	// ##     
	0xFC, 0xFC, 0x3C, 0x24, 0x24, 0x3C, 0x18, 

	// @513 'q' (7 pixels wide)
	//        
	//        
	//  ######
	// ##  ###
	// ##  ###
	//  ######
	//      ##
	//      ##
	0x18, 0x3C, 0x24, 0x24, 0x3C, 0xFC, 0xFC, 

	// @520 'r' (7 pixels wide)
	//        
	//        
	// ###### 
	// ###  ##
	// ##     
	// ##     
	// ##     
	//        
	0x7C, 0x7C, 0x0C, 0x04, 0x04, 0x0C, 0x08, 

	// @527 's' (7 pixels wide)
	//        
	//        
	//  ######
	// ##     
	//  ##### 
	//      ##
	// ###### 
	//        
	0x48, 0x5C, 0x54, 0x54, 0x54, 0x74, 0x24, 

	// @534 't' (7 pixels wide)
	//   ##   
	//   ##   
	// ###### 
	//   ##   
	//   ##   
	//   ## ##
	//    ### 
	//        
	0x04, 0x04, 0x3F, 0x7F, 0x44, 0x64, 0x20, 

	// @541 'u' (7 pixels wide)
	//        
	//        
	// ##   ##
	// ##   ##
	// ##   ##
	// ##  ###
	//  ######
	//        
	0x3C, 0x7C, 0x40, 0x40, 0x60, 0x7C, 0x7C, 

	// @548 'v' (7 pixels wide)
	//        
	//        
	// ##   ##
	// ##   ##
	// ##   ##
	//  ## ## 
	//   ###  
	//        
	0x1C, 0x3C, 0x60, 0x40, 0x60, 0x3C, 0x1C, 

	// @555 'w' (8 pixels wide)
	//         
	//         
	// ##    ##
	// ## ## ##
	// ## ## ##
	// ## ## ##
	//  ###### 
	//         
	0x3C, 0x7C, 0x40, 0x78, 0x78, 0x40, 0x7C, 0x3C, 

	// @563 'x' (7 pixels wide)
	//        
	//        
	// ##   ##
	//  ## ## 
	//   ###  
	//  ## ## 
	// ##   ##
	//        
	0x44, 0x6C, 0x38, 0x10, 0x38, 0x6C, 0x44, 

	// @570 'y' (7 pixels wide)
	//        
	//        
	// ##   ##
	// ##   ##
	// ##  ###
	//  ######
	//      ##
	//  ##### 
	0x1C, 0xBC, 0xA0, 0xA0, 0xB0, 0xFC, 0x7C, 

	// @577 'z' (7 pixels wide)
	//        
	//        
	// #######
	//     ## 
	//   ###  
	//  ##    
	// #######
	//        
	0x44, 0x64, 0x74, 0x54, 0x5C, 0x4C, 0x44, 

	// @584 '{' (6 pixels wide)
	//    ###
	//   ##  
	//   ##  
	// ###   
	//   ##  
	//   ##  
	//    ###
	//       
	0x08, 0x08, 0x3E, 0x77, 0x41, 0x41, 

	// @590 '|' (2 pixels wide)
	// ##
	// ##
	// ##
	// ##
	// ##
	// ##
	// ##
	// ##
	0xFF, 0xFF, 

	// @592 '}' (6 pixels wide)
	// ###   
	//   ##  
	//   ##  
	//    ###
	//   ##  
	//   ##  
	// ###   
	//       
	0x41, 0x41, 0x77, 0x3E, 0x08, 0x08, 

	// @598 '~' (8 pixels wide)
	//  ###  ##
	// ## ## ##
	// ##  ### 
	//         
	//         
	//         
	//         
	//         
	0x06, 0x07, 0x01, 0x03, 0x06, 0x04, 0x07, 0x03, 

};


// Character descriptors for Terminal_8pt
// { [Char width in bits], [Offset into Terminal_8ptCharBitmaps in bytes] }
const PROGMEM unsigned int Terminal_8ptDescriptors[][2] = 
{
	{8, 0}, 		//   
	{2, 8}, 		// ! 
	{5, 10}, 		// " 
	{7, 15}, 		// # 
	{6, 22}, 		// $ 
	{7, 28}, 		// % 
	{7, 35}, 		// & 
	{4, 42}, 		// ' 
	{4, 46}, 		// ( 
	{4, 50}, 		// ) 
	{6, 54}, 		// * 
	{6, 60}, 		// + 
	{3, 66}, 		// , 
	{7, 69}, 		// - 
	{3, 76}, 		// . 
	{7, 79}, 		// / 
	{7, 86}, 		// 0 
	{6, 93}, 		// 1 
	{7, 99}, 		// 2 
	{7, 106}, 		// 3 
	{7, 113}, 		// 4 
	{7, 120}, 		// 5 
	{7, 127}, 		// 6 
	{7, 134}, 		// 7 
	{7, 141}, 		// 8 
	{7, 148}, 		// 9 
	{2, 155}, 		// : 
	{3, 157}, 		// ; 
	{7, 160}, 		// < 
	{7, 167}, 		// = 
	{7, 174}, 		// > 
	{7, 181}, 		// ? 
	{7, 188}, 		// @ 
	{7, 195}, 		// A 
	{7, 202}, 		// B 
	{7, 209}, 		// C 
	{7, 216}, 		// D 
	{7, 223}, 		// E 
	{7, 230}, 		// F 
	{7, 237}, 		// G 
	{7, 244}, 		// H 
	{4, 251}, 		// I 
	{7, 255}, 		// J 
	{7, 262}, 		// K 
	{7, 269}, 		// L 
	{7, 276}, 		// M 
	{7, 283}, 		// N 
	{7, 290}, 		// O 
	{7, 297}, 		// P 
	{7, 304}, 		// Q 
	{7, 311}, 		// R 
	{7, 318}, 		// S 
	{6, 325}, 		// T 
	{7, 331}, 		// U 
	{7, 338}, 		// V 
	{7, 345}, 		// W 
	{7, 352}, 		// X 
	{6, 359}, 		// Y 
	{7, 365}, 		// Z 
	{5, 372}, 		// [ 
	{7, 377}, 		// backslash 
	{5, 384}, 		// ] 
	{6, 389}, 		// ^ 
	{9, 395}, 		// _ 
	{4, 404}, 		// ` 
	{7, 408}, 		// a 
	{7, 415}, 		// b 
	{7, 422}, 		// c 
	{7, 429}, 		// d 
	{7, 436}, 		// e 
	{7, 443}, 		// f 
	{7, 450}, 		// g 
	{7, 457}, 		// h 
	{4, 464}, 		// i 
	{6, 468}, 		// j 
	{6, 474}, 		// k 
	{4, 480}, 		// l 
	{8, 484}, 		// m 
	{7, 492}, 		// n 
	{7, 499}, 		// o 
	{7, 506}, 		// p 
	{7, 513}, 		// q 
	{7, 520}, 		// r 
	{7, 527}, 		// s 
	{7, 534}, 		// t 
	{7, 541}, 		// u 
	{7, 548}, 		// v 
	{8, 555}, 		// w 
	{7, 563}, 		// x 
	{7, 570}, 		// y 
	{7, 577}, 		// z 
	{6, 584}, 		// { 
	{2, 590}, 		// | 
	{6, 592}, 		// } 
	{8, 598}, 		// ~ 

};

// Font information for Terminal_8pt
const FONT_INFO Terminal_8ptFontInfo =
{
	1, //  Character height
	' ', //  Start character
	'~', //  End character
/*	NULL, //  Character block lookup */
	Terminal_8ptDescriptors[0], //  Character descriptor array
	Terminal_8pt, //  Character bitmap array
};









/* Character bitmaps for medium proportional font (MedProp_11pt) */
const PROGMEM byte MedProp_11pt[] = 
{
	// @0 ' ' (8 pixels wide)
	//         
	//         
	//         
	//         
	//         
	//         
	//         
	//         
	//         
	//         
	//         
	//         
	//         
	//         
	//         
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @16 '!' (2 pixels wide)
	//   
	// ##
	// ##
	// ##
	// ##
	// ##
	// ##
	// ##
	// ##
	//   
	// ##
	// ##
	//   
	//   
	//   
	0xFE, 0xFE, 
	0x0D, 0x0D, 

	// @20 '"' (5 pixels wide)
	//      
	// ## ##
	// ## ##
	// ## ##
	// ## ##
	//      
	//      
	//      
	//      
	//      
	//      
	//      
	//      
	//      
	//      
	0x1E, 0x1E, 0x00, 0x1E, 0x1E, 
	0x00, 0x00, 0x00, 0x00, 0x00, 

	// @30 '#' (8 pixels wide)
	//         
	//    #  # 
	//    #  # 
	//   ##  # 
	//  #######
	//   #  #  
	//   #  #  
	//   #  #  
	// ####### 
	//  #  ##  
	//  #  #   
	//  #  #   
	//         
	//         
	//         
	0x00, 0x10, 0xF8, 0x1E, 0x10, 0xF0, 0x1E, 0x10, 
	0x01, 0x0F, 0x01, 0x01, 0x0F, 0x03, 0x01, 0x00, 

	// @46 '$' (8 pixels wide)
	//         
	//   ####  
	//  ###### 
	//  ## ### 
	//  ## #   
	//  ####   
	//   ##### 
	//     ####
	//     # ##
	// ##  # ##
	//  ###### 
	//   ####  
	//         
	//         
	//         
	0x00, 0x3C, 0x7E, 0x66, 0xFE, 0xCE, 0xCC, 0x80, 
	0x02, 0x06, 0x0C, 0x0C, 0x0F, 0x0C, 0x07, 0x03, 

	// @62 '%' (13 pixels wide)
	//              
	//  ####    #   
	//  #  #   ##   
	// ##  #   #    
	// ##  #  #     
	//  #  # ##     
	//  ###  # #### 
	//      ## #  # 
	//      #  #  ##
	//     #   #  ##
	//    ##   #  # 
	//    #    #### 
	//              
	//              
	//              
	0x18, 0x7E, 0x42, 0x42, 0x3E, 0x80, 0xE0, 0x30, 0xCC, 0x46, 0x40, 0xC0, 0x00, 
	0x00, 0x00, 0x00, 0x0C, 0x06, 0x01, 0x00, 0x00, 0x0F, 0x08, 0x08, 0x0F, 0x03, 

	// @88 '&' (10 pixels wide)
	//           
	//    ###    
	//   #####   
	//   #  ##   
	//   # ###   
	//   ###  #  
	//  ####  ## 
	// ## ## ##  
	// ##  ####  
	// ##   ###  
	// ##########
	//  ####  ###
	//           
	//           
	//           
	0x80, 0xC0, 0x7C, 0xE6, 0xF6, 0x1E, 0x9C, 0xE0, 0x40, 0x00, 
	0x07, 0x0F, 0x0C, 0x0C, 0x0D, 0x07, 0x07, 0x0F, 0x0C, 0x0C, 

	// @108 ''' (2 pixels wide)
	//   
	// ##
	// ##
	// ##
	// ##
	//   
	//   
	//   
	//   
	//   
	//   
	//   
	//   
	//   
	//   
	0x1E, 0x1E, 
	0x00, 0x00, 

	// @112 '(' (4 pixels wide)
	//     
	//   ##
	//  ## 
	//  ## 
	// ##  
	// ##  
	// ##  
	// ##  
	// ##  
	// ##  
	// ##  
	// ##  
	//  ## 
	//  ## 
	//   ##
	0xF0, 0xFC, 0x0E, 0x02, 
	0x0F, 0x3F, 0x70, 0x40, 

	// @120 ')' (4 pixels wide)
	//     
	// ##  
	//  ## 
	//  ## 
	//   ##
	//   ##
	//   ##
	//   ##
	//   ##
	//   ##
	//   ##
	//   ##
	//  ## 
	//  ## 
	// ##  
	0x02, 0x0E, 0xFC, 0xF0, 
	0x40, 0x70, 0x3F, 0x0F, 

	// @128 '*' (6 pixels wide)
	//       
	//   ##  
	//   ## #
	// ######
	//   ##  
	//  #### 
	//  #  # 
	//       
	//       
	//       
	//       
	//       
	//       
	//       
	//       
	0x08, 0x68, 0x3E, 0x3E, 0x68, 0x0C, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @140 '+' (7 pixels wide)
	//        
	//        
	//        
	//    #   
	//    #   
	//    #   
	// #######
	// #######
	//    #   
	//    #   
	//    #   
	//        
	//        
	//        
	//        
	0xC0, 0xC0, 0xC0, 0xF8, 0xC0, 0xC0, 0xC0, 
	0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 

	// @154 ',' (2 pixels wide)
	//   
	//   
	//   
	//   
	//   
	//   
	//   
	//   
	//   
	//   
	// ##
	// ##
	//  #
	// ##
	//   
	0x00, 0x00, 
	0x2C, 0x3C, 

	// @158 '-' (3 pixels wide)
	//    
	//    
	//    
	//    
	//    
	//    
	//    
	// ###
	// ###
	//    
	//    
	//    
	//    
	//    
	//    
	0x80, 0x80, 0x80, 
	0x01, 0x01, 0x01, 

	// @164 '.' (2 pixels wide)
	//   
	//   
	//   
	//   
	//   
	//   
	//   
	//   
	//   
	//   
	// ##
	// ##
	//   
	//   
	//   
	0x00, 0x00, 
	0x0C, 0x0C, 

	// @168 '/' (4 pixels wide)
	//     
	//   ##
	//   ##
	//   # 
	//   # 
	//  ## 
	//  ## 
	//  ## 
	//  #  
	//  #  
	// ##  
	// ##  
	//     
	//     
	//     
	0x00, 0xE0, 0xFE, 0x06, 
	0x0C, 0x0F, 0x00, 0x00, 

	// @176 '0' (6 pixels wide)
	//       
	//  #### 
	// ######
	// ##  ##
	// ##  ##
	// ##  ##
	// ##  ##
	// ##  ##
	// ##  ##
	// ##  ##
	// ######
	//  #### 
	//       
	//       
	//       
	0xFC, 0xFE, 0x06, 0x06, 0xFE, 0xFC, 
	0x07, 0x0F, 0x0C, 0x0C, 0x0F, 0x07, 

	// @188 '1' (7 pixels wide)
	//        
	//   ##   
	// ####   
	// # ##   
	//   ##   
	//   ##   
	//   ##   
	//   ##   
	//   ##   
	//   ##   
	// #######
	// #######
	//        
	//        
	//        
	0x0C, 0x04, 0xFE, 0xFE, 0x00, 0x00, 0x00, 
	0x0C, 0x0C, 0x0F, 0x0F, 0x0C, 0x0C, 0x0C, 

	// @202 '2' (7 pixels wide)
	//        
	//   #### 
	//  ######
	//  ##  ##
	//      ##
	//      ##
	//     ## 
	//    ##  
	//   ##   
	//  ##    
	// #######
	// #######
	//        
	//        
	//        
	0x00, 0x0C, 0x0E, 0x86, 0xC6, 0x7E, 0x3C, 
	0x0C, 0x0E, 0x0F, 0x0D, 0x0C, 0x0C, 0x0C, 

	// @216 '3' (7 pixels wide)
	//        
	//   #### 
	//  ######
	//  ##  ##
	//      ##
	//    ####
	//    ### 
	//     ###
	//      ##
	// ###  ##
	//  ######
	//   #### 
	//        
	//        
	//        
	0x00, 0x0C, 0x0E, 0x66, 0xE6, 0xFE, 0xBC, 
	0x02, 0x06, 0x0E, 0x0C, 0x0C, 0x0F, 0x07, 

	// @230 '4' (8 pixels wide)
	//         
	//     ### 
	//    #### 
	//    # ## 
	//   ## ## 
	//   #  ## 
	//  ##  ## 
	//  #   ## 
	// ########
	// ########
	//      ## 
	//      ## 
	//         
	//         
	//         
	0x00, 0xC0, 0x70, 0x1C, 0x06, 0xFE, 0xFE, 0x00, 
	0x03, 0x03, 0x03, 0x03, 0x03, 0x0F, 0x0F, 0x03, 

	// @246 '5' (8 pixels wide)
	//         
	//  ###### 
	//  ###### 
	//  ##     
	//  ##     
	//  #####  
	//  ###### 
	//      ###
	//      ###
	// ###  ## 
	//  ###### 
	//   ####  
	//         
	//         
	//         
	0x00, 0x7E, 0x7E, 0x66, 0x66, 0xE6, 0xC6, 0x80, 
	0x02, 0x06, 0x0E, 0x0C, 0x0C, 0x0F, 0x07, 0x01, 

	// @262 '6' (6 pixels wide)
	//       
	//  #### 
	// ######
	// ##  ##
	// ##    
	// ##### 
	// ######
	// ##  ##
	// ##  ##
	// ##  ##
	// ######
	//  #### 
	//       
	//       
	//       
	0xFC, 0xFE, 0x66, 0x66, 0xEE, 0xCC, 
	0x07, 0x0F, 0x0C, 0x0C, 0x0F, 0x07, 

	// @274 '7' (6 pixels wide)
	//       
	// ######
	// ######
	//     ##
	//     ##
	//    ## 
	//   ##  
	//   ##  
	//   ##  
	//  ##   
	//  ##   
	//  ##   
	//       
	//       
	//       
	0x06, 0x06, 0xC6, 0xE6, 0x3E, 0x1E, 
	0x00, 0x0E, 0x0F, 0x01, 0x00, 0x00, 

	// @286 '8' (8 pixels wide)
	//         
	//   ####  
	//  ###### 
	//  ##  ## 
	//  ##  ## 
	//  ###### 
	//  ###### 
	//  ##  ## 
	// ###  ###
	//  ##  ## 
	//  ###### 
	//   ####  
	//         
	//         
	//         
	0x00, 0xFC, 0xFE, 0x66, 0x66, 0xFE, 0xFC, 0x00, 
	0x01, 0x07, 0x0F, 0x0C, 0x0C, 0x0F, 0x07, 0x01, 

	// @302 '9' (6 pixels wide)
	//       
	//  #### 
	// ######
	// ##  ##
	// ##  ##
	// ##  ##
	// ######
	//  #####
	//     ##
	// ##  ##
	// ######
	//  #### 
	//       
	//       
	//       
	0x7C, 0xFE, 0xC6, 0xC6, 0xFE, 0xFC, 
	0x06, 0x0E, 0x0C, 0x0C, 0x0F, 0x07, 

	// @314 ':' (2 pixels wide)
	//   
	//   
	//   
	//   
	// ##
	// ##
	//   
	//   
	//   
	//   
	// ##
	// ##
	//   
	//   
	//   
	0x30, 0x30, 
	0x0C, 0x0C, 

	// @318 ';' (2 pixels wide)
	//   
	//   
	//   
	//   
	// ##
	// ##
	//   
	//   
	//   
	//   
	// ##
	// ##
	//  #
	//  #
	//   
	0x30, 0x30, 
	0x0C, 0x3C, 

	// @322 '<' (7 pixels wide)
	//        
	//        
	//        
	//       #
	//    ####
	// #####  
	// ##     
	// ##     
	//  ####  
	//    ####
	//       #
	//        
	//        
	//        
	//        
	0xE0, 0xE0, 0x20, 0x30, 0x30, 0x10, 0x18, 
	0x00, 0x01, 0x01, 0x03, 0x03, 0x02, 0x06, 

	// @336 '=' (7 pixels wide)
	//        
	//        
	//        
	//        
	//        
	// #######
	// #######
	//        
	// #######
	// #######
	//        
	//        
	//        
	//        
	//        
	0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 

	// @350 '>' (7 pixels wide)
	//        
	//        
	//        
	// #      
	// ####   
	//   #####
	//      ##
	//      ##
	//   #### 
	// ####   
	// #      
	//        
	//        
	//        
	//        
	0x18, 0x10, 0x30, 0x30, 0x20, 0xE0, 0xE0, 
	0x06, 0x02, 0x03, 0x03, 0x01, 0x01, 0x00, 

	// @364 '?' (7 pixels wide)
	//        
	//  ##### 
	// #######
	// ##   ##
	//      ##
	//      ##
	//     ## 
	//    ##  
	//   ##   
	//        
	//   ##   
	//   ##   
	//        
	//        
	//        
	0x0C, 0x0E, 0x06, 0x86, 0xC6, 0x7E, 0x3C, 
	0x00, 0x00, 0x0D, 0x0D, 0x00, 0x00, 0x00, 

	// @378 '@' (13 pixels wide)
	//              
	//     ######   
	//    ##     ## 
	//   #        # 
	//  #   ### #  #
	// ##  #   ##  #
	// #  ##   ##  #
	// #  #    #   #
	// #  #    #   #
	// #  ##  ##  # 
	// ##  ### ###  
	//  #           
	//   #      ##  
	//    ######    
	//              
	0xE0, 0x30, 0x08, 0xC4, 0x66, 0x12, 0x12, 0x12, 0xE2, 0x72, 0x04, 0x0C, 0xF0, 
	0x07, 0x0C, 0x10, 0x23, 0x26, 0x24, 0x24, 0x22, 0x27, 0x14, 0x14, 0x02, 0x01, 

	// @404 'A' (9 pixels wide)
	//          
	//    ###   
	//    ###   
	//    # #   
	//   ## ##  
	//   ## ##  
	//   ## ##  
	//   #####  
	//  ####### 
	//  ##   ## 
	//  ##   ## 
	// ###   ###
	//          
	//          
	//          
	0x00, 0x00, 0xF0, 0xFE, 0x86, 0xFE, 0xF0, 0x00, 0x00, 
	0x08, 0x0F, 0x0F, 0x01, 0x01, 0x01, 0x0F, 0x0F, 0x08, 

	// @422 'B' (9 pixels wide)
	//          
	// #######  
	// ######## 
	// ##    ###
	// ##    ###
	// ######## 
	// ######## 
	// ##     ##
	// ##     ##
	// ##     ##
	// #########
	// ######## 
	//          
	//          
	//          
	0xFE, 0xFE, 0x66, 0x66, 0x66, 0x66, 0x7E, 0xFC, 0x98, 
	0x0F, 0x0F, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0F, 0x07, 

	// @440 'C' (9 pixels wide)
	//          
	//   ###### 
	//  ########
	// ###    ##
	// ##       
	// ##       
	// ##       
	// ##       
	// ##       
	// ###    ##
	//  ########
	//   ###### 
	//          
	//          
	//          
	0xF8, 0xFC, 0x0E, 0x06, 0x06, 0x06, 0x06, 0x0E, 0x0C, 
	0x03, 0x07, 0x0E, 0x0C, 0x0C, 0x0C, 0x0C, 0x0E, 0x06, 

	// @458 'D' (9 pixels wide)
	//          
	// #######  
	// ######## 
	// ##    ###
	// ##     ##
	// ##     ##
	// ##     ##
	// ##     ##
	// ##     ##
	// ##    ###
	// ######## 
	// #######  
	//          
	//          
	//          
	0xFE, 0xFE, 0x06, 0x06, 0x06, 0x06, 0x0E, 0xFC, 0xF8, 
	0x0F, 0x0F, 0x0C, 0x0C, 0x0C, 0x0C, 0x0E, 0x07, 0x03, 

	// @476 'E' (8 pixels wide)
	//         
	// ########
	// ########
	// ##      
	// ##      
	// ########
	// ########
	// ##      
	// ##      
	// ##      
	// ########
	// ########
	//         
	//         
	//         
	0xFE, 0xFE, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 
	0x0F, 0x0F, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 

	// @492 'F' (7 pixels wide)
	//        
	// #######
	// #######
	// ##     
	// ##     
	// #######
	// #######
	// ##     
	// ##     
	// ##     
	// ##     
	// ##     
	//        
	//        
	//        
	0xFE, 0xFE, 0x66, 0x66, 0x66, 0x66, 0x66, 
	0x0F, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @506 'G' (10 pixels wide)
	//           
	//   ######  
	//  ######## 
	// ###    ###
	// ##        
	// ##        
	// ##   #####
	// ##   #####
	// ##      ##
	// ###     ##
	//  #########
	//   ######  
	//           
	//           
	//           
	0xF8, 0xFC, 0x0E, 0x06, 0x06, 0xC6, 0xC6, 0xCE, 0xCC, 0xC8, 
	0x03, 0x07, 0x0E, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x07, 0x07, 

	// @526 'H' (9 pixels wide)
	//          
	// ##     ##
	// ##     ##
	// ##     ##
	// ##     ##
	// #########
	// #########
	// ##     ##
	// ##     ##
	// ##     ##
	// ##     ##
	// ##     ##
	//          
	//          
	//          
	0xFE, 0xFE, 0x60, 0x60, 0x60, 0x60, 0x60, 0xFE, 0xFE, 
	0x0F, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x0F, 

	// @544 'I' (2 pixels wide)
	//   
	// ##
	// ##
	// ##
	// ##
	// ##
	// ##
	// ##
	// ##
	// ##
	// ##
	// ##
	//   
	//   
	//   
	0xFE, 0xFE, 
	0x0F, 0x0F, 

	// @548 'J' (7 pixels wide)
	//        
	//    ####
	//    ####
	//      ##
	//      ##
	//      ##
	//      ##
	//      ##
	//      ##
	// ###  ##
	//  ######
	//   #### 
	//        
	//        
	//        
	0x00, 0x00, 0x00, 0x06, 0x06, 0xFE, 0xFE, 
	0x02, 0x06, 0x0E, 0x0C, 0x0C, 0x0F, 0x07, 

	// @562 'K' (9 pixels wide)
	//          
	// ##     ##
	// ##    ## 
	// ##   ##  
	// ##  ##   
	// ## ##    
	// ######   
	// ### ##   
	// ##   ##  
	// ##   ### 
	// ##    ###
	// ##     ##
	//          
	//          
	//          
	0xFE, 0xFE, 0xC0, 0x60, 0xF0, 0xD8, 0x0C, 0x06, 0x02, 
	0x0F, 0x0F, 0x00, 0x00, 0x00, 0x03, 0x07, 0x0E, 0x0C, 

	// @580 'L' (8 pixels wide)
	//         
	// ##      
	// ##      
	// ##      
	// ##      
	// ##      
	// ##      
	// ##      
	// ##      
	// ##      
	// ########
	// ########
	//         
	//         
	//         
	0xFE, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x0F, 0x0F, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 

	// @596 'M' (11 pixels wide)
	//            
	// ###     ###
	// ###     ###
	// ####   ####
	// ####   ####
	// ## #   # ##
	// ## ## ## ##
	// ## ## ## ##
	// ##  # #  ##
	// ##  ###  ##
	// ##  ###  ##
	// ##   #   ##
	//            
	//            
	//            
	0xFE, 0xFE, 0x1E, 0xF8, 0xC0, 0x00, 0xC0, 0xF8, 0x1E, 0xFE, 0xFE, 
	0x0F, 0x0F, 0x00, 0x00, 0x07, 0x0E, 0x07, 0x00, 0x00, 0x0F, 0x0F, 

	// @618 'N' (9 pixels wide)
	//          
	// ###    ##
	// ###    ##
	// ####   ##
	// ####   ##
	// ## ##  ##
	// ## ### ##
	// ##  ## ##
	// ##   ####
	// ##   ####
	// ##    ###
	// ##    ###
	//          
	//          
	//          
	0xFE, 0xFE, 0x1E, 0x78, 0xE0, 0xC0, 0x00, 0xFE, 0xFE, 
	0x0F, 0x0F, 0x00, 0x00, 0x00, 0x03, 0x0F, 0x0F, 0x0F, 

	// @636 'O' (10 pixels wide)
	//           
	//   ######  
	//  ######## 
	// ###    ###
	// ##      ##
	// ##      ##
	// ##      ##
	// ##      ##
	// ##      ##
	// ###    ###
	//  ######## 
	//   #####   
	//           
	//           
	//           
	0xF8, 0xFC, 0x0E, 0x06, 0x06, 0x06, 0x06, 0x0E, 0xFC, 0xF8, 
	0x03, 0x07, 0x0E, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x07, 0x03, 

	// @656 'P' (8 pixels wide)
	//         
	// ####### 
	// ########
	// ##    ##
	// ##    ##
	// ##    ##
	// ########
	// ####### 
	// ##      
	// ##      
	// ##      
	// ##      
	//         
	//         
	//         
	0xFE, 0xFE, 0xC6, 0xC6, 0xC6, 0xC6, 0xFE, 0x7C, 
	0x0F, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @672 'Q' (10 pixels wide)
	//           
	//   ######  
	//  ######## 
	// ###    ###
	// ##      ##
	// ##      ##
	// ##      ##
	// ##      ##
	// ##      ##
	// ###    ###
	//  ######## 
	//   ######  
	//     ###   
	//      #### 
	//       ### 
	0xF8, 0xFC, 0x0E, 0x06, 0x06, 0x06, 0x06, 0x0E, 0xFC, 0xF8, 
	0x03, 0x07, 0x0E, 0x0C, 0x1C, 0x3C, 0x7C, 0x6E, 0x67, 0x03, 

	// @692 'R' (9 pixels wide)
	//          
	// ######## 
	// #########
	// ##     ##
	// ##     ##
	// ##     ##
	// ######## 
	// #######  
	// ##   ##  
	// ##    ## 
	// ##    ###
	// ##     ##
	//          
	//          
	//          
	0xFE, 0xFE, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0x7E, 0x3C, 
	0x0F, 0x0F, 0x00, 0x00, 0x00, 0x01, 0x07, 0x0E, 0x0C, 

	// @710 'S' (9 pixels wide)
	//          
	//   ###### 
	//  ########
	//  ##    ##
	//  ##      
	//  #####   
	//   ###### 
	//       ###
	//        ##
	// ###    ##
	//  ########
	//   ###### 
	//          
	//          
	//          
	0x00, 0x3C, 0x7E, 0x66, 0x66, 0x66, 0xC6, 0xCE, 0x8C, 
	0x02, 0x06, 0x0E, 0x0C, 0x0C, 0x0C, 0x0C, 0x0F, 0x07, 

	// @728 'T' (10 pixels wide)
	//           
	// ##########
	// ##########
	//     ##    
	//     ##    
	//     ##    
	//     ##    
	//     ##    
	//     ##    
	//     ##    
	//     ##    
	//     ##    
	//           
	//           
	//           
	0x06, 0x06, 0x06, 0x06, 0xFE, 0xFE, 0x06, 0x06, 0x06, 0x06, 
	0x00, 0x00, 0x00, 0x00, 0x0F, 0x0F, 0x00, 0x00, 0x00, 0x00, 

	// @748 'U' (9 pixels wide)
	//          
	// ##     ##
	// ##     ##
	// ##     ##
	// ##     ##
	// ##     ##
	// ##     ##
	// ##     ##
	// ##     ##
	// ###   ###
	//  ####### 
	//   #####  
	//          
	//          
	//          
	0xFE, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFE, 0xFE, 
	0x03, 0x07, 0x0E, 0x0C, 0x0C, 0x0C, 0x0E, 0x07, 0x03, 

	// @766 'V' (9 pixels wide)
	//          
	// ##     ##
	//  ##   ## 
	//  ##   ## 
	//  ##   ## 
	//  ##   ## 
	//   ## ##  
	//   ## ##  
	//   ## ##  
	//    # #   
	//    ###   
	//    ###   
	//          
	//          
	//          
	0x02, 0x3E, 0xFC, 0xC0, 0x00, 0xC0, 0xFC, 0x3E, 0x02, 
	0x00, 0x00, 0x01, 0x0F, 0x0C, 0x0F, 0x01, 0x00, 0x00, 

	// @784 'W' (13 pixels wide)
	//              
	// ##   ###   ##
	// ##   ###   ##
	//  ##  # #  ## 
	//  ##  # #  ## 
	//  ## ## ## ## 
	//  ## ## ## ## 
	//  ## ## ## ## 
	//   # ## ## #  
	//   ###   ###  
	//   ###   ###  
	//   ###   ###  
	//              
	//              
	//              
	0x06, 0xFE, 0xF8, 0x00, 0xE0, 0xFE, 0x06, 0xFE, 0xE0, 0x00, 0xF8, 0xFE, 0x06, 
	0x00, 0x00, 0x0F, 0x0E, 0x0F, 0x01, 0x00, 0x01, 0x0F, 0x0E, 0x0F, 0x00, 0x00, 

	// @810 'X' (10 pixels wide)
	//           
	//  ##    ## 
	//  ###  ### 
	//   ##  ##  
	//    ####   
	//    ####   
	//     ###   
	//    ####   
	//   ##  ##  
	//   ##  ##  
	//  ##    ## 
	// ###    ###
	//           
	//           
	//           
	0x00, 0x06, 0x0E, 0xBC, 0xF0, 0xF0, 0xFC, 0x0E, 0x06, 0x00, 
	0x08, 0x0C, 0x0F, 0x03, 0x00, 0x00, 0x03, 0x0F, 0x0C, 0x08, 

	// @830 'Y' (8 pixels wide)
	//         
	// ##    ##
	// ##    ##
	//  ##  ## 
	//  ###### 
	//   ####  
	//    ##   
	//    ##   
	//    ##   
	//    ##   
	//    ##   
	//    ##   
	//         
	//         
	//         
	0x06, 0x1E, 0x38, 0xF0, 0xF0, 0x38, 0x1E, 0x06, 
	0x00, 0x00, 0x00, 0x0F, 0x0F, 0x00, 0x00, 0x00, 

	// @846 'Z' (8 pixels wide)
	//         
	//  ###### 
	//  ###### 
	//      ## 
	//     ##  
	//    ###  
	//    ##   
	//   ##    
	//  ###    
	//  ##     
	// ########
	// ########
	//         
	//         
	//         
	0x00, 0x06, 0x86, 0xE6, 0x76, 0x3E, 0x0E, 0x00, 
	0x0C, 0x0F, 0x0F, 0x0D, 0x0C, 0x0C, 0x0C, 0x0C, 

	// @862 '[' (4 pixels wide)
	//     
	// ####
	// ##  
	// ##  
	// ##  
	// ##  
	// ##  
	// ##  
	// ##  
	// ##  
	// ##  
	// ##  
	// ##  
	// ##  
	// ####
	0xFE, 0xFE, 0x02, 0x02, 
	0x7F, 0x7F, 0x40, 0x40, 

	// @870 '\' (4 pixels wide)
	//     
	// ##  
	// ##  
	//  #  
	//  #  
	//  ## 
	//  ## 
	//  ## 
	//   # 
	//   # 
	//   ##
	//   ##
	//     
	//     
	//     
	0x06, 0xFE, 0xE0, 0x00, 
	0x00, 0x00, 0x0F, 0x0C, 

	// @878 ']' (4 pixels wide)
	//     
	// ####
	//   ##
	//   ##
	//   ##
	//   ##
	//   ##
	//   ##
	//   ##
	//   ##
	//   ##
	//   ##
	//   ##
	//   ##
	// ####
	0x02, 0x02, 0xFE, 0xFE, 
	0x40, 0x40, 0x7F, 0x7F, 

	// @886 '^' (7 pixels wide)
	//        
	//   ###  
	//   # #  
	//  ## ## 
	//  #  ## 
	// ##   ##
	// ##   ##
	// #     #
	//        
	//        
	//        
	//        
	//        
	//        
	//        
	0xE0, 0x78, 0x0E, 0x02, 0x1E, 0x78, 0xE0, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @900 '_' (8 pixels wide)
	//         
	//         
	//         
	//         
	//         
	//         
	//         
	//         
	//         
	//         
	//         
	//         
	//         
	// ########
	//         
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 

	// @916 '`' (3 pixels wide)
	// ## 
	//  # 
	//  ##
	//    
	//    
	//    
	//    
	//    
	//    
	//    
	//    
	//    
	//    
	//    
	//    
	0x01, 0x07, 0x04, 
	0x00, 0x00, 0x00, 

	// @922 'a' (8 pixels wide)
	//         
	//         
	//         
	//         
	//   ####  
	//  ###### 
	//      ## 
	//  ###### 
	//  ###### 
	// ###  ## 
	//  #######
	//  ###  ##
	//         
	//         
	//         
	0x00, 0xA0, 0xB0, 0xB0, 0xB0, 0xF0, 0xE0, 0x00, 
	0x02, 0x0F, 0x0F, 0x0D, 0x05, 0x07, 0x0F, 0x0C, 

	// @938 'b' (7 pixels wide)
	//        
	// ##     
	// ##     
	// ##     
	// ## ### 
	// #######
	// ##   ##
	// ##   ##
	// ##   ##
	// ###  ##
	// #######
	// ## ### 
	//        
	//        
	//        
	0xFE, 0xFE, 0x20, 0x30, 0x30, 0xF0, 0xE0, 
	0x0F, 0x0F, 0x06, 0x0C, 0x0C, 0x0F, 0x07, 

	// @952 'c' (7 pixels wide)
	//        
	//        
	//        
	//        
	//  ####  
	// ###### 
	// ##  ## 
	// ##     
	// ##     
	// ##  ###
	// ###### 
	//  ####  
	//        
	//        
	//        
	0xE0, 0xF0, 0x30, 0x30, 0x70, 0x60, 0x00, 
	0x07, 0x0F, 0x0C, 0x0C, 0x0E, 0x06, 0x02, 

	// @966 'd' (7 pixels wide)
	//        
	//      ##
	//      ##
	//      ##
	//  ### ##
	// #######
	// ##   ##
	// ##   ##
	// ##   ##
	// ##   ##
	// #######
	//  ### ##
	//        
	//        
	//        
	0xE0, 0xF0, 0x30, 0x30, 0x20, 0xFE, 0xFE, 
	0x07, 0x0F, 0x0C, 0x0C, 0x04, 0x0F, 0x0F, 

	// @980 'e' (7 pixels wide)
	//        
	//        
	//        
	//        
	//  ##### 
	// #######
	// ##   ##
	// #######
	// #######
	// ##     
	// #######
	//  ##### 
	//        
	//        
	//        
	0xE0, 0xF0, 0xB0, 0xB0, 0xB0, 0xF0, 0xE0, 
	0x07, 0x0F, 0x0D, 0x0D, 0x0D, 0x0D, 0x05, 

	// @994 'f' (5 pixels wide)
	//      
	//   ###
	//  ####
	//  ##  
	// #####
	// #####
	//  ##  
	//  ##  
	//  ##  
	//  ##  
	//  ##  
	//  ##  
	//      
	//      
	//      
	0x30, 0xFC, 0xFE, 0x36, 0x36, 
	0x00, 0x0F, 0x0F, 0x00, 0x00, 

	// @1004 'g' (7 pixels wide)
	//        
	//        
	//        
	//        
	//  ### ##
	// #######
	// ##   ##
	// ##   ##
	// ##   ##
	// ##   ##
	// #######
	//  ### ##
	//      ##
	// #######
	//  ##### 
	0xE0, 0xF0, 0x30, 0x30, 0x20, 0xF0, 0xF0, 
	0x27, 0x6F, 0x6C, 0x6C, 0x64, 0x7F, 0x3F, 

	// @1018 'h' (7 pixels wide)
	//        
	// ##     
	// ##     
	// ##     
	// ## ### 
	// #######
	// ###  ##
	// ##   ##
	// ##   ##
	// ##   ##
	// ##   ##
	// ##   ##
	//        
	//        
	//        
	0xFE, 0xFE, 0x60, 0x30, 0x30, 0xF0, 0xE0, 
	0x0F, 0x0F, 0x00, 0x00, 0x00, 0x0F, 0x0F, 

	// @1032 'i' (2 pixels wide)
	//   
	// ##
	// ##
	//   
	// ##
	// ##
	// ##
	// ##
	// ##
	// ##
	// ##
	// ##
	//   
	//   
	//   
	0xF6, 0xF6, 
	0x0F, 0x0F, 

	// @1036 'j' (3 pixels wide)
	//    
	//  ##
	//  ##
	//    
	//  ##
	//  ##
	//  ##
	//  ##
	//  ##
	//  ##
	//  ##
	//  ##
	//  ##
	// ###
	// ## 
	0x00, 0xF6, 0xF6, 
	0x60, 0x7F, 0x3F, 

	// @1042 'k' (7 pixels wide)
	//        
	// ##     
	// ##     
	// ##     
	// ##  ## 
	// ## ### 
	// ## ##  
	// ####   
	// #####  
	// ## ### 
	// ##  ## 
	// ##  ###
	//        
	//        
	//        
	0xFE, 0xFE, 0x80, 0xE0, 0x70, 0x30, 0x00, 
	0x0F, 0x0F, 0x01, 0x03, 0x0F, 0x0E, 0x08, 

	// @1056 'l' (2 pixels wide)
	//   
	// ##
	// ##
	// ##
	// ##
	// ##
	// ##
	// ##
	// ##
	// ##
	// ##
	// ##
	//   
	//   
	//   
	0xFE, 0xFE, 
	0x0F, 0x0F, 

	// @1060 'm' (10 pixels wide)
	//           
	//           
	//           
	//           
	// ## ##  ## 
	// ##########
	// ##  ##  ##
	// ##  ##  ##
	// ##  ##  ##
	// ##  ##  ##
	// ##  ##  ##
	// ##  ##  ##
	//           
	//           
	//           
	0xF0, 0xF0, 0x20, 0x30, 0xF0, 0xE0, 0x20, 0x30, 0xF0, 0xE0, 
	0x0F, 0x0F, 0x00, 0x00, 0x0F, 0x0F, 0x00, 0x00, 0x0F, 0x0F, 

	// @1080 'n' (7 pixels wide)
	//        
	//        
	//        
	//        
	// ## ### 
	// #######
	// ###  ##
	// ##   ##
	// ##   ##
	// ##   ##
	// ##   ##
	// ##   ##
	//        
	//        
	//        
	0xF0, 0xF0, 0x60, 0x30, 0x30, 0xF0, 0xE0, 
	0x0F, 0x0F, 0x00, 0x00, 0x00, 0x0F, 0x0F, 

	// @1094 'o' (7 pixels wide)
	//        
	//        
	//        
	//        
	//  ##### 
	// #######
	// ##   ##
	// ##   ##
	// ##   ##
	// ##   ##
	// #######
	//  ##### 
	//        
	//        
	//        
	0xE0, 0xF0, 0x30, 0x30, 0x30, 0xF0, 0xE0, 
	0x07, 0x0F, 0x0C, 0x0C, 0x0C, 0x0F, 0x07, 

	// @1108 'p' (7 pixels wide)
	//        
	//        
	//        
	//        
	// ## ### 
	// #######
	// ###  ##
	// ##   ##
	// ##   ##
	// ##   ##
	// #######
	// ## ### 
	// ##     
	// ##     
	// ##     
	0xF0, 0xF0, 0x60, 0x30, 0x30, 0xF0, 0xE0, 
	0x7F, 0x7F, 0x04, 0x0C, 0x0C, 0x0F, 0x07, 

	// @1122 'q' (7 pixels wide)
	//        
	//        
	//        
	//        
	//  ### ##
	// #######
	// ##   ##
	// ##   ##
	// ##   ##
	// ##   ##
	// #######
	//  ### ##
	//      ##
	//      ##
	//      ##
	0xE0, 0xF0, 0x30, 0x30, 0x20, 0xF0, 0xF0, 
	0x07, 0x0F, 0x0C, 0x0C, 0x04, 0x7F, 0x7F, 

	// @1136 'r' (5 pixels wide)
	//      
	//      
	//      
	//      
	// ## ##
	// #####
	// ###  
	// ##   
	// ##   
	// ##   
	// ##   
	// ##   
	//      
	//      
	//      
	0xF0, 0xF0, 0x60, 0x30, 0x30, 
	0x0F, 0x0F, 0x00, 0x00, 0x00, 

	// @1146 's' (6 pixels wide)
	//       
	//       
	//       
	//       
	//  #### 
	// ######
	// ##    
	// ##### 
	//   ####
	//     ##
	// ######
	// ##### 
	//       
	//       
	//       
	0xE0, 0xF0, 0xB0, 0xB0, 0xB0, 0x20, 
	0x0C, 0x0C, 0x0D, 0x0D, 0x0F, 0x07, 

	// @1158 't' (5 pixels wide)
	//      
	//      
	//   #  
	//  ##  
	// #####
	// #####
	//  ##  
	//  ##  
	//  ##  
	//  ##  
	//  ####
	//   ###
	//      
	//      
	//      
	0x30, 0xF8, 0xFC, 0x30, 0x30, 
	0x00, 0x07, 0x0F, 0x0C, 0x0C, 

	// @1168 'u' (7 pixels wide)
	//        
	//        
	//        
	//        
	// ##   ##
	// ##   ##
	// ##   ##
	// ##   ##
	// ##   ##
	// ##  ###
	// #######
	//  ### ##
	//        
	//        
	//        
	0xF0, 0xF0, 0x00, 0x00, 0x00, 0xF0, 0xF0, 
	0x07, 0x0F, 0x0C, 0x0C, 0x06, 0x0F, 0x0F, 

	// @1182 'v' (9 pixels wide)
	//          
	//          
	//          
	//          
	// ##     ##
	//  ##   ## 
	//  ##   ## 
	//  ### ### 
	//   ## ##  
	//   ## ##  
	//    ###   
	//    ###   
	//          
	//          
	//          
	0x10, 0xF0, 0xE0, 0x80, 0x00, 0x80, 0xE0, 0xF0, 0x10, 
	0x00, 0x00, 0x03, 0x0F, 0x0C, 0x0F, 0x03, 0x00, 0x00, 

	// @1200 'w' (11 pixels wide)
	//            
	//            
	//            
	//            
	// ##  ###  ##
	// ##  # #  ##
	//  #  # #  # 
	//  ## # # ## 
	//  #### #### 
	//  #### #### 
	//  ###   ##  
	//   ##   ##  
	//            
	//            
	//            
	0x30, 0xF0, 0x80, 0x00, 0xF0, 0x10, 0xF0, 0x00, 0x80, 0xF0, 0x30, 
	0x00, 0x07, 0x0F, 0x0F, 0x03, 0x00, 0x03, 0x0F, 0x0F, 0x03, 0x00, 

	// @1222 'x' (8 pixels wide)
	//         
	//         
	//         
	//         
	//  ##  ## 
	//  ##  ## 
	//   ####  
	//    ##   
	//   ####  
	//   ####  
	//  ##  ## 
	// ###  ###
	//         
	//         
	//         
	0x00, 0x30, 0x70, 0xC0, 0xC0, 0x70, 0x30, 0x00, 
	0x08, 0x0C, 0x0F, 0x03, 0x03, 0x0F, 0x0C, 0x08, 

	// @1238 'y' (7 pixels wide)
	//        
	//        
	//        
	//        
	// ##   ##
	//  ## ## 
	//  ## ## 
	//  ## ## 
	//  ## ## 
	//   # #  
	//   ###  
	//   ###  
	//   ##   
	//  ###   
	//  ##    
	0x10, 0xF0, 0xE0, 0x00, 0xE0, 0xF0, 0x10, 
	0x00, 0x61, 0x7F, 0x3C, 0x0F, 0x01, 0x00, 

	// @1252 'z' (6 pixels wide)
	//       
	//       
	//       
	//       
	// ######
	// ######
	//    ###
	//   ##  
	//  ##   
	// ##    
	// ######
	// ######
	//       
	//       
	//       
	0x30, 0x30, 0xB0, 0xF0, 0x70, 0x70, 
	0x0E, 0x0F, 0x0D, 0x0C, 0x0C, 0x0C, 

	// @1264 '{' (6 pixels wide)
	//       
	//    ###
	//   ##  
	//   ##  
	//   ##  
	//   ##  
	//   ##  
	// ##    
	//   ##  
	//   ##  
	//   ##  
	//   ##  
	//   ##  
	//   ##  
	//    ###
	0x80, 0x80, 0x7C, 0x7E, 0x02, 0x02, 
	0x00, 0x00, 0x3F, 0x7F, 0x40, 0x40, 

	// @1276 '|' (2 pixels wide)
	//   
	// ##
	// ##
	// ##
	// ##
	// ##
	// ##
	// ##
	// ##
	// ##
	// ##
	// ##
	// ##
	// ##
	// ##
	0xFE, 0xFE, 
	0x7F, 0x7F, 

	// @1280 '}' (6 pixels wide)
	//       
	// ###   
	//   ##  
	//   ##  
	//   ##  
	//   ##  
	//   ##  
	//     ##
	//   ##  
	//   ##  
	//   ##  
	//   ##  
	//   ##  
	//   ##  
	// ###   
	0x02, 0x02, 0x7E, 0x7C, 0x80, 0x80, 
	0x40, 0x40, 0x7F, 0x3F, 0x00, 0x00, 

	// @1292 '~' (7 pixels wide)
	//        
	//        
	//        
	//        
	//        
	// ####   
	// #######
	//    ####
	//        
	//        
	//        
	//        
	//        
	//        
	//        
	0x60, 0x60, 0x60, 0xE0, 0xC0, 0xC0, 0xC0, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

// Character descriptors for MedProp_11pt
// { [Char width in bits], [Offset into MedProp_11ptCharBitmaps in bytes] }
const  PROGMEM uint16_t    MedProp_11ptDescriptors[][2] = 
{
	{8, 0}, 		//   
	{2, 16}, 		// ! 
	{5, 20}, 		// " 
	{8, 30}, 		// # 
	{8, 46}, 		// $ 
	{13, 62}, 		// % 
	{10, 88}, 		// & 
	{2, 108}, 		// ' 
	{4, 112}, 		// ( 
	{4, 120}, 		// ) 
	{6, 128}, 		// * 
	{7, 140}, 		// + 
	{2, 154}, 		// , 
	{3, 158}, 		// - 
	{2, 164}, 		// . 
	{4, 168}, 		// / 
	{6, 176}, 		// 0 
	{7, 188}, 		// 1 
	{7, 202}, 		// 2 
	{7, 216}, 		// 3 
	{8, 230}, 		// 4 
	{8, 246}, 		// 5 
	{6, 262}, 		// 6 
	{6, 274}, 		// 7 
	{8, 286}, 		// 8 
	{6, 302}, 		// 9 
	{2, 314}, 		// : 
	{2, 318}, 		// ; 
	{7, 322}, 		// < 
	{7, 336}, 		// = 
	{7, 350}, 		// > 
	{7, 364}, 		// ? 
	{13, 378}, 		// @ 
	{9, 404}, 		// A 
	{9, 422}, 		// B 
	{9, 440}, 		// C 
	{9, 458}, 		// D 
	{8, 476}, 		// E 
	{7, 492}, 		// F 
	{10, 506}, 		// G 
	{9, 526}, 		// H 
	{2, 544}, 		// I 
	{7, 548}, 		// J 
	{9, 562}, 		// K 
	{8, 580}, 		// L 
	{11, 596}, 		// M 
	{9, 618}, 		// N 
	{10, 636}, 		// O 
	{8, 656}, 		// P 
	{10, 672}, 		// Q 
	{9, 692}, 		// R 
	{9, 710}, 		// S 
	{10, 728}, 		// T 
	{9, 748}, 		// U 
	{9, 766}, 		// V 
	{13, 784}, 		// W 
	{10, 810}, 		// X 
	{8, 830}, 		// Y 
	{8, 846}, 		// Z 
	{4, 862}, 		// [ 
	{4, 870}, 		// backslash
	{4, 878}, 		// ] 
	{7, 886}, 		// ^ 
	{8, 900}, 		// _ 
	{3, 916}, 		// ` 
	{8, 922}, 		// a 
	{7, 938}, 		// b 
	{7, 952}, 		// c 
	{7, 966}, 		// d 
	{7, 980}, 		// e 
	{5, 994}, 		// f 
	{7, 1004}, 		// g 
	{7, 1018}, 		// h 
	{2, 1032}, 		// i 
	{3, 1036}, 		// j 
	{7, 1042}, 		// k 
	{2, 1056}, 		// l 
	{10, 1060}, 		// m 
	{7, 1080}, 		// n 
	{7, 1094}, 		// o 
	{7, 1108}, 		// p 
	{7, 1122}, 		// q 
	{5, 1136}, 		// r 
	{6, 1146}, 		// s 
	{5, 1158}, 		// t 
	{7, 1168}, 		// u 
	{9, 1182}, 		// v 
	{11, 1200}, 		// w 
	{8, 1222}, 		// x 
	{7, 1238}, 		// y 
	{6, 1252}, 		// z 
	{6, 1264}, 		// { 
	{2, 1276}, 		// | 
	{6, 1280}, 		// } 
	{7, 1292}, 		// ~ 
};





// Font information for MedProp_11pt
const FONT_INFO MedProp_11ptFontInfo =
{
	2, //  Character height
	' ', //  Start character
	'~', //  End character
/*	NULL, //  Character block lookup */
	MedProp_11ptDescriptors[0], //  Character descriptor array
	MedProp_11pt, //  Character bitmap array
};



/* Character bitmaps for large LCD style font (LCDLarge_24pt) */
const PROGMEM byte LCDLarge_24pt[] = 
{
	// @0 ' ' (8 pixels wide)
	//         
	//         
	//         
	//         
	//         
	//         
	//         
	//         
	//         
	//         
	//         
	//         
	//         
	//         
	//         
	//         
	//         
	//         
	//         
	//         
	//         
	//         
	//         
	//         
	//         
	//         
	//         
	//         
	//         
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @32 '!' (2 pixels wide)
	//   
	//   
	//   
	// # 
	// ##
	// ##
	// ##
	// ##
	// ##
	// ##
	// ##
	// ##
	// ##
	// ##
	// ##
	// ##
	// ##
	// ##
	// ##
	//   
	//   
	//   
	// ##
	// ##
	//   
	//   
	//   
	//   
	//   
	0xF8, 0xF0, 
	0xFF, 0xFF, 
	0xC7, 0xC7, 
	0x00, 0x00, 

	// @40 '"' (7 pixels wide)
	//        
	//        
	//        
	// #    # 
	// ##   ##
	// ##   ##
	// ##   ##
	// ##   ##
	// ##   ##
	// ##   ##
	// ##   ##
	// ##   ##
	// #    # 
	//        
	//        
	//        
	//        
	//        
	//        
	//        
	//        
	//        
	//        
	//        
	//        
	//        
	//        
	//        
	//        
	0xF8, 0xF0, 0x00, 0x00, 0x00, 0xF8, 0xF0, 
	0x1F, 0x0F, 0x00, 0x00, 0x00, 0x1F, 0x0F, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @68 '#' (21 pixels wide)
	//                      
	//                      
	//                      
	//      #        #      
	//      ##       ##     
	//      ##       ##     
	//      ##       ##     
	//      ##       ##     
	// #### ##  #### ## ####
	// #### ## ##### ## ####
	//      ##       ##     
	//      ##       ##     
	//      ##       ##     
	//                      
	//      ##       ##     
	//      ##       ##     
	// #### ##  #### ## ####
	// #### ## ##### ## ####
	//      ##       ##     
	//      ##       ##     
	//      ##       ##     
	//      ##       ##     
	//      ##       ##     
	//      #        #      
	//                      
	//                      
	//                      
	//                      
	//                      
	0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x03, 0x03, 0x03, 0x03, 0x00, 0xDF, 0xDF, 0x00, 0x02, 0x03, 0x03, 0x03, 0x03, 0x00, 0xDF, 0xDF, 0x00, 0x03, 0x03, 0x03, 0x03, 
	0x03, 0x03, 0x03, 0x03, 0x00, 0xFF, 0x7F, 0x00, 0x02, 0x03, 0x03, 0x03, 0x03, 0x00, 0xFF, 0x7F, 0x00, 0x03, 0x03, 0x03, 0x03, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @152 '$' (12 pixels wide)
	//      ##     
	//      ##     
	//             
	//   ######### 
	//   ######### 
	// ##          
	// ##          
	// ##          
	// ##          
	// ##          
	// ##          
	// ##          
	//  ########   
	//   ########  
	//   ####### ##
	//           ##
	//           ##
	//           ##
	//           ##
	//           ##
	//           ##
	//           ##
	//  ########   
	// ##########  
	//             
	//      ##     
	//      ##     
	//      ##     
	//      #      
	0xE0, 0xE0, 0x18, 0x18, 0x18, 0x1B, 0x1B, 0x18, 0x18, 0x18, 0x18, 0x00, 
	0x0F, 0x1F, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x20, 0xC0, 0xC0, 
	0x80, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x80, 0x3F, 0x3F, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @200 '%' (28 pixels wide)
	//                             
	//                             
	//                             
	//   ########       ##         
	// # #########      ##         
	// ##        ##    ###         
	// ##        ##    ##          
	// ##        ##   ###          
	// ##        ##   ###          
	// ##        ##   ##           
	// ##        ##  ###           
	// ##        ##  ##            
	// ###########   ##   #######  
	//   ########        ######### 
	//             ###  #        ##
	//             ### ###       ##
	//             ##  ###       ##
	//            ###  ###       ##
	//            ###  ###       ##
	//            ##   ###       ##
	//           ###   ###       ##
	//           ##     #        ##
	//          ###       #######  
	//           #       ######### 
	//                             
	//                             
	//                             
	//                             
	//                             
	0xF0, 0xE0, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xF0, 0xE0, 0x00, 0x00, 0x00, 0x80, 0xE0, 0xF8, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x1F, 0x1F, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x1F, 0x0F, 0xC0, 0xC0, 0xDC, 0x1F, 0x87, 0xC1, 0xA0, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0xE0, 0xC0, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xF0, 0x7E, 0x1F, 0x07, 0x00, 0x00, 0x1F, 0x3F, 0x9F, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xBF, 0x3F, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @312 '&' (12 pixels wide)
	//      ##     
	//      ##     
	//             
	//    ######## 
	//   ##########
	// ##          
	// ##          
	// ##          
	// ##          
	// ##          
	// ##          
	// ##          
	// ##          
	//   ######### 
	// ############
	// ##          
	// ##          
	// ##          
	// ##          
	// ##          
	// ##          
	// ##          
	//   ######### 
	//    #########
	//             
	//      ##     
	//      ##     
	//      ##     
	//      #      
	0xE0, 0xE0, 0x10, 0x18, 0x18, 0x1B, 0x1B, 0x18, 0x18, 0x18, 0x18, 0x10, 
	0xDF, 0xDF, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x40, 
	0x3F, 0x3F, 0x40, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x80, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @360 ''' (2 pixels wide)
	//   
	//   
	//   
	// # 
	// ##
	// ##
	// ##
	// ##
	// ##
	// ##
	// ##
	// ##
	// # 
	//   
	//   
	//   
	//   
	//   
	//   
	//   
	//   
	//   
	//   
	//   
	//   
	//   
	//   
	//   
	//   
	0xF8, 0xF0, 
	0x1F, 0x0F, 
	0x00, 0x00, 
	0x00, 0x00, 

	// @368 '(' (6 pixels wide)
	//   ####
	//   ### 
	//       
	// #     
	// ##    
	// ##    
	// ##    
	// ##    
	// ##    
	// ##    
	// ##    
	// ##    
	// #     
	//       
	// ##    
	// ##    
	// ##    
	// ##    
	// ##    
	// ##    
	// ##    
	// ##    
	// ##    
	// #     
	//       
	//   ### 
	//   ####
	//     ##
	//       
	0xF8, 0xF0, 0x03, 0x03, 0x03, 0x01, 
	0xDF, 0xCF, 0x00, 0x00, 0x00, 0x00, 
	0xFF, 0x7F, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x06, 0x06, 0x0E, 0x0C, 

	// @392 ')' (5 pixels wide)
	// #### 
	//  ### 
	//      
	//    # 
	//    ##
	//    ##
	//    ##
	//    ##
	//    ##
	//    ##
	//    ##
	//    ##
	//    ##
	//      
	//    # 
	//    ##
	//    ##
	//    ##
	//    ##
	//    ##
	//    ##
	//    ##
	//    ##
	//     #
	//      
	//  ### 
	// #### 
	// ##   
	//      
	0x01, 0x03, 0x03, 0xFB, 0xF0, 
	0x00, 0x00, 0x00, 0xDF, 0x9F, 
	0x00, 0x00, 0x00, 0x7F, 0xFF, 
	0x0C, 0x0E, 0x06, 0x06, 0x00, 

	// @412 '*' (12 pixels wide)
	//             
	//             
	//             
	//      #      
	//      ##     
	//      ##     
	//  #   ##   # 
	// #### ## ####
	// ###### #####
	//   ##    ##  
	//     #  #    
	//    ######   
	//   ###  ###  
	//   ###  ###  
	//   ##    ##  
	//             
	//             
	//             
	//             
	//             
	//             
	//             
	//             
	//             
	//             
	//             
	//             
	//             
	//             
	0x80, 0xC0, 0x80, 0x80, 0x00, 0xF8, 0xF0, 0x00, 0x80, 0x80, 0xC0, 0x80, 
	0x01, 0x01, 0x73, 0x7B, 0x3D, 0x09, 0x08, 0x3D, 0x7B, 0x73, 0x01, 0x01, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @460 '+' (11 pixels wide)
	//            
	//            
	//            
	//            
	//            
	//            
	//            
	//            
	//      #     
	//      ##    
	//      ##    
	//      ##    
	//  ##########
	// #####  ####
	//      #     
	//      ##    
	//      ##    
	//      ##    
	//      #     
	//            
	//            
	//            
	//            
	//            
	//            
	//            
	//            
	//            
	//            
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x20, 0x30, 0x30, 0x30, 0x30, 0xDF, 0x9E, 0x30, 0x30, 0x30, 0x30, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x03, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @504 ',' (4 pixels wide)
	//     
	//     
	//     
	//     
	//     
	//     
	//     
	//     
	//     
	//     
	//     
	//     
	//     
	//     
	//     
	//     
	//     
	//     
	//     
	//    #
	//   ##
	//  ###
	//  ###
	// ### 
	// ### 
	// ##  
	// #   
	//     
	//     
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x80, 0xE0, 0xF0, 0x78, 
	0x07, 0x03, 0x01, 0x00, 

	// @520 '-' (8 pixels wide)
	//         
	//         
	//         
	//         
	//         
	//         
	//         
	//         
	//         
	//         
	//         
	//         
	// ########
	// ########
	//         
	//         
	//         
	//         
	//         
	//         
	//         
	//         
	//         
	//         
	//         
	//         
	//         
	//         
	//         
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @552 '.' (2 pixels wide)
	//   
	//   
	//   
	//   
	//   
	//   
	//   
	//   
	//   
	//   
	//   
	//   
	//   
	//   
	//   
	//   
	//   
	//   
	//   
	//   
	//   
	//   
	// ##
	// ##
	//   
	//   
	//   
	//   
	//   
	0x00, 0x00, 
	0x00, 0x00, 
	0xC0, 0xC0, 
	0x00, 0x00, 

	// @560 '/' (10 pixels wide)
	//           
	//           
	//           
	//         ##
	//        ###
	//        ###
	//        ## 
	//       ### 
	//       ##  
	//      ###  
	//      ###  
	//      ##   
	//      ##   
	//           
	//    ##     
	//    ###    
	//    ##     
	//   ###     
	//   ##      
	//  ###      
	//  ###      
	//  ##       
	// ###       
	//  #        
	//           
	//           
	//           
	//           
	//           
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xF0, 0xF8, 0x38, 
	0x00, 0x00, 0x00, 0xC0, 0xC0, 0x9E, 0x1F, 0x07, 0x00, 0x00, 
	0x40, 0xF8, 0x7E, 0x1F, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @600 '0' (11 pixels wide)
	//            
	//            
	//            
	//   #######  
	//  ######### 
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// #        ##
	//            
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	//   #######  
	//  ######### 
	//            
	//            
	//            
	//            
	//            
	0xE0, 0xF0, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xF0, 0xE0, 
	0xDF, 0xCF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xDF, 0xDF, 
	0x3F, 0xBF, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xBF, 0x3F, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @644 '1' (2 pixels wide)
	//   
	//   
	//   
	// # 
	// ##
	// ##
	// ##
	// ##
	// ##
	// ##
	// ##
	// ##
	// ##
	//   
	// ##
	// ##
	// ##
	// ##
	// ##
	// ##
	// ##
	// ##
	// ##
	// # 
	//   
	//   
	//   
	//   
	//   
	0xF8, 0xF0, 
	0xDF, 0xDF, 
	0xFF, 0x7F, 
	0x00, 0x00, 

	// @652 '2' (12 pixels wide)
	//             
	//             
	//             
	//  #########  
	//  ########## 
	//           ##
	//           ##
	//           ##
	//           ##
	//           ##
	//           ##
	//           ##
	//    ######## 
	//   ########  
	// ##          
	// ##          
	// ##          
	// ##          
	// ##          
	// ##          
	// ##          
	// ##          
	// # ######### 
	// ########### 
	//             
	//             
	//             
	//             
	//             
	0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xF0, 0xE0, 
	0xC0, 0xC0, 0x20, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x1F, 0x0F, 
	0xFF, 0xBF, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @700 '3' (11 pixels wide)
	//            
	//            
	//            
	//  ########  
	// ########## 
	//          ##
	//          ##
	//          ##
	//          ##
	//          ##
	//          ##
	//          ##
	//  ######### 
	// #########  
	//          ##
	//          ##
	//          ##
	//          ##
	//          ##
	//          ##
	//          ##
	//          ##
	//  ########  
	// ########## 
	//            
	//            
	//            
	//            
	//            
	0x10, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xF0, 0xE0, 
	0x20, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0xDF, 0xCF, 
	0x80, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xBF, 0x3F, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @744 '4' (12 pixels wide)
	//             
	//             
	//             
	// #         # 
	// ##        ##
	// ##        ##
	// ##        ##
	// ##        ##
	// ##        ##
	// ##        ##
	// ##        ##
	// ##        ##
	// ############
	//   ########  
	//           ##
	//           ##
	//           ##
	//           ##
	//           ##
	//           ##
	//           ##
	//           ##
	//           ##
	//           # 
	//             
	//             
	//             
	//             
	//             
	0xF8, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xF0, 
	0x1F, 0x1F, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0xDF, 0xDF, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x7F, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @792 '5' (12 pixels wide)
	//             
	//             
	//             
	// ########### 
	// # ######### 
	// ##          
	// ##          
	// ##          
	// ##          
	// ##          
	// ##          
	// ##          
	//  #          
	//    #######  
	//   ##########
	//           ##
	//           ##
	//           ##
	//           ##
	//           ##
	//           ##
	//           ##
	//  #########  
	//  ########## 
	//             
	//             
	//             
	//             
	//             
	0xF8, 0xE8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 
	0x0F, 0x1F, 0x40, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0xC0, 0xC0, 
	0x00, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xBF, 0x3F, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @840 '6' (11 pixels wide)
	//            
	//            
	//            
	//   ######## 
	//  ##########
	// ##         
	// ##         
	// ##         
	// ##         
	// ##         
	// ##         
	// ##         
	// # #######  
	//  ######### 
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	//   #######  
	//  ######### 
	//            
	//            
	//            
	//            
	//            
	0xE0, 0xF0, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x10, 
	0xDF, 0xEF, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0xE0, 0xC0, 
	0x3F, 0xBF, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xBF, 0x3F, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @884 '7' (11 pixels wide)
	//            
	//            
	//            
	//  ##########
	// ######### #
	//          ##
	//          ##
	//          ##
	//          ##
	//          ##
	//          ##
	//          ##
	//          # 
	//            
	//          # 
	//          ##
	//          ##
	//          ##
	//          ##
	//          ##
	//          ##
	//          ##
	//          ##
	//          # 
	//            
	//            
	//            
	//            
	//            
	0x10, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xE8, 0xF8, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xDF, 0x8F, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x7F, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @928 '8' (11 pixels wide)
	//            
	//            
	//            
	//   #######  
	//  ######### 
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ###########
	//   #######  
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	//   #######  
	//  ######### 
	//            
	//            
	//            
	//            
	//            
	0xE0, 0xF0, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xF0, 0xE0, 
	0xDF, 0xDF, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0xDF, 0xDF, 
	0x3F, 0xBF, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xBF, 0x3F, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @972 '9' (12 pixels wide)
	//             
	//             
	//             
	//    #######  
	//   ########  
	// ##        ##
	// ##        ##
	// ##        ##
	// ##        ##
	// ##        ##
	// ##        ##
	// ##        ##
	// #         ##
	//    #######  
	//   ##########
	//           ##
	//           ##
	//           ##
	//           ##
	//           ##
	//           ##
	//           ##
	//   ########  
	//  #########  
	//             
	//             
	//             
	//             
	//             
	0xE0, 0xE0, 0x10, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xE0, 0xE0, 
	0x1F, 0x0F, 0x40, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0xDF, 0xDF, 
	0x00, 0x80, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x3F, 0x3F, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @1020 ':' (2 pixels wide)
	//   
	//   
	//   
	//   
	//   
	//   
	//   
	//   
	//   
	// ##
	// ##
	//   
	//   
	//   
	//   
	//   
	// ##
	// ##
	//   
	//   
	//   
	//   
	//   
	//   
	//   
	//   
	//   
	//   
	//   
	0x00, 0x00, 
	0x06, 0x06, 
	0x03, 0x03, 
	0x00, 0x00, 

	// @1028 ';' (4 pixels wide)
	//     
	//     
	//     
	//     
	//     
	//     
	//     
	//     
	//     
	//     
	//     
	//     
	//     
	//     
	//     
	//   ##
	//   ##
	//     
	//     
	//    #
	//   ##
	//  ###
	//  ###
	// ### 
	// ### 
	// ##  
	// #   
	//     
	//     
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x80, 0x80, 
	0x80, 0xE0, 0xF1, 0x79, 
	0x07, 0x03, 0x01, 0x00, 

	// @1044 '<' (7 pixels wide)
	//        
	//        
	//        
	//      ##
	//     ###
	//     ## 
	//    ### 
	//   ###  
	//   ###  
	//  ###   
	// ###    
	// ###    
	// ##     
	//        
	// ##     
	// ###    
	// ###    
	//  ###   
	//   ###  
	//   ###  
	//    ### 
	//     ## 
	//     ###
	//      ##
	//        
	//        
	//        
	//        
	//        
	0x00, 0x00, 0x80, 0xC0, 0xF0, 0x78, 0x18, 
	0xDC, 0xDE, 0x8F, 0x03, 0x01, 0x00, 0x00, 
	0x01, 0x03, 0x0F, 0x1E, 0x7C, 0xF0, 0xC0, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @1072 '=' (9 pixels wide)
	//          
	//          
	//          
	//          
	//          
	//          
	//          
	//          
	//          
	//          
	//  ####### 
	// #########
	//          
	//          
	//          
	//  ####### 
	// #########
	//          
	//          
	//          
	//          
	//          
	//          
	//          
	//          
	//          
	//          
	//          
	//          
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x08, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x08, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @1108 '>' (7 pixels wide)
	//        
	//        
	//        
	// ##     
	// ###    
	// ###    
	//  ###   
	//   ##   
	//   ###  
	//    ### 
	//    ### 
	//     ###
	//      ##
	//        
	//      ##
	//     ###
	//     ## 
	//    ### 
	//   ###  
	//   ###  
	//  ###   
	// ###    
	// ###    
	// ##     
	//        
	//        
	//        
	//        
	//        
	0x38, 0x78, 0xF0, 0xC0, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x01, 0x07, 0x8F, 0xDE, 0xD8, 
	0xE0, 0xF0, 0x7C, 0x1E, 0x0F, 0x03, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @1136 '?' (12 pixels wide)
	//             
	//             
	//             
	//  #########  
	// ##########  
	//           ##
	//           ##
	//           ##
	//           ##
	//           ##
	//           ##
	//           ##
	//   ##########
	//   ########  
	// ##          
	// ##          
	// ##          
	// ##          
	// #           
	//             
	//             
	//             
	// ##          
	// ##          
	//             
	//             
	//             
	//             
	//             
	0x10, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xE0, 0xE0, 
	0xC0, 0xC0, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x1F, 0x1F, 
	0xC7, 0xC3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @1184 '@' (21 pixels wide)
	//                      
	//                      
	//                      
	//   #######  ########  
	//  ######### ########  
	// ##                 ##
	// ##                 ##
	// ##                 ##
	// ##     #######     ##
	// ##   ##########    ##
	// ##   ##       ##   ##
	// ##   ##       ##   ##
	//  #   ##       ##   # 
	//      ##       ##     
	// ##   ##       ##   ##
	// ##   ##       ##   ##
	// ##   ##       ##   ##
	// ##   # ########    ##
	// ##    #########    ##
	// ##            ##   ##
	// ##            ##   ##
	// ##            ##   ##
	//   #######       ###  
	//  #########     ####  
	//                      
	//                      
	//                      
	//                      
	//                      
	0xE0, 0xF0, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x10, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xE0, 0xE0, 
	0xCF, 0xDF, 0x00, 0x00, 0x00, 0xFE, 0xFE, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0xFE, 0xFC, 0x00, 0x00, 0x00, 0xDF, 0xCF, 
	0x3F, 0xBF, 0xC0, 0xC0, 0xC0, 0xC3, 0xC5, 0xC6, 0xC6, 0x86, 0x06, 0x06, 0x06, 0x06, 0x3F, 0xB9, 0xC0, 0xC0, 0xC0, 0x3F, 0x3F, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @1268 'A' (11 pixels wide)
	//            
	//            
	//            
	//   #######  
	// ########## 
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ###########
	//   #######  
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// #        # 
	//            
	//            
	//            
	//            
	//            
	0xF0, 0xF0, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xF0, 0xE0, 
	0xDF, 0xDF, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0xDF, 0xDF, 
	0xFF, 0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x7F, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @1312 'B' (11 pixels wide)
	//            
	//            
	//            
	// ########## 
	// # ######## 
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// # #########
	//  ########  
	//  #       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// # #######  
	// ########## 
	//            
	//            
	//            
	//            
	//            
	0xF8, 0xE8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xF8, 0xE0, 
	0x9F, 0xEF, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0xDF, 0xDF, 
	0xFF, 0xBF, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xBF, 0x3F, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @1356 'C' (11 pixels wide)
	//            
	//            
	//            
	//   #######  
	// ########## 
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// #        ##
	//            
	// ##         
	// ##         
	// ##         
	// ##         
	// ##         
	// ##         
	// ##         
	// ##         
	//   ######## 
	//  ##########
	//            
	//            
	//            
	//            
	//            
	0xF0, 0xF0, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xF0, 0xE0, 
	0xDF, 0xCF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x1F, 
	0x3F, 0xBF, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x80, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @1400 'D' (11 pixels wide)
	//            
	//            
	//            
	// ########## 
	// # ######## 
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// #        # 
	//            
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// # #######  
	// ########## 
	//            
	//            
	//            
	//            
	//            
	0xF8, 0xE8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xF8, 0xE0, 
	0xDF, 0xCF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xDF, 0xCF, 
	0xFF, 0xBF, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xBF, 0x3F, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @1444 'E' (10 pixels wide)
	//           
	//           
	//           
	// ##########
	// # ########
	// ##        
	// ##        
	// ##        
	// ##        
	// ##        
	// ##        
	// ##        
	// # ####### 
	//  #########
	//  #        
	// ##        
	// ##        
	// ##        
	// ##        
	// ##        
	// ##        
	// ##        
	// # ####### 
	// ##########
	//           
	//           
	//           
	//           
	//           
	0xF8, 0xE8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 
	0x9F, 0xEF, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x20, 
	0xFF, 0xBF, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x80, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @1484 'F' (10 pixels wide)
	//           
	//           
	//           
	// ##########
	// # ########
	// ##        
	// ##        
	// ##        
	// ##        
	// ##        
	// ##        
	// ##        
	// # ####### 
	//   ########
	// ##        
	// ##        
	// ##        
	// ##        
	// ##        
	// ##        
	// ##        
	// ##        
	// ##        
	// #         
	//           
	//           
	//           
	//           
	//           
	0xF8, 0xE8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 
	0xDF, 0xCF, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x20, 
	0xFF, 0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @1524 'G' (11 pixels wide)
	//            
	//            
	//            
	//   ######## 
	// ###########
	// ##         
	// ##         
	// ##         
	// ##         
	// ##         
	// ##         
	// ##         
	// ##         
	//            
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	//   #######  
	//  ######### 
	//            
	//            
	//            
	//            
	//            
	0xF0, 0xF0, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x10, 
	0xDF, 0xDF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0xC0, 
	0x3F, 0xBF, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xBF, 0x3F, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @1568 'H' (11 pixels wide)
	//            
	//            
	//            
	// #        # 
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ###########
	//   #######  
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// #        # 
	//            
	//            
	//            
	//            
	//            
	0xF8, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xF0, 
	0xDF, 0xDF, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0xDF, 0xDF, 
	0xFF, 0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x7F, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @1612 'I' (2 pixels wide)
	//   
	//   
	//   
	// # 
	// ##
	// ##
	// ##
	// ##
	// ##
	// ##
	// ##
	// ##
	// ##
	//   
	// ##
	// ##
	// ##
	// ##
	// ##
	// ##
	// ##
	// ##
	// ##
	// # 
	//   
	//   
	//   
	//   
	//   
	0xF8, 0xF0, 
	0xDF, 0xDF, 
	0xFF, 0x7F, 
	0x00, 0x00, 

	// @1620 'J' (12 pixels wide)
	//             
	//             
	//             
	//           # 
	//           ##
	//           ##
	//           ##
	//           ##
	//           ##
	//           ##
	//           ##
	//           ##
	//           ##
	//             
	// ##        ##
	// ##        ##
	// ##        ##
	// ##        ##
	// ##        ##
	// ##        ##
	// ##        ##
	// ##        ##
	//    #######  
	//   ########  
	//             
	//             
	//             
	//             
	//             
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xF0, 
	0xC0, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xDF, 0xDF, 
	0x3F, 0x3F, 0x80, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x3F, 0x3F, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @1668 'K' (12 pixels wide)
	//             
	//             
	//             
	// #        ## 
	// ##       ## 
	// ##      ### 
	// ##     ###  
	// ##    ###   
	// ##    ###   
	// ##   ###    
	// ##  ###     
	// ## ###      
	// ## ###      
	//             
	// ## ###      
	// ## ###      
	// ##  ###     
	// ##   ###    
	// ##    ###   
	// ##    ###   
	// ##     ###  
	// ##      ### 
	// ##       ###
	// #        ## 
	//             
	//             
	//             
	//             
	//             
	0xF8, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x80, 0xC0, 0xE0, 0x78, 0x38, 0x00, 
	0xDF, 0xDF, 0x00, 0xD8, 0xDC, 0xDE, 0x07, 0x03, 0x01, 0x00, 0x00, 0x00, 
	0xFF, 0x7F, 0x00, 0x00, 0x01, 0x03, 0x0F, 0x1E, 0x3C, 0xF0, 0xE0, 0x40, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @1716 'L' (10 pixels wide)
	//           
	//           
	//           
	// #         
	// ##        
	// ##        
	// ##        
	// ##        
	// ##        
	// ##        
	// ##        
	// ##        
	// ##        
	//           
	// ##        
	// ##        
	// ##        
	// ##        
	// ##        
	// ##        
	// ##        
	// ##        
	// # ####### 
	// ##########
	//           
	//           
	//           
	//           
	//           
	0xF8, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0xDF, 0xDF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0xFF, 0xBF, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x80, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @1756 'M' (12 pixels wide)
	//             
	//             
	//             
	//   #######   
	//  #########  
	// ##        ##
	// ##   ##   ##
	// ##   ##   ##
	// ##   ##   ##
	// ##   ##   ##
	// ##   ##   ##
	// ##   ##   ##
	// ##   ##   ##
	//             
	// ##        ##
	// ##        ##
	// ##        ##
	// ##        ##
	// ##        ##
	// ##        ##
	// ##        ##
	// ##        # 
	// ##        # 
	// #         # 
	//             
	//             
	//             
	//             
	//             
	0xE0, 0xF0, 0x18, 0x18, 0x18, 0xD8, 0xD8, 0x18, 0x18, 0x10, 0xE0, 0xE0, 
	0xDF, 0xDF, 0x00, 0x00, 0x00, 0x1F, 0x1F, 0x00, 0x00, 0x00, 0xDF, 0xDF, 
	0xFF, 0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x1F, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @1804 'N' (11 pixels wide)
	//            
	//            
	//            
	// #        # 
	// ## #     ##
	// ## ##    ##
	// ## ###   ##
	// ## ###   ##
	// ##  ###  ##
	// ##  ###  ##
	// ##   ##  ##
	// ##   ### ##
	// ##    ## ##
	//       ##   
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// #        # 
	//            
	//            
	//            
	//            
	//            
	0xF8, 0xF0, 0x00, 0xF0, 0xE0, 0xC0, 0x00, 0x00, 0x00, 0xF8, 0xF0, 
	0xDF, 0xDF, 0x00, 0x00, 0x03, 0x0F, 0x3F, 0x38, 0x00, 0xDF, 0xDF, 
	0xFF, 0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x7F, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @1848 'O' (11 pixels wide)
	//            
	//            
	//            
	//   #######  
	//  ######### 
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// #        ##
	//            
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	//   #######  
	//  ######### 
	//            
	//            
	//            
	//            
	//            
	0xE0, 0xF0, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xF0, 0xE0, 
	0xDF, 0xCF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xDF, 0xDF, 
	0x3F, 0xBF, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xBF, 0x3F, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @1892 'P' (11 pixels wide)
	//            
	//            
	//            
	// ########## 
	// # ######## 
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// # #########
	//  ########  
	// ##         
	// ##         
	// ##         
	// ##         
	// ##         
	// ##         
	// ##         
	// ##         
	// ##         
	// #          
	//            
	//            
	//            
	//            
	//            
	0xF8, 0xE8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xF8, 0xE0, 
	0xDF, 0xEF, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x1F, 0x1F, 
	0xFF, 0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @1936 'Q' (11 pixels wide)
	//            
	//            
	//            
	//   #######  
	//  ######### 
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// #        ##
	//            
	// ##   ##  ##
	// ##   ##  ##
	// ##   ##  ##
	// ##   ##  ##
	// ##   ##  ##
	// ##   ##  ##
	// ##   ##  ##
	// ##       ##
	//   #######  
	//  ######### 
	//            
	//            
	//            
	//            
	//            
	0xE0, 0xF0, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xF0, 0xE0, 
	0xDF, 0xCF, 0x00, 0x00, 0x00, 0xC0, 0xC0, 0x00, 0x00, 0xDF, 0xDF, 
	0x3F, 0xBF, 0xC0, 0xC0, 0xC0, 0xDF, 0xDF, 0xC0, 0xC0, 0xBF, 0x3F, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @1980 'R' (11 pixels wide)
	//            
	//            
	//            
	// ########## 
	// # ######## 
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// # #########
	//  ########  
	// ##         
	// ## #       
	// ## ##      
	// ## ###     
	// ##  ###    
	// ##   ###   
	// ##    ###  
	// ##     ### 
	// ##      ###
	// #        ##
	//            
	//            
	//            
	//            
	//            
	0xF8, 0xE8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xF8, 0xE0, 
	0xDF, 0xEF, 0x30, 0xB0, 0x30, 0x30, 0x30, 0x30, 0x30, 0x1F, 0x1F, 
	0xFF, 0x7F, 0x00, 0x03, 0x07, 0x0E, 0x1C, 0x38, 0x70, 0xE0, 0xC0, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @2024 'S' (12 pixels wide)
	//             
	//             
	//             
	//   ######### 
	//   ##########
	// ##          
	// ##          
	// ##          
	// ##          
	// ##          
	// ##          
	// ##          
	//  #          
	//   ########  
	//   ##########
	//           ##
	//           ##
	//           ##
	//           ##
	//           ##
	//           ##
	//           ##
	//  #########  
	//  #########  
	//             
	//             
	//             
	//             
	//             
	0xE0, 0xE0, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x10, 
	0x0F, 0x1F, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0xC0, 0xC0, 
	0x00, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x3F, 0x3F, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @2072 'T' (12 pixels wide)
	//             
	//             
	//             
	//  ########## 
	// ############
	//             
	//      ##     
	//      ##     
	//      ##     
	//      ##     
	//      ##     
	//      ##     
	//      ##     
	//             
	//      ##     
	//      ##     
	//      ##     
	//      ##     
	//      ##     
	//      ##     
	//      ##     
	//      ##     
	//      ##     
	//      #      
	//             
	//             
	//             
	//             
	//             
	0x10, 0x18, 0x18, 0x18, 0x18, 0xD8, 0xD8, 0x18, 0x18, 0x18, 0x18, 0x10, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0xDF, 0xDF, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @2120 'U' (11 pixels wide)
	//            
	//            
	//            
	// #        # 
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	//            
	//  #        #
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// # ######## 
	//  ########  
	//            
	//            
	//            
	//            
	//            
	0xF8, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xF0, 
	0x9F, 0xDF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9F, 0xDF, 
	0x7F, 0xBF, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x7F, 0x3F, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @2164 'V' (11 pixels wide)
	//            
	//            
	//            
	// #        # 
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	//            
	// ##       ##
	// ##      ###
	// ##     ### 
	// ##    ###  
	// ##   ###   
	// ##  ###    
	// ## ###     
	// ## ##      
	// ###        
	// #          
	//            
	//            
	//            
	//            
	//            
	0xF8, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xF0, 
	0xDF, 0xDF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xDF, 0xDF, 
	0xFF, 0x7F, 0x40, 0x30, 0x38, 0x1C, 0x0E, 0x07, 0x03, 0x01, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @2208 'W' (12 pixels wide)
	//             
	//             
	//             
	// #         # 
	// ##        ##
	// ##        ##
	// ##        ##
	// ##        ##
	// ##        ##
	// ##        ##
	// ##        ##
	// ##        ##
	// ##        ##
	//             
	// ##   ##    #
	// ##   ##   ##
	// ##   ##   ##
	// ##   ##   ##
	// ##   ##   ##
	// ##   ##   ##
	// ##   ##   ##
	// ##        ##
	// # ####### # 
	//  #########  
	//             
	//             
	//             
	//             
	//             
	0xF8, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xF0, 
	0xDF, 0xDF, 0x00, 0x00, 0x00, 0xC0, 0xC0, 0x00, 0x00, 0x00, 0x9F, 0xDF, 
	0x7F, 0xBF, 0xC0, 0xC0, 0xC0, 0xDF, 0xDF, 0xC0, 0xC0, 0x80, 0x7F, 0x3F, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @2256 'X' (12 pixels wide)
	//             
	//             
	//             
	//  #        # 
	// ###      ###
	// ###      ## 
	//  ##     ### 
	//  ###    ### 
	//   ##    ##  
	//   ###  ###  
	//   ###  ##   
	//    ##  ##   
	//    ## ###   
	//             
	//    ##  ##   
	//    ## ###   
	//   ###  ###  
	//   ###  ###  
	//   ##    ##  
	//  ###    ### 
	//  ##     ### 
	// ###      ## 
	// ###      ###
	//  #        # 
	//             
	//             
	//             
	//             
	//             
	0x30, 0xF8, 0xF0, 0x80, 0x00, 0x00, 0x00, 0x00, 0xC0, 0xF0, 0xF8, 0x10, 
	0x00, 0x00, 0x07, 0xDF, 0xDE, 0x00, 0x90, 0xDE, 0xDF, 0x03, 0x00, 0x00, 
	0x60, 0xF8, 0x7F, 0x0F, 0x03, 0x00, 0x00, 0x03, 0x1F, 0x7F, 0xF8, 0x40, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @2304 'Y' (11 pixels wide)
	//            
	//            
	//            
	// #        # 
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ###########
	//   #######  
	//          ##
	//          ##
	//          ##
	//          ##
	//          ##
	//          ##
	//          ##
	//          ##
	//  ########  
	// #########  
	//            
	//            
	//            
	//            
	//            
	0xF8, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xF0, 
	0x1F, 0x1F, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0xDF, 0xDF, 
	0x80, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x3F, 0x3F, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @2348 'Z' (11 pixels wide)
	//            
	//            
	//            
	// ###########
	// ###########
	//            
	//        ##  
	//        ### 
	//       ###  
	//       ###  
	//      ###   
	//      ###   
	//      ##    
	//            
	//    ##      
	//    ###     
	//   ###      
	//   ##       
	//  ###       
	//  ##        
	//  #         
	//            
	// ###########
	// ###########
	//            
	//            
	//            
	//            
	//            
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xD8, 0xD8, 0x98, 0x18, 
	0x00, 0x00, 0x00, 0xC0, 0xC0, 0x9C, 0x1F, 0x0F, 0x03, 0x00, 0x00, 
	0xC0, 0xDC, 0xCF, 0xC7, 0xC1, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @2392 '[' (9 pixels wide)
	//          
	//   ###### 
	//  ########
	// #        
	// ##       
	// ##       
	// ##       
	// ##       
	// ##       
	// ##       
	// ##       
	// ##       
	// #        
	//          
	// ##       
	// ##       
	// ##       
	// ##       
	// ##       
	// ##       
	// ##       
	// ##       
	// ##       
	// #        
	//   ###### 
	//  ########
	//          
	//          
	//          
	0xF8, 0xF4, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 
	0xDF, 0xCF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0xFF, 0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x02, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x02, 

	// @2428 '\' (9 pixels wide)
	//          
	//          
	//          
	// #        
	// ##       
	// ###      
	// ###      
	//  ##      
	//  ###     
	//  ###     
	//   ##     
	//   ###    
	//    ##    
	//          
	//     ##   
	//     ###  
	//     ###  
	//      ##  
	//      ### 
	//      ### 
	//       ## 
	//       ###
	//        ##
	//         #
	//          
	//          
	//          
	//          
	//          
	0x78, 0xF0, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x03, 0x0F, 0x1F, 0xD8, 0xC0, 0x80, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x01, 0x0F, 0x3F, 0x7C, 0xE0, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @2464 ']' (9 pixels wide)
	//          
	// #######  
	// #######  
	//        # 
	//        ##
	//        ##
	//        ##
	//        ##
	//        ##
	//        ##
	//        ##
	//        ##
	//        # 
	//          
	//        # 
	//        ##
	//        ##
	//        ##
	//        ##
	//        ##
	//        ##
	//        ##
	//        ##
	//        # 
	// #######  
	// #######  
	//          
	//          
	//          
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0xF8, 0xF0, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xDF, 0x8F, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x7F, 
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x00, 0x00, 

	// @2500 '^' (12 pixels wide)
	//             
	//             
	//             
	//    #####    
	//   #######   
	//  ####  #### 
	// ####    ####
	// ##       ###
	//             
	//             
	//             
	//             
	//             
	//             
	//             
	//             
	//             
	//             
	//             
	//             
	//             
	//             
	//             
	//             
	//             
	//             
	//             
	//             
	//             
	0xC0, 0xE0, 0x70, 0x78, 0x38, 0x18, 0x18, 0x38, 0x70, 0xE0, 0xE0, 0xC0, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @2548 '_' (13 pixels wide)
	//              
	//              
	//              
	//              
	//              
	//              
	//              
	//              
	//              
	//              
	//              
	//              
	//              
	//              
	//              
	//              
	//              
	//              
	//              
	//              
	//              
	//              
	// ############ 
	// #############
	//              
	//              
	//              
	//              
	//              
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x80, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @2600 '`' (6 pixels wide)
	//       
	//       
	//       
	// ##    
	// ###   
	//  ###  
	//   ### 
	//    ###
	//     ##
	//       
	//       
	//       
	//       
	//       
	//       
	//       
	//       
	//       
	//       
	//       
	//       
	//       
	//       
	//       
	//       
	//       
	//       
	//       
	//       
	0x18, 0x38, 0x70, 0xE0, 0xC0, 0x80, 
	0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @2624 'a' (11 pixels wide)
	//            
	//            
	//            
	//   #######  
	// ########## 
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ###########
	//   #######  
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// #        # 
	//            
	//            
	//            
	//            
	//            
	0xF0, 0xF0, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xF0, 0xE0, 
	0xDF, 0xDF, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0xDF, 0xDF, 
	0xFF, 0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x7F, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @2668 'b' (11 pixels wide)
	//            
	//            
	//            
	// ########## 
	// # ######## 
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// # #########
	//  ########  
	//  #       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// # #######  
	// ########## 
	//            
	//            
	//            
	//            
	//            
	0xF8, 0xE8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xF8, 0xE0, 
	0x9F, 0xEF, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0xDF, 0xDF, 
	0xFF, 0xBF, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xBF, 0x3F, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @2712 'c' (11 pixels wide)
	//            
	//            
	//            
	//   #######  
	// ########## 
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// #        ##
	//            
	// ##         
	// ##         
	// ##         
	// ##         
	// ##         
	// ##         
	// ##         
	// ##         
	//   ######## 
	//  ##########
	//            
	//            
	//            
	//            
	//            
	0xF0, 0xF0, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xF0, 0xE0, 
	0xDF, 0xCF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x1F, 
	0x3F, 0xBF, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x80, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @2756 'd' (11 pixels wide)
	//            
	//            
	//            
	// ########## 
	// # ######## 
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// #        # 
	//            
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// # #######  
	// ########## 
	//            
	//            
	//            
	//            
	//            
	0xF8, 0xE8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xF8, 0xE0, 
	0xDF, 0xCF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xDF, 0xCF, 
	0xFF, 0xBF, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xBF, 0x3F, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @2800 'e' (10 pixels wide)
	//           
	//           
	//           
	// ##########
	// # ########
	// ##        
	// ##        
	// ##        
	// ##        
	// ##        
	// ##        
	// ##        
	// # ####### 
	//  #########
	//  #        
	// ##        
	// ##        
	// ##        
	// ##        
	// ##        
	// ##        
	// ##        
	// # ####### 
	// ##########
	//           
	//           
	//           
	//           
	//           
	0xF8, 0xE8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 
	0x9F, 0xEF, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x20, 
	0xFF, 0xBF, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x80, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @2840 'f' (10 pixels wide)
	//           
	//           
	//           
	// ##########
	// # ########
	// ##        
	// ##        
	// ##        
	// ##        
	// ##        
	// ##        
	// ##        
	// # ####### 
	//   ########
	// ##        
	// ##        
	// ##        
	// ##        
	// ##        
	// ##        
	// ##        
	// ##        
	// ##        
	// #         
	//           
	//           
	//           
	//           
	//           
	0xF8, 0xE8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 
	0xDF, 0xCF, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x20, 
	0xFF, 0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @2880 'g' (11 pixels wide)
	//            
	//            
	//            
	//   ######## 
	// ###########
	// ##         
	// ##         
	// ##         
	// ##         
	// ##         
	// ##         
	// ##         
	// ##         
	//            
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	//   #######  
	//  ######### 
	//            
	//            
	//            
	//            
	//            
	0xF0, 0xF0, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x10, 
	0xDF, 0xDF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0xC0, 
	0x3F, 0xBF, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xBF, 0x3F, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @2924 'h' (11 pixels wide)
	//            
	//            
	//            
	// #        # 
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ###########
	//   #######  
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// #        # 
	//            
	//            
	//            
	//            
	//            
	0xF8, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xF0, 
	0xDF, 0xDF, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0xDF, 0xDF, 
	0xFF, 0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x7F, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @2968 'i' (2 pixels wide)
	//   
	//   
	//   
	// # 
	// ##
	// ##
	// ##
	// ##
	// ##
	// ##
	// ##
	// ##
	// ##
	//   
	// ##
	// ##
	// ##
	// ##
	// ##
	// ##
	// ##
	// ##
	// ##
	// # 
	//   
	//   
	//   
	//   
	//   
	0xF8, 0xF0, 
	0xDF, 0xDF, 
	0xFF, 0x7F, 
	0x00, 0x00, 

	// @2976 'j' (12 pixels wide)
	//             
	//             
	//             
	//           # 
	//           ##
	//           ##
	//           ##
	//           ##
	//           ##
	//           ##
	//           ##
	//           ##
	//           ##
	//             
	// ##        ##
	// ##        ##
	// ##        ##
	// ##        ##
	// ##        ##
	// ##        ##
	// ##        ##
	// ##        ##
	//    #######  
	//   ########  
	//             
	//             
	//             
	//             
	//             
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xF0, 
	0xC0, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xDF, 0xDF, 
	0x3F, 0x3F, 0x80, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x3F, 0x3F, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @3024 'k' (12 pixels wide)
	//             
	//             
	//             
	// #        ## 
	// ##       ## 
	// ##      ### 
	// ##     ###  
	// ##    ###   
	// ##    ###   
	// ##   ###    
	// ##  ###     
	// ## ###      
	// ## ###      
	//             
	// ## ###      
	// ## ###      
	// ##  ###     
	// ##   ###    
	// ##    ###   
	// ##    ###   
	// ##     ###  
	// ##      ### 
	// ##       ###
	// #        ## 
	//             
	//             
	//             
	//             
	//             
	0xF8, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x80, 0xC0, 0xE0, 0x78, 0x38, 0x00, 
	0xDF, 0xDF, 0x00, 0xD8, 0xDC, 0xDE, 0x07, 0x03, 0x01, 0x00, 0x00, 0x00, 
	0xFF, 0x7F, 0x00, 0x00, 0x01, 0x03, 0x0F, 0x1E, 0x3C, 0xF0, 0xE0, 0x40, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @3072 'l' (10 pixels wide)
	//           
	//           
	//           
	// #         
	// ##        
	// ##        
	// ##        
	// ##        
	// ##        
	// ##        
	// ##        
	// ##        
	// ##        
	//           
	// ##        
	// ##        
	// ##        
	// ##        
	// ##        
	// ##        
	// ##        
	// ##        
	// # ####### 
	// ##########
	//           
	//           
	//           
	//           
	//           
	0xF8, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0xDF, 0xDF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0xFF, 0xBF, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x80, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @3112 'm' (12 pixels wide)
	//             
	//             
	//             
	//   #######   
	//  #########  
	// ##        ##
	// ##   ##   ##
	// ##   ##   ##
	// ##   ##   ##
	// ##   ##   ##
	// ##   ##   ##
	// ##   ##   ##
	// ##   ##   ##
	//             
	// ##        ##
	// ##        ##
	// ##        ##
	// ##        ##
	// ##        ##
	// ##        ##
	// ##        ##
	// ##        # 
	// ##        # 
	// #         # 
	//             
	//             
	//             
	//             
	//             
	0xE0, 0xF0, 0x18, 0x18, 0x18, 0xD8, 0xD8, 0x18, 0x18, 0x10, 0xE0, 0xE0, 
	0xDF, 0xDF, 0x00, 0x00, 0x00, 0x1F, 0x1F, 0x00, 0x00, 0x00, 0xDF, 0xDF, 
	0xFF, 0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x1F, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @3160 'n' (11 pixels wide)
	//            
	//            
	//            
	// #        # 
	// ## #     ##
	// ## ##    ##
	// ## ###   ##
	// ## ###   ##
	// ##  ###  ##
	// ##  ###  ##
	// ##   ##  ##
	// ##   ### ##
	// ##    ## ##
	//       ##   
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// #        # 
	//            
	//            
	//            
	//            
	//            
	0xF8, 0xF0, 0x00, 0xF0, 0xE0, 0xC0, 0x00, 0x00, 0x00, 0xF8, 0xF0, 
	0xDF, 0xDF, 0x00, 0x00, 0x03, 0x0F, 0x3F, 0x38, 0x00, 0xDF, 0xDF, 
	0xFF, 0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x7F, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @3204 'o' (11 pixels wide)
	//            
	//            
	//            
	//   #######  
	//  ######### 
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// #        ##
	//            
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	//   #######  
	//  ######### 
	//            
	//            
	//            
	//            
	//            
	0xE0, 0xF0, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xF0, 0xE0, 
	0xDF, 0xCF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xDF, 0xDF, 
	0x3F, 0xBF, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xBF, 0x3F, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @3248 'p' (11 pixels wide)
	//            
	//            
	//            
	// ########## 
	// # ######## 
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// # #########
	//  ########  
	// ##         
	// ##         
	// ##         
	// ##         
	// ##         
	// ##         
	// ##         
	// ##         
	// ##         
	// #          
	//            
	//            
	//            
	//            
	//            
	0xF8, 0xE8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xF8, 0xE0, 
	0xDF, 0xEF, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x1F, 0x1F, 
	0xFF, 0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @3292 'q' (11 pixels wide)
	//            
	//            
	//            
	//   #######  
	//  ######### 
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// #        ##
	//            
	// ##   ##  ##
	// ##   ##  ##
	// ##   ##  ##
	// ##   ##  ##
	// ##   ##  ##
	// ##   ##  ##
	// ##   ##  ##
	// ##       ##
	//   #######  
	//  ######### 
	//            
	//            
	//            
	//            
	//            
	0xE0, 0xF0, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xF0, 0xE0, 
	0xDF, 0xCF, 0x00, 0x00, 0x00, 0xC0, 0xC0, 0x00, 0x00, 0xDF, 0xDF, 
	0x3F, 0xBF, 0xC0, 0xC0, 0xC0, 0xDF, 0xDF, 0xC0, 0xC0, 0xBF, 0x3F, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @3336 'r' (11 pixels wide)
	//            
	//            
	//            
	// ########## 
	// # ######## 
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// # #########
	//  ########  
	// ##         
	// ## #       
	// ## ##      
	// ## ###     
	// ##  ###    
	// ##   ###   
	// ##    ###  
	// ##     ### 
	// ##      ###
	// #        ##
	//            
	//            
	//            
	//            
	//            
	0xF8, 0xE8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xF8, 0xE0, 
	0xDF, 0xEF, 0x30, 0xB0, 0x30, 0x30, 0x30, 0x30, 0x30, 0x1F, 0x1F, 
	0xFF, 0x7F, 0x00, 0x03, 0x07, 0x0E, 0x1C, 0x38, 0x70, 0xE0, 0xC0, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @3380 's' (12 pixels wide)
	//             
	//             
	//             
	//   ######### 
	//   ##########
	// ##          
	// ##          
	// ##          
	// ##          
	// ##          
	// ##          
	// ##          
	//  #          
	//   ########  
	//   ##########
	//           ##
	//           ##
	//           ##
	//           ##
	//           ##
	//           ##
	//           ##
	//  #########  
	//  #########  
	//             
	//             
	//             
	//             
	//             
	0xE0, 0xE0, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x10, 
	0x0F, 0x1F, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0xC0, 0xC0, 
	0x00, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x3F, 0x3F, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @3428 't' (12 pixels wide)
	//             
	//             
	//             
	//  ########## 
	// ############
	//             
	//      ##     
	//      ##     
	//      ##     
	//      ##     
	//      ##     
	//      ##     
	//      ##     
	//             
	//      ##     
	//      ##     
	//      ##     
	//      ##     
	//      ##     
	//      ##     
	//      ##     
	//      ##     
	//      ##     
	//      #      
	//             
	//             
	//             
	//             
	//             
	0x10, 0x18, 0x18, 0x18, 0x18, 0xD8, 0xD8, 0x18, 0x18, 0x18, 0x18, 0x10, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0xDF, 0xDF, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @3476 'u' (11 pixels wide)
	//            
	//            
	//            
	// #        # 
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	//            
	//  #        #
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// # ######## 
	//  ########  
	//            
	//            
	//            
	//            
	//            
	0xF8, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xF0, 
	0x9F, 0xDF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9F, 0xDF, 
	0x7F, 0xBF, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x7F, 0x3F, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @3520 'v' (11 pixels wide)
	//            
	//            
	//            
	// #        # 
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	//            
	// ##       ##
	// ##      ###
	// ##     ### 
	// ##    ###  
	// ##   ###   
	// ##  ###    
	// ## ###     
	// ## ##      
	// ###        
	// #          
	//            
	//            
	//            
	//            
	//            
	0xF8, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xF0, 
	0xDF, 0xDF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xDF, 0xDF, 
	0xFF, 0x7F, 0x40, 0x30, 0x38, 0x1C, 0x0E, 0x07, 0x03, 0x01, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @3564 'w' (12 pixels wide)
	//             
	//             
	//             
	// #         # 
	// ##        ##
	// ##        ##
	// ##        ##
	// ##        ##
	// ##        ##
	// ##        ##
	// ##        ##
	// ##        ##
	// ##        ##
	//             
	// ##   ##    #
	// ##   ##   ##
	// ##   ##   ##
	// ##   ##   ##
	// ##   ##   ##
	// ##   ##   ##
	// ##   ##   ##
	// ##        ##
	// # ####### # 
	//  #########  
	//             
	//             
	//             
	//             
	//             
	0xF8, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xF0, 
	0xDF, 0xDF, 0x00, 0x00, 0x00, 0xC0, 0xC0, 0x00, 0x00, 0x00, 0x9F, 0xDF, 
	0x7F, 0xBF, 0xC0, 0xC0, 0xC0, 0xDF, 0xDF, 0xC0, 0xC0, 0x80, 0x7F, 0x3F, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @3612 'x' (12 pixels wide)
	//             
	//             
	//             
	//  #        # 
	// ###      ###
	// ###      ## 
	//  ##     ### 
	//  ###    ### 
	//   ##    ##  
	//   ###  ###  
	//   ###  ##   
	//    ##  ##   
	//    ## ###   
	//             
	//    ##  ##   
	//    ## ###   
	//   ###  ###  
	//   ###  ###  
	//   ##    ##  
	//  ###    ### 
	//  ##     ### 
	// ###      ## 
	// ###      ###
	//  #        # 
	//             
	//             
	//             
	//             
	//             
	0x30, 0xF8, 0xF0, 0x80, 0x00, 0x00, 0x00, 0x00, 0xC0, 0xF0, 0xF8, 0x10, 
	0x00, 0x00, 0x07, 0xDF, 0xDE, 0x00, 0x90, 0xDE, 0xDF, 0x03, 0x00, 0x00, 
	0x60, 0xF8, 0x7F, 0x0F, 0x03, 0x00, 0x00, 0x03, 0x1F, 0x7F, 0xF8, 0x40, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @3660 'y' (11 pixels wide)
	//            
	//            
	//            
	// #        # 
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ##       ##
	// ###########
	//   #######  
	//          ##
	//          ##
	//          ##
	//          ##
	//          ##
	//          ##
	//          ##
	//          ##
	//  ########  
	// #########  
	//            
	//            
	//            
	//            
	//            
	0xF8, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xF0, 
	0x1F, 0x1F, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0xDF, 0xDF, 
	0x80, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x3F, 0x3F, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @3704 'z' (11 pixels wide)
	//            
	//            
	//            
	// ###########
	// ###########
	//            
	//        ##  
	//        ### 
	//       ###  
	//       ###  
	//      ###   
	//      ###   
	//      ##    
	//            
	//    ##      
	//    ###     
	//   ###      
	//   ##       
	//  ###       
	//  ##        
	//  #         
	//            
	// ###########
	// ###########
	//            
	//            
	//            
	//            
	//            
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xD8, 0xD8, 0x98, 0x18, 
	0x00, 0x00, 0x00, 0xC0, 0xC0, 0x9C, 0x1F, 0x0F, 0x03, 0x00, 0x00, 
	0xC0, 0xDC, 0xCF, 0xC7, 0xC1, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @3748 '{' (5 pixels wide)
	//  ####
	//  ### 
	//      
	// #    
	// ##   
	// ###  
	// ###  
	//  ##  
	//  ### 
	//  ### 
	//   ## 
	//   ###
	//    # 
	//      
	//    # 
	//   ###
	//   ## 
	//  ### 
	//  ### 
	//  ##  
	// ###  
	// ###  
	// ##   
	// #    
	//      
	//  ### 
	//  ####
	//    ##
	//      
	0x78, 0xF3, 0xE3, 0x03, 0x01, 
	0x00, 0x03, 0x8F, 0xDF, 0x88, 
	0xF0, 0x7E, 0x3F, 0x07, 0x00, 
	0x00, 0x06, 0x06, 0x0E, 0x0C, 

	// @3768 '|' (13 pixels wide)
	//              
	//              
	//              
	//  ########### 
	//  ############
	//              
	//      ###     
	//      ###     
	//      ###     
	//      ###     
	//      ###     
	//      ###     
	//       #      
	//              
	//       #      
	//      ###     
	//      ###     
	//      ###     
	//      ###     
	//      ###     
	//      ###     
	//              
	//  ########### 
	// ############ 
	//              
	//              
	//              
	//              
	//              
	0x00, 0x18, 0x18, 0x18, 0x18, 0xD8, 0xD8, 0xD8, 0x18, 0x18, 0x18, 0x18, 0x10, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x8F, 0xDF, 0x8F, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x80, 0xC0, 0xC0, 0xC0, 0xC0, 0xDF, 0xDF, 0xDF, 0xC0, 0xC0, 0xC0, 0xC0, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

	// @3820 '}' (5 pixels wide)
	// #### 
	//  ### 
	//     #
	//     #
	//    ##
	//    ##
	//   ###
	//   ## 
	//   ## 
	//  ### 
	//  ##  
	//  ##  
	//  #   
	//      
	//  #   
	//  ##  
	//  ##  
	//  ### 
	//   ## 
	//   ## 
	//   ###
	//    ##
	//    ##
	//     #
	//      
	//  ####
	// #### 
	// ###  
	//      
	0x01, 0x03, 0xC3, 0xF3, 0x7C, 
	0x00, 0xDE, 0x8F, 0x03, 0x00, 
	0x00, 0x03, 0x1F, 0x7E, 0xF0, 
	0x0C, 0x0E, 0x0E, 0x06, 0x02, 

	// @3840 '~' (14 pixels wide)
	//               
	//               
	//               
	//               
	//               
	//               
	//               
	//               
	//               
	//             ##
	//            ###
	//           ####
	//      #### ### 
	//     ######    
	//   ##          
	//  ###          
	// ###           
	// ##            
	//               
	//               
	//               
	//               
	//               
	//               
	//               
	//               
	//               
	//               
	//               
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x80, 0xC0, 0xC0, 0x20, 0x30, 0x30, 0x30, 0x30, 0x20, 0x18, 0x1C, 0x1E, 0x0E, 
	0x03, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

// Character descriptors for LCDLarge_24pt
// { [Char width in bits], [Offset into LCDLarge_24ptCharBitmaps in bytes] }
const PROGMEM unsigned int LCDLarge_24ptDescriptors[][2] = 
{
	{8, 0}, 		//   
	{2, 32}, 		// ! 
	{7, 40}, 		// " 
	{21, 68}, 		// # 
	{12, 152}, 		// $ 
	{28, 200}, 		// % 
	{12, 312}, 		// & 
	{2, 360}, 		// ' 
	{6, 368}, 		// ( 
	{5, 392}, 		// ) 
	{12, 412}, 		// * 
	{11, 460}, 		// + 
	{4, 504}, 		// , 
	{8, 520}, 		// - 
	{2, 552}, 		// . 
	{10, 560}, 		// / 
	{11, 600}, 		// 0 
	{2, 644}, 		// 1 
	{12, 652}, 		// 2 
	{11, 700}, 		// 3 
	{12, 744}, 		// 4 
	{12, 792}, 		// 5 
	{11, 840}, 		// 6 
	{11, 884}, 		// 7 
	{11, 928}, 		// 8 
	{12, 972}, 		// 9 
	{2, 1020}, 		// : 
	{4, 1028}, 		// ; 
	{7, 1044}, 		// < 
	{9, 1072}, 		// = 
	{7, 1108}, 		// > 
	{12, 1136}, 		// ? 
	{21, 1184}, 		// @ 
	{11, 1268}, 		// A 
	{11, 1312}, 		// B 
	{11, 1356}, 		// C 
	{11, 1400}, 		// D 
	{10, 1444}, 		// E 
	{10, 1484}, 		// F 
	{11, 1524}, 		// G 
	{11, 1568}, 		// H 
	{2, 1612}, 		// I 
	{12, 1620}, 		// J 
	{12, 1668}, 		// K 
	{10, 1716}, 		// L 
	{12, 1756}, 		// M 
	{11, 1804}, 		// N 
	{11, 1848}, 		// O 
	{11, 1892}, 		// P 
	{11, 1936}, 		// Q 
	{11, 1980}, 		// R 
	{12, 2024}, 		// S 
	{12, 2072}, 		// T 
	{11, 2120}, 		// U 
	{11, 2164}, 		// V 
	{12, 2208}, 		// W 
	{12, 2256}, 		// X 
	{11, 2304}, 		// Y 
	{11, 2348}, 		// Z 
	{9, 2392}, 		// [ 
	{9, 2428}, 		// backslash
	{9, 2464}, 		// ] 
	{12, 2500}, 		// ^ 
	{13, 2548}, 		// _ 
	{6, 2600}, 		// ` 
	{11, 2624}, 		// a 
	{11, 2668}, 		// b 
	{11, 2712}, 		// c 
	{11, 2756}, 		// d 
	{10, 2800}, 		// e 
	{10, 2840}, 		// f 
	{11, 2880}, 		// g 
	{11, 2924}, 		// h 
	{2, 2968}, 		// i 
	{12, 2976}, 		// j 
	{12, 3024}, 		// k 
	{10, 3072}, 		// l 
	{12, 3112}, 		// m 
	{11, 3160}, 		// n 
	{11, 3204}, 		// o 
	{11, 3248}, 		// p 
	{11, 3292}, 		// q 
	{11, 3336}, 		// r 
	{12, 3380}, 		// s 
	{12, 3428}, 		// t 
	{11, 3476}, 		// u 
	{11, 3520}, 		// v 
	{12, 3564}, 		// w 
	{12, 3612}, 		// x 
	{11, 3660}, 		// y 
	{11, 3704}, 		// z 
	{5, 3748}, 		// { 
	{13, 3768}, 		// | 
	{5, 3820}, 		// } 
	{14, 3840}, 		// ~ 
};

// Font information for LCDLarge_24pt
const FONT_INFO LCDLarge_24ptFontInfo =
{
	4, //  Character height
	' ', //  Start character
	'~', //  End character
	/*NULL, //  Character block lookup*/
	LCDLarge_24ptDescriptors[0], //  Character descriptor array
	LCDLarge_24pt, //  Character bitmap array
};



#endif