
//Developer Chris Gimson    chris@gimson.co.uk

String Firmware_Version = "Geyser_Control_2V9  21st April 2019"; 
#define SERIAL_BAUDRATE 115200
  // ----------------- IO pin assignments  - Change to suit hardware build
byte GeyserControlRelay = 13;    // Geyser Switching relay pin assignments
const byte AP_Switch = 0;        // IO address of the AP enable switch
const byte Heartbeat_LED = 2;    // IO pin number for Heartbeat LED
const byte Board_SDA = 4;
const byte Board_SCL = 5;
const byte  ONE_WIRE_BUS = 12;  // pin used for Temperature sensor bus  
 // -------------------------- IO states - Change to suit hardware build --------------
const boolean LED_On = LOW;   
const boolean LED_Off = !LED_On;
const boolean GeyserOn = LOW; 
const boolean GeyserOff = !GeyserOn;
const boolean SwitchOn = LOW;       // Switch/buttons
const boolean SwitchOff = !SwitchOn;
const boolean Fitted = true;
const boolean NotFitted = !Fitted;
  // -------------------------- Important program parameters ----------------------------------------
const unsigned long LED_OnFlash = 4;   // Station mode
const unsigned long LED_OffFlash = 1980;   
const unsigned long LED_FlashStartup = 50;
byte Setting1_ON_Setpoint = 20;   // ON Temperature setting for Geyser Temp Control during daytime 0 to 60'C
byte Setting2_ON_Setpoint = 21; // ON Temperature setting for Geyser Temp Control during nighttime 0 to 60'C
byte Setting1_OFF_Setpoint = 22;   // OFF Temperature setting for Geyser Temp Control during daytime 0 to 60'C
byte Setting2_OFF_Setpoint = 23; // OFF Temperature setting for Geyser Temp Control during nighttime 0 to 60'C
const byte GeyserManualControlTimerInterval = 15;  // Maximum time allowed in minutes for Geyser to run without Setpoints being enabled
const byte MaxStringLength = 20;  // Max. no of characters allowed in any stored string. 
float ShutdownTemperature = 75.0;
const byte TimerLimit = 240;  // max value of switch timer ON values
const byte NoOf_OLED_Pages = 6;     // No of OLED screens
byte DisplayOffTime = 23; // Time (hour) that the OLED screen will auto switch OFF
byte DisplayOnTime = 8;   // Time (hour) that the OLED screen will auto switch ON
const byte TemporaryDisplayCounterInterval = 7;  // Duration of Temporary display time
  // ------------------------------------------------------------------------------------------------  
boolean WiFiManualEnable = true;
byte TemporaryDisplayCounter = TemporaryDisplayCounterInterval;   // Increment by Manual switch, Controls temporary display On time
const boolean SetpointGroup1 = true;
const boolean SetpointGroup2 = !SetpointGroup1;
const boolean Enabled = true;
const boolean Disabled = !Enabled;
const boolean Stopped = false;
const boolean Running = true;
boolean GeyserTempControlEnabled = Enabled;   // true = Geyser temperature control enabled, false = off
boolean SelfCheck = Enabled;
int TempFailCounter;
float TempLog[24];     // storage for last 24 hourly temperature readings
float SkinLog[24][4];  // storage for last 24 hourly skin readings
byte GeyserPowerLog [24];     // storage for last 24 hourly Geyser ON readings - minutes
byte TimeLogHr[24];   // storage for last 24 hourly Geyser ON readings - Time hours
byte TimeLogMin[24];   // storage for last 24 hourly Geyser ON readings - Time Minutes
byte LogPointer = 0;  // index pointer for Log arrays
float TempMax = 0;         // maximum temperature recorded during day
float TempMin = 0;         // minimum temperature recorded during day
float AverageGeyserTemperature;
unsigned long GeyserOnTimer;    // ON timer for each output when switched in seconds
unsigned long GeyserOnRunningTimer;   // used for timing Geryser On times
byte GeyserManualControlTimer;
//float MinuteTempLog[60];   // used for calculating hourly averages
  // -------------------------------------------------------------------------------
boolean AccessPointRunning;   // true = AP is running
boolean FirstPass;    // used in OLED update function

String ssid = "....................";    // variable for storing the Access Point SSID
String esid;             // Variable for the WiFi Station log in SSID (stored in EEPROM)
String epass = "";       // Variable for the WiFi Station log in Password (stored in EEPROM)
String HostName = "...................." ;
String StoredString = "....................";
String passphrase =   "....................";
String st;
String content;
boolean LoginSuccessful;   // = true if WiFi login failed
unsigned long NTP_Time_Interval; // NTP time interval between updates in mS  
boolean NTP_Resolved;   // true if NTP has successfully set up soft clock  
 // -----------------------------------------------------------------------------------------
            // EEPROM - direct byte addresses for EEPROM storage of configurable parameters
const unsigned int EEPROM_Start_Address = 0;      // starting address for EEPROM store (changing this moves the EEPROM block up/down the available memory range  
const unsigned int EEPROM_WiFi_SSID = EEPROM_Start_Address;   // start of Wifi SSID store - 20 bytes
const unsigned int EEPROM_WiFi_Password = EEPROM_WiFi_SSID + MaxStringLength;     // start of Wifi password - 20 bytes  
const unsigned int EEPROM_HostName = EEPROM_WiFi_Password + MaxStringLength;     // Device network name - 20 bytes  
const unsigned int EEPROM_Geyser_Timer1_TimOn_Min = EEPROM_HostName  + MaxStringLength;     // Geyser Timer 1 Time ON minutes value
const unsigned int EEPROM_Geyser_Timer1_TimOn_Hrs = EEPROM_Geyser_Timer1_TimOn_Min + 1;      // Geyser Timer 1 Time ON hours value
const unsigned int EEPROM_Geyser_Timer1_TimOff_Min = EEPROM_Geyser_Timer1_TimOn_Hrs + 1;     // Geyser Timer 1 Time OFF minutes value
const unsigned int EEPROM_Geyser_Timer1_TimOff_Hrs = EEPROM_Geyser_Timer1_TimOff_Min + 1;    // Geyser Timer 1 Time OFF hours value
const unsigned int EEPROM_Geyser_Timer2_TimOn_Min = EEPROM_Geyser_Timer1_TimOff_Hrs + 1;     // Geyser Timer 2 Time ON minutes value
const unsigned int EEPROM_Geyser_Timer2_TimOn_Hrs = EEPROM_Geyser_Timer2_TimOn_Min + 1;      // Geyser Timer 2 Time ON hours value
const unsigned int EEPROM_Geyser_Timer2_TimOff_Min = EEPROM_Geyser_Timer2_TimOn_Hrs + 1;     // Geyser Timer 2 Time ON minutes value
const unsigned int EEPROM_Geyser_Timer2_TimOff_Hrs = EEPROM_Geyser_Timer2_TimOff_Min + 1;    // Geyser Timer 2 Time OFF hours value
const unsigned int EEPROM_Geyser_Timer1_Sun = EEPROM_Geyser_Timer2_TimOff_Hrs + 1;      // Geyser Timer 1 Sunday
const unsigned int EEPROM_Geyser_Timer1_Mon = EEPROM_Geyser_Timer1_Sun + 1;             // Geyser Timer 1 Monday
const unsigned int EEPROM_Geyser_Timer1_Tue = EEPROM_Geyser_Timer1_Mon + 1;             // Geyser Timer 1 Tuesday
const unsigned int EEPROM_Geyser_Timer1_Wed = EEPROM_Geyser_Timer1_Tue + 1;           
const unsigned int EEPROM_Geyser_Timer1_Thu = EEPROM_Geyser_Timer1_Wed + 1;          
const unsigned int EEPROM_Geyser_Timer1_Fri = EEPROM_Geyser_Timer1_Thu + 1;          
const unsigned int EEPROM_Geyser_Timer1_Sat = EEPROM_Geyser_Timer1_Fri + 1;    
const unsigned int EEPROM_Geyser_Timer2_Sun = EEPROM_Geyser_Timer1_Sat + 1;             // Geyser Timer 2 Sunday
const unsigned int EEPROM_Geyser_Timer2_Mon = EEPROM_Geyser_Timer2_Sun + 1;             // Geyser Timer 2 Monday
const unsigned int EEPROM_Geyser_Timer2_Tue = EEPROM_Geyser_Timer2_Mon + 1;             // Geyser Timer 2 Tuesday
const unsigned int EEPROM_Geyser_Timer2_Wed = EEPROM_Geyser_Timer2_Tue + 1;           
const unsigned int EEPROM_Geyser_Timer2_Thu = EEPROM_Geyser_Timer2_Wed + 1;          
const unsigned int EEPROM_Geyser_Timer2_Fri = EEPROM_Geyser_Timer2_Thu + 1;          
const unsigned int EEPROM_Geyser_Timer2_Sat = EEPROM_Geyser_Timer2_Fri + 1;   
const unsigned int EEPROM_Setting1_ON_Setpoint =  EEPROM_Geyser_Timer2_Sat + 1;
const unsigned int EEPROM_Setting2_ON_Setpoint = EEPROM_Setting1_ON_Setpoint + 1;
const unsigned int EEPROM_Setting1_OFF_Setpoint =  EEPROM_Setting2_ON_Setpoint + 1; 
const unsigned int EEPROM_Setting2_OFF_Setpoint = EEPROM_Setting1_OFF_Setpoint + 1;
const unsigned int EEPROM_GeyserTempControlEnabled = EEPROM_Setting2_OFF_Setpoint + 1;
const unsigned int EEPROM_TimerEnableGeyserTimer1 = EEPROM_GeyserTempControlEnabled  + 1;    // Timer 1 enable - Geyser
const unsigned int EEPROM_TimerEnableGeyserTimer2 = EEPROM_TimerEnableGeyserTimer1 +1;
const unsigned int EEPROM_EnableMessages = EEPROM_TimerEnableGeyserTimer2 + 1;      // disgnostic messages enable
const unsigned int EEPROM_Timer_Reset_Clock_Finish_Hrs = EEPROM_EnableMessages + 1;
const unsigned int EEPROM_Timer_Reset_Enable = EEPROM_Timer_Reset_Clock_Finish_Hrs + 1;
const unsigned int EEPROM_WiFiManualEnable = EEPROM_Timer_Reset_Enable + 1;   // 
const unsigned int EEPROM_AP_Password = EEPROM_WiFiManualEnable + 1;     // Access point password 20 bytes
const unsigned int EEPROM_Header_Block = EEPROM_AP_Password + + MaxStringLength;       // EEPROM header block 5 bytes
//const unsigned int EEPROM_GeyserAddress = EEPROM_Header_Block + 5;
//const unsigned int EEPROM_SkinAddress = EEPROM_GeyserAddress + 8;
const unsigned int EEPROM_TempSensorIndex =  EEPROM_Header_Block + 5;    // 5 bytes  
const unsigned int EEPROM_DisplayOffTime = EEPROM_TempSensorIndex + 5;
const unsigned int EEPROM_DisplayOnTime = EEPROM_DisplayOffTime + 1;

  // for geyser, [timer1,2], true = a time control timer (timer 1 and/or timer 2)is running ON
boolean TimerActive[2] = {false,false};   // flags reflect whether the Geyser timers are running
unsigned int LongClockMinute;  // day clock expressed in minutes
const boolean Hardware = true;
const boolean Software = !Hardware;
boolean EnableMessages;    // true = enable diagnostic messages, false = mute messages
 // --------------- 3 arrays holding the Timer control parameters -------------------------
byte GeyserTimeControlParameters [2][2][2];   // arranged as  [TimerNo][TimON/TimOFF][Min,Hrs,]                                                                
unsigned int LongTimerON[2];    // Timer control settings in minutes [Timer1, timer2)
unsigned int LongTimerOFF[2];
const byte Timer1 = 0;
const byte Timer2 = 1;
// --------------------------------------------------------------
int deviceCount = 0;
float SkinTemp[4]; // upto 4 skin temperature variables
 // --------------- Two dimensional array for geyser output holding the day enable flags --------
boolean GeyserTimeControlParameters_Day_Flags [2][7];  // arranged as  [TimerNo][Week day]                                                                            
boolean TimerEnable[2];  // Timer enable flag for each timer (2)
boolean Soft_AP_Switch;  // true = Access point will run 
boolean TempFailFlag;
const byte TimerOn = 0;
const byte TimerOff = 1;
const byte Mins = 0;
const byte Hrs = 1;

unsigned long Timer_Tick;     // used as timer for one minute timed operations. E.g. Output timers

byte TempSensorIndex[] = {0,1,2,3,4};     // Bus index number for each DS18B20 sensor used

// Soft clock & date time elements
byte ClockMinute;
byte ClockHour;
byte ClockWeekDay = 0;
byte Last_NTP_Hour;   // // storage of the last time that the NTP update was successful (diagnostoics page)
byte Last_NTP_Minute;
byte Last_NTP_Day;
//   RTC varaiables
byte RTC_Second;
byte RTC_Minute;
byte RTC_Hour;
byte RTC_Day;
byte RTC_MonthDay;
byte RTC_Month;
int RTC_Year;
byte zero;

byte PreviousHour;
boolean RTC_BoardPresent = false;  // true if RTC board is fitted to circuit

unsigned long TimeStart;   // used in boolean Check_AP_Switch(unsigned long Debounce)
                            // stores start time (ms) when button is pressed
byte AutoResetTimer;        // timer used for timing an auto reset after a start up wifi connection fail
const byte AutoResetTimeout = 2; // if start up wifi connection fails, device will reset after this timeout (minutes)
boolean AutoResetTimerEnable = false;  // true = AutoResetTimer is enabled

unsigned long DisplayToggleRunningTimer;
unsigned long DisplayToggleInterval = 3000;  // time that each display page is displayed when display toggle is enabled
boolean OLED;
byte ScreenNo;        // page no of screen contrents to be displayed
