//http://www.gpsvisualizer.com/map_input?form=data

#define RED 3
#define GREEN 5
#define BLUE 6
#define SRX 9
#define STX 10
#define chipSelect 4

#define sleeptime 20000

#define Datsize 7
#define Timsize 10
#define Latsize 9
#define SNsize 2
#define Lonsize 10
#define EWsize 2
#define Spdsize 6
#define Qtysize 2
#define Trcsize 3

#define LOG_FILE "log.txt"

#include <SoftwareSerial.h>
SoftwareSerial ss(SRX, STX);

#include <SdFat.h>
SdFat sd;
SdFile f;

char cDat[Datsize],
     cTim[Timsize],
     cLat[Latsize],
     cSN[SNsize],
     cLon[Lonsize],
     cEW[EWsize],
     cSpd[Spdsize],
     cQty[Qtysize],
     cTrc[Trcsize];

int toLog = 0;

void setup(){
  pinMode(RED,OUTPUT);
  pinMode(GREEN,OUTPUT);
  pinMode(BLUE,OUTPUT);
  RGBOFF();
  
  Serial.begin(9600);
  ss.begin(9600);
  
  if(!sd.begin(chipSelect, SPI_HALF_SPEED)){
    while(1){
      RGBR();
      delay(100);
      RGBB();
      delay(100);
    }
  }
}

void loop(){
  while (ss.available() > 0){
    //byte gpsData = ss.read();
    //Serial.write(gpsData);
    readIt();
    delay(1);
  }
  RGBOFF();
  if(toLog == 2){
    Serial.println("logged                  +++");
    Serial.println(cDat[0]);
    logIt('S');
    RGBB();
    delay(100);
    RGBOFF();
    delay(sleeptime);
    while (ss.available() > 0){
      ss.read();
    }
  }
  //Serial.println("-");
  String data = "";
  data.toCharArray(cTim, Timsize);
  data.toCharArray(cLat, Latsize);
  data.toCharArray(cSN, SNsize);
  data.toCharArray(cLon, Lonsize);
  data.toCharArray(cEW, EWsize);
  data.toCharArray(cQty, Qtysize);
  data.toCharArray(cTrc, Trcsize);
  data.toCharArray(cSpd, Spdsize);
  data.toCharArray(cDat, Datsize);
  toLog = 0;
}


