/*----------------------------------------------------------------------------------------------+
                               All sensor functions in this tab.
/-----------------------------------------------------------------------------------------------*/
#if (USE_HDC1000)
void HDC1000() {

  if (!hdc.begin()) {                      // open and verify it's found
#if (DEBUG)
    Serial.println("Couldn't find sensor!");
#endif
    Temp = -1;                             // default to -1 if not found
    humidity = -1;
    // MORE HERE - flag?
    return;
  }

  humidity = hdc.readHumidity();          // Read humidity (percent)
  delay(100);                          // SEE IF HELPS
  Temp = hdc.readTemperature();     // Read temperature as Centigrade

#if (!CELSIUS)
  Temp = (Temp * 9.0) / 5.0 + 32.0; // Convert Celsius to Fahrenheit
#endif
}
#endif


#if (USE_DHT)
void getDHT() {
  // Reading temperature for humidity takes about 250 milliseconds!
  delay(750);                             // let the voltage settle (may no be necessary)
  humidity = dht.readHumidity();          // Read humidity (percent)
  Temp = dht.readTemperature();           // Read temperature as Fahrenheit

#if (!CELSIUS)
  Temp = (Temp * 9.0) / 5.0 + 32.0; // Convert Celsius to Fahrenheit
#endif

  // handle a bad read IF FARENHEIT !!! - Note if using ThingSpeak these values can be omitted from the chart.
  if (Temp > 200 || isnan(Temp)) Temp = 0;   // handle a bad read
  if (humidity > 100 || isnan(humidity)) humidity = 0;

#if (DEBUG)
  // Check if any reads failed
  if (isnan(humidity) || isnan(Temp)) {
    Serial.println("Failed to read from DHT sensor!");
    return;
  }
  else {
    Serial.print("Temp = ");
    Serial.print(Temp);
    Serial.print("  Humidity = ");
    Serial.println(humidity);
  }
#endif
}
#endif

