//----------------------------------------------------------------------------------------------+
//                               PIN MAP for ESP8266
//----------------------------------------------------------------------------------------------+
#define SDA_PIN        0                // I2C SDA pin (pulled up) + PGM button and LED
// TX                  1                // wired to serial comm
#define SCL_PIN        2                // I2C SCL pin (pulled up)
// RX                  3                // wired to serial comm
//Brett
#define Rain_Sense     4                // rain sensor output
//Brett
#define DHT_PIN        5                // must have a 10k pullup on this pin
#define YEL_LED        12               // steady = empty buffer (no GK connection yet)
#define RED_LED        13               // connecting to network - off when connected.
#define GRN_LED        14               // flashes with each send
// RUN / PGM           15               // pulled low on carrier board
// WAKE                16               // wired to RESET through cap to wake from sleep

//----------------------------------------------------------------------------------------------+
//                                 other defines and globals. . .
//----------------------------------------------------------------------------------------------+

#define CPM              0              // index names for f_values
#define DOSE             1
#define VCC              2

// global variables . . .
float f_value[3];                       // floats for CPM, Dose, Vcc
float humidity, Temp;                   // values read from temp/humidity sensor
boolean newData = false;                // true when new data arrives from Geiger Kit
unsigned long lastConnectionTime = 0;   // mS from last server connection
unsigned int maxCPM = 0;                // saves the maximum CPM from each 24 hours after startup
unsigned long lastmaxCpmTime = 0;       // mS from last maxCPM period
//Brett
int rain = 0;                           // rain sensor-raining = 1
//Brett
