/*----------------------------------------------------------------------------------------------+
                               All WiFi send functions in this tab.
/-----------------------------------------------------------------------------------------------*/

//----------------------------------------------------------------------------------------------+
//                              RADMON send function:
// Radmon only accepts CPM value
//----------------------------------------------------------------------------------------------+

#if (SEND_TO_RADMON)
void sendToRadmon() {
  digitalWrite(GRN_LED, HIGH);          // signal you're transmitting

#if (DEBUG)
  Serial.print("connecting to ");
  Serial.println(RadmonHost);
#endif

  WiFiClient client;                    // Use WiFiClient class to create TCP connections
  const int httpPort = 80;
  if (!client.connect(RadmonHost, httpPort)) {
#if (DEBUG)
    Serial.println("connection failed");
#endif
    return;
  }

  // We now create a URI for the request
  String url = "function=submit&user=";
  url += UserName;
  url += "&password=";
  url += PassWord;
  url += "&value=";
  url += int(f_value[CPM]);
  url += "&unit=CPM";


#if (DEBUG)
  Serial.print("Requesting URL: ");
  Serial.println(url);
#endif

  // This will send the request to the server
  client.print(String("GET /radmon.php?") + url + " HTTP/1.1\r\n" +
               "Host: " + RadmonHost + "\r\n" +
               "Connection: close\r\n\r\n");
  delay(10);

#if (DEBUG)  // Read all the lines of the reply from server and print them to Serial
  while (client.available()) {
    String line = client.readStringUntil('\r');
    Serial.print(line);
  }
  Serial.println();
  Serial.println("closing connection");
#endif

  digitalWrite(GRN_LED, LOW);         // it's just a flash
  lastConnectionTime = millis();      // note the time (used for DEBUG)
}
#endif


//----------------------------------------------------------------------------------------------+
//                              THINGSPEAK send function:
// ThingSpeak uses string fields. Field names must be field1, field2, etc.
//----------------------------------------------------------------------------------------------+

#if (SEND_TO_THINGSPEAK) // (data.sparkfun.com)
void sendToThingSpeak() {
  digitalWrite(GRN_LED, HIGH);          // signal you're transmitting

#if (DEBUG)
  Serial.print("connecting to ");
  Serial.println(ThingSpeakHost);
#endif

  WiFiClient client;                    // Use WiFiClient class to create TCP connections
  const int httpPort = 80;
  if (!client.connect(ThingSpeakHost, httpPort)) {
#if (DEBUG)
    Serial.println("connection failed");
#endif
    return;
  }

  // We now create a URI for the request
  String url = "/update?api_key=";
  url += writeAPI;
  url += "&field1=";
  url += String(int(f_value[CPM]));
  url += "&field2=";
  url += String(f_value[DOSE]);
  url += "&field3=";
  url += String(f_value[VCC]); // Vcc at Geiger Kit
  //url += String(ESP.getVcc());    // gets Vcc at ESP8266
  url += "&field4=";
  url += String(maxCPM);
#if (USE_DHT | USE_HDC1000)
  url += "&field5=";
  url += String(Temp);
  url += "&field6=";
  url += String(int(humidity));
#endif
 
//Brett
  url += "&field7=";
  url += String(int(rain));
//Brett

#if (DEBUG)
  Serial.print("Requesting URL: ");
  Serial.println(url);
#endif

  // This will send the request to the server
  client.print(String("GET ") + url + " HTTP/1.1\r\n" +
               "Host: " + ThingSpeakHost + "\r\n" +
               "Connection: close\r\n\r\n");
  delay(10);

#if (DEBUG) // Read all the lines of the reply from server and print them to Serial
  while (client.available()) {
    String line = client.readStringUntil('\r');
    Serial.print(line);
  }
  Serial.println();
  Serial.println("closing connection");
#endif

  digitalWrite(GRN_LED, LOW);         // it's just a flash
  lastConnectionTime = millis();      // note the time (used for DEBUG)
}
#endif


//----------------------------------------------------------------------------------------------+
//                              SPARKFUN send function:
// Sparkfun ("phant") converts field names to all lowercase when creating a new account.
// So field names must be in lower case in this function. All field names in account
// must be sent. Otherwise, none will be received.
//----------------------------------------------------------------------------------------------+
#if (SEND_TO_SPARKFUN) // (data.sparkfun.com)
void sendToSparkfun() {
  digitalWrite(GRN_LED, HIGH);          // signal you're transmitting

#if (DEBUG)
  Serial.print("connecting to ");
  Serial.println(SparkfunHost);
#endif

  WiFiClient client;                    // Use WiFiClient class to create TCP connections
  const int httpPort = 80;
  if (!client.connect(SparkfunHost, httpPort)) {
#if (DEBUG)
    Serial.println("connection failed");
#endif
    return;
  }

  // We now create a URI for the request
  String url = "/input/";
  url += streamId;
  url += "?private_key=";
  url += privateKey;
  url += "&cpm=";
  url += int(f_value[CPM]);
  url += "&dose=";
  url += f_value[DOSE];
  url += "&vcc=";
  url += f_value[VCC];
  url += "&maxcpm=";
  url += maxCPM;
#if (USE_DHT | USE_HDC1000)
  url += "&temp=";
  url += int(Temp);
  url += "&humidity=";
  url += int(humidity);
#endif

//Brett
  url += "&rain=";
  url += int(rain);
//Brett

#if (DEBUG)
  Serial.print("Requesting URL: ");
  Serial.println(url);
#endif

  // This will send the request to the server
  client.print(String("GET ") + url + " HTTP/1.1\r\n" +
               "Host: " + SparkfunHost + "\r\n" +
               "Connection: close\r\n\r\n");
  delay(10);

#if (DEBUG) // Read all the lines of the reply from server and print them to Serial
  while (client.available()) {
    String line = client.readStringUntil('\r');
    Serial.print(line);
  }
  Serial.println();
  Serial.println("closing connection");
#endif

  digitalWrite(GRN_LED, LOW);         // it's just a flash
  lastConnectionTime = millis();      // note the time (used for DEBUG)
}
#endif


//----------------------------------------------------------------------------------------------+
//               Get serial data from Geiger kit and (optionally temp and humidity)
//----------------------------------------------------------------------------------------------+

void getInput() {
  // Called from loop when serial available, (i.e. "1889,10.7678,4.96") it's parsed into 3 floats
  // Floats are used for compatibility with services that take them - uSv/hr for instance.
  char inStr[10];                       // buffer for serial input
  byte f_valIdx = 0;                    // index to the 3 floats
  byte inStrPos = 0;                    // position in inStr

  memset(inStr, 0, sizeof(inStr));      // clear the input string
  while (Serial.available()) {
    digitalWrite(YEL_LED, HIGH);        // signal buffer is being read
    delay(10);                          // makes you crazy if you don't allow input buffer to fill NEEDED!
    char inChar = Serial.read();
    if (inChar == ',' || inChar == '\r') {
      f_value[f_valIdx] = atof(inStr);  // covert to float (strcat(inStr,'\0') not needed)
      f_valIdx++;
      inStrPos = 0;
      memset(inStr, 0, sizeof(inStr));  // clear the input string again
    }
    else {
      inStr[inStrPos] = inChar;         // just read in the next char
      inStrPos++;
    }
    digitalWrite(YEL_LED, LOW);
    if (inChar == '\r') {
      newData = true;
      break;
    }
  }

}


