/*----------------------------------------------------------------------------------------------+
Routines for 0.96" or 1.3" I2C OLED display (128x64). Display is 8 lines of 16 char.
Thanks to Mike-Rankin for the original work.
Added some functions, cleaned up, and fixed Y & X reversal in names. [BH 11/11/15]
Draw_WIFI() and Draw_WAVES() do not work - REMOVE.
/-----------------------------------------------------------------------------------------------*/

#include "font.h"
#define OLED_address  0x3c              //OLED I2C bus address... even if OLED states 0x78 !!!
#define TOP2BOTTOM

  char buffer[18];                        // message buffer - general purpose

static void reset_display(void) {
  displayOff();
  clear_display();
  displayOn();
}


void StartUp_OLED() {
  init_OLED();
  reset_display();
  displayOff();
  setXY(0, 0);
  clear_display();
  displayOn();
}


void displayOn(void) {
  sendcommand(0xaf);                  //display on
}


void displayOff(void) {
  sendcommand(0xae);                    //display off
}


static void clear_display(void) {
  unsigned char i, k;
  for (k = 0; k < 8; k++)
  {
    setXY(k, 0);
    {
      for (i = 0; i < 128; i++)         //clear all COL
      {
        SendByte(0);                    //clear all COL
      }
    }
  }
  setXY(0, 0);                          // added MRB
}

// BH ADDED - clear a row
void clearRow (byte rowNum) {
  sendStrYX("                ", rowNum, 0); 
}


// This sends a byte to draw in the display.
static void SendByte(unsigned char data) {
  Wire.beginTransmission(OLED_address); // begin transmitting
  Wire.write(0x40);                     //data mode
  Wire.write(data);
  Wire.endTransmission();             // stop transmitting
}


// Prints a display char (not just a byte) in coordinates X Y,
static void sendCharYX(unsigned char data, int X, int Y) {
  //if(interrupt && !doing_menu) return;// Stop printing only if interrupt is call but not in button functions
  setXY(X, Y);
  Wire.beginTransmission(OLED_address); // begin transmitting
  Wire.write(0x40);                     //data mode

  for (int i = 0; i < 8; i++)
    Wire.write(pgm_read_byte(myFont[data - 0x20] + i));

  Wire.endTransmission();               // stop transmitting
}


static void sendcommand(unsigned char com) {
  Wire.beginTransmission(OLED_address); //begin transmitting
  Wire.write(0x80);                     //command mode
  Wire.write(com);
  Wire.endTransmission();               // stop transmitting
}


// Set the cursor position in a 16 COL * 8 ROW map.
static void setXY(unsigned char row, unsigned char col) {
  sendcommand(0xb0 + row);              //set page address
  sendcommand(0x00 + (8 * col & 0x0f)); //set low col address
  sendcommand(0x10 + ((8 * col >> 4) & 0x0f)); //set high col address
}


// Prints a string regardless the cursor position.
static void sendStr(unsigned char *string) {
  unsigned char i = 0;
  while (*string)
  {
    for (i = 0; i < 8; i++)
    {
      SendByte(pgm_read_byte(myFont[*string - 0x20] + i));
    }
    *string++;
  }
}


// Prints a string in coordinates Y X, being multiples of 8.
// This means we have 16 COLS (0-15) and 8 ROWS (0-7).
static void sendStrYX( char *string, int X, int Y) {
  setXY(X, Y);
  unsigned char i = 0;
  while (*string)
  {
    for (i = 0; i < 8; i++)
    {
      SendByte(pgm_read_byte(myFont[*string - 0x20] + i));
    }
    *string++;
  }
}


// BH ADDED - Cheap trick to display a float or int at Y X, with width and nmbr of places.
// This means we have 16 COLS (0-15) and 8 ROWS (0-7).
static void sendIntYX( float f, int X, int Y, int width, int places) {
  char buff[6];                       // buffer used to hold float to string conversion
  dtostrf(f, width, places, buff);    // convert float to string x dec places
  sendStrYX (buff, X, Y);
}

// BH ADDED - Display the IP object
static void sendIpYX(int X, int Y) {
  IPAddress myIp = WiFi.localIP();
  sprintf(buffer, "%d.%d.%d.%d", myIp[0], myIp[1], myIp[2], myIp[3]);
  sendStrYX(buffer, X, Y);
}


void drawFont(int Start, int End) {
  int row = 0;
  int col = 1;
  clear_display();
  for (int i = Start; i <= End; i++) {
    if (i % 6 == 0) {
      row++;
      col = 1;
    }
    sendCharYX(i, row, col); //TESTING format: int, Y,X
    col = col + 2;
    delay(100);

    if (row == 7) {
      delay(2000);
      clear_display();
      row = 0;
      col = 1;
    }
  }
     delay(2000);
}


// Inits oled and draws logo at startup
static void init_OLED(void) {
  sendcommand(0xae);               //display off
  sendcommand(0xa6);               //Set Normal Display (default)
  sendcommand(0xAE);             //DISPLAYOFF
  sendcommand(0xD5);             //SETDISPLAYCLOCKDIV
  sendcommand(0x80);             // the suggested ratio 0x80
  sendcommand(0xA8);             //SSD1306_SETMULTIPLEX
  sendcommand(0x3F);
  sendcommand(0xD3);             //SETDISPLAYOFFSET
  sendcommand(0x0);              //no offset
  sendcommand(0x40 | 0x0);       //SETSTARTLINE
  sendcommand(0x8D);             //CHARGEPUMP
  sendcommand(0x14);
  sendcommand(0x20);             //MEMORYMODE
  sendcommand(0x00);             //0x0 act like ks0108
  //sendcommand(0xA0 | 0x1);     //SEGREMAP   //Rotate screen 180 deg
  sendcommand(0xA0);
  //sendcommand(0xC8);           //COMSCANDEC  Rotate screen 180 Deg
  sendcommand(0xC0);
  sendcommand(0xDA);             //0xDA
  sendcommand(0x12);             //COMSCANDEC
  sendcommand(0x81);             //SETCONTRAS
  sendcommand(0xCF);
  sendcommand(0xd9);             //SETPRECHARGE
  sendcommand(0xF1);
  sendcommand(0xDB);             //SETVCOMDETECT
  sendcommand(0x40);
  sendcommand(0xA4);             //DISPLAYALLON_RESUME
  sendcommand(0xA6);             //NORMALDISPLAY

  clear_display();
  sendcommand(0x2e);               // stop scroll
  //----------------------------REVERSE comments----------------------------//
  // Next 3 command lines control display top-bottom or bottom-top MRB 20150718
#ifdef TOP2BOTTOM
  sendcommand(0xa0);           //seg re-map 0->127(default)
  sendcommand(0xa1);           //seg re-map 127->0
  sendcommand(0xc8);
#endif
  //  delay(1000);
  //----------------------------REVERSE comments----------------------------//
  // sendcommand(0xa7);            //Set Inverse Display
  // sendcommand(0xae);            //display off
  sendcommand(0x20);               //Set Memory Addressing Mode
  sendcommand(0x00);               //Set Memory Addressing Mode ab Horizontal addressing mode
  // sendcommand(0x02);            // Set Memory Addressing Mode ab Page addressing mode(RESET)

  //  setXY(0,0);
  // Display Logo here :)
  //  for(int i=0;i<128*8;i++)     // show 128* 64 Logo
  // {
  //  SendChar(pgm_read_byte(logo+i));
  // }
  // sendcommand(0xaf);   //display on

  // delay(5000);
}


/*
------------------------------------------------------------------------------------
              Added to Mikes routine Draw routines
------------------------------------------------------------------------------------
*/

/*
void Draw_WIFI() {
  clear_display();
  setXY(0, 0);
  // Display Logo here :)
  for (int i = 0; i < 128 * 8; i++)    // show 128* 64 Logo
  {
    SendByte(pgm_read_byte(WIFI1 + i));
  }
  sendcommand(0xaf);                   //display on
}


void Draw_WAVES() {
  clear_display();
  setXY(0, 0);
  // Display Logo here :)
  for (int i = 0; i < 128 * 8; i++)    // show 128* 64 Logo
  {
    SendByte(pgm_read_byte(rfwaves + i));
  }
  sendcommand(0xaf);                   //display on
}

*/



