

/* GK to Radmon.org & Xively & Sparkfun via GK-WiFi board    306936 (70%)      bHogan 11/25/15
 * This sketch requires IDE v1.6.5 or > with the ESP8266 core installed.
 * DESCRIPTION:
 * Reads serial from Geiger Kit and sends to Radmon.org, ThingSpeak, and Sparkfun via WiFi.
 * Transmission begins as soon as new data from the kit arrives.
 * 
 * Brett v2.0 Reformatted txt on OLED screen + added corection for Sparkfun upload + added rain sensor upload
 * 
 * Brett v1.9 Rain sensor added on sp GPIO4
 * 
 * Brett v1.8 added DHT22 sensor
 * 
 * WHAT IS NEW since v1.6:
 * - support for Adafruit HDC1008 I2C temp / humidity sensor (nicer than DHT22)
 * - added Celsius option
 * - display IP address of connection
 * - moved sensor and WiFi functions to tabs and made a .h tab for includes
 * - general cleanup
 * 
 * USER NOTES:
 * - Requires GK-B5 software version 10.1 or higher or GK-Plus v2.0 or higher
 * - Make sure you have USE RADLOGGER turned off in the kit's menu.
 * - Be sure to fill out Credentials tab.
 * - Use the FTDI header to upload your sketch. You can test without connecting to the kit by
 *   setting DEBUG true. Do not connect GK-WiFi to the kit if DEBUG true.
 * - Ignore compiler warnings - sketch will still load
 *
 * - RED LED =  connecting to network - off when connected.
 * - YEL LED = steady = empty buffer (no GK connection yet). Flash during send.
 * - GRN LED = flashes with each send
 *
 * SLEEP MODE NOTES:
 * - If powering from a wall wart it is recommended not to use sleep mode.
 * - To use sleep, you must connect GPIO16 to RST. (You might try a .01uF cap between instead.)
 *   (This may be already provided on the GK-WiFi board.)
 * - After a transmission, the ESP8266 will sleep for the number of seconds set by sleepTimeS.
 *   During sleep the ESP8266 will draw about 8mA (mostly from it's LED!).
 *   When it wakes, it will reboot, and connect to the network again. It will send as soon as
 *   it receives new data from the kit and go to sleep again.
 * - If sleep is used, configure your kit so that it sends faster than the sleep mode time.
 *   For example, if sleepTimeS = 60 sec, set your LOG PERIOD in the GK menu to 10 seconds. This
 *   means that the ESP8266 will be powered for a maximum of 10 seconds.
 * - If sleep is not used (sleepTimeS=0)LOG PERIOD will equal transmission interval.
 * - Due to reboot after sleep, MaxCPM will not work and DEBUG counts will not increment.
 *
 * DHT NOTES:
 * - Not working well if sleep mode used for some reason.
 * - Works best with DHT22 (DHT11 flaky). Attach to GPIO5 with a 10k pullup.
 * - If DHT can not be read, the Temp and Humidity will be set to zero.
 *
 ** TODO:
 * - DHT22 not working well if Sleep mode used
 * - Test ADC_MODE with DHT22 - currently commented out
 *
 * THIS PROGRAM AND IT'S MEASUREMENTS IS NOT INTENDED TO GUIDE ACTIONS TO TAKE, OR NOT
 * TO TAKE, REGARDING EXPOSURE TO RADIATION. THE GEIGER KIT AND IT'S SOFTWARE ARE FOR
 * EDUCATIONAL PURPOSES ONLY. DO NOT RELY ON THEM IN HAZARDOUS SITUATIONS!
 *
 * LICENSE: Creative Commons NonCommercial-ShareAlike 4.0
 * See http://creativecommons.org/licenses/by-nc-sa/4.0/ for a full definition. 
 * Some key features are:
 * - You are granted a royalty-free, non-exclusive, license to use and Share this Licensed Material
 *   in whole or in part, for NonCommercial purposes only.
 * - Every recipient of this software automatically receives the same rights.  
 *   You may not impose any additional or different terms or conditions on this material.
 * - If You Share this material (including in modified form), you must retain the identification 
 *   of the DIY Geiger, this copyright notice, and indicate this Public License, 
 * 
 * This program is distributed WITHOUT ANY WARRANTY implied or otherwise, and with no warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Do not remove information from this header.
----------------------------------------------------------------------------------------------+
*/

//----------------------------------------------------------------------------------------------+
//                               Other User settings
//----------------------------------------------------------------------------------------------+

// Other user settings . . .
const int sleepTimeS = 0;               // seconds to sleep - set to zero to disable sleep
#define MAX_CPM_PERIOD   86400 //=24hr  // secs before new maxCPM period rolls over to begin again
#define USE_HDC1000      false           // output temp and humidity readings from HDC1000
#define USE_DHT          true          // output temp and humidity readings from the DHT22 sensor
#define CELSIUS          true          // if USE_HDC1000 or USE_DHT - output temp as Celsius
#define USE_OLED         true           // use I2C OLED for status messages
// DEBUG generates test counts from 21-50 with each post at the interval set by TEST_POST_PERIOD
// However this is true only is sleep mode is off (sleepTimeS = 0).
// It also generates serial debugging messages. ONLY USE WHEN NOT ATTACHED TO THE KIT.
#define DEBUG            false
#define TEST_POST_PERIOD 30             // secs between posting if DEBUG is true

//----------------------------------------------------------------------------------------------+
//                       End other user setup #defines
//----------------------------------------------------------------------------------------------+

#include "Credentials.h"                // tab for user setup info
#include "gk_wifi.h"                    // tab for other defines and globals
#include <ESP8266WiFi.h>
#include <Wire.h>                       // for I2C

#if (USE_HDC1000)
#include "Adafruit_HDC1000.h"
Adafruit_HDC1000 hdc = Adafruit_HDC1000();
#endif

#if (USE_DHT)
#include <DHT.h>                        // for DHT22 - no memory use if not used
DHT dht(DHT_PIN, DHT22, 35);            // threshold for cycle counts (try 25 - 11 was suggested)
#endif

//ADC_MODE(ADC_VCC);                      // for Vcc at ESP8266 - do not move if used


void setup() {
  Serial.begin(9600);                   // connection to kit requires 9600 baud
  pinMode(RED_LED, OUTPUT);             // setup LED pins
  pinMode(YEL_LED, OUTPUT);
  pinMode(GRN_LED, OUTPUT);

  //Brett
  pinMode(Rain_Sense, INPUT);           // setup rain sensor input on pin 4
  //Brett
  delay(10);
  digitalWrite(RED_LED, HIGH);          // red until WL_CONNECTED
#if (USE_DHT)
  dht.begin();                          // initialize temperature sensor
#endif
#if (USE_OLED)
  Wire.pins(0, 2);                        //SDA = GPIO0, SCL = GPIO2
  Wire.begin();
  StartUp_OLED();                         // Init OLED and fire up!
  clear_display();                        // simplifies clearing and also setXY(0,0);
  sendStrYX("GK-WiFi v2.0", 0, 2);        // version #
#endif

  // start by connecting to a WiFi network
#if (DEBUG)
  Serial.begin(115200);                 // redefine baud if debug print
  Serial.println();
  Serial.println();
  Serial.print("Connecting to ");
  Serial.println(ssid);
#endif

  WiFi.begin(ssid, password);           // connect to the network
  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
  }
#if (USE_OLED)
  sendStrYX("Connected To:", 2, 1);
  sendIpYX(3, 2);                       // special display function to display the IP object
  sendStrYX("WAITING...", 7, 3);
#endif

#if (DEBUG)
  Serial.println("");
  Serial.println("WiFi connected");
  Serial.println("IP address: ");
  Serial.println(WiFi.localIP());
#endif

  digitalWrite(YEL_LED, HIGH);          // lamp test . . .
  digitalWrite(GRN_LED, HIGH);
  delay (1000);
  digitalWrite(YEL_LED, LOW);
  digitalWrite(GRN_LED, LOW);

  digitalWrite(RED_LED, LOW);           // connected so turn off red LED

#if (DEBUG)
  f_value[CPM] = 20;                    // DEBUG for simulating counts
#endif
}



void loop() {
#if (DEBUG)
  if (millis() - lastConnectionTime > (TEST_POST_PERIOD * 1000L)) {
    f_value[CPM]++;                            // DEBUG for simulating counts
    if (f_value[CPM] > 50) f_value[CPM] = 20;  // Don't cause an alarm :)
    newData = true;                            // simulate new data arrived
    f_value[DOSE] = f_value[CPM] / 100;        // calc the other stuff based om CPM
    f_value[VCC] = 4.95;
#if (USE_DHT)
    getDHT();                                  // get DHT readings
#endif
    digitalWrite(YEL_LED, HIGH);               // cause yellow LED to flash
    delay(500);
  }
#endif

//Brett
rain = digitalRead(Rain_Sense);   // read the rain sensor input pin

//Brett




  // serialEvent() does not work in the ESP - so check for serial in loop
  if (Serial.available()) getInput();

  if (f_value[CPM] == 0) {
    digitalWrite(YEL_LED, HIGH);        // nothing from Geiger Kit (yet)
    delay(1000);                        // Fixes (startup) problem of sending 0 CPM counts
    return;                             // loop() will be called again in a moment...
  }
  else {
    digitalWrite(YEL_LED, LOW);         // have counts from GK
  }

  // New data arrived, do some prep
  if (newData) {
    newData = false;                    // reset for next transmission
    if (millis() - lastmaxCpmTime > MAX_CPM_PERIOD * 1000L) { // reset MAX CPM if it's time
      maxCPM = 0;                         // reset this
      lastmaxCpmTime = millis();          // reset this
    }
    if (f_value[CPM] > maxCPM) maxCPM = f_value[CPM]; // check for maxCPM
#if (USE_DHT)
    getDHT();                             // get DHT readings
#endif
#if (USE_HDC1000)                         // get HDC1008 readings
  HDC1000();
#endif

    // connect and send data to each of the defined sites:
#if (SEND_TO_RADMON)
    sendToRadmon();                     // call the function that sends to Radmon.org
#if (USE_OLED)
    clearRow(7);                        // clear "WAITING..."
    clearRow(5);                        // clear line
    sendStrYX("Radmon OK", 5, 2);
     delay(1000);
#endif
#endif


#if (SEND_TO_THINGSPEAK)
    sendToThingSpeak();                 // call the function that sends to ThingSpeak
#if (USE_OLED)
    clearRow(7);                        // clear "WAITING..."
    clearRow(6);                        // clear line
    sendStrYX("ThingSpeak OK", 6, 2);
    delay(1000);
#endif
#endif


#if (SEND_TO_SPARKFUN)
    sendToSparkfun();                   // call the function that sends to Sparkfun 'Phant'
#if (USE_OLED)
    clearRow(7);                        // clear line
    sendStrYX("Sparkfun OK", 7, 2);
    delay(1000);
#endif
#endif

#if (USE_OLED)
    delay(1000);
    clear_display();
    sendStrYX("SENT! RSSI=", 0, 1);     // change SENDING to SENT
    sendIntYX(WiFi.RSSI(),0,12,1,0);  // value, Y, X, width, nmbr dec places
    sendStrYX("CPM ", 2, 1);
    sendIntYX(f_value[CPM], 2, 6, 1, 0);  // value, Y, X, width, nmbr dec places
    sendStrYX("Dose ", 3, 1);
    sendIntYX(f_value[DOSE], 3, 6, 4, 3); // value, Y, X, width, nmbr dec places
    sendStrYX("Vcc ", 4, 1);
    sendIntYX(f_value[VCC], 4, 6, 3, 2);  // value, Y, X, width, nmbr dec places
    
#if (USE_DHT | USE_HDC1000)
//Brett
  sendStrYX("Temp ", 5, 1);
  sendIntYX(Temp, 5, 6, 4, 2);          // display temp
  sendCharYX(127, 5, 11);
  // char 127 (last char) is ° symbol
  sendStrYX("Hum ", 6, 1);
  sendIntYX(humidity, 6, 6, 4, 2);      // display humidity
  sendStrYX("%", 6, 11);
//Brett  
#endif

    //Brett
sendStrYX("Rain ", 7, 1);
    sendIntYX(rain, 7, 6, 1, 0);  // value, Y, X, width, nmbr dec places
    //Brett
    
    if (sleepTimeS != 0) {
      sendStrYX("SLEEPING:", 7, 2);     // add seconds
      sendIntYX(sleepTimeS, 7, 11, 1, 0); // value, Y, X, width, nmbr dec places
    }
#endif

    if (sleepTimeS != 0) ESP.deepSleep(sleepTimeS * 1000000, WAKE_RF_DEFAULT); // go to sleep

  }
}


