//----------------------------------------------------------------------------------------------+
//                           ****   USER SETUP   ****
// Define your network, sites you want to send to, and the credentials for those sites.
//----------------------------------------------------------------------------------------------+

// Define your WiFi network . . .
const char* ssid     = "";
const char* password = "";

// Define who you want to send to . . .
#define SEND_TO_RADMON      true          // CPM will be sent to Radmon.org
#define SEND_TO_THINGSPEAK  true           // CPM, Dose, Vcc and MAX CPM will be sent
#define SEND_TO_SPARKFUN    true           // CPM, Dose, Vcc and MAX CPM will be sent


// Add your credintials for the site(s) that you will connect to . . .
#if (SEND_TO_RADMON)
// For Radmon.org: set the next 2 lines to your Radmon.org UserName and PassWord . . .
const char* UserName = "";
const char* PassWord = "";
const char* RadmonHost = "radmon.org";     // no need to change this
#endif


#if (SEND_TO_THINGSPEAK)
const char* writeAPI = "";
const char* ThingSpeakHost = "api.thingspeak.com";  // no need to change this
#endif


#if (SEND_TO_SPARKFUN)
const char* streamId   = "";
const char* privateKey = "";
const char* SparkfunHost = "data.sparkfun.com";  // no need to change this
#endif
