// Connect your cell phone with Wurstserver, open a browser,
// and go to 192.168.4.1.
// WeMos will send value to your phone, change the tone signal frequency
// and the number (and color) of NeoPixel ring LEDs.
#include <ESP8266WiFi.h>
#include <WiFiClient.h>
#include <WiFiServer.h>
#include <WiFiUdp.h>
#include <ESP8266mDNS.h>
#include <ESP8266WebServer.h>
#include <TimeLib.h>  

#include <Adafruit_NeoPixel.h>
#ifdef __AVR__
  #include <avr/power.h>
#endif

#define PIN D7

ESP8266WebServer server(80);
MDNSResponder mdns;
String bewegung_html = "<table border = 1>";
int sensorValue;

String twoDigits(int digits){
  if(digits < 10) {
    String i = '0'+String(digits);
    return i;
  }
  else {
    return String(digits);
  }
}

Adafruit_NeoPixel strip = Adafruit_NeoPixel(12, PIN, NEO_GRB + NEO_KHZ800);

void setup() {
// WiFi
  WiFi.softAP("Wurstserver", "");
  Serial.begin(115200);
  if (mdns.begin("esp8266", WiFi.localIP())) {
    Serial.println("MDNS responder started");
  }
  sensorValue = analogRead(A0);
  server.on("/", handleRoot);
  server.on("/inline", [](){
  server.send(200, "text/plain", "Funktioniert");
  });
  server.begin();

// NeoRing
strip.begin();
strip.show(); // Initialize all pixels to 'off'
}

void loop() {
  delay(100);
//  Serial.println(sensorValue);
  sensorValue = analogRead(A0);
  RingEinschalten(sensorValue/5);
  tone(D6, sensorValue*3);
  server.handleClient();
  mdns.update();
}

void handleRoot() {
    bewegung_html = bewegung_html + "<tr><td>" + twoDigits(hour()) + ":" + twoDigits(minute()) 
      + ":" + twoDigits(second()) + "</td> <td> Sensorwert " + sensorValue
      + "</td> </tr>"; 
    server.send(200, "text/html", bewegung_html);
}  
  
void RingEinschalten(uint8_t sensetemp)
{
    colorSet(strip.Color(0, 0, 0), 12);
    if(sensetemp>=24) {
      sensetemp = sensetemp % 24 +1;
     colorSet(strip.Color(255, 0, 0), sensetemp);
    }
    else if(sensetemp>=12) {
      sensetemp = sensetemp % 12 +1;
      colorSet(strip.Color(0, 255, 0), sensetemp);
    }
    else {
    colorSet(strip.Color(0, 0, 255), sensetemp);
    }
}

void colorSet(uint32_t c, uint8_t maxpixel) {
  if (maxpixel > strip.numPixels()){
    maxpixel = strip.numPixels();
  }
  for(uint16_t i=0; i<maxpixel; i++) {
    strip.setPixelColor(i, c);
  }
  strip.show();
}
