/*
  Fridge Door Alarm Detector
  Version 01
  
  Written by Pavel Mihaylov and Tatqna Mihaylova
  11 September 2012
  
  This version is ready to be uploaded to Arduino Uno microcontroller using Arduino Uno as a programmer.
 */
 

int led = 2;
int pwr = 3;
int alarm = 4;
int door  = 5;
int LDR = A0;
int time_door_open = (3)*1000; // value in brackets is in seconds
int time = 500;
int time2 = time*2;
int time_tone = 80;  //make the beep tone
int tx = 1; //set this to 1 if you want to monitor the serial port debugging info, 0 otherwise
float trig = 2.5;
float LDRval = 0;
int door_left = 0; //whether the door is left opened (1) or closed (0)
extern volatile unsigned long timer0_overflow_count;

// the setup routine runs once when you press reset:
void setup() {                
  // initialize the digital pin as an output.
  if(tx)
    Serial.begin(9600);
  pinMode(led, OUTPUT);     
  pinMode(pwr, OUTPUT);     
  pinMode(alarm, OUTPUT);
  pinMode(door, OUTPUT);  
  pinMode(LDR, INPUT);       
}
  
  // the loop routine runs over and over again forever:
void loop() {
  if (tx) delay(time);
  if (tx){ Serial.print("--------------------------------------------\n");}
     
  read_light();
  
  if(read_light())
  {
    if (tx) delay(time);
    if (tx){ Serial.print("Door just opened!\n");}
    digitalWrite(door, HIGH);
    door_left = 1;
      
    int n = 0;
    
    timer0_overflow_count = 0;
    unsigned long start = millis();
    while( (millis() - start) <= time_door_open )
    {
      if(millis() - start < 0) //break while loop if rollover occures
      {
        if (tx){ Serial.print("ROLLOVER OCCURED");}
        break;
      }
      if (tx){ Serial.print("Counting seconds down\n");}
      if (tx){ Serial.print(millis());}
      n++;
      
      
      read_light();
      if(read_light() == 0)
      {
        if (tx) delay(time);
        if (tx){ Serial.print("Door just closed!\n");}
        digitalWrite(door, LOW);
        door_left = 0;
        break;
      }
      delay(time); //delay needed
      
    }
    if (tx){ Serial.print("Out of while loop!\n");}
    
    if(door_left == 1)
      {
        if (tx) delay(time);
        if (tx){ Serial.print("> > > Alarm triggered!\n");}
        
        alarm_sound();
      }
      else
      {
        if (tx) delay(time);
        if (tx){ Serial.print("Alarm not triggered!\n");}
      }
    
  }
  else
  {
    if (tx) delay(time);
    if (tx){ Serial.print("Door stays closed!\n");}
  }
    
 

  delay(time2);
  
}




//Function to read the light sensor (LDR) and return either 0 (door is closed) or 1 (door is opened)

int read_light()
{
  digitalWrite(led, HIGH);    // turn the LED on by making the voltage High
  digitalWrite(pwr, HIGH);    // turn the pwr pin on by making the voltage high to allow a measurement to be taken
  
  delay(30);               // wait for some time
  
  LDRval = analogRead(LDR);    // read the sensor value

  delay(10);                  // wait for some time
  
  digitalWrite(led, LOW);    // turn the LED off by making the voltage LOW
  digitalWrite(pwr, LOW);    // turn the pwr pin off by making the voltage low
  
  
  LDRval = LDRval/1024*5; // sensor value is in the range 0 to 1023 and we need it between 0 and 5 - this is the calculation required
  
  if (tx)
  {   
    Serial.print("\nLDR value in volts = ");
    Serial.println(LDRval);
  }

  if(LDRval<trig)
  {
    return 1;    // Means door is opened
  }
  else
  {
    return 0;     // Means door is closed
  }

}



/*
   Loop to make the beep sounds
   First makes three 3-beep sounds
   Then makes 4-beep sounds 
*/



void alarm_sound()
{
  // digitalWrite(alarm, HIGH);
  int looop1=0;
  while(read_light() && looop1<3)
  {
    
    if (tx) delay(time);
    if (tx){ Serial.print("Door is still opened - now beep second time!\n");}
    
    int i;
    
    digitalWrite(alarm, HIGH); //make beep sound
    delay(80);
    digitalWrite(alarm, LOW); //make beep sound
    delay(320);
    
    
    digitalWrite(alarm, LOW); //make beep sound
    delay(time_tone);
    digitalWrite(alarm, LOW); //make beep sound
    
    for(i = 15; i>=0; i--)
    {
    digitalWrite(alarm, HIGH); //make beep sound
    delay(i);
    digitalWrite(alarm, LOW); //make beep sound
    }

    digitalWrite(alarm, LOW); //make beep sound
    delay(time_tone);
    digitalWrite(alarm, LOW); //make beep sound
    
    for(i = 18; i>=0; i--)
    {
    digitalWrite(alarm, HIGH); //make beep sound
    delay(i);
    digitalWrite(alarm, LOW); //make beep sound
    }

    digitalWrite(alarm, LOW); //make beep sound
    delay(time_tone);
    digitalWrite(alarm, LOW); //make beep sound
    


    delay(1500);
    looop1++;
    read_light();


  }
  
  delay(2000);
  
  //second beep loop now begins
  
  looop1 = 0;
  while(read_light() && looop1<3)
  {
    
    if (tx) delay(time);
    if (tx){ Serial.print("Door is still opened - now beep second time!\n");}
    
    int i;
    
    digitalWrite(alarm, HIGH); //make beep sound
    delay(80);
    digitalWrite(alarm, LOW); //make beep sound
    delay(320);
    
    
    digitalWrite(alarm, LOW); //make beep sound
    delay(time_tone);
    digitalWrite(alarm, LOW); //make beep sound
    
    for(i = 15; i>=0; i--)
    {
    digitalWrite(alarm, HIGH); //make beep sound
    delay(i);
    digitalWrite(alarm, LOW); //make beep sound
    }

    digitalWrite(alarm, LOW); //make beep sound
    delay(time_tone);
    digitalWrite(alarm, LOW); //make beep sound
    
    for(i = 18; i>=0; i--)
    {
    digitalWrite(alarm, HIGH); //make beep sound
    delay(i);
    digitalWrite(alarm, LOW); //make beep sound
    }

    digitalWrite(alarm, LOW); //make beep sound
    delay(time_tone);
    digitalWrite(alarm, LOW); //make beep sound
    

    for(i = 18; i>=0; i--)
    {
    digitalWrite(alarm, HIGH); //make beep sound
    delay(i);
    digitalWrite(alarm, LOW); //make beep sound
    }


    delay(1000);
    looop1++;
    read_light();


  }
  
  //now go on if door is still opened
  if(read_light())
  {
    delay(3000); //time to restart the two beep loops
    alarm_sound();
  }
  else
  {
//    digitalWrite(alarm, LOW);
    if (tx) delay(time);
    if (tx){ Serial.print("Door was just closed by the angry guy!\n");}  
    digitalWrite(door, LOW);
  }
   
  
  
}
