﻿package com.Red5Link{
	import flash.events.Event;
	import flash.events.IEventDispatcher;
	import flash.events.EventDispatcher;
	import flash.events.NetStatusEvent;
	import flash.events.SecurityErrorEvent;
	import flash.events.SyncEvent;
	import flash.net.NetConnection;
	import flash.net.SharedObject;
	import fl.controls.Slider;
	import flash.errors.*;
	import flash.events.TimerEvent;
	import flash.utils.Timer;
	import flash.text.TextField;
	

	public class Red5SharedObject extends NetConnection {
		private var netConnection:NetConnection;
		private var connectionUrl:String;
		private var sharedObjectUrl:String;
		private var _isconnected:Boolean;
		private var _isSharing:Boolean;
		public var sharedObject:SharedObject;
		private var objectsToSync:Array;
		private var autoStartObject:Boolean;
		private var reconnectTimer:Timer;
		private var statusTextField:TextField;
		
		public static const ON_SYNC:String="onSync";

		public function Red5SharedObject(conUrl:String,so:String,statusDisplay:TextField) {
			statusTextField=statusDisplay;
			autoStartObject=false;
			connectionUrl=conUrl;
			sharedObjectUrl=so;
			netConnection=new NetConnection();
			netConnection.addEventListener(NetStatusEvent.NET_STATUS,netStatusHandler);
			netConnection.addEventListener(SecurityErrorEvent.SECURITY_ERROR,securityErrorHandler);
			netConnection.client=this;
			connectNetConnection();
			reconnectTimer=new Timer(5000);
			reconnectTimer.addEventListener("timer", timerHandler);
		}
		
		private function connectNetConnection():void{
			statusTextField.htmlText="Connecting...";
			statusTextField.textColor=0x333333;
			netConnection.connect(connectionUrl);
		}
		
		private function closeNetConnection():void{
			statusTextField.htmlText="Closed";
			statusTextField.textColor=0xCC3300;
			netConnection.close();
			isconnected=false;
		}

		public function set isconnected(val:Boolean):void {
			_isconnected=val;
		}

		public function get isconnected():Boolean {
			return _isconnected;
		}

		public function set isSharing(val:Boolean):void {
			_isSharing=val;
		}

		public function get isSharing():Boolean {
			return _isSharing;
		}

		private function netStatusHandler(event:NetStatusEvent):void {
			switch (event.info.code) {
				case "NetConnection.Connect.Success" :
					trace("Shared object netConnection.Succes");
					statusTextField.htmlText="Connected";
					statusTextField.textColor=0x009900;
					if(reconnectTimer.running){
						reconnectTimer.stop();
					}
					isconnected=true;
					if (autoStartObject) {
						startSharedObject(objectsToSync);
					}
					break;

				case "NetConnection.Connect.Closed" :
					/*statusTextField.htmlText="Closed";
					statusTextField.textColor=0x333333;
					isconnected=false;*/
					break;

				case "NetConnection.Connect.Failed" :
					trace("Shared object netConnection.Failed");
					statusTextField.htmlText="Failed";
					statusTextField.textColor=0xCC3300;
					isconnected=false;
					reconnectTimer.start();
					break;

				case "NetConnection.Connect.AppShutdown" :
					statusTextField.htmlText="AppShutdown";
					statusTextField.textColor=0xCC3300;
					isconnected=false;
					reconnectTimer.start();
					break;

				case "NetConnection.Call.Failed" :
					statusTextField.htmlText="Call failed";
					statusTextField.textColor=0xCC3300;
					reconnectTimer.start();
					break;

				case "NetConnection.Connect.InvalidApp" :
					statusTextField.htmlText="Invalid App";
					statusTextField.textColor=0xCC3300;
					reconnectTimer.start();
					break;

				case "NetConnection.Connect.Rejected" :
					statusTextField.htmlText="Rejected";
					statusTextField.textColor=0xCC3300;
					reconnectTimer.start();
					break;

			}
		}
		
		private function securityErrorHandler(event:SecurityErrorEvent):void {
			trace("securityErrorHandler: "+event);
		}

		public function startSharedObject(objToSync:Array):void {
			objectsToSync=objToSync;
			if (isconnected) {
				trace("Shared object started!!!");
				sharedObject=SharedObject.getRemote(sharedObjectUrl,netConnection.uri,false);
				sharedObject.addEventListener(SyncEvent.SYNC,syncData);
				sharedObject.addEventListener(NetStatusEvent.NET_STATUS,sharedObjectStatus);
				sharedObject.connect(netConnection);
				isSharing=true;
			} else {
				autoStartObject=true;
				connectNetConnection();
			}
		}

		public function stopSharedObject():void {
			if (isconnected&&isSharing) {
				isSharing=false;
				sharedObject.removeEventListener(SyncEvent.SYNC,syncData);
				closeNetConnection();
			}
		}

		private function syncData(e:SyncEvent):void {			
			var notifyOfSync:SyncEvent=new SyncEvent(Red5SharedObject.ON_SYNC);
			notifyOfSync.changeList=e.changeList;
					
			dispatchEvent(notifyOfSync);			
		}

		public function pushSync():void {
			if (isSharing) {
				trace("pushSync()");
				var obj:Object = new Object();
				for(var i:Object in objectsToSync){
					trace("pushToSync i="+i+" name="+objectsToSync[i].name)
					obj[objectsToSync[i].name]=objectsToSync[i].value;
				}
				
				
				sharedObject.setProperty("motors",obj);
				
				//sharedObject.data.chatMessage="n";

			}
		}
		
		private function sharedObjectStatus(e:NetStatusEvent):void {			
			trace("sharedObjectNetStatus: "+e.info);			
		}
		
		private function timerHandler(event:TimerEvent):void {
            trace("Reconnect shared object NetConnection.");
			connectNetConnection();		
        }
	}


}