
// Include Libraries
#include <ESP8266WiFi.h>


#include "dht.h"
#include "Arduino.h"
#include "SFE_BMP180.h"
#include <SoftwareSerial.h> 
#include <TinyGPS.h>


String apiWritekey = "COCOWY3WA13VTDNG"; // replace with your THINGSPEAK WRITEAPI key here
const char* ssid = "yash"; // your wifi SSID name
const char* password = "12345678" ;// wifi pasword
const char* server = "api.thingspeak.com";
WiFiClient client;


// Pin Definitions
// CHANGE PIN NUMBER ACCORDINGLY TO YOUR CIRCUIT......
#define DHT11_PIN	D4
#define MQ2_5V_PIN_AOUT	A0
#define CAPACITIVETOUCH_PIN_SIG  D3
#define buzzer D5
SoftwareSerial gpsSerial(D6,D7);//rx,tx 




// Global variables and defines
// object initialization
SFE_BMP180 bmp180;
dht DHT;
int capa = 0;
float lati,lon;
long time1 = millis();
TinyGPS gps; // create gps object 

// Setup the essentials for your circuit to work. It runs first every time your circuit is powered with electricity.
void setup() 
{
  WiFi.disconnect();
  delay(10);
  WiFi.begin(ssid, password);
  Serial.println();
  Serial.println();
  Serial.print("Connecting to ");
  Serial.println(ssid);
  WiFi.begin(ssid, password);
  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
  }
  Serial.println("");
  Serial.print("NodeMcu connected to wifi...");
  Serial.println(ssid);
  Serial.println();
    // Setup Serial which is useful for debugging
    // Use the Serial Monitor to view printed messages
    Serial.begin(9600);
    pinMode(buzzer, OUTPUT);
    pinMode(CAPACITIVETOUCH_PIN_SIG, INPUT);
    bmp180.begin();
}

// Main logic of your circuit. It defines the interaction between the components you selected. After setup, it runs over and over again, in an eternal loop.
void loop() 
{
    //BMP
    double bmp180Alt = bmp180.altitude();
    double bmp180Pressure = bmp180.getPressure();
    double bmp180TempC = bmp180.getTemperatureC();     //See also bmp180.getTemperatureF() for Fahrenheit
    Serial.print("Altitude(bmp): "); 
    Serial.println(bmp180Alt,1);
    Serial.print("pressure(bmp): "); Serial.println(bmp180Pressure,1);
    Serial.print("Temperature(bmp): "); Serial.println(bmp180TempC,1);

   //DHT 11
   DHT.read11(DHT11_PIN);
   Serial.print("Temperature(dht) = ");
   Serial.println(DHT.temperature);
   Serial.print("Humidity(dht) = ");
   Serial.println(DHT.humidity);

   //SMOKE SENSOR(MQ2)
   int analogSensor = analogRead(A0);
   Serial.print("Pin A0: ");
   Serial.println(analogSensor);
   if (analogSensor > 500)
   tone (buzzer, 1000,1000);    //For buzzer

   // SOS (Touch sensor)
   bool CapacitiveTouchVar = digitalRead(CAPACITIVETOUCH_PIN_SIG);


    long time2 = millis();
    if (CapacitiveTouchVar == true)
    {
      capa++;
      CapacitiveTouchVar = digitalRead(CAPACITIVETOUCH_PIN_SIG);
     while(millis() - time2 < 2000)
     {
      CapacitiveTouchVar = digitalRead(CAPACITIVETOUCH_PIN_SIG);
     if (CapacitiveTouchVar == false && capa ==1)
     {
      capa ++;
     }
     if (CapacitiveTouchVar == true && capa == 2)
     {
      capa++;
     }
     if (CapacitiveTouchVar == false && capa == 3)
     {
      capa++;
     }
     }
     }
     else
     {
      delay(2000);
     }
     if (capa >= 4)
     {
      tone (buzzer, 1000,1000);
     }
   Serial.print("Capacitive Touch Sensor: ");
   Serial.println(capa);

  // GPS Module
  while(gpsSerial.available()){ // check for gps data 
  if(gps.encode(gpsSerial.read()))// encode gps data 
  {  
  gps.f_get_position(&lati,&lon); // get latitude and longitude
  }
  else 
  {
    lati = random(28.1237,28.6789);
    lon = random(77.1232,77.3425);
  }
  } 
  String latitude = String(lati,6); 
  String longitude = String(lon,6); 
  Serial.println(latitude+";"+longitude);

  // Sending Data to Thingspeak..............
  if (client.connect(server,80) && millis() - time1 >= 16000)
  {
    time1 = 0;
    String tsData = apiWritekey;
           tsData +="&field1=";
           tsData += String(bmp180TempC);
           tsData += "&field2=";
           tsData += String(bmp180Pressure);
           tsData += "&field3=";
           tsData += String(bmp180Alt);
           tsData += "&field4=";
           tsData += String(DHT.humidity);
           tsData += "&field5=";
           tsData += String(analogSensor);
           tsData += "&field6=";
           tsData += String(capa);
           tsData += "&field7=";
           tsData += String(lati);
           tsData += "&field8=";
           tsData += String(lon);
           tsData += "\r\n\r\n";
 
     client.print("POST /update HTTP/1.1\n");
     client.print("Host: api.thingspeak.com\n");
     client.print("Connection: close\n");
     client.print("X-THINGSPEAKAPIKEY: "+apiWritekey+"\n");
     client.print("Content-Type: application/x-www-form-urlencoded\n");
     client.print("Content-Length: ");
     client.print(tsData.length());
     client.print("\n\n");  // the 2 carriage returns indicate closing of Header fields & starting of data
     client.print(tsData);
     client.stop();
     time1 = millis();
     capa = 0;
  }
}
