#include "TimerOne.h"
#include "Bounce.h"

// Define the inputs and the outputs
#define XLIMIT   2
#define YLIMIT   3
#define LASERON  4
#define LASERPULSE 5

#define YDIR     8
#define YPULSE   9
#define XPULSE   10
#define XDIR     11
#define LED      13

#define XDIRIN   A0 
#define XSTEPIN  A1
#define YDIRIN   A2 
#define YSTEPIN  A3


// Define the FASTSPEEDs for moving the axis
#define FASTSPEED    100
#define SLOWSPEED    200

#define LASERPOWER  35  // Set the power to 20%

#define XHOME    250
#define YHOME    250
// Define the possible z axis modes

Bounce XLimitBounce = Bounce( XLIMIT, 10 ); 
Bounce YLimitBounce = Bounce( YLIMIT, 10 ); 

Bounce XStepBounce = Bounce( XSTEPIN, 10 ); 
Bounce YStepBounce = Bounce( YSTEPIN, 10 ); 

long previousMillis = 0; 
long interval = 20;

byte XEnabled = 0;
byte YEnabled = 0;

byte XLimit = 0;
byte YLimit = 0;

byte XStepIn = 0;
byte XStepInOld = 0;

byte YStepIn = 0;
byte YStepInOld = 0;

byte XDirection = 0;
byte YDirection = 0;

byte LaserOn = 0;


void setup() 
{
  pinMode(XLIMIT,INPUT_PULLUP);
  pinMode(YLIMIT,INPUT_PULLUP);
 
  pinMode(XSTEPIN,INPUT_PULLUP);
  pinMode(XDIRIN,INPUT_PULLUP);

  pinMode(YSTEPIN,INPUT_PULLUP);
  pinMode(YDIRIN,INPUT_PULLUP);

  pinMode(XPULSE, OUTPUT);     
  pinMode(XDIR, OUTPUT);     
  
  pinMode(YPULSE, OUTPUT);     
  pinMode(YDIR, OUTPUT);     
 
  pinMode(LASERON, OUTPUT);     
  pinMode(LASERPULSE, OUTPUT);     

  // Set the power for the laser tube
  analogWrite(LASERPULSE, LASERPOWER); 

  pinMode(LED,OUTPUT);
  
  Timer1.initialize(FASTSPEED);
  
  Home();
}

void loop() 
{
  unsigned long currentMillis = millis();
  ScanInputs();
  
  if(currentMillis - previousMillis > interval) 
  {
    previousMillis = currentMillis;      
    
    if(XEnabled > 10)
    {
      XEnabled = 0;
      Timer1.pwm(XPULSE, 0);
    }
    else if(XEnabled > 0)
    {
      XEnabled += 1;
    }
    
    if(YEnabled > 10)
    {
      YEnabled = 0;
      Timer1.pwm(YPULSE, 0);
    }
    else if(YEnabled > 0)
    {
      YEnabled += 1;
    }
  }
  
  //When the X input dial pulses, output the direction to the stepper motor
  if((XStepIn == 0) && (XStepInOld == 1))
  {
    XDirection = digitalRead(XDIRIN);
    
    //Turn the stepper on
    XEnabled = 1;
    Timer1.pwm(XPULSE, 512);
  }

  
  //When the Y input dial pulses, output the direction to the stepper motor
  if((YStepIn == 0) && (YStepInOld == 1))
  {
    YDirection = digitalRead(YDIRIN);

    //Turn the stepper on
    YEnabled = 1;
    Timer1.pwm(YPULSE, 512);
  }
  
  LaserOn = YEnabled || XEnabled;
  
  digitalWrite(XDIR, XDirection);
  digitalWrite(YDIR, YDirection);
  digitalWrite(LED, LaserOn);
  digitalWrite(LASERON, 1 - LaserOn); //Laser zero is on
}

void ScanInputs()
{
  XLimitBounce.update();
  YLimitBounce.update();
  XStepBounce.update();
  YStepBounce.update();

  XLimit = XLimitBounce.read();
  YLimit = YLimitBounce.read();
  
  XStepInOld = XStepIn;
  YStepInOld = YStepIn;

  XStepIn = XStepBounce.read();
  YStepIn = YStepBounce.read();
}


void Home()
{
  Datum();

  digitalWrite(YDIR, 0);
  digitalWrite(XDIR, 0);

  Timer1.pwm(XPULSE, 512);
  Timer1.pwm(YPULSE, 512);

  delay(XHOME);
  Timer1.pwm(YPULSE, 0);
  delay(YHOME);
  Timer1.pwm(XPULSE, 0);
}


void Datum()
{
  digitalWrite(XDIR, 1);
  digitalWrite(YDIR, 1);

  Timer1.pwm(XPULSE, 512);
  Timer1.pwm(YPULSE, 512);

  do
  {
    ScanInputs();  
    
    if(XLimit == 0)
      Timer1.pwm(XPULSE, 0);

    if(YLimit == 0)
      Timer1.pwm(YPULSE, 0);
    
  } while ((XLimit == 1) || (YLimit == 1));
  
  delay(100);
  

  digitalWrite(XDIR, 0);
  digitalWrite(YDIR, 0);

  Timer1.pwm(XPULSE, 512);
  Timer1.pwm(YPULSE, 512);

  do
  {
    ScanInputs();  
    
    if(XLimit == 1)
      Timer1.pwm(XPULSE, 0);

    if(YLimit == 1)
      Timer1.pwm(YPULSE, 0);
    
  } while ((XLimit == 0) || (YLimit == 0));
}

