//
//  SettingsViewController.m
//  ChatClient
//
//  Created by Cynthia DeRose on 8/6/12.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import "SettingsViewController.h"

#import "EntertainmentCenterController.h"

@interface SettingsViewController ()
@property (weak, nonatomic) IBOutlet UITextField *ipTextField;
@property (weak, nonatomic) IBOutlet UITextField *portTextField;

@end

@implementation SettingsViewController
@synthesize ipTextField;
@synthesize portTextField;

@synthesize delegate;

- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        // Custom initialization -- make sure ipAddress and port settings are there
        NSUserDefaults *userDefaults = [NSUserDefaults standardUserDefaults];
        NSString *ipAddress = [userDefaults objectForKey:@"ipAddress"];
        if (!ipAddress) {
            [userDefaults setObject:@"10.0.1.3" forKey: @"ipAddress"];
        }
        NSString *port = [userDefaults objectForKey: @"port"];
        if (!port) {
            [userDefaults setObject:@"80" forKey: @"port"];
        }
    }
    return self;
}

// Send a command to the entertainment center controller
- (IBAction) ECButtonPressed: (id) sender
{
    EcCommand cmd = [sender tag];
    [[EntertainmentCenterController mainController] sendCommand: cmd];
}


- (IBAction)done {
	[self.delegate settingsViewControllerDidFinish:self];	
}

- (BOOL)textFieldShouldReturn:(UITextField *)theTextField {
    [theTextField resignFirstResponder];
    return YES;
}

- (void) textFieldDidEndEditing:(UITextField *)theTextField
{
    NSUserDefaults *userDefaults = [NSUserDefaults standardUserDefaults];
    if (theTextField == self.ipTextField) {
        NSLog(@"setting ip = %@", theTextField.text);
        [userDefaults setObject: theTextField.text forKey:@"ipAddress"];
    } else if (theTextField == self.portTextField) {
        NSLog(@"setting port = %@", theTextField.text);
        [userDefaults setObject: theTextField.text forKey:@"port"];
    }
    [userDefaults synchronize];
}

- (void)viewDidLoad
{
    [super viewDidLoad];
    // Do any additional setup after loading the view from its nib.
    NSUserDefaults *userDefaults = [NSUserDefaults standardUserDefaults];
    ipTextField.text = [userDefaults objectForKey: @"ipAddress"];
    portTextField.text = [userDefaults objectForKey:@"port"];
}

- (void)viewDidUnload
{
    [self setIpTextField:nil];
    [self setPortTextField:nil];
    [super viewDidUnload];
    // Release any retained subviews of the main view.
    // e.g. self.myOutlet = nil;
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
    return (interfaceOrientation == UIInterfaceOrientationPortrait);
}

@end
