//
//  MainViewController07.m
//  EntertainmentCenter
//
//  Created by Tony DeRose on 9/21/13.
//  Copyright (c) 2013 Tony DeRose. All rights reserved.
//

#import "MainViewController07.h"

#import "AppleTvViewController.h"
#import "DVDViewController.h"
#import "EntertainmentCenterController.h"
#import "ITunesViewController.h"
#import "KQEDViewController.h"
#import "LightingViewController.h"
#import "SettingsViewController.h"
#import "WatchTVViewController.h"

@interface MainViewController07 ()

@end

@implementation MainViewController07

- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        // Custom initialization
    }
    return self;
}

- (IBAction) buttonPressed: (id) sender
{
    EcCommand cmd = [sender tag];
    [[EntertainmentCenterController mainController] sendCommand: cmd];
}


- (IBAction) iTunes
{
    [[EntertainmentCenterController mainController] sendCommand: EC_ITUNES];
    ITunesViewController *iTunesViewController = [[ITunesViewController alloc] initWithNibName:@"ITunesView" bundle: [NSBundle mainBundle]];
    [self.navigationController pushViewController:iTunesViewController animated:YES];
    
}

// SettingsViewController delegate method
- (void)settingsViewControllerDidFinish:(SettingsViewController *)controller
{
    [self dismissViewControllerAnimated:YES completion: nil];
}

- (IBAction) showSettings
{
    SettingsViewController *controller = [[SettingsViewController alloc] initWithNibName:@"SettingsView" bundle:nil];
	controller.delegate = self;
	
	controller.modalTransitionStyle = UIModalTransitionStyleFlipHorizontal;
	[self presentViewController:controller animated:YES completion: nil];
}

- (void)viewDidLoad
{
    [super viewDidLoad];
    // Do any additional setup after loading the view from its nib.
    self.title = @"Main";
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (IBAction) watchTV
{
    [[EntertainmentCenterController mainController] sendCommand: EC_TV];
    WatchTVViewController *watchTVViewController = [[WatchTVViewController alloc] initWithNibName:@"WatchTVView" bundle: [NSBundle mainBundle]];
    [self.navigationController pushViewController:watchTVViewController animated:YES];
}

- (IBAction) appleTV
{
    [[EntertainmentCenterController mainController] sendCommand: EC_APPLE_TV];
    AppleTvViewController *appleTvViewController = [[AppleTvViewController alloc] initWithNibName:@"AppleTvView" bundle: [NSBundle mainBundle]];
    [self.navigationController pushViewController:appleTvViewController animated:YES];
    
}

- (IBAction) dvd
{
    [[EntertainmentCenterController mainController] sendCommand: EC_DVD];
    DVDViewController *dvdViewController = [[DVDViewController alloc] initWithNibName:@"DVDView" bundle: [NSBundle mainBundle]];
    [self.navigationController pushViewController:dvdViewController animated:YES];
}

- (IBAction) lighting
{
    LightingViewController *lightingViewController = [[LightingViewController alloc] initWithNibName:@"LightingView" bundle: [NSBundle mainBundle]];
    [self.navigationController pushViewController:lightingViewController animated:YES];
}

- (IBAction) kqed
{
    [[EntertainmentCenterController mainController] sendCommand: EC_KQED];
    KQEDViewController *kqedViewController = [[KQEDViewController alloc] initWithNibName:@"KQEDView" bundle: [NSBundle mainBundle]];
    [self.navigationController pushViewController:kqedViewController animated:YES];
}


@end
