//
//  WatchTVViewController.m
//  EntertainmentCenter
//
//  Created by Tony DeRose on 6/21/13.
//  Copyright (c) 2013 Tony DeRose. All rights reserved.
//

#import "WatchTVViewController.h"
#import "EntertainmentCenterController.h"
#import "VideoGuideViewController.h"

@interface WatchTVViewController ()
@property (weak, nonatomic) IBOutlet UIButton *muteButton;
@property (weak, nonatomic) IBOutlet UISlider *volumeSlider;
@end

@implementation WatchTVViewController
- (IBAction)setVolume:(UISlider *)sender {
    [super setVolume:sender];
}

- (IBAction) guide: (id) sender
{
    [[EntertainmentCenterController mainController] sendCommand: EC_V_GUIDE];
    
    VideoGuideViewController *viewController = [[VideoGuideViewController alloc] initWithNibName:@"VideoGuideView" bundle: [NSBundle mainBundle]];
    [self.navigationController pushViewController:viewController animated:YES];
}

- (BOOL)textFieldShouldReturn:(UITextField *)theTextField {
    [theTextField resignFirstResponder];
    return YES;
}

- (void) textFieldDidEndEditing:(UITextField *)theTextField
{
    int channelNumber = [theTextField.text intValue];
    if (channelNumber != 0) {
        NSString *cmdStr = [NSString stringWithFormat:@"channel%d", channelNumber];
        [[EntertainmentCenterController mainController] sendCommandString: [cmdStr UTF8String]];
    } else {
        // Complain
    }
}

- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        // Custom initialization
    }
    return self;
}

- (void)viewDidLoad
{
    [super viewDidLoad];
    // Do any additional setup after loading the view from its nib.
    self.title = @"TV";
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

@end
