//
//  EntertainmentCenterController.h
//  EntertainmentCenter
//
//  Created by Tony DeRose on 6/21/13.
//  Copyright (c) 2013 Tony DeRose. All rights reserved.
//

#import <Foundation/Foundation.h>

// Entertainment center command codes
typedef enum {
    EC_MUTE = 0,
    EC_UNMUTE,                  // 1
    EC_AUDIO_ON,                // 2
    EC_AUDIO_OFF,               // 3
    EC_AUDIO_VOLUME_UP,         // 4
    EC_AUDIO_VOLUME_DOWN,       // 5
    EC_V_ON,                    // 6
    EC_V_OFF,                   // 7
    EC_V_VOLUME_UP,             // 8
    EC_V_VOLUME_DOWN,           // 9
    EC_V_CHANNEL_UP,            // 10
    EC_V_CHANNEL_DOWN,          // 11
    EC_TV,                      // 12
    EC_ITUNES,                  // 13
    EC_DVD,                     // 14
    EC_CD,                      // 15
    EC_AUDIO_AUX_CHANNEL,       // 16
    EC_AUDIO_VIDEO_CHANNEL,     // 17
    EC_AUDIO_CD_CHANNEL,        // 18
    EC_AUDIO_MUTE,              // 19
    EC_V_MUTE,                  // 20
    EC_V_INPUT,                 // 21
    EC_V_UPKEY,                 // 22
    EC_V_DOWNKEY,               // 23
    EC_ALL_OFF,                 // 24
    EC_TV_IS_ON,                // 25
    EC_TV_IS_OFF,               // 26
    EC_APPLE_TV,                // 27
    EC_APPLE_LEFT,              // 28
    EC_APPLE_RIGHT,             // 29
    EC_APPLE_UP,                // 30
    EC_APPLE_DOWN,              // 31
    EC_APPLE_SELECT,            // 32
    EC_APPLE_MENU,              // 33
    EC_APPLE_PLAY,              // 34
    EC_DVD_PLAY,                // 35
    EC_DVD_PAUSE,               // 36
    EC_DVD_PREV,                // 37
    EC_DVD_NEXT,                // 38
    EC_AUDIO_SPEAKERS_A,        // 39
    EC_AUDIO_SPEAKERS_B,        // 40
    EC_DVD_LEFT,                // 41
    EC_DVD_RIGHT,               // 42
    EC_DVD_UP,                  // 43
    EC_DVD_DOWN,                // 44
    EC_DVD_SELECT,              // 45
    EC_V_GUIDE,                 // 46
    EC_V_LEFT,                  // 47
    EC_V_RIGHT,                 // 48
    EC_V_SELECT,                // 49
    EC_L_RAINBOW,               // 50
    EC_KQED,                    // 51
    EC_V_0,                     // 52
    EC_V_1,                     // 53
    EC_V_2,                     // 54
    EC_V_3,                     // 55
    EC_V_4,                     // 56
    EC_V_5,                     // 57
    EC_V_6,                     // 58
    EC_V_7,                     // 59
    EC_V_8,                     // 60
    EC_V_9,                     // 61
    EC_V_PAGE_UP,               // 62
    EC_V_PAGE_DOWN,             // 63
    EC_V_NBC,                   // 64
    EC_V_CBS,                   // 65
    EC_V_CNN,                   // 66
    EC_V_ABC,                   // 67
    EC_V_KQED,                  // 68
    EC_V_FOX,                   // 69
    EC_ARC_ON,                  // 70
    EC_ARC_OFF,                 // 71
    EC_ARC_THROB,               // 72
    EC_ARC_ANY,                 // 73
    EC_L_OFF,                   // 74
 } EcCommand;

@interface EntertainmentCenterController : NSObject {
    NSDictionary *status;
}

+ (EntertainmentCenterController *) mainController;
- (void) sendCommand: (EcCommand) cmd;
- (void) sendCommandString: (const char *) cmdString;
- (NSString *) valueForKey: (NSString *) key;
@end
