//
//  EcViewController.m
//  EntertainmentCenter
//
//  Created by Tony DeRose on 10/5/13.
//  Copyright (c) 2013 Tony DeRose. All rights reserved.
//

#import "EcViewController.h"

#import "EntertainmentCenterController.h"

@interface EcViewController ()

@end

@implementation EcViewController
- (IBAction)setVolume:(UISlider *)sender {
    
    EntertainmentCenterController *mainController =
    [EntertainmentCenterController mainController];
    float volume = [sender value];
    NSLog(@"Setting volume to %d", (int) volume);
    NSString *cmdString = [NSString stringWithFormat: @"volume%d", (int) volume];
    [mainController sendCommandString: [cmdString UTF8String]];
}

- (void) updateUI
{
    // Update the volume and speaker control components
    
    EntertainmentCenterController *mainController =
    [EntertainmentCenterController mainController];
    
    NSString *isMuted = [mainController valueForKey:@"mute"];
    NSString *areArborSpeakersOn = [mainController valueForKey: @"speakerB"];
    
    self.muteButton.backgroundColor = [isMuted isEqualToString: @"yes" ] ? self.highlightedColor : self.normalColor;
    self.arborSpeakerButton.backgroundColor = [areArborSpeakersOn isEqualToString: @"yes"] ? self.highlightedColor : self.normalColor;
    
    float volume = [[mainController valueForKey: @"volume"] floatValue];
    [self.volumeSlider setValue: volume animated: YES];
}

- (IBAction) buttonPressed: (id) sender
{
    EcCommand cmd = [sender tag];
    [[EntertainmentCenterController mainController] sendCommand: cmd];
    [self updateUI];
}

- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        // Custom initialization
        _normalColor = [UIColor colorWithRed: (192./255.) green: (232./255.) blue: 1.0 alpha: 1.0];
        _highlightedColor = [UIColor colorWithRed: (250./255.) green: (150./255.) blue: 150./255. alpha: 1.];
    }
    return self;
}

- (void)viewDidLoad
{
    [super viewDidLoad];
	// Do any additional setup after loading the view.
}

- (void) viewWillAppear: (BOOL) animated
{
    [super viewWillAppear: animated];
    [self updateUI];
    
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

@end
