// NeteCmds.CompileThis CEXE NET2
// REF ./Yaler.Net.Sockets.dll~

using System;
using System.IO;
using System.IO.Ports;
using System.Net;
using System.Net.Sockets;
using System.Threading;
using System.Management;
using Yaler.Net.Sockets;

class Program {

	static string QuerySerialPortName() {
		string result = null;
		try {
			ManagementObjectSearcher s = new ManagementObjectSearcher(
				"root\\cimv2",
				"SELECT Antecedent " +
				"FROM Win32_CIMLogicalDeviceCIMDataFile " +
				"WHERE PurposeDescription = 'USB Modem Driver'");
			ManagementObjectCollection c = s.Get();
			foreach (ManagementBaseObject mbo in c) {
				string antecedent = mbo["Antecedent"] as string;
				if (antecedent != null) {
					ManagementObject mo = new ManagementObject(antecedent);
					string description = mo["Description"] as string;
					if (description == "USB Serial (UBW-based) communications port") {
						string name = mo["Name"].ToString();
						int i = name.LastIndexOf('(');
						result = name.Substring(i + 1, name.Length - i - 2);
					}
				}
			}
		} catch( ManagementException) {
			result = null;
		}
		return result;
	}

	static int ParseValue (TextReader r, int length) {
		int result = 0;
		int sign = 1;
		while (length > 0) {
			int ch = r.Read();
			if (ch == '-') {
				sign = -1;
				length--;
				ch = r.Read();
			}
			result = result * 10 + (ch- '0');
			length--;
		}
		result = result * sign;
		return result;
	}		

	static void Run (string relayHost, string relayDomain, string justinTvChannel) {
		while (true) {
			string serialPortName = QuerySerialPortName();
			if (serialPortName != null) {
				try {
					SerialPort p = new SerialPort(serialPortName);
					using (p) {
						Console.WriteLine("{0}, {1}", p.PortName, p.BaudRate);
						p.Open();
						Thread.Sleep(1000);
						bool relay = (relayHost != null) && (relayDomain != null);
						TcpListener tl = null; 
						YalerListener yl = null;
						if (relay) {
							yl = new YalerListener(relayHost, 80, relayDomain);
							Console.WriteLine("http://{0}/{1}/", relayHost, relayDomain);
						} else {
							tl = new TcpListener(IPAddress.Parse("127.0.0.1"), 0);
							tl.Start();
							Console.WriteLine("http://{0}/", tl.LocalEndpoint);
						}
						while (true) {
							Socket k;
							if (relay) {
								k = yl.AcceptSocket();
							} else {
								k = tl.AcceptSocket();
							}
							using (Stream s = new NetworkStream(k, true)) {
								using (TextReader r = new StreamReader(s)) {				
									string line = r.ReadLine();
									string[] parts = line.Split(' ');
									string method = parts[0];
									string path;
									if (relay) {
										path = parts[1].Substring(relayDomain.Length + 1);
									} else {
										path = parts[1];
									}
									Console.WriteLine(path);
									int length = 0;
									while (line != "") {
										line = r.ReadLine();
										int lenPos = line.IndexOf("Content-Length: ");
										if (lenPos >= 0) {
											length = line[lenPos + "Content-Length: ".Length] - '0';
										}
									}
									string content;
									if (method == "PUT") {
										int value = ParseValue(r, length);
										Console.WriteLine("value = {0}", value);
										if ((path == "/x") && (value >= -10 || value <= 10)) {
											p.Write(String.Format("SM,100,{0},0\r", value));
										} else if ((path == "/y") && (value >= -10 || value <= 10)) {
											p.Write(String.Format("SM,100,0,{0}\r", value));
										} else if ((path == "/pen") && (value == -1)) {
												p.Write(String.Format("TP\r", value));
										} else if ((path == "/pen") && (value == 0 || value == 1)) {
												p.Write(String.Format("SP,{0}\r", value));
										} else if ((path == "/pen/min") && (value >= 10000 || value <= 27000)) {
											p.Write(String.Format("SC,4,{0}\r", value));
										} else if ((path == "/pen/max") && (value >= 10000 || value <= 27000)) {
											p.Write(String.Format("SC,5,{0}\r", value));
										} else if ((path == "/motors/enabled") && (value == 0 || value == 1)) {
											p.Write(String.Format("EM,{0},{0}\r", value));
										}
										content = value.ToString();
									} else {
										if ((path == "/x") ||
											(path == "/y") ||
											(path == "/pen") ||
											(path == "/pen/min") ||
											(path == "/pen/max") ||
											(path == "/motors/enabled"))
										{
											content = "?";
										} else if (path == "/") {
											content = File.ReadAllText("./index.html");
											content = content.Replace("{{justin-tv-channel}}", justinTvChannel);
										} else if (path == "/setup") {
											content = File.ReadAllText("./setup.html");
										} else {
											content = "";
										}
									}
									using (TextWriter w = new StreamWriter(s)) {
										w.Write("HTTP/1.1 200 OK\r\n" );
										w.Write("Connection: close\r\n");
										w.Write("Content-Length: ");
										w.Write(content.Length);
										w.Write("\r\n\r\n");
										w.WriteLine(content);
										w.Flush();
										Thread.Sleep(1);
									}
								}
							}
						}
					}
				} catch (Exception e) {
					Console.WriteLine(e.Message);
					Thread.Sleep(3000);
				}
			} else {
				Console.WriteLine("EggBot USB COM port not found.");
				Thread.Sleep(3000);
			}
		}
	}

	static void Main (string[] args) {
		if (args.Length <= 3) {
			string relayHost = null;
			string relayDomain = null;
			string justinTvChannel = null;
			if (args.Length == 1) {
				justinTvChannel = args[0];
			} else if (args.Length >= 2) {
				relayHost = args[0];
				relayDomain = args[1];
				if (args.Length == 3) {
					justinTvChannel = args[2];
				}
			}
			Run(relayHost, relayDomain, justinTvChannel);
		} else {
			Console.WriteLine("usage: EggBotWebApi <relay-host> <relay-domain> <justin-tv-user>");
		}	
	}

}