#include <FS.h>                   //this needs to be first, or it all crashes and burns...

#include <ESP8266WiFi.h>          //https://github.com/esp8266/Arduino
#include <Arduino.h>
//needed for library
#include <DNSServer.h>
#include <ESP8266WebServer.h>
#include <WiFiManager.h>          //https://github.com/tzapu/WiFiManager
#include <ESP8266HTTPClient.h>
#include "DHT.h"                 // DHT Library


/**************************************************************************************
 * This is Pocket Weather Station Code for Grabbing Data from DHT11 Sensor and Send it
 * to Your Own Website. Attention: You Donot Need to Rely on Thingsspeak or Any Other 3rd Party Service. 
 * 
 * Instructions: 
 * Upload this Code to your Pocket Weather Station. 
 * On Restart, Your Pocket Weather Station will Boot in AP Mode. 
 * Connect to ConfigWeather AP 
 * A Webpage where Configuration Settings will be Displayed.
 * Find or Type your Router SSID , PASSWORD, IP, GATEWAY , SUBNET
 * After This Module will Reboot and Connect to your WIFI Router.
 * 
 * DONE and Happy Tinkering! Regards ~ Ayush
 * Made By: Ayush Sharma 
 * Hosted On Instructables.com
 * And Website for Sharing Projects: inventorsarea.com
 * Credits: Adafruit DHT Library, WebManager Library and Specially to ESP8266 Arduino Library
 *************************************************************************************/


#define DHTPIN 4     // Connect your DHT11 to Pin4 of ESP8266 Module.

#define DHTTYPE DHT11   // DHT 11

DHT dht(DHTPIN, DHTTYPE);  // Initialize DHT11 Module and Library


void setup() {
  Serial.begin(115200);
  Serial.println();
  //WiFiManager
  //Local intialization. Once its business is done, there is no need to keep it around
  WiFiManager wifiManager;
  
  IPAddress _ip = IPAddress(192, 168, 1, 112);  // Change These 3 Settings According to your Router's IP and GateWay.
  IPAddress _gw = IPAddress(192, 168, 1, 1);
  IPAddress _sn = IPAddress(255, 255, 255, 0);
  
  wifiManager.setSTAStaticIPConfig(_ip, _gw, _sn);
    dht.begin();  // Intialize DHT Library. Credits: Adafruit. 

  if (!wifiManager.autoConnect("ConfigWeather", "esp8266")) {           // No Need for Changing These.
    Serial.println("failed to connect, we should reset as see if it connects");
    delay(3000);
    ESP.reset();
    delay(5000);
  }
  //if you get here you have connected to the WiFi
  Serial.println("connected...yeey :)");
  Serial.println("local ip");
  Serial.println(WiFi.localIP());
}

void loop() {
  delay(2000);
  // Reading temperature or humidity takes about 250 milliseconds!
  // Sensor readings may also be up to 2 seconds 'old' (its a very slow sensor)
  float h = dht.readHumidity();
  // Read temperature as Celsius (the default)
  float t = dht.readTemperature();
Serial.println(h);
Serial.println(t);
  // Check if any reads failed and exit early (to try again).
  if (isnan(h) || isnan(t)) {
    Serial.println("Failed to read from DHT sensor!");
    return;
  }
  // Intiating HTTP Request to your Website. 
  HTTPClient http;

  Serial.print("[HTTP] begin...\n");
  http.begin("http://yourwebsiteurl.com/main.php?temp="+ String(t) +"&hum="+ String(h) +""); //Change the URL according to your Website URL
  Serial.print("[HTTP] GET...\n");
  // start connection and send HTTP header
  int httpCode = http.GET();
  
  if(httpCode > 0) {
  Serial.printf("[HTTP] GET... code: %d\n", httpCode);
   if(httpCode == HTTP_CODE_OK) {
    String payload = http.getString();
    Serial.println(payload);
   } 
 }
  
  else {
            Serial.println("GET Request Failed!");
}
  http.end();
    
    ESP.deepSleep(1800 * 1000000); // Sleep for 30Min's 
  // Change Sleep Time According to your Choice. 
  // Deep Sleep Works in MicroSeconds Therefore Change Accordingly. 

}
