//Code By Vermont Internet Design LLC, John Anderson 
// http://www.vermontinternetdesign.com
// Marshfield,VT 5/5/2018 info@vermontinternetdesign.com
#include <SoftwareSerial.h>
#include <ArduinoJson.h>

SoftwareSerial mySerial(2, 3); // RX, TX
String bufferx;
int start = 0;
void SendJSON(char pin, char highlow){
     StaticJsonBuffer<200> jsonBuffer;
     JsonObject& root = jsonBuffer.createObject();
     root["PinNumber"] = pin;
     root["HighLow"] = highlow;
     root.printTo(Serial);
     return;
}
void processJSON(String jsonii){
    
     StaticJsonBuffer<200> jsonBuffer;
    // Serial.println(json);
     Serial.println();
     JsonObject& root = jsonBuffer.parseObject(jsonii);
     if (!root.success()) {
        Serial.println("parseObject() failed");
        return;
     }
    // root.printTo(mySerial);
      //root.printTo(Serial);
     int ana = root["IsAnalog"];
     int respond = root["Respond"];
     uint8_t pin = root["PinNumber"];
     int val = root["HighLow"];
     if(ana == 1){
        
        analogWrite(pin, val);
     }else if(ana == 0){
       
       if(val == 0){
        digitalWrite(pin, LOW);
       }else if(val == 1){
        digitalWrite(pin, HIGH);
       }
     }
     if(respond == 1){
        String res;
        if(ana == 1){
           res = analogRead(pin);
        }else if(ana == 0){
          res = digitalRead(pin);
        }
        // Serial.print(res);
        sendResponse(pin, res);
     }
     return;
}
void sendResponse(uint8_t p, String r){
   StaticJsonBuffer<200> jsonBuffer;
     JsonObject& root = jsonBuffer.createObject();
     root["PinNumber"] = p;
     root["HighLow"] = r;
     String js;     
     root.printTo(js);
    // Serial.print(js);
     mySerial.print(js);
     return;
}
void setup() {
  // Declare Pin Mode 
  pinMode(12, OUTPUT);
  pinMode(11, OUTPUT);
  pinMode(9, OUTPUT);
  pinMode(8, OUTPUT);
  pinMode(A0, INPUT);   
  Serial.begin(4800);
  while (!Serial) {
    ; // wait for serial port to connect. Needed for native USB port only
  }
  
  // set the data rate for the SoftwareSerial port
  mySerial.begin(9600);
  
}

void loop() { // run over and over
 
 
  if (mySerial.available()) {
           int incoming = mySerial.read();
           if(incoming >= 32){
             //Serial.println(incoming);
             char character = (char) incoming;
           
             if(character == '{'){
                start = 1;
             }
             if(start == 1){
                bufferx.concat(character);
             }
             if(character == '}'){
              processJSON(bufferx);
              start = 0;
              bufferx = "";
             }
              
          }
  }
   if (Serial.available()) {
    //mySerial.println(Serial.read());
  }
  
}
