/*
* MAC addresses of various boards used for sensor stations
*
* Author: Marcell Stoer
* December 2018
*
*/

// holds all info/data from each sensor station, fill with real location and temporary sensor data
// add to this as needed for additional sensors/locations
// Check "MainStationESP32.h" for data format
struct SENSORSTN_INFO sensorstn[MAXSTNS] = {
 {"Outside", {0x84, 0xF3, 0xEB, 0x73, 0x49, 0x34}, 0,0,0,0, "20010101 00:00:00"},  
 {"Garage", {0x5E, 0xCF, 0x7F, 0x11, 0x56, 0x8D}, 0,0,0,0, "20010101 00:00:00"}, 
 {"Alexander's Room", {0x5C, 0xCF, 0x7F, 0x11, 0xD3, 0x4C}, 0,0,0,0, "20010101 00:00:00"}, 
 {"Sun Room", {0x62, 0x01, 0x94, 0x01, 0x11, 0x6C}, 0,0,0,0, "20010101 00:00:00"}, 
 {"Living Room", {0x84, 0xF3, 0xEB, 0x73, 0xD3, 0x40}, 0,0,0,0, "20010101 00:00:00"} 
} ;

// sensor station data file names
// files are created in root area
String dfilenames[MAXSTNS] = { "File01.txt", "File02.txt", "File03.txt","File04.txt", "File05.txt" };

//
// Corrections to humidity measurements versus BME280
// This does not imply that one particular sensor is more accurate, but simply allows readings to be compared
// Add value to the reading (-ve value indicates the sensor read higher than the BME280)
float hsenscor[MAXSTNS] = {0, 0, -4, -9, 0};
