/*
  23/12/15
  Darren Lewis
*/
const int onLight = 12;     // assign to button that switches the lights on
const int offLight = 11;    // assign to button that switches the lights off
const int led = 4;          // if you have an LED connected
bool doorBell = LOW;

void setup() {
  Serial.begin(9600);
  pinMode(onLight, OUTPUT);
  pinMode(offLight, OUTPUT);
  pinMode(led, OUTPUT);
  digitalWrite(onLight, LOW);
  digitalWrite(offLight, LOW);
  for (int i = 0; i < 64; i++) {      // add values to the software filter accumulator
    getAnalogue(A0);
  }
}

void loop() {
  if (getAnalogue(A0) > 200) doorBell = HIGH;     // record if doorbell is pressed
  else doorBell = LOW;
  Serial.println(getAnalogue(A0));
  if (doorBell == HIGH) pulseLights();
}


void pulseLights() {
  digitalWrite(led, HIGH);
  for (int i = 0; i < 10; i++) {    // switch lights 10 times
    digitalWrite(offLight, HIGH);   // press off button for 200ms
    delay(200);
    digitalWrite(offLight, LOW);    // wait for 2sec
    delay(2000);          

    digitalWrite(onLight, HIGH);   
    delay(200);
    digitalWrite(onLight, LOW);   
    delay(2000);         
  }
  for (int i = 0; i < 64; i++) {
    getAnalogue(A0);
  }
  digitalWrite(led, LOW);
}

