`timescale 1ns / 1ps
//////////////////////////////////////////////////////////////////////////////////
// Company: 
// Engineer: 
// 
// Create Date: 06/30/2016 03:43:31 PM
// Design Name: 
// Module Name: state_machine
// Project Name: 
// Target Devices: 
// Tool Versions: 
// Description: 
// 
// Dependencies: 
// 
// Revision:
// Revision 0.01 - File Created
// Additional Comments:
// 
//////////////////////////////////////////////////////////////////////////////////


module state_machine(
    input btn,
    input clk,
    input rst,
    output reg step_en,
    output [1:0] state
    );
    
    localparam start = 2'b0;
    localparam vend = 2'b01;
    localparam vend2 = 2'b10;
    localparam count_val = 32'd62500000;
    
    reg clr;
    wire [31:0] timer;
    
    counter count (
        .clk(clk),
        .clr(clr||~rst),
        .count(timer)
    );
    
    reg [1:0] curr_state;
    reg [1:0] next_state;
    
    assign state = curr_state;
        
    always @ (posedge(clk))
    begin
        case (curr_state)
            start:
            begin
                step_en <= 1'b0; //Disable the stepper motor
                clr <= 1'b1; //Hold the Counter at 0
                if (btn == 1'b1) next_state <= vend; //Go to vend state if the button was pressed
                else next_state <= start; //Otherwise stay here
            end
            vend:
            begin
                if (btn == 1'b0) next_state <= vend2; //Go to the vend2 state if the button was released
                else next_state <= vend; //Stay here if not
            end
            vend2:
            begin
                step_en <= 1'b1; //Enable the Stepper only in this state
                clr <= 1'b0; //Run the counter in this step
                if (timer < count_val) next_state <= vend2; //If the counter hasn't reached the goal stay here
                else next_state <= start; //The counter has reached the goal, go back to the start state
            end
        endcase
    end
    
    //Update the state registers
    always @ (posedge(clk), posedge(rst))
    begin
        if (rst == 1'b0)
        begin
            curr_state <= start;
        end
        else curr_state <= next_state; 
    end
endmodule
