`timescale 1ns / 1ps
//////////////////////////////////////////////////////////////////////////////////
// Company: 
// Engineer: 
// 
// Create Date: 06/29/2016 03:50:56 PM
// Design Name: 
// Module Name: dispenser_top
// Project Name: 
// Target Devices: 
// Tool Versions: 
// Description: 
// 
// Dependencies: 
// 
// Revision:
// Revision 0.01 - File Created
// Additional Comments:
// 
//////////////////////////////////////////////////////////////////////////////////


module dispenser_top(
    input clk,
    input rst,
    input en,
    output [3:0] step,
    output en_led,
    output [1:0] state_led,
    output rst_led
    );
    
    wire step_en;
    wire [1:0] state;
    wire en_db;
    
    assign state_led = state;
    assign rst_led = rst;
    assign en_led = en;
    
debounce db (
    .clk(clk),
    .signal(en),
    .db_signal(en_db)
);
    
state_machine fsm (
    .btn(en_db),
    .clk(clk),
    .rst(rst),
    .step_en(step_en),
    .state(state)
);

//Control the Stepper Motor
pmod_step_interface stepper (
    .clk(clk),
    .rst(rst),
    .direction(1'b1),
    .en(step_en),
    .signal_out(step)
);
endmodule
