/*
 * Dice.cpp - Library for Reading dice face.
 * Created by Calvin Ochs, January 15, 2019
 * 
 * 0 0 0
 * 1 2 0
 * 5 4 3
 */
#ifndef Dice_h
#define Dice_h

#include "Arduino.h"




class Dice
{
  public:
		Dice(const int pin1,const int pin2,const int pin3,const int pin4,const int pin5, int cal1, int cal2, int cal3, int cal4, int cal5, int loop, int serialDataPin, int clockPin, int latchPin);
		int ReadFace();
		int One();
		int Two();
		int Three();
		int Four();
		int Five();
		int getDice();
    void setAll(uint8_t * digitalValues);
    uint8_t * getAll(); 
    void set(int pin, uint8_t value);
    void setNoUpdate(int pin, uint8_t value);
    void updateRegisters();
    void setAllLow();
    void setAllHigh(); 
    uint8_t get(int pin);

    
  private:
   
	  int _pin1;
	  int _pin2;
	  int _pin3;
	  int _pin4;
	  int _pin5;
	  int _cal1;
	  int _cal2;
	  int _cal3;
	  int _cal4;
	  int _cal5;
	  
	  int dot1;
	  int dot2;
	  int dot3;
	  int dot4;
	  int dot5;
	  
	  int p1;
	  int p2;
	  int p3;
	  int p4;
	  int p5;

    int _loop;
	  int dice;
	  
	  String currentFace;
	  String face1;
	  String face2;
	  String face2r;
	  String face3;
	  String face3r;
	  String face4;
	  String face5;
	  String face6;
	  String face6r;

    int _numberOfShiftRegisters;
    int _clockPin;
    int _serialDataPin;
    int _latchPin;
    uint8_t * _digitalValues;
  
};

#endif
