/*
 * Demo.ino - Demo for Reading dice face.
 * Created by Calvin Ochs, January 15, 2019
 * 
 * Dice Face Pip locations
 * 0 0 0
 * 1 2 0
 * 5 4 3
 */

#include "Dice.h"

//Create dice object

// parameters: (pin1, pin2, pin3, pin4, pin5, calibration numbers 1-5, amount of times to loop, data pin, clock pin, latch pin)
Dice dice(A0,A1,A2,A3,A4,270,230,275,278,272,40,3,13,12);
 
int face = 0;
void setup() {
	face = dice.ReadFace();
 Serial.begin(9600);
}

void loop() {
	
  delay(1000);
  
  //prints the values of each of the pip locations
  //these are used to get the calibration numbers
  Serial.println(dice.One());
  Serial.println(dice.Two());
  Serial.println(dice.Three());
  Serial.println(dice.Four());
  Serial.println(dice.Five());

  //depending if calibration numbers are setup correctly, this will return the face of the dice
  face = dice.ReadFace();
  Serial.println(face);

}
