// This is an OpenSCAD clone of F.Lab's DIYBio rotor v2.
//
// Thomas Kircher <tkircher@gnu.org>, 8/11/2017



module main_rotor_body() {
    // Rotor base
    translate([0, 0, 0])
        cylinder(d = 10, h = 3, $fn = 300);
    
    // Rotor upper taper
    translate([0, 0, 3])
        cylinder(d1 = 10, d2 = 60, h = 24, $fn = 300);
    
    translate([0, 0, 27])
        cylinder(d = 60, h = 2, $fn = 300);
    
    }

module rotor_body_cutout() {
    // Rotor inner taper
    translate([0, 0, 15])
        cylinder(d1 = 20, d2 = 55, h = 15.1, $fn = 300);
    
    // Rotor mount hole
    translate([0, 0, -1])
        cylinder(d = 2.5, h = 18, $fn = 60);
    

    
}

// Eppendorf 1.5mL tubes are 10.7mm OD
module rotor_slot_cutout() {
    for(i = [0:5]) {
        rotate([0, 0, -60 * i]) translate([0, 41, -2])
            rotate([45, 0, 0])
                cylinder(d = 11, h = 35, $fn = 200);
    }
}

difference() {
    main_rotor_body();

    union() {
        rotor_body_cutout();
        rotor_slot_cutout();
    }
}