/* 
This is a test sketch for the Adafruit assembled Motor Shield for Arduino v2
It won't work with v1.x motor shields! Only for the v2's with built in PWM
control

For use with the Adafruit Motor Shield v2 
---->	http://www.adafruit.com/products/1438
*/


#include <Wire.h>
#include <Adafruit_MotorShield.h>
#define BUTTON_SX 10               // pin di input dove è collegato il pulsante
#define BUTTON_DX 9              // pin di input dove e collegato il pulsante
#define ENDSTOP_SX 12         // pin di output dove e collegato il fineCorsa
#define ENDSTOP_DX 11         // pin di output dove e collegato il Finecorsa

// Create the motor shield object with the default I2C address
Adafruit_MotorShield AFMS = Adafruit_MotorShield(); 

Adafruit_StepperMotor *myMotor = AFMS.getStepper(200, 2);



void setup() {
  Serial.begin(9600);           // set up Serial library at 9600 bps
  Serial.println("Stepper test!");
  pinMode(BUTTON_SX, INPUT);     // imposta il pin digitale come input  
  pinMode(BUTTON_DX, INPUT);     // imposta il pin digitale come input 
  pinMode(ENDSTOP_DX,INPUT);// pin di fineCorsa input/ 
  pinMode(ENDSTOP_SX,INPUT);// pin di fineCorsa input/ 

  AFMS.begin();  // create with the default frequency 1.6KHz
  //AFMS.begin(1000);  // OR with a different frequency, say 1KHz
  
  myMotor->setSpeed(10);  // 10 rpm   
}

void loop() 
   {  if (digitalRead(BUTTON_SX) == HIGH) 
      { Serial.println("va a sinistra (microstep)");
        while ( digitalRead(ENDSTOP_SX)==LOW ) 
        {  myMotor->step(4, FORWARD, MICROSTEP);  }
      }
     
     
      if (digitalRead(BUTTON_DX) == HIGH) 
      { Serial.println("va a destra (microstep)");
        while ( digitalRead(ENDSTOP_DX)==LOW ) 
        {  myMotor->step(4, BACKWARD, MICROSTEP);  }
      }
}
