﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Ozeki.Media.IPCamera;
using Ozeki.Media.IPCamera.Server;
using Ozeki.Media.MediaHandlers;

namespace Basic_CameraViewer
{
    public class MyServer : IPCameraServer
    {
        private MediaConnector _connector;

        private IIPCameraClient _client;

        public IVideoSender VideoSender { get; set; }

        public event EventHandler<EventArgs> OnClientCountChanged;

        public MyServer()
        {
            _connector = new MediaConnector();
        }

        protected override void OnClientConnected(IIPCameraClient client)
        {
            _client = client;
            _connector.Connect(VideoSender, _client.VideoChannel);

            var handler = OnClientCountChanged;
            if (handler != null)
                handler(null, new EventArgs());

            base.OnClientConnected(_client);
        }

        protected override void OnClientDisconnected(IIPCameraClient client)
        {
            _client = client;

            _connector.Disconnect(VideoSender, _client.VideoChannel);
            _connector.Dispose();

            var handler = OnClientCountChanged;
            if (handler != null)
                handler(null, new EventArgs());

            base.OnClientDisconnected(_client);
        }
    }
}