#include <TimerOne.h>
#include <IRSendRev.h>
#include <SparkFunMiniMoto.h>   // Include the MiniMoto library
#include "JointV2.h"

JointV2 Joint;

MiniMoto motor2_r(0xc0);            // -
MiniMoto motor2_l(0xc4);            // +

MiniMoto motor1_l(0xcc);            // +
MiniMoto motor1_r(0xd0);            // -


#define MAXSPEED    63

#define BIT_DATA_LEN    5
#define BIT_DATA        6

#define IR_KEY_F1   0x9D            // go forward
#define IR_KEY_B1   0x57            // go back
#define IR_KEY_L1   0xDD            // go left
#define IR_KEY_R1   0x3D            // go right
#define IR_KEY_S1   0xFD            // stop

#define IR_KEY_F2   0xE7            // go forward
#define IR_KEY_B2   0xB5            // go back
#define IR_KEY_L2   0xEF            // go left
#define IR_KEY_R2   0xA5            // go right
#define IR_KEY_S2   0xC7            // stop

char speed1_r      = 0;
char speed1_r_buf  = 0;

char speed1_l      = 0;
char speed1_l_buf  = 0;

char speed2_r      = 0;
char speed2_r_buf  = 0;

char speed2_l      = 0;
char speed2_l_buf  = 0;

// pin connect to IR
const int pinRecv = 5;                  // ir receiver connect to D5


void setup()
{
    Serial.begin(9600);
    IR.Init(pinRecv);
    
    Joint.begin();

    Timer1.initialize(31000);           // set a timer of length 100000 microseconds (or 0.1 sec - or 10Hz => the led will blink 5 times, 5 cycles of on-and-off, per second)
    Timer1.attachInterrupt(timerIsr);   // attach the service routine here

    Serial.println("sys start");
    
    motor1_l.stop();
    motor1_r.stop();
    
    motor2_l.stop();
    motor2_r.stop();
    
    pinMode(13, OUTPUT);
    digitalWrite(13, LOW);
}


void loop()
{
    int key = getDta();

    if(key>0)
    {
        Serial.print("KEY: 0x");
        Serial.println(key, HEX);
    }

    speedGet(key);
    SpeedProcess();
    jointProcess();
}

void jointProcess()
{
    if(Joint.readKey())
    {
        delay(20);
        if(Joint.readKey())
        {
            unsigned long timer_s = millis();
            bool flg_pwr_off = 0;
            digitalWrite(13, HIGH);
            while(Joint.readKey())
            {
                if(millis()-timer_s > 500)
                {
                    flg_pwr_off = 1;
                    Serial.println("power off");
                    digitalWrite(13, LOW);
                    Joint.pwrOff();
                }
            }

            Serial.println("button on");
            
        }
    }
    
    ledBlink();
}

void ledBlink()
{
    static unsigned long timer_s = millis();
    if(millis()-timer_s < 100)return;
    timer_s = millis();
    digitalWrite(13, 1-digitalRead(13));
}

void setSpeed(unsigned char motor, char speed_l, char speed_r)
{
    if(motor<1 || motor>2)return;
    if(speed_l > 63)speed_l = 63;
    if(speed_r > 63)speed_r = 63;
    if(speed_l < -63)speed_l = -63;
    if(speed_r < -63)speed_r = -63;

    if(motor == 1)
    {
        speed1_l = speed_l;
        speed1_r = speed_r;
    }
    else if(motor == 2)
    {
        speed2_l = speed_l;
        speed2_r = speed_r;
    }


}

void speedGet(int key)
{
    if(key==0)return;

    switch(key)
    {

        case IR_KEY_F1:         // go forward

        Serial.println("IR_KEY_F1");
        setSpeed(1, MAXSPEED, MAXSPEED);

        break;
        case IR_KEY_B1:
        Serial.println("IR_KEY_B1");
        setSpeed(1, 0-MAXSPEED, 0-MAXSPEED);
        break;

        case IR_KEY_L1:
        Serial.println("IR_KEY_L1");
        setSpeed(1, 0, MAXSPEED);

        break;
        case IR_KEY_R1:
        Serial.println("IR_KEY_R1");
        setSpeed(1, MAXSPEED, 0);

        break;
        
        case IR_KEY_S1:
        Serial.println("IR_KEY_S1");
        setSpeed(1, 0, 0);

        break;

        case IR_KEY_F2:
        Serial.println("IR_KEY_F2");
        setSpeed(2, MAXSPEED, MAXSPEED);

        break;

        case IR_KEY_B2:
        Serial.println("IR_KEY_B2");
        setSpeed(2, 0-MAXSPEED, 0-MAXSPEED);

        break;

        case IR_KEY_L2:
        Serial.println("IR_KEY_L2");
        setSpeed(2, 0, MAXSPEED);

        break;

        case IR_KEY_R2:
        Serial.println("IR_KEY_R2");
        setSpeed(2, MAXSPEED, 0);

        break;

        case IR_KEY_S2:
        Serial.println("IR_KEY_S2");
        setSpeed(2, 0, 0);

        break;

        default:;
    }
}

void SpeedProcess()
{
    if(speed1_l != speed1_l_buf)
    {
        speed1_l_buf = speed1_l;
        motor1_l.drive(speed1_l);
        // todo: motor move
    }

    if(speed1_r != speed1_r_buf)
    {
        speed1_r_buf = speed1_r;
        motor1_r.drive(speed1_r);
        
        Serial.println((int)speed1_r);
    }

    if(speed2_l != speed2_l_buf)
    {
        speed2_l_buf = speed2_l;
        motor2_l.drive(speed2_l);
        // todo: motor move
    }

    if(speed2_r != speed2_r_buf)
    {
        speed2_r_buf = speed2_r;
        motor2_r.drive(0-speed2_r);
        // todo: motor move
    }
}
/// --------------------------
/// Custom ISR Timer Routine
/// --------------------------
void timerIsr()
{
    if(speed1_r < 0)speed1_r++;
    else if(speed1_r>0)speed1_r--;
    
    if(speed1_l < 0)speed1_l++;
    else if(speed1_l>0)speed1_l--;
    
    if(speed2_r < 0)speed2_r++;
    else if(speed2_r>0)speed2_r--;
    
    if(speed2_l < 0)speed2_l++;
    else if(speed2_l>0)speed2_l--;
}

// if return 0, no data
unsigned char getDta()
{
    if(0 == IR.IsDta())return 0;

    unsigned char dta[20];
    IR.Recv(dta);
    int len = dta[BIT_DATA_LEN];
    return dta[len+BIT_DATA-1];
}
