//IR test
#include <IRSendRev.h>
#include <SparkFunMiniMoto.h>   // Include the MiniMoto library

MiniMoto motorA_0(0xc0);          // A1 = 1, A0 = clear
MiniMoto motorA_1(0xc4);          // A1 = 1, A0 = 1 (default)

MiniMoto motorB_0(0xcc);
MiniMoto motorB_1(0xd0);

#define BIT_DATA_LEN    5
#define BIT_DATA        6

const int pinRecv = 5;              // ir receiver connect to D5

void setup()
{
    Serial.begin(115200);
    IR.Init(pinRecv);
    Serial.println("init over");
}

#define STOP    93
#define FORWARD 253
#define REVERSE 61

void loop()
{
    int key = getDta();
    if(key != 0)
    {
        // Serial.println(key);
        Serial.println(key);
        
        switch(key)
        {
            case STOP:      // stop
            Serial.println("STOP");
            motorA_0.stop();
            motorA_1.stop();
            motorB_0.stop();
            motorB_1.stop();
            break;
            
            case FORWARD:   // go forward
            Serial.println("FORWARD");
            motorA_0.drive(100);
            motorA_1.drive(100);
            motorB_0.drive(100);
            motorB_1.drive(100);
            break;
            
            case REVERSE:   // go reverse
            Serial.println("REVERSE");
            motorA_0.drive(-100);
            motorA_1.drive(-100);
            motorB_0.drive(-100);
            motorB_1.drive(-100);
            break;
            
            default:;
        }
    }
    
    delay(10);
}

// if return 0, no data
unsigned char getDta()
{
    if(0 == IR.IsDta())return 0;
    
    unsigned char dta[20];
    IR.Recv(dta);
    int len = dta[BIT_DATA_LEN];
    return dta[len+BIT_DATA-1];
}
