//*****************************************************************************
// (c) Copyright 2011-2012 Xilinx, Inc. All rights reserved.
//
// This file contains confidential and proprietary information
// of Xilinx, Inc. and is protected under U.S. and
// international copyright and other intellectual property
// laws.
//
// DISCLAIMER
// This disclaimer is not a license and does not grant any
// rights to the materials distributed herewith. Except as
// otherwise provided in a valid license issued to you by
// Xilinx, and to the maximum extent permitted by applicable
// law: (1) THESE MATERIALS ARE MADE AVAILABLE "AS IS" AND
// WITH ALL FAULTS, AND XILINX HEREBY DISCLAIMS ALL WARRANTIES
// AND CONDITIONS, EXPRESS, IMPLIED, OR STATUTORY, INCLUDING
// BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, NON-
// INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE; and
// (2) Xilinx shall not be liable (whether in contract or tort,
// including negligence, or under any other theory of
// liability) for any loss or damage of any kind or nature
// related to, arising under or in connection with these
// materials, including for any direct, or any indirect,
// special, incidental, or consequential loss or damage
// (including loss of data, profits, goodwill, or any type of
// loss or damage suffered as a result of any action brought
// by a third party) even if such damage or loss was
// reasonably foreseeable or Xilinx had been advised of the
// possibility of the same.
//
// CRITICAL APPLICATIONS
// Xilinx products are not designed or intended to be fail-
// safe, or for use in any application requiring fail-safe
// performance, such as life-support or safety devices or
// systems, Class III medical devices, nuclear facilities,
// applications related to the deployment of airbags, or any
// other applications that could lead to death, personal
// injury, or severe property or environmental damage
// (individually and collectively, "Critical
// Applications"). Customer assumes the sole risk and
// liability of any use of Xilinx products in Critical
// Applications, subject only to applicable laws and
// regulations governing limitations on product liability.

//Generated by MBAC v3.04
//8-12-2010, 14h 8m 23s
//--------------------------------------------

//RESET_POLARITY_SYMBOL, set to ! (or blank) for active low (high)
`define AKRPS ! // ###MBAC###

`timescale 1 ps / 1 ps // ###MBAC###

//Assertion circuit for vunit: inline
//vunit is bound to module: Axi4LitePC
(* DowngradeIPIdentifiedWarnings="yes" *) 
module axi_protocol_checker_v1_1_14_axi4litepc_asr_inline (Axi4LitePC_asr_inline_out, reset, BVALID, BRESP, ACLK, RVALID, RRESP);
  parameter DATA_WIDTH = 64;
  output [3:1] Axi4LitePC_asr_inline_out;
  input reset, BVALID, ACLK, RVALID;
  input [1:0] BRESP;
  input [1:0] RRESP;

  reg ASR_1, ASR_2, ASR_3;

  assign Axi4LitePC_asr_inline_out={ASR_3, ASR_2, ASR_1};

  //---------------
  //ASR_1 : assert property ( @(posedge ACLK) ( BVALID |-> BRESP != 2'b1 ) );
  //---------------
  always @(posedge ACLK) if (`AKRPS reset) ASR_1<=0; else
    ASR_1 <= ((BVALID && !((BRESP != 2'b1))));

  //---------------
  //ASR_2 : assert property ( @(posedge ACLK) ( RVALID |-> RRESP != 2'b1 ) );
  //---------------
  always @(posedge ACLK) if (`AKRPS reset) ASR_2<=0; else
    ASR_2 <= ((RVALID && !((RRESP != 2'b1))));

  //---------------
  //ASR_3 : assert property ( @(posedge ACLK) ( ( DATA_WIDTH == 32 || DATA_WIDTH == 64 ) ) );
  //---------------
  always @(posedge ACLK) if (`AKRPS reset) ASR_3<=0; else
    ASR_3 <= (!(((DATA_WIDTH == 32) || (DATA_WIDTH == 64))));

endmodule //Axi4LitePC_asr_inline
/*Instantiation code:
Axi4LitePC_asr_inline #(DATA_WIDTH) i_Axi4LitePC_asr_inline (Axi4LitePC_asr_inline_out, reset, BVALID, BRESP, ACLK, RVALID, RRESP);
*/
//End of circuit(s) for vunit: inline


//*****************************************************************************
// (c) Copyright 2011-2013 Xilinx, Inc. All rights reserved.
//
// This file contains confidential and proprietary information
// of Xilinx, Inc. and is protected under U.S. and
// international copyright and other intellectual property
// laws.
//
// DISCLAIMER
// This disclaimer is not a license and does not grant any
// rights to the materials distributed herewith. Except as
// otherwise provided in a valid license issued to you by
// Xilinx, and to the maximum extent permitted by applicable
// law: (1) THESE MATERIALS ARE MADE AVAILABLE "AS IS" AND
// WITH ALL FAULTS, AND XILINX HEREBY DISCLAIMS ALL WARRANTIES
// AND CONDITIONS, EXPRESS, IMPLIED, OR STATUTORY, INCLUDING
// BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, NON-
// INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE; and
// (2) Xilinx shall not be liable (whether in contract or tort,
// including negligence, or under any other theory of
// liability) for any loss or damage of any kind or nature
// related to, arising under or in connection with these
// materials, including for any direct, or any indirect,
// special, incidental, or consequential loss or damage
// (including loss of data, profits, goodwill, or any type of
// loss or damage suffered as a result of any action brought
// by a third party) even if such damage or loss was
// reasonably foreseeable or Xilinx had been advised of the
// possibility of the same.
//
// CRITICAL APPLICATIONS
// Xilinx products are not designed or intended to be fail-
// safe, or for use in any application requiring fail-safe
// performance, such as life-support or safety devices or
// systems, Class III medical devices, nuclear facilities,
// applications related to the deployment of airbags, or any
// other applications that could lead to death, personal
// injury, or severe property or environmental damage
// (individually and collectively, "Critical
// Applications"). Customer assumes the sole risk and
// liability of any use of Xilinx products in Critical
// Applications, subject only to applicable laws and
// regulations governing limitations on product liability.

//RESET_POLARITY_SYMBOL, set to ! (or blank) for active low (high)
`define AKRPS ! // ###MBAC###

`timescale 1 ps / 1 ps // ###MBAC###

//Assertion circuit for vunit: inline
//vunit is bound to module: Axi4PC
(* DowngradeIPIdentifiedWarnings="yes" *) 
module axi_protocol_checker_v1_1_14_axi4pc_asr_inline (Axi4PC_asr_inline_out, reset, AWVALID, AWBURST, AwAddrIncr, AWADDR, ACLK, AlignMaskW, AWLEN, AWLOCK, AWCACHE, AwSizeInBits, ARESETn, AWREADY, AWID, AWPROT, AWSIZE, AWQOS, AWREGION, i_RecommendOn, i_RecMaxWaitOn, WriteDataNumError, BStrbError, WVALID, WREADY, WDATA, WLAST, WSTRB, BrespErrorLast, BrespExokError, BVALID, BrespErrorLead, BREADY, BID, BRESP, ARVALID, ARBURST, ArAddrIncr, ARADDR, AlignMaskR, ARLEN, ARLOCK, ARCACHE, ArSizeInBits, ARREADY, ARID, ARPROT, ARSIZE, ARQOS, ARREGION, RVALID, RREADY, ArCountPending, ArLenPending, RLAST, RidMatch, RRESP, ArExclPending, RDATA, RID, CSYSREQ, CSYSACK, ExclMask, ExclReadAddr, ExclAwMatch, ExclAddr, ExclSize, ExclLen, ExclBurst, ExclCache, ExclProt, ExclRegion, ArLenInBytes, ExclReadData, AWUSER, WUSER, BUSER, ARUSER, RUSER); // ###MBAC###
  parameter DATA_WIDTH = 64;
  parameter ID_WIDTH = 4;
  parameter AWUSER_WIDTH = 32;
  parameter WUSER_WIDTH = 32;
  parameter BUSER_WIDTH = 32;
  parameter ARUSER_WIDTH = 32;
  parameter RUSER_WIDTH = 32;
  parameter MAXRBURSTS = 16;
  parameter MAXWBURSTS = 16;
  parameter ADDR_WIDTH = 32;
  parameter EXMON_WIDTH = 4;
  parameter DATA_MAX = DATA_WIDTH - 1; // ###MBAC###
  parameter ADDR_MAX = ADDR_WIDTH - 1;
  parameter STRB_WIDTH = DATA_WIDTH / 8;
  parameter STRB_MAX = STRB_WIDTH - 1;
  parameter ID_MAX = ID_WIDTH ? ID_WIDTH - 1 : 0;
  parameter EXMON_MAX = EXMON_WIDTH - 1;
  parameter EXMON_HI = {EXMON_WIDTH{1'b1}};
  parameter AWUSER_MAX = AWUSER_WIDTH ? AWUSER_WIDTH - 1 : 0; // ###MBAC###
  parameter WUSER_MAX = WUSER_WIDTH ? WUSER_WIDTH - 1 : 0;
  parameter BUSER_MAX = BUSER_WIDTH ? BUSER_WIDTH - 1 : 0;
  parameter ARUSER_MAX = ARUSER_WIDTH ? ARUSER_WIDTH - 1 : 0;
  parameter RUSER_MAX = RUSER_WIDTH ? RUSER_WIDTH - 1 : 0;
  parameter MAX_AW_WAITS = 16;
  parameter MAX_AR_WAITS = 16;
  parameter MAX_W_WAITS  = 16;
  parameter MAX_R_WAITS  = 16;
  parameter MAX_B_WAITS  = 16;
  parameter MAX_CONTINUOUS_RTRANSFERS_WAITS  = 16;
  parameter MAX_CONTINUOUS_WTRANSFERS_WAITS  = 16;
  parameter MAX_WLAST_TO_AWVALID_WAITS  = 16;
  parameter MAX_WRITE_TO_BVALID_WAITS  = 16;
  parameter LIGHT_WEIGHT  = 0;
  output [91:1] Axi4PC_asr_inline_out;
  input reset, AWVALID, ACLK, AWLOCK, ARESETn, AWREADY, i_RecommendOn, i_RecMaxWaitOn, WriteDataNumError, BStrbError, WVALID, WREADY, WLAST, BrespErrorLast, BrespExokError, BVALID, BrespErrorLead, BREADY, ARVALID, ARLOCK, ARREADY, RVALID, RREADY, RLAST, ArExclPending, CSYSREQ, CSYSACK, ExclAwMatch; // ###MBAC###
  input [1:0] AWBURST;
  input [ADDR_MAX:0] AwAddrIncr;
  input [ADDR_MAX:0] AWADDR;
  input [6:0] AlignMaskW;
  input [7:0] AWLEN;
  input [3:0] AWCACHE;
  input [10:0] AwSizeInBits;
  input [ID_MAX:0] AWID;
  input [2:0] AWPROT;
  input [2:0] AWSIZE;
  input [3:0] AWQOS;
  input [3:0] AWREGION;
  input [DATA_MAX:0] WDATA; // ###MBAC###
  input [STRB_MAX:0] WSTRB;
  input [ID_MAX:0] BID; // ###MBAC###
  input [1:0] BRESP;
  input [1:0] ARBURST;
  input [ADDR_MAX:0] ArAddrIncr;
  input [ADDR_MAX:0] ARADDR;
  input [6:0] AlignMaskR;
  input [7:0] ARLEN;
  input [3:0] ARCACHE;
  input [10:0] ArSizeInBits;
  input [ID_MAX:0] ARID;
  input [2:0] ARPROT;
  input [2:0] ARSIZE;
  input [3:0] ARQOS;
  input [3:0] ARREGION;
  input [8:0] ArCountPending;
  input [8:0] ArLenPending;
  input [31:0] RidMatch;
  input [1:0] RRESP;
  input [DATA_MAX:0] RDATA; // ###MBAC###
  input [ID_MAX:0] RID;
  input [14:0] ExclMask;
// ###MBAC###  input [EXMON_MAX:0] ExclAwId;
// ###MBAC###  input [ADDR_MAX:0] ExclAddr [EXMON_HI:0];
// ###MBAC###  input [2:0] ExclSize [EXMON_HI:0];
// ###MBAC###  input [7:0] ExclLen [EXMON_HI:0];
// ###MBAC###  input [1:0] ExclBurst [EXMON_HI:0];
// ###MBAC###  input [3:0] ExclCache [EXMON_HI:0];
// ###MBAC###  input [2:0] ExclProt [EXMON_HI:0];
// ###MBAC###  input [3:0] ExclRegion [EXMON_HI:0];
  input [ADDR_MAX:0] ExclAddr;
  input [2:0] ExclSize;
  input [7:0] ExclLen;
  input [1:0] ExclBurst;
  input [3:0] ExclCache;
  input [2:0] ExclProt;
  input [3:0] ExclRegion;
  input ExclReadAddr;
  input ExclReadData;
// ###MBAC###
  input [15:0] ArLenInBytes;
  input [AWUSER_MAX:0] AWUSER; // ###MBAC###
  input [WUSER_MAX:0] WUSER;
  input [BUSER_MAX:0] BUSER;
  input [ARUSER_MAX:0] ARUSER;
  input [RUSER_MAX:0] RUSER;
// ###MBAC###  input [31:0] RIndex;
// ###MBAC###  input [31:0] WIndex;

  function integer f_clogb2 (input integer size);
    integer s;
    begin
      s = size;
      s = s - 1;
      for (f_clogb2=1; s>1; f_clogb2=f_clogb2+1)
            s = s >> 1;
    end
  endfunction // clogb2

  wire [2:0] s1s;
  reg [2:0] s1sq;
  reg [ADDR_MAX:0] s2;
  wire [2:0] s4s;
  reg [2:0] s4sq;
  reg [1:0] s5;
  wire [2:0] s7s;
  reg [2:0] s7sq;
  reg [3:0] s8;
  wire [2:0] s10s;
  reg [2:0] s10sq;
  reg [ID_MAX:0] s11;
  wire [2:0] s13s;
  reg [2:0] s13sq;
  reg [7:0] s14;
  wire [2:0] s16s;
  reg [2:0] s16sq;
  wire [2:0] s19s;
  reg [2:0] s19sq;
  reg [2:0] s20;
  wire [2:0] s22s;
  reg [2:0] s22sq;
  reg [2:0] s23;
  wire [2:0] s25s;
  reg [2:0] s25sq;
  reg [3:0] s26;
  wire [2:0] s28s;
  reg [2:0] s28sq;
  reg [3:0] s29;
  wire [2:0] s31s;
  reg [2:0] s31sq;
  wire [2:0] s32s;
  reg [2:0] s32sq;
  wire [2:0] s34s;
  reg [2:0] s34sq;
  reg [DATA_MAX:0] s35;
  wire [2:0] s37s;
  reg [2:0] s37sq;
  wire [2:0] s40s;
  reg [2:0] s40sq;
  reg [STRB_MAX:0] s41;
  wire [2:0] s43s;
  reg [2:0] s43sq;
  wire [2:0] s44s;
  reg [2:0] s44sq;
  wire [2:0] s46s;
  reg [2:0] s46sq;
  reg [ID_MAX:0] s47;
  wire [2:0] s49s;
  reg [2:0] s49sq;
  reg [1:0] s50;
  wire [2:0] s52s;
  reg [2:0] s52sq;
  wire [2:0] s53s;
  reg [2:0] s53sq;
  wire [2:0] s55s;
  reg [2:0] s55sq;
  reg [ADDR_MAX:0] s56;
  wire [2:0] s58s;
  reg [2:0] s58sq;
  reg [1:0] s59;
  wire [2:0] s61s;
  reg [2:0] s61sq;
  reg [3:0] s62;
  wire [2:0] s64s;
  reg [2:0] s64sq;
  reg [ID_MAX:0] s65;
  wire [2:0] s67s;
  reg [2:0] s67sq;
  reg [7:0] s68;
  wire [2:0] s70s;
  reg [2:0] s70sq;
  wire [2:0] s73s;
  reg [2:0] s73sq;
  reg [2:0] s74;
  wire [2:0] s76s;
  reg [2:0] s76sq;
  reg [2:0] s77;
  wire [2:0] s79s;
  reg [2:0] s79sq;
  reg [3:0] s80;
  wire [2:0] s82s;
  reg [2:0] s82sq;
  reg [3:0] s83;
  wire [2:0] s85s;
  reg [2:0] s85sq;
  wire [2:0] s86s;
  reg [2:0] s86sq;
  wire [2:0] s88s;
  reg [2:0] s88sq;
  reg [DATA_MAX:0] s89;
  wire [2:0] s91s;
  reg [2:0] s91sq;
  reg [ID_MAX:0] s92;
  wire [2:0] s94s;
  reg [2:0] s94sq;
  wire [2:0] s97s;
  reg [2:0] s97sq;
  reg [1:0] s98;
  wire [2:0] s100s;
  reg [2:0] s100sq;
  wire [2:0] s101s;
  reg [2:0] s101sq;
  reg [31:0] s103;
  wire [2:0] s105s;
  reg [2:0] s105sq;
  reg [WUSER_MAX:0] s106;
  wire [2:0] s108s;
  reg [2:0] s108sq;
  reg [BUSER_MAX:0] s109;
  wire [2:0] s111s;
  reg [2:0] s111sq;
  reg [ARUSER_MAX:0] s112;
  wire [2:0] s114s;
  reg [2:0] s114sq;
  reg [RUSER_MAX:0] s115;
  wire [2:0] s117s;
  reg [2:0] s117sq;
  reg [AWUSER_MAX:0] s118;
  reg [WUSER_MAX:0] s120;
  reg [BUSER_MAX:0] s122;
  reg [ARUSER_MAX:0] s124;
  reg [RUSER_MAX:0] s126;
  reg [ID_MAX:0] s128;
  reg [ID_MAX:0] s130;
  reg [ID_MAX:0] s132;
  reg [ID_MAX:0] s134;
  wire s3, s6, s9, s12, s15, s18, s21, s24, s27, s30, s36, s39, s42, s48, s51, s57, s60, s63, s66, s69, s72, s75, s78, s81, s84, s90, s93, s96, s99, s104, s107, s110, s113, s116, s119, s121, s123, s125, s127, s129, s131, s133, s135;
  reg ASR_1, ASR_2, ASR_3, ASR_4, ASR_5, ASR_6, ASR_7, ASR_8, ASR_9, ASR_10, ASR_11, ASR_12, ASR_13, ASR_14, s17, ASR_15, ASR_16, ASR_17, ASR_18, ASR_19, ASR_20, ASR_21, ASR_22, ASR_23, ASR_24, ASR_25, s38, ASR_26, ASR_27, ASR_28, ASR_29, ASR_30, ASR_31, ASR_32, ASR_33, ASR_34, ASR_35, ASR_36, ASR_37, ASR_38, ASR_39, ASR_40, ASR_41, ASR_42, ASR_43, ASR_44, ASR_45, ASR_46, ASR_47, ASR_48, ASR_49, ASR_50, ASR_51, s71, ASR_52, ASR_53, ASR_54, ASR_55, ASR_56, ASR_57, ASR_58, ASR_59, ASR_60, ASR_61, ASR_62, ASR_63, ASR_64, s95, ASR_65, ASR_66, ASR_67, ASR_68, ASR_69, ASR_70, ASR_71, ASR_72, ASR_73, ASR_74, ASR_75, ASR_76, ASR_77, ASR_78, ASR_79, ASR_80, ASR_81, ASR_82, ASR_83, ASR_84, ASR_85, ASR_86, ASR_87, ASRX_1, ASRX_2, ASRX_3, ASRX_4;

  assign Axi4PC_asr_inline_out={ASRX_4, ASRX_3, ASRX_2, ASRX_1, ASR_87, ASR_86, ASR_85, ASR_84, ASR_83, ASR_82, ASR_81, ASR_80, ASR_79, ASR_78, ASR_77, ASR_76, ASR_75, ASR_74, ASR_73, ASR_72, ASR_71, ASR_70, ASR_69, ASR_68, ASR_67, ASR_66, ASR_65, ASR_64, ASR_63, ASR_62, ASR_61, ASR_60, ASR_59, ASR_58, ASR_57, ASR_56, ASR_55, ASR_54, ASR_53, ASR_52, ASR_51, ASR_50, ASR_49, ASR_48, ASR_47, ASR_46, ASR_45, ASR_44, ASR_43, ASR_42, ASR_41, ASR_40, ASR_39, ASR_38, ASR_37, ASR_36, ASR_35, ASR_34, ASR_33, ASR_32, ASR_31, ASR_30, ASR_29, ASR_28, ASR_27, ASR_26, ASR_25, ASR_24, ASR_23, ASR_22, ASR_21, ASR_20, ASR_19, ASR_18, ASR_17, ASR_16, ASR_15, ASR_14, ASR_13, ASR_12, ASR_11, ASR_10, ASR_9, ASR_8, ASR_7, ASR_6, ASR_5, ASR_4, ASR_3, ASR_2, ASR_1};

localparam integer L_AW_WAIT_WIDTH = f_clogb2(MAX_AW_WAITS+1);
localparam integer L_AR_WAIT_WIDTH = f_clogb2(MAX_AW_WAITS+1);
localparam integer L_W_WAIT_WIDTH  = f_clogb2(MAX_W_WAITS+1);
localparam integer L_R_WAIT_WIDTH  = f_clogb2(MAX_R_WAITS+1);
localparam integer L_B_WAIT_WIDTH  = f_clogb2(MAX_B_WAITS+1);
localparam integer L_WVALID_WAIT_WIDTH  = f_clogb2(MAX_CONTINUOUS_WTRANSFERS_WAITS+1);
localparam integer L_AWVALID_WAIT_WIDTH  = f_clogb2(MAX_WLAST_TO_AWVALID_WAITS+1);
localparam integer L_BVALID_WAIT_WIDTH  = f_clogb2(MAX_WRITE_TO_BVALID_WAITS+1);
localparam integer L_RVALID_WAIT_WIDTH  = f_clogb2(MAX_CONTINUOUS_RTRANSFERS_WAITS+1);
localparam integer P_W_OUTSTANDING_WIDTH = f_clogb2(MAXWBURSTS);
localparam integer P_R_OUTSTANDING_WIDTH = f_clogb2(MAXRBURSTS);

genvar AWADDR_bit;
genvar WSTRB_bit;
genvar ARADDR_bit;
genvar AWUSER_bit;
genvar WUSER_bit;
genvar BUSER_bit;
genvar ARUSER_bit;
genvar RUSER_bit;

generate

  //---------------
  // BASELINE CHECKS (enabled for all modes)
  //---------------

  //---------------
  //ASR_8 : assert property ( @(posedge ACLK) ( AWVALID |-> ( AwSizeInBits <= DATA_WIDTH ) ) );
  //---------------
  always @(posedge ACLK) if (`AKRPS reset) ASR_8<=0; else
    ASR_8 <= ((AWVALID && !((AwSizeInBits <= DATA_WIDTH))));

  //---------------
  //ASR_21 : assert property ( @(posedge ACLK) ( ARESETn & i_RecommendOn & i_RecMaxWaitOn & ( AWVALID & ! AWREADY ) |-> ##[1:16] ( ! AWVALID | AWREADY ) ) );
  //---------------

  reg [L_AW_WAIT_WIDTH-1:0]  aw_cnt;
  wire asr_21_set;

    if (MAX_AW_WAITS > 0) begin : gen_aw_wait
      always @(posedge ACLK) begin
        if (`AKRPS reset) begin
          aw_cnt <= {L_AW_WAIT_WIDTH{1'b0}};
        end else begin
          //Valid, not ready, clken
          if (((ARESETn & i_RecommendOn) & i_RecMaxWaitOn) & ( AWVALID & ! AWREADY )) begin
            aw_cnt <= aw_cnt + 1;
          end else begin
            aw_cnt <= {L_AW_WAIT_WIDTH{1'b0}};
          end
        end
      end

      assign asr_21_set = (aw_cnt == MAX_AW_WAITS) & (AWVALID & ! AWREADY);
    end else begin : gen_no_aw_wait
      assign asr_21_set = 1'b0;
    end

  always @(posedge ACLK) if (`AKRPS reset) ASR_21<=0; else
    ASR_21 <= asr_21_set;

  //---------------
  //ASR_22 : assert property ( @(posedge ACLK) ( ARESETn |-> ~ WriteDataNumError ) );
  //---------------
  always @(posedge ACLK) if (`AKRPS reset) ASR_22<=0; else
    ASR_22 <= ((ARESETn && WriteDataNumError));

  //---------------
  //ASR_29 : assert property ( @(posedge ACLK) ( ARESETn & i_RecommendOn & i_RecMaxWaitOn & ( WVALID & ! WREADY ) |-> ##[1:16] ( ! WVALID | WREADY ) ) );
  //---------------
  reg [L_W_WAIT_WIDTH-1:0]  w_cnt;
  wire asr_29_set;

    if (MAX_W_WAITS > 0) begin : gen_w_wait
      always @(posedge ACLK) begin
        if (`AKRPS reset) begin
          w_cnt <= {L_W_WAIT_WIDTH{1'b0}};
        end else begin
          //Valid, not ready, clken
          if (((ARESETn & i_RecommendOn) & i_RecMaxWaitOn) & ( WVALID & ! WREADY )) begin
            w_cnt <= w_cnt + 1;
          end else begin
            w_cnt <= {L_W_WAIT_WIDTH{1'b0}};
          end
        end
      end

      assign asr_29_set = (w_cnt == MAX_W_WAITS) & ( WVALID & ! WREADY );
    end else begin : gen_no_w_wait
      assign asr_29_set = 1'b0;
    end

  always @(posedge ACLK) if (`AKRPS reset) ASR_29<=0; else
    ASR_29 <= asr_29_set;

  //---------------
  //ASR_30 : assert property ( @(posedge ACLK) ( ARESETn |-> ~ BrespErrorLast ) );
  //---------------
  always @(posedge ACLK) if (`AKRPS reset) ASR_30<=0; else
    ASR_30 <= ((ARESETn && BrespErrorLast));

  //---------------
  //ASR_33 : assert property ( @(posedge ACLK) ( ARESETn |-> ~ BrespErrorLead ) );
  //---------------
  always @(posedge ACLK) if (`AKRPS reset) ASR_33<=0; else
    ASR_33 <= ((ARESETn && BrespErrorLead));

  //---------------
  //ASR_37 : assert property ( @(posedge ACLK) ( ARESETn & i_RecommendOn & i_RecMaxWaitOn & ( BVALID & ! BREADY ) |-> ##[1:16] ( ! BVALID | BREADY ) ) );
  //---------------
  reg [L_B_WAIT_WIDTH-1:0]  b_cnt;
  wire asr_37_set;

    if (MAX_B_WAITS > 0) begin : gen_b_wait
      always @(posedge ACLK) begin
        if (`AKRPS reset) begin
          b_cnt <= {L_B_WAIT_WIDTH{1'b0}};
        end else begin
          //Valid, not ready, clken
          if (((ARESETn & i_RecommendOn) & i_RecMaxWaitOn) & ( BVALID & ! BREADY )) begin
            b_cnt <= b_cnt + 1;
          end else begin
            b_cnt <= {L_B_WAIT_WIDTH{1'b0}};
          end
        end
      end

      assign asr_37_set = (b_cnt == MAX_B_WAITS) & ( BVALID & ! BREADY );

    end else begin : gen_no_b_wait
      assign asr_37_set = 1'b0;
    end

  always @(posedge ACLK) if (`AKRPS reset) ASR_37<=0; else
    ASR_37 <= asr_37_set;

  //---------------
  //ASR_45 : assert property ( @(posedge ACLK) ( ARVALID |-> ( ArSizeInBits <= DATA_WIDTH ) ) );
  //---------------
  always @(posedge ACLK) if (`AKRPS reset) ASR_45<=0; else
    ASR_45 <= ((ARVALID && !((ArSizeInBits <= DATA_WIDTH))));

  //---------------
  //ASR_58 : assert property ( @(posedge ACLK) ( ARESETn & i_RecommendOn & i_RecMaxWaitOn & ( ARVALID & ! ARREADY ) |-> ##[1:16] ( ! ARVALID | ARREADY ) ) );
  //---------------
  reg [L_AR_WAIT_WIDTH-1:0]  ar_cnt;
  wire asr_58_set;

    if (MAX_AR_WAITS > 0) begin : gen_ar_wait
      always @(posedge ACLK) begin
        if (`AKRPS reset) begin
          ar_cnt <= {L_AR_WAIT_WIDTH{1'b0}};
        end else begin
          //Valid, not ready, clken
          if (((ARESETn & i_RecommendOn) & i_RecMaxWaitOn) & ( ARVALID & ! ARREADY )) begin
            ar_cnt <= ar_cnt + 1;
          end else begin
            ar_cnt <= {L_AR_WAIT_WIDTH{1'b0}};
          end
        end
      end

      assign asr_58_set = (ar_cnt == MAX_AR_WAITS) & ( ARVALID & ! ARREADY );

    end else begin : gen_no_ar_wait
      assign asr_58_set = 1'b0;
    end

  always @(posedge ACLK) if (`AKRPS reset) ASR_58<=0; else
    ASR_58 <= asr_58_set;

  //---------------
  //ASR_59 : assert property ( @(posedge ACLK) ( ARESETn & RVALID & RREADY |-> ( ( ( ArCountPending == ArLenPending ) & RLAST ) | ( ( ArCountPending != ArLenPending ) & ~ RLAST ) ) ) );
  //---------------
  always @(posedge ACLK) if (`AKRPS reset) ASR_59<=0; else
    ASR_59 <= ((ARESETn & RVALID) && !((( (( (ArCountPending == ArLenPending) ) & RLAST) ) | ( (( (ArCountPending != ArLenPending) ) & (~ RLAST)) ))));

  //---------------
  //ASR_60 : assert property ( @(posedge ACLK) ( ARESETn & RVALID |-> ( RidMatch > 0 ) ) );
  //---------------
  always @(posedge ACLK) if (`AKRPS reset) ASR_60<=0; else
    ASR_60 <= (((ARESETn & RVALID) && !((RidMatch > 0))));

  //---------------
  //ASR_68 : assert property ( @(posedge ACLK) ( ARESETn & i_RecommendOn & i_RecMaxWaitOn & ( RVALID & ! RREADY ) |-> ##[1:16] ( ! RVALID | RREADY ) ) );
  //---------------
  reg [L_R_WAIT_WIDTH-1:0]  r_cnt;
  wire asr_68_set;

    if (MAX_R_WAITS > 0) begin : gen_r_wait
      always @(posedge ACLK) begin
        if (`AKRPS reset) begin
          r_cnt <= {L_R_WAIT_WIDTH{1'b0}};
        end else begin
          //Valid, not ready, clken
          if (((ARESETn & i_RecommendOn) & i_RecMaxWaitOn) & ( RVALID & ! RREADY )) begin
            r_cnt <= r_cnt + 1;
          end else begin
            r_cnt <= {L_R_WAIT_WIDTH{1'b0}};
          end
        end
      end

      assign asr_68_set = (r_cnt == MAX_R_WAITS) & ( RVALID & ! RREADY );
    end else begin : gen_no_r_wait
      assign asr_68_set = 1'b0;
    end

  always @(posedge ACLK) if (`AKRPS reset) ASR_68<=0; else
    ASR_68 <= asr_68_set;

  //---------------
  // STALL CHECKS
  //---------------
  
  reg [P_W_OUTSTANDING_WIDTH:0] aw_active;  // Number of AW commands outstanding
  reg [P_W_OUTSTANDING_WIDTH:0] w_active;  // Number of W bursts outstanding
  reg [P_W_OUTSTANDING_WIDTH+1:0] aw_w_active;  // Number of AW commands exceeding W bursts 
  wire aw_push;
  wire w_push;
  wire b_pop;
  
    if (MAX_CONTINUOUS_WTRANSFERS_WAITS>0 || MAX_WLAST_TO_AWVALID_WAITS>0 || MAX_WRITE_TO_BVALID_WAITS>0) begin : gen_w_active
      assign aw_push = AWVALID & AWREADY;
      assign w_push = WVALID & WREADY & WLAST; 
      assign b_pop = BVALID & BREADY;
      always @(posedge ACLK) begin
        if (`AKRPS reset) begin
          aw_active <= {P_W_OUTSTANDING_WIDTH+1{1'b0}};
          w_active <= {P_W_OUTSTANDING_WIDTH+1{1'b0}};
          aw_w_active <= {P_W_OUTSTANDING_WIDTH+2{1'b0}};
        end else begin
          if ((ARESETn & i_RecommendOn) & i_RecMaxWaitOn) begin
            if (aw_push & !b_pop) begin
              aw_active <= aw_active + 1;
            end else if (!aw_push & b_pop) begin
              aw_active <= aw_active - 1;
            end
            if (w_push & !b_pop) begin
              w_active <= w_active + 1;
            end else if (!w_push & b_pop) begin
              w_active <= w_active - 1;
            end
            if (aw_push & !w_push) begin
              aw_w_active <= aw_w_active + 1;
            end else if (!aw_push & w_push) begin
              aw_w_active <= aw_w_active - 1;
            end
          end
        end
      end
    end // gen_w_active
  
  //---------------
  //ASRX_1 : XILINX_RECS_CONTINUOUS_RTRANSFERS_MAX_WAIT : Cycles waiting for RVALID, after AR command, exceeds MAX_CONTINUOUS_RTRANSFERS_WAITS
  //---------------

  reg [L_RVALID_WAIT_WIDTH-1:0]  ar_r_cnt;  // Timer
  reg [P_R_OUTSTANDING_WIDTH-1:0] ar_active;  // Number of AR commands outstanding
  wire asrx_1_set;
  wire ar_push;
  wire r_pop;
  wire ar_r_any_active;

    if (MAX_CONTINUOUS_RTRANSFERS_WAITS > 0) begin : gen_ar_r_wait
      assign ar_push = ARVALID & ARREADY;  // AR command
      assign r_pop = RVALID & RREADY & RLAST;  // R burst completion
      assign ar_r_any_active = |ar_active;  // Positive count value
      always @(posedge ACLK) begin
        if (`AKRPS reset) begin
          ar_r_cnt <= {L_RVALID_WAIT_WIDTH{1'b0}};
          ar_active <= {P_R_OUTSTANDING_WIDTH{1'b0}};
        end else begin
          if ((ARESETn & i_RecommendOn) & i_RecMaxWaitOn) begin
            if (ar_push & !r_pop) begin
              ar_active <= ar_active + 1;
            end else if (!ar_push & r_pop) begin
              ar_active <= ar_active - 1;
            end
            if (ar_r_any_active & ~RVALID) begin  // RVALID stall
              ar_r_cnt <= ar_r_cnt + 1;
            end else begin
              ar_r_cnt <= {L_RVALID_WAIT_WIDTH{1'b0}};
            end
          end
        end
      end

      assign asrx_1_set = (ar_r_cnt == MAX_CONTINUOUS_RTRANSFERS_WAITS);
    end else begin : gen_no_ar_r_wait
      assign asrx_1_set = 1'b0;
    end

  always @(posedge ACLK) if (`AKRPS reset) ASRX_1<=0; else
    ASRX_1 <= asrx_1_set;

  //---------------
  //ASRX_2 : XILINX_RECM_CONTINUOUS_WTRANSFERS_MAX_WAIT : !WVALID cycles, while AW commands outstanding, exceeds MAX_CONTINUOUS_WTRANSFERS_WAITS
  //---------------

  reg [L_WVALID_WAIT_WIDTH-1:0]  aw_w_cnt;  // Timer
  wire asrx_2_set;
  wire aw_w_any_active;

    if (MAX_CONTINUOUS_WTRANSFERS_WAITS > 0) begin : gen_aw_w_wait
      assign aw_w_any_active = !aw_w_active[P_W_OUTSTANDING_WIDTH+1] & |aw_w_active[P_W_OUTSTANDING_WIDTH:0];  // Positive count value
      always @(posedge ACLK) begin
        if (`AKRPS reset) begin
          aw_w_cnt <= {L_WVALID_WAIT_WIDTH{1'b0}};
        end else begin
          if ((ARESETn & i_RecommendOn) & i_RecMaxWaitOn) begin
            if (aw_w_any_active & ~WVALID) begin  // WVALID stalling
              aw_w_cnt <= aw_w_cnt + 1;
            end else begin
              aw_w_cnt <= {L_WVALID_WAIT_WIDTH{1'b0}};
            end
          end
        end
      end

      assign asrx_2_set = (aw_w_cnt == MAX_CONTINUOUS_WTRANSFERS_WAITS);
    end else begin : gen_no_aw_w_wait
      assign asrx_2_set = 1'b0;
    end

  always @(posedge ACLK) if (`AKRPS reset) ASRX_2<=0; else
    ASRX_2 <= asrx_2_set;

  //---------------
  //ASRX_3 : XILINX_RECM_WLAST_TO_AWVALID_MAX_WAIT : Cycles waiting for AWVALID, after W burst already started, exceeds MAX_WLAST_TO_AWVALID_WAITS
  //---------------

  reg [L_AWVALID_WAIT_WIDTH-1:0]  w_aw_cnt;  // Timer
  wire asrx_3_set;
  wire w_aw_any_active;

    if (MAX_WLAST_TO_AWVALID_WAITS > 0) begin : gen_w_aw_wait
      assign w_aw_any_active = aw_w_active[P_W_OUTSTANDING_WIDTH+1];  // Negative count value
      always @(posedge ACLK) begin
        if (`AKRPS reset) begin
          w_aw_cnt <= {L_AWVALID_WAIT_WIDTH{1'b0}};
        end else begin
          if ((ARESETn & i_RecommendOn) & i_RecMaxWaitOn) begin
            if (w_aw_any_active & ~AWVALID) begin  // AWVALID stall
              w_aw_cnt <= w_aw_cnt + 1;
            end else begin
              w_aw_cnt <= {L_AWVALID_WAIT_WIDTH{1'b0}};
            end
          end
        end
      end

      assign asrx_3_set = (w_aw_cnt == MAX_WLAST_TO_AWVALID_WAITS);
    end else begin : gen_no_w_aw_wait
      assign asrx_3_set = 1'b0;
    end

  always @(posedge ACLK) if (`AKRPS reset) ASRX_3<=0; else
    ASRX_3 <= asrx_3_set;

  //---------------
  //ASRX_4 : XILINX_RECS_WRITE_TO_BVALID_MAX_WAIT : Cycles waiting for BVALID, after AW command or W burst completion, exceeds MAX_WRITE_TO_BVALID_WAITS
  //---------------

  reg [L_BVALID_WAIT_WIDTH-1:0]  w_b_cnt;  // Timer
  wire asrx_4_set;
  wire w_b_any_active;

    if (MAX_WRITE_TO_BVALID_WAITS > 0) begin : gen_w_b_wait
      assign w_b_any_active = |aw_active & |w_active;  // Both AW and W outstanding counts >0
      always @(posedge ACLK) begin
        if (`AKRPS reset) begin
          w_b_cnt <= {L_BVALID_WAIT_WIDTH{1'b0}};
        end else begin
          if ((ARESETn & i_RecommendOn) & i_RecMaxWaitOn) begin
            if (w_b_any_active & ~BVALID) begin  // BVALID stall
              w_b_cnt <= w_b_cnt + 1;
            end else begin
              w_b_cnt <= {L_BVALID_WAIT_WIDTH{1'b0}};
            end
          end
        end
      end

      assign asrx_4_set = (w_b_cnt == MAX_WRITE_TO_BVALID_WAITS);
    end else begin : gen_no_w_b_wait
      assign asrx_4_set = 1'b0;
    end

  always @(posedge ACLK) if (`AKRPS reset) ASRX_4<=0; else
    ASRX_4 <= asrx_4_set;

//==================================================================================================================================================

if (LIGHT_WEIGHT==0) begin : gen_deflt_chks
  //---------------
  // DEFAULT CHECKS (disabled in light-weight mode)
  //---------------

  //---------------
  //ASR_1 : assert property ( @(posedge ACLK) ( AWVALID & ( AWBURST == 2'b1 ) |-> ( AwAddrIncr[ADDR_MAX:12] == AWADDR[ADDR_MAX:12] ) ) );
  //---------------
  reg [ADDR_MAX-12:0] AwAddrIncr_q1;
  reg [ADDR_MAX-12:0] AWADDR_q1;
  reg                 asr_1_ctrl;
  always @(posedge ACLK) begin
    AwAddrIncr_q1 <= AwAddrIncr[ADDR_MAX:12];
    AWADDR_q1     <= AWADDR[ADDR_MAX:12];
    asr_1_ctrl   <= (AWVALID & ( (AWBURST == 2'b1) ));
  end

  always @(posedge ACLK) if (`AKRPS reset) ASR_1<=0; else
    ASR_1 <= asr_1_ctrl && !(AwAddrIncr_q1 == AWADDR_q1);

  //---------------
  //ASR_2 : assert property ( @(posedge ACLK) ( AWVALID & ( AWBURST == 2'b10 ) |-> ( ( AWADDR[6:0] & AlignMaskW ) == AWADDR[6:0] ) ) );
  //---------------
  always @(posedge ACLK) if (`AKRPS reset) ASR_2<=0; else
    ASR_2 <= (((AWVALID & ( (AWBURST == 2'b10) )) && !((( (AWADDR[6:0] & AlignMaskW) ) == AWADDR[6:0]))));

  //---------------
  //ASR_3 : assert property ( @(posedge ACLK) ( AWVALID |-> ( AWBURST != 2'b11 ) ) );
  //---------------
  always @(posedge ACLK) if (`AKRPS reset) ASR_3<=0; else
    ASR_3 <= ((AWVALID && !((AWBURST != 2'b11))));

  //---------------
  //ASR_4 : assert property ( @(posedge ACLK) ( AWVALID & AWLEN > 8'b1111 |-> ( AWLOCK != 1'b1 ) ) );
  //---------------
  always @(posedge ACLK) if (`AKRPS reset) ASR_4<=0; else
    ASR_4 <= (((AWVALID & (AWLEN > 8'b1111)) && !((AWLOCK != 1'b1))));

  //---------------
  //ASR_5 : assert property ( @(posedge ACLK) ( AWVALID & ~ AWCACHE[1] |-> ( AWCACHE[3:2] == 2'b0 ) ) );
  //---------------
  always @(posedge ACLK) if (`AKRPS reset) ASR_5<=0; else
    ASR_5 <= (((AWVALID & (~ AWCACHE[1])) && !((AWCACHE[3:2] == 2'b0))));

  //---------------
  //ASR_6 : assert property ( @(posedge ACLK) ( AWVALID & AWLEN > 8'b1111 |-> ( AWBURST != 2'b0 ) ) );
  //---------------
  always @(posedge ACLK) if (`AKRPS reset) ASR_6<=0; else
    ASR_6 <= (((AWVALID & (AWLEN > 8'b1111)) && !((AWBURST != 2'b0))));

  //---------------
  //ASR_7 : assert property ( @(posedge ACLK) ( AWVALID & ( AWBURST == 2'b10 ) |-> ( AWLEN == 8'b1 || AWLEN == 8'b11 || AWLEN == 8'b111 || AWLEN == 8'b1111 ) ) );
  //---------------
  always @(posedge ACLK) if (`AKRPS reset) ASR_7<=0; else
    ASR_7 <= (((AWVALID & ( (AWBURST == 2'b10) )) && !(((((AWLEN == 8'b1) || (AWLEN == 8'b11)) || (AWLEN == 8'b111)) || (AWLEN == 8'b1111)))));

  //---------------
  //ASR_9 : assert property ( @(posedge ACLK) ( ! ( ARESETn ) ##1 ARESETn |-> ! AWVALID ) );
  //---------------
  always @(posedge ACLK) if (`AKRPS reset) s1sq<=3'h4; else
    s1sq<=s1s;
  assign s1s={1'b1,
    !(ARESETn),
    (s1sq[1] && (ARESETn && AWVALID))};
  always @(posedge ACLK) if (`AKRPS reset) ASR_9<=0; else
    ASR_9 <= (s1s[0]);

  //---------------
  //ASR_10 : assert property ( @(posedge ACLK) ( ARESETn & AWVALID & ! AWREADY ##1 ARESETn |-> $stable(AWADDR) ) );
  //---------------
//  always @(posedge ACLK)
//    s2<=AWADDR;
//  assign s3 = s2 == AWADDR;
//  always @(posedge ACLK) if (`AKRPS reset) s4sq<=3'h4; else
//    s4sq<=s4s;
//  assign s4s={1'b1,
//    ((ARESETn & AWVALID) & (! AWREADY)),
//    (s4sq[1] && (ARESETn && !(s3)))};
//  always @(posedge ACLK) if (`AKRPS reset) ASR_10<=0; else
//    ASR_10 <= (s4s[0]);
localparam integer L_NUM_AWADDR_BYTES       = ((ADDR_WIDTH + 7) / 8);
localparam integer L_NUM_AWADDR_BYTE_LANES  = ((L_NUM_AWADDR_BYTES + 7) / 8) * 8;
localparam integer L_NUM_AWADDR_EQ_LANES    = (L_NUM_AWADDR_BYTE_LANES / 8);
localparam integer L_NUM_AWADDR_AND1_LANES  = (L_NUM_AWADDR_EQ_LANES + 7) / 8;
localparam integer L_NUM_AWADDR_AND2_LANES  = (L_NUM_AWADDR_AND1_LANES + 7) / 8;

reg   [ADDR_WIDTH - 1:0]  AWADDR_q;
reg   [4:0]               s_AWADDR_sq;
wire  [4:0]               s_AWADDR_s;
wire                      s_AWADDR_sqaa;

reg [(8*L_NUM_AWADDR_EQ_LANES)-1:0]    AWADDR_eq;
reg [(8*L_NUM_AWADDR_AND1_LANES)-1:0]  AWADDR_stage_1_eq;
reg [(8*L_NUM_AWADDR_AND2_LANES)-1:0]  AWADDR_stage_2_eq;

always @(posedge ACLK) begin
  if (`AKRPS reset) begin
    s_AWADDR_sq<=5'h00; 
    ASR_10 <=0;
  end else begin
    s_AWADDR_sq<=s_AWADDR_s;
    ASR_10 <= (s_AWADDR_s[0]);
  end
end

assign s_AWADDR_s={
  (((ARESETn & AWVALID) & (! AWREADY))),
  (s_AWADDR_sq[4] && ARESETn),
  (s_AWADDR_sq[3]),
  (s_AWADDR_sq[2]),
  (s_AWADDR_sq[1] & !(s_AWADDR_sqaa))
  };

assign s_AWADDR_sqaa = &AWADDR_stage_2_eq;

wire  [(L_NUM_AWADDR_BYTES*8)-1:0]      AWADDR_expand;
wire  [(L_NUM_AWADDR_BYTES*8)-1:0]      AWADDRsqa_expand;
  ///////////////////////////////////////////////////////////////////////////////////////////
  //Expand the AWADDR up to the nearest byte
  for (AWADDR_bit = 0; AWADDR_bit < (L_NUM_AWADDR_BYTES * 8); AWADDR_bit = AWADDR_bit + 1) begin : AWADDR_BIT_LOOP
    if (AWADDR_bit < ADDR_WIDTH) begin : VAL
      assign AWADDR_expand[AWADDR_bit] = AWADDR[AWADDR_bit];
      assign AWADDRsqa_expand[AWADDR_bit] = AWADDR_q[AWADDR_bit];
    end else begin
      assign AWADDR_expand[AWADDR_bit] = 1'b0;
      assign AWADDRsqa_expand[AWADDR_bit] = 1'b0;
    end
  end

integer AWADDR_bc;
integer AWADDR_stage_1;
integer AWADDR_stage_2;

always @(posedge ACLK) begin
  AWADDR_q<=AWADDR;

  for (AWADDR_bc = 0; AWADDR_bc < L_NUM_AWADDR_EQ_LANES*8; AWADDR_bc = AWADDR_bc + 1) begin : AWADDR_BC_LOOP
    if (AWADDR_bc < L_NUM_AWADDR_BYTES) begin
      AWADDR_eq[AWADDR_bc] <= AWADDR_expand[AWADDR_bc*8 +:8] == AWADDRsqa_expand[AWADDR_bc*8 +: 8];
    end else begin
      AWADDR_eq[AWADDR_bc] <= 1'b1;
    end
  end

  for (AWADDR_stage_1 = 0; AWADDR_stage_1 < L_NUM_AWADDR_AND1_LANES * 8;AWADDR_stage_1 = AWADDR_stage_1 + 1) begin : AWADDR_S1
    if (AWADDR_stage_1 < L_NUM_AWADDR_EQ_LANES) begin
      AWADDR_stage_1_eq[AWADDR_stage_1] <= &AWADDR_eq[AWADDR_stage_1*8 +:8];
    end else begin
      AWADDR_stage_1_eq[AWADDR_stage_1] <= 1'b1;
    end
  end

  for (AWADDR_stage_2 = 0; AWADDR_stage_2 < L_NUM_AWADDR_AND2_LANES * 8;AWADDR_stage_2 = AWADDR_stage_2 + 1) begin : AWADDR_S2
    if (AWADDR_stage_2 < L_NUM_AWADDR_AND1_LANES) begin
      AWADDR_stage_2_eq[AWADDR_stage_2] <= &AWADDR_stage_1_eq[AWADDR_stage_2*8 +:8];
    end else begin
      AWADDR_stage_2_eq[AWADDR_stage_2] <= 1'b1;
    end
  end

end

  //---------------
  //ASR_11 : assert property ( @(posedge ACLK) ( ARESETn & AWVALID & ! AWREADY ##1 ARESETn |-> $stable(AWBURST) ) );
  //---------------
  always @(posedge ACLK)
    s5<=AWBURST;
  assign s6 = s5 == AWBURST;
  always @(posedge ACLK) if (`AKRPS reset) s7sq<=3'h4; else
    s7sq<=s7s;
  assign s7s={1'b1,
    ((ARESETn & AWVALID) & (! AWREADY)),
    (s7sq[1] && (ARESETn && !(s6)))};
  always @(posedge ACLK) if (`AKRPS reset) ASR_11<=0; else
    ASR_11 <= (s7s[0]);

  //---------------
  //ASR_12 : assert property ( @(posedge ACLK) ( ARESETn & AWVALID & ! AWREADY ##1 ARESETn |-> $stable(AWCACHE) ) );
  //---------------
  always @(posedge ACLK)
    s8<=AWCACHE;
  assign s9 = s8 == AWCACHE;
  always @(posedge ACLK) if (`AKRPS reset) s10sq<=3'h4; else
    s10sq<=s10s;
  assign s10s={1'b1,
    ((ARESETn & AWVALID) & (! AWREADY)),
    (s10sq[1] && (ARESETn && !(s9)))};
  always @(posedge ACLK) if (`AKRPS reset) ASR_12<=0; else
    ASR_12 <= (s10s[0]);

  //---------------
  //ASR_13 : assert property ( @(posedge ACLK) ( ARESETn & AWVALID & ! AWREADY ##1 ARESETn |-> $stable(AWID) ) );
  //---------------
  always @(posedge ACLK)
    s11<=AWID;
  assign s12 = s11 == AWID;
  always @(posedge ACLK) if (`AKRPS reset) s13sq<=3'h4; else
    s13sq<=s13s;
  assign s13s={1'b1,
    ((ARESETn & AWVALID) & (! AWREADY)),
    (s13sq[1] && (ARESETn && !(s12)))};
  always @(posedge ACLK) if (`AKRPS reset) ASR_13<=0; else
    ASR_13 <= (s13s[0]);

  //---------------
  //ASR_14 : assert property ( @(posedge ACLK) ( ARESETn & AWVALID & ! AWREADY ##1 ARESETn |-> $stable(AWLEN) ) );
  //---------------
  always @(posedge ACLK)
    s14<=AWLEN;
  assign s15 = s14 == AWLEN;
  always @(posedge ACLK) if (`AKRPS reset) s16sq<=3'h4; else
    s16sq<=s16s;
  assign s16s={1'b1,
    ((ARESETn & AWVALID) & (! AWREADY)),
    (s16sq[1] && (ARESETn && !(s15)))};
  always @(posedge ACLK) if (`AKRPS reset) ASR_14<=0; else
    ASR_14 <= (s16s[0]);

  //---------------
  //ASR_15 : assert property ( @(posedge ACLK) ( ARESETn & AWVALID & ! AWREADY ##1 ARESETn |-> $stable(AWLOCK) ) );
  //---------------
  always @(posedge ACLK)
    s17<=AWLOCK;
  assign s18 = s17 == AWLOCK;
  always @(posedge ACLK) if (`AKRPS reset) s19sq<=3'h4; else
    s19sq<=s19s;
  assign s19s={1'b1,
    ((ARESETn & AWVALID) & (! AWREADY)),
    (s19sq[1] && (ARESETn && !(s18)))};
  always @(posedge ACLK) if (`AKRPS reset) ASR_15<=0; else
    ASR_15 <= (s19s[0]);

  //---------------
  //ASR_16 : assert property ( @(posedge ACLK) ( ARESETn & AWVALID & ! AWREADY ##1 ARESETn |-> $stable(AWPROT) ) );
  //---------------
  always @(posedge ACLK)
    s20<=AWPROT;
  assign s21 = s20 == AWPROT;
  always @(posedge ACLK) if (`AKRPS reset) s22sq<=3'h4; else
    s22sq<=s22s;
  assign s22s={1'b1,
    ((ARESETn & AWVALID) & (! AWREADY)),
    (s22sq[1] && (ARESETn && !(s21)))};
  always @(posedge ACLK) if (`AKRPS reset) ASR_16<=0; else
    ASR_16 <= (s22s[0]);

  //---------------
  //ASR_17 : assert property ( @(posedge ACLK) ( ARESETn & AWVALID & ! AWREADY ##1 ARESETn |-> $stable(AWSIZE) ) );
  //---------------
  always @(posedge ACLK)
    s23<=AWSIZE;
  assign s24 = s23 == AWSIZE;
  always @(posedge ACLK) if (`AKRPS reset) s25sq<=3'h4; else
    s25sq<=s25s;
  assign s25s={1'b1,
    ((ARESETn & AWVALID) & (! AWREADY)),
    (s25sq[1] && (ARESETn && !(s24)))};
  always @(posedge ACLK) if (`AKRPS reset) ASR_17<=0; else
    ASR_17 <= (s25s[0]);

  //---------------
  //ASR_18 : assert property ( @(posedge ACLK) ( ARESETn & AWVALID & ! AWREADY ##1 ARESETn |-> $stable(AWQOS) ) );
  //---------------
  always @(posedge ACLK)
    s26<=AWQOS;
  assign s27 = s26 == AWQOS;
  always @(posedge ACLK) if (`AKRPS reset) s28sq<=3'h4; else
    s28sq<=s28s;
  assign s28s={1'b1,
    ((ARESETn & AWVALID) & (! AWREADY)),
    (s28sq[1] && (ARESETn && !(s27)))};
  always @(posedge ACLK) if (`AKRPS reset) ASR_18<=0; else
    ASR_18 <= (s28s[0]);

  //---------------
  //ASR_19 : assert property ( @(posedge ACLK) ( ARESETn & AWVALID & ! AWREADY ##1 ARESETn |-> $stable(AWREGION) ) );
  //---------------
  always @(posedge ACLK)
    s29<=AWREGION;
  assign s30 = s29 == AWREGION;
  always @(posedge ACLK) if (`AKRPS reset) s31sq<=3'h4; else
    s31sq<=s31s;
  assign s31s={1'b1,
    ((ARESETn & AWVALID) & (! AWREADY)),
    (s31sq[1] && (ARESETn && !(s30)))};
  always @(posedge ACLK) if (`AKRPS reset) ASR_19<=0; else
    ASR_19 <= (s31s[0]);

  //---------------
  //ASR_20 : assert property ( @(posedge ACLK) ( ARESETn & AWVALID & ! AWREADY ##1 ARESETn |-> AWVALID ) );
  //---------------
  always @(posedge ACLK) if (`AKRPS reset) s32sq<=3'h4; else
    s32sq<=s32s;
  assign s32s={1'b1,
    ((ARESETn & AWVALID) & (! AWREADY)),
    (s32sq[1] && (ARESETn && !(AWVALID)))};
  always @(posedge ACLK) if (`AKRPS reset) ASR_20<=0; else
    ASR_20 <= (s32s[0]);

  //---------------
  //ASR_23 : assert property ( @(posedge ACLK) ( ARESETn |-> ~ BStrbError ) );
  //---------------
  always @(posedge ACLK) if (`AKRPS reset) ASR_23<=0; else
    ASR_23 <= ((ARESETn && BStrbError));

  //---------------
  //ASR_24 : assert property ( @(posedge ACLK) ( ! ( ARESETn ) ##1 ARESETn |-> ! WVALID ) );
  //---------------
  always @(posedge ACLK) if (`AKRPS reset) s34sq<=3'h4; else
    s34sq<=s34s;
  assign s34s={1'b1,
    !(ARESETn),
    (s34sq[1] && (ARESETn && WVALID))};
  always @(posedge ACLK) if (`AKRPS reset) ASR_24<=0; else
    ASR_24 <= (s34s[0]);

  //---------------
  //ASR_25 : assert property ( @(posedge ACLK) ( ARESETn & WVALID & ! WREADY ##1 ARESETn |-> $stable(WDATA) ) );
//  //---------------
//  always @(posedge ACLK)
//    s35<=WDATA;
//  assign s36 = s35 == WDATA;
//  always @(posedge ACLK) if (`AKRPS reset) s37sq<=3'h4; else
//    s37sq<=s37s;
//  assign s37s={1'b1,
//    ((ARESETn & WVALID) & (! WREADY)),
//    (s37sq[1] && (ARESETn && !(s36)))};
//  always @(posedge ACLK) if (`AKRPS reset) ASR_25<=0; else
//    ASR_25 <= (s37s[0]);

localparam integer L_NUM_WDATA_BYTES       = ((DATA_WIDTH + 7) / 8);
localparam integer L_NUM_WDATA_BYTE_LANES  = ((L_NUM_WDATA_BYTES + 7) / 8) * 8;
localparam integer L_NUM_WDATA_EQ_LANES    = (L_NUM_WDATA_BYTE_LANES / 8);
localparam integer L_NUM_WDATA_AND1_LANES  = (L_NUM_WDATA_EQ_LANES + 7) / 8;
localparam integer L_NUM_WDATA_AND2_LANES  = (L_NUM_WDATA_AND1_LANES + 7) / 8;

reg   [DATA_WIDTH - 1:0]  WDATA_q;
reg   [4:0]               s_WDATA_sq;
wire  [4:0]               s_WDATA_s;
wire                      s_WDATA_sqaa;

reg [(8*L_NUM_WDATA_EQ_LANES)-1:0]    WDATA_eq;
reg [(8*L_NUM_WDATA_AND1_LANES)-1:0]  WDATA_stage_1_eq;
reg [(8*L_NUM_WDATA_AND2_LANES)-1:0]  WDATA_stage_2_eq;

always @(posedge ACLK) begin
  if (`AKRPS reset) begin
    s_WDATA_sq<=5'h00; 
    ASR_25 <=0;
  end else begin
    s_WDATA_sq<=s_WDATA_s;
    ASR_25 <= (s_WDATA_s[0]);
  end
end

assign s_WDATA_s={
  (((ARESETn & WVALID) & (! WREADY))),
  (s_WDATA_sq[4] && ARESETn),
  (s_WDATA_sq[3]),
  (s_WDATA_sq[2]),
  (s_WDATA_sq[1] & !(s_WDATA_sqaa))
  };

assign s_WDATA_sqaa = &WDATA_stage_2_eq;

integer WDATA_bc;
integer WDATA_stage_1;
integer WDATA_stage_2;

always @(posedge ACLK) begin
  WDATA_q<=WDATA;

  for (WDATA_bc = 0; WDATA_bc < L_NUM_WDATA_EQ_LANES*8; WDATA_bc = WDATA_bc + 1) begin : WDATA_BC_LOOP
    if (WDATA_bc < L_NUM_WDATA_BYTES) begin
      WDATA_eq[WDATA_bc] <= WDATA_q[WDATA_bc*8 +:8] == WDATA[WDATA_bc*8 +: 8];
    end else begin
      WDATA_eq[WDATA_bc] <= 1'b1;
    end
  end

  for (WDATA_stage_1 = 0; WDATA_stage_1 < L_NUM_WDATA_AND1_LANES * 8;WDATA_stage_1 = WDATA_stage_1 + 1) begin : WDATA_S1
    if (WDATA_stage_1 < L_NUM_WDATA_EQ_LANES) begin
      WDATA_stage_1_eq[WDATA_stage_1] <= &WDATA_eq[WDATA_stage_1*8 +:8];
    end else begin
      WDATA_stage_1_eq[WDATA_stage_1] <= 1'b1;
    end
  end

  for (WDATA_stage_2 = 0; WDATA_stage_2 < L_NUM_WDATA_AND2_LANES * 8;WDATA_stage_2 = WDATA_stage_2 + 1) begin : WDATA_S2
    if (WDATA_stage_2 < L_NUM_WDATA_AND1_LANES) begin
      WDATA_stage_2_eq[WDATA_stage_2] <= &WDATA_stage_1_eq[WDATA_stage_2*8 +:8];
    end else begin
      WDATA_stage_2_eq[WDATA_stage_2] <= 1'b1;
    end
  end

end


  //---------------
  //ASR_26 : assert property ( @(posedge ACLK) ( ARESETn & WVALID & ! WREADY ##1 ARESETn |-> $stable(WLAST) ) );
  //---------------
  always @(posedge ACLK)
    s38<=WLAST;
  assign s39 = s38 == WLAST;
  always @(posedge ACLK) if (`AKRPS reset) s40sq<=3'h4; else
    s40sq<=s40s;
  assign s40s={1'b1,
    ((ARESETn & WVALID) & (! WREADY)),
    (s40sq[1] && (ARESETn && !(s39)))};
  always @(posedge ACLK) if (`AKRPS reset) ASR_26<=0; else
    ASR_26 <= (s40s[0]);

  //---------------
  //ASR_27 : assert property ( @(posedge ACLK) ( ARESETn & WVALID & ! WREADY ##1 ARESETn |-> $stable(WSTRB) ) );
  //---------------
//  always @(posedge ACLK)
//    s41<=WSTRB;
//  assign s42 = s41 == WSTRB;
//  always @(posedge ACLK) if (`AKRPS reset) s43sq<=3'h4; else
//    s43sq<=s43s;
//  assign s43s={1'b1,
//    ((ARESETn & WVALID) & (! WREADY)),
//    (s43sq[1] && (ARESETn && !(s42)))};
//  always @(posedge ACLK) if (`AKRPS reset) ASR_27<=0; else
//    ASR_27 <= (s43s[0]);
localparam integer L_NUM_WSTRB_BYTES       = (((DATA_WIDTH/8) + 7) / 8);
localparam integer L_NUM_WSTRB_BYTE_LANES  = ((L_NUM_WSTRB_BYTES + 7) / 8) * 8;
localparam integer L_NUM_WSTRB_EQ_LANES    = (L_NUM_WSTRB_BYTE_LANES / 8);
localparam integer L_NUM_WSTRB_AND1_LANES  = (L_NUM_WSTRB_EQ_LANES + 7) / 8;
localparam integer L_NUM_WSTRB_AND2_LANES  = (L_NUM_WSTRB_AND1_LANES + 7) / 8;

reg   [(DATA_WIDTH/8) - 1:0] WSTRB_q;
reg   [4:0]               s_WSTRB_sq;
wire  [4:0]               s_WSTRB_s;
wire                      s_WSTRB_sqaa;

reg [(8*L_NUM_WSTRB_EQ_LANES)-1:0]    WSTRB_eq;
reg [(8*L_NUM_WSTRB_AND1_LANES)-1:0]  WSTRB_stage_1_eq;
reg [(8*L_NUM_WSTRB_AND2_LANES)-1:0]  WSTRB_stage_2_eq;

always @(posedge ACLK) begin
  if (`AKRPS reset) begin
    s_WSTRB_sq<=5'h00; 
    ASR_27 <=0;
  end else begin
    s_WSTRB_sq<=s_WSTRB_s;
    ASR_27 <= (s_WSTRB_s[0]);
  end
end

assign s_WSTRB_s={
  (((ARESETn & WVALID) & (! WREADY))),
  (s_WSTRB_sq[4] && ARESETn),
  (s_WSTRB_sq[3]),
  (s_WSTRB_sq[2]),
  (s_WSTRB_sq[1] & !(s_WSTRB_sqaa))
  };

assign s_WSTRB_sqaa = &WSTRB_stage_2_eq;

wire  [(L_NUM_WSTRB_BYTES*8)-1:0]      WSTRB_expand;
wire  [(L_NUM_WSTRB_BYTES*8)-1:0]      WSTRBsqa_expand;
  ///////////////////////////////////////////////////////////////////////////////////////////
  //Expand the WSTRB up to the nearest byte
  for (WSTRB_bit = 0; WSTRB_bit < (L_NUM_WSTRB_BYTES * 8); WSTRB_bit = WSTRB_bit + 1) begin : WSTRB_BIT_LOOP
    if (WSTRB_bit < (DATA_WIDTH/8)) begin : VAL
      assign WSTRB_expand[WSTRB_bit] = WSTRB[WSTRB_bit];
      assign WSTRBsqa_expand[WSTRB_bit] = WSTRB_q[WSTRB_bit];
    end else begin
      assign WSTRB_expand[WSTRB_bit] = 1'b0;
      assign WSTRBsqa_expand[WSTRB_bit] = 1'b0;
    end
  end

integer WSTRB_bc;
integer WSTRB_stage_1;
integer WSTRB_stage_2;

always @(posedge ACLK) begin
  WSTRB_q<=WSTRB;

  for (WSTRB_bc = 0; WSTRB_bc < L_NUM_WSTRB_EQ_LANES*8; WSTRB_bc = WSTRB_bc + 1) begin : WSTRB_BC_LOOP
    if (WSTRB_bc < L_NUM_WSTRB_BYTES) begin
      WSTRB_eq[WSTRB_bc] <= WSTRB_expand[WSTRB_bc*8 +:8] == WSTRBsqa_expand[WSTRB_bc*8 +: 8];
    end else begin
      WSTRB_eq[WSTRB_bc] <= 1'b1;
    end
  end

  for (WSTRB_stage_1 = 0; WSTRB_stage_1 < L_NUM_WSTRB_AND1_LANES * 8;WSTRB_stage_1 = WSTRB_stage_1 + 1) begin : WSTRB_S1
    if (WSTRB_stage_1 < L_NUM_WSTRB_EQ_LANES) begin
      WSTRB_stage_1_eq[WSTRB_stage_1] <= &WSTRB_eq[WSTRB_stage_1*8 +:8];
    end else begin
      WSTRB_stage_1_eq[WSTRB_stage_1] <= 1'b1;
    end
  end

  for (WSTRB_stage_2 = 0; WSTRB_stage_2 < L_NUM_WSTRB_AND2_LANES * 8;WSTRB_stage_2 = WSTRB_stage_2 + 1) begin : WSTRB_S2
    if (WSTRB_stage_2 < L_NUM_WSTRB_AND1_LANES) begin
      WSTRB_stage_2_eq[WSTRB_stage_2] <= &WSTRB_stage_1_eq[WSTRB_stage_2*8 +:8];
    end else begin
      WSTRB_stage_2_eq[WSTRB_stage_2] <= 1'b1;
    end
  end

end

  //---------------
  //ASR_28 : assert property ( @(posedge ACLK) ( ARESETn & WVALID & ! WREADY ##1 ARESETn |-> WVALID ) );
  //---------------
  always @(posedge ACLK) if (`AKRPS reset) s44sq<=3'h4; else
    s44sq<=s44s;
  assign s44s={1'b1,
    ((ARESETn & WVALID) & (! WREADY)),
    (s44sq[1] && (ARESETn && !(WVALID)))};
  always @(posedge ACLK) if (`AKRPS reset) ASR_28<=0; else
    ASR_28 <= (s44s[0]);

  //---------------
  //ASR_31 : assert property ( @(posedge ACLK) ( ARESETn |-> ~ BrespExokError ) );
  //---------------
  always @(posedge ACLK) if (`AKRPS reset) ASR_31<=0; else
    ASR_31 <= ((ARESETn && BrespExokError));

  //---------------
  //ASR_32 : assert property ( @(posedge ACLK) ( ! ( ARESETn ) ##1 ARESETn |-> ! BVALID ) );
  //---------------
  always @(posedge ACLK) if (`AKRPS reset) s46sq<=3'h4; else
    s46sq<=s46s;
  assign s46s={1'b1,
    !(ARESETn),
    (s46sq[1] && (ARESETn && BVALID))};
  always @(posedge ACLK) if (`AKRPS reset) ASR_32<=0; else
    ASR_32 <= (s46s[0]);

  //---------------
  //ASR_34 : assert property ( @(posedge ACLK) ( ARESETn & BVALID & ! BREADY ##1 ARESETn |-> $stable(BID) ) );
  //---------------
  always @(posedge ACLK)
    s47<=BID;
  assign s48 = s47 == BID;
  always @(posedge ACLK) if (`AKRPS reset) s49sq<=3'h4; else
    s49sq<=s49s;
  assign s49s={1'b1,
    ((ARESETn & BVALID) & (! BREADY)),
    (s49sq[1] && (ARESETn && !(s48)))};
  always @(posedge ACLK) if (`AKRPS reset) ASR_34<=0; else
    ASR_34 <= (s49s[0]);

  //---------------
  //ASR_35 : assert property ( @(posedge ACLK) ( ARESETn & BVALID & ! BREADY ##1 ARESETn |-> $stable(BRESP) ) );
  //---------------
  always @(posedge ACLK)
    s50<=BRESP;
  assign s51 = s50 == BRESP;
  always @(posedge ACLK) if (`AKRPS reset) s52sq<=3'h4; else
    s52sq<=s52s;
  assign s52s={1'b1,
    ((ARESETn & BVALID) & (! BREADY)),
    (s52sq[1] && (ARESETn && !(s51)))};
  always @(posedge ACLK) if (`AKRPS reset) ASR_35<=0; else
    ASR_35 <= (s52s[0]);

  //---------------
  //ASR_36 : assert property ( @(posedge ACLK) ( ARESETn & BVALID & ! BREADY ##1 ARESETn |-> BVALID ) );
  //---------------
  always @(posedge ACLK) if (`AKRPS reset) s53sq<=3'h4; else
    s53sq<=s53s;
  assign s53s={1'b1,
    ((ARESETn & BVALID) & (! BREADY)),
    (s53sq[1] && (ARESETn && !(BVALID)))};
  always @(posedge ACLK) if (`AKRPS reset) ASR_36<=0; else
    ASR_36 <= (s53s[0]);

  //---------------
  //ASR_38 : assert property ( @(posedge ACLK) ( ARVALID & ( ARBURST == 2'b1 ) |-> ( ArAddrIncr[ADDR_MAX:12] == ARADDR[ADDR_MAX:12] ) ) );
  //---------------
  reg [ADDR_MAX-12:0] ArAddrIncr_q1;
  reg [ADDR_MAX-12:0] ARADDR_q1;
  reg                 asr_38_ctrl;
  
  always @(posedge ACLK) begin
    ArAddrIncr_q1 <= ArAddrIncr[ADDR_MAX:12];
    ARADDR_q1     <= ARADDR[ADDR_MAX:12];
    asr_38_ctrl   <= (ARVALID & ( (ARBURST == 2'b1) ));
  end
  
  always @(posedge ACLK) if (`AKRPS reset) ASR_38<=0; else
    ASR_38 <= asr_38_ctrl && !(ArAddrIncr_q1 == ARADDR_q1);

  //---------------
  //ASR_39 : assert property ( @(posedge ACLK) ( ARVALID & ( ARBURST == 2'b10 ) |-> ( ( ARADDR[6:0] & AlignMaskR ) == ARADDR[6:0] ) ) );
  //---------------
  always @(posedge ACLK) if (`AKRPS reset) ASR_39<=0; else
    ASR_39 <= (((ARVALID & ( (ARBURST == 2'b10) )) && !((( (ARADDR[6:0] & AlignMaskR) ) == ARADDR[6:0]))));

  //---------------
  //ASR_40 : assert property ( @(posedge ACLK) ( ARVALID |-> ( ARBURST != 2'b11 ) ) );
  //---------------
  always @(posedge ACLK) if (`AKRPS reset) ASR_40<=0; else
    ASR_40 <= ((ARVALID && !((ARBURST != 2'b11))));

  //---------------
  //ASR_41 : assert property ( @(posedge ACLK) ( ARVALID & ARLEN > 8'b1111 |-> ( ARLOCK != 1'b1 ) ) );
  //---------------
  always @(posedge ACLK) if (`AKRPS reset) ASR_41<=0; else
    ASR_41 <= (((ARVALID & (ARLEN > 8'b1111)) && !((ARLOCK != 1'b1))));

  //---------------
  //ASR_42 : assert property ( @(posedge ACLK) ( ARVALID & ~ ARCACHE[1] |-> ( ARCACHE[3:2] == 2'b0 ) ) );
  //---------------
  always @(posedge ACLK) if (`AKRPS reset) ASR_42<=0; else
    ASR_42 <= (((ARVALID & (~ ARCACHE[1])) && !((ARCACHE[3:2] == 2'b0))));

  //---------------
  //ASR_43 : assert property ( @(posedge ACLK) ( ARVALID & ARLEN > 8'b1111 |-> ( ARBURST != 2'b0 ) ) );
  //---------------
  always @(posedge ACLK) if (`AKRPS reset) ASR_43<=0; else
    ASR_43 <= (((ARVALID & (ARLEN > 8'b1111)) && !((ARBURST != 2'b0))));

  //---------------
  //ASR_44 : assert property ( @(posedge ACLK) ( ARVALID & ( ARBURST == 2'b10 ) |-> ( ARLEN == 8'b1 || ARLEN == 8'b11 || ARLEN == 8'b111 || ARLEN == 8'b1111 ) ) );
  //---------------
  always @(posedge ACLK) if (`AKRPS reset) ASR_44<=0; else
    ASR_44 <= (((ARVALID & ( (ARBURST == 2'b10) )) && !(((((ARLEN == 8'b1) || (ARLEN == 8'b11)) || (ARLEN == 8'b111)) || (ARLEN == 8'b1111)))));

  //---------------
  //ASR_46 : assert property ( @(posedge ACLK) ( ! ( ARESETn ) ##1 ARESETn |-> ! ARVALID ) );
  //---------------
  always @(posedge ACLK) if (`AKRPS reset) s55sq<=3'h4; else
    s55sq<=s55s;
  assign s55s={1'b1,
    !(ARESETn),
    (s55sq[1] && (ARESETn && ARVALID))};
  always @(posedge ACLK) if (`AKRPS reset) ASR_46<=0; else
    ASR_46 <= (s55s[0]);

  //---------------
  //ASR_47 : assert property ( @(posedge ACLK) ( ARESETn & ARVALID & ! ARREADY ##1 ARESETn |-> $stable(ARADDR) ) );
  //---------------
//  always @(posedge ACLK)
//    s56<=ARADDR;
//  assign s57 = s56 == ARADDR;
//  always @(posedge ACLK) if (`AKRPS reset) s58sq<=3'h4; else
//    s58sq<=s58s;
//  assign s58s={1'b1,
//    ((ARESETn & ARVALID) & (! ARREADY)),
//    (s58sq[1] && (ARESETn && !(s57)))};
//  always @(posedge ACLK) if (`AKRPS reset) ASR_47<=0; else
//    ASR_47 <= (s58s[0]);
localparam integer L_NUM_ARADDR_BYTES       = ((ADDR_WIDTH + 7) / 8);
localparam integer L_NUM_ARADDR_BYTE_LANES  = ((L_NUM_ARADDR_BYTES + 7) / 8) * 8;
localparam integer L_NUM_ARADDR_EQ_LANES    = (L_NUM_ARADDR_BYTE_LANES / 8);
localparam integer L_NUM_ARADDR_AND1_LANES  = (L_NUM_ARADDR_EQ_LANES + 7) / 8;
localparam integer L_NUM_ARADDR_AND2_LANES  = (L_NUM_ARADDR_AND1_LANES + 7) / 8;

reg   [ADDR_WIDTH - 1:0] ARADDR_q;
reg   [4:0]               s_ARADDR_sq;
wire  [4:0]               s_ARADDR_s;
wire                      s_ARADDR_sqaa;

reg [(8*L_NUM_ARADDR_EQ_LANES)-1:0]    ARADDR_eq;
reg [(8*L_NUM_ARADDR_AND1_LANES)-1:0]  ARADDR_stage_1_eq;
reg [(8*L_NUM_ARADDR_AND2_LANES)-1:0]  ARADDR_stage_2_eq;

always @(posedge ACLK) begin
  if (`AKRPS reset) begin
    s_ARADDR_sq<=5'h00; 
    ASR_47 <=0;
  end else begin
    s_ARADDR_sq<=s_ARADDR_s;
    ASR_47 <= (s_ARADDR_s[0]);
  end
end

assign s_ARADDR_s={
  (((ARESETn & ARVALID) & (! ARREADY))),
  (s_ARADDR_sq[4] && ARESETn),
  (s_ARADDR_sq[3]),
  (s_ARADDR_sq[2]),
  (s_ARADDR_sq[1] & !(s_ARADDR_sqaa))
  };

assign s_ARADDR_sqaa = &ARADDR_stage_2_eq;

wire  [(L_NUM_ARADDR_BYTES*8)-1:0]      ARADDR_expand;
wire  [(L_NUM_ARADDR_BYTES*8)-1:0]      ARADDRsqa_expand;
  ///////////////////////////////////////////////////////////////////////////////////////////
  //Expand the ARADDR up to the nearest byte
  for (ARADDR_bit = 0; ARADDR_bit < (L_NUM_ARADDR_BYTES * 8); ARADDR_bit = ARADDR_bit + 1) begin : ARADDR_BIT_LOOP
    if (ARADDR_bit < ADDR_WIDTH) begin : VAL
      assign ARADDR_expand[ARADDR_bit] = ARADDR[ARADDR_bit];
      assign ARADDRsqa_expand[ARADDR_bit] = ARADDR_q[ARADDR_bit];
    end else begin
      assign ARADDR_expand[ARADDR_bit] = 1'b0;
      assign ARADDRsqa_expand[ARADDR_bit] = 1'b0;
    end
  end

integer ARADDR_bc;
integer ARADDR_stage_1;
integer ARADDR_stage_2;

always @(posedge ACLK) begin
  ARADDR_q<=ARADDR;

  for (ARADDR_bc = 0; ARADDR_bc < L_NUM_ARADDR_EQ_LANES*8; ARADDR_bc = ARADDR_bc + 1) begin : ARADDR_BC_LOOP
    if (ARADDR_bc < L_NUM_ARADDR_BYTES) begin
      ARADDR_eq[ARADDR_bc] <= ARADDR_expand[ARADDR_bc*8 +:8] == ARADDRsqa_expand[ARADDR_bc*8 +: 8];
    end else begin
      ARADDR_eq[ARADDR_bc] <= 1'b1;
    end
  end

  for (ARADDR_stage_1 = 0; ARADDR_stage_1 < L_NUM_ARADDR_AND1_LANES * 8;ARADDR_stage_1 = ARADDR_stage_1 + 1) begin : ARADDR_S1
    if (ARADDR_stage_1 < L_NUM_ARADDR_EQ_LANES) begin
      ARADDR_stage_1_eq[ARADDR_stage_1] <= &ARADDR_eq[ARADDR_stage_1*8 +:8];
    end else begin
      ARADDR_stage_1_eq[ARADDR_stage_1] <= 1'b1;
    end
  end

  for (ARADDR_stage_2 = 0; ARADDR_stage_2 < L_NUM_ARADDR_AND2_LANES * 8;ARADDR_stage_2 = ARADDR_stage_2 + 1) begin : ARADDR_S2
    if (ARADDR_stage_2 < L_NUM_ARADDR_AND1_LANES) begin
      ARADDR_stage_2_eq[ARADDR_stage_2] <= &ARADDR_stage_1_eq[ARADDR_stage_2*8 +:8];
    end else begin
      ARADDR_stage_2_eq[ARADDR_stage_2] <= 1'b1;
    end
  end

end

  //---------------
  //ASR_48 : assert property ( @(posedge ACLK) ( ARESETn & ARVALID & ! ARREADY ##1 ARESETn |-> $stable(ARBURST) ) );
  //---------------
  always @(posedge ACLK)
    s59<=ARBURST;
  assign s60 = s59 == ARBURST;
  always @(posedge ACLK) if (`AKRPS reset) s61sq<=3'h4; else
    s61sq<=s61s;
  assign s61s={1'b1,
    ((ARESETn & ARVALID) & (! ARREADY)),
    (s61sq[1] && (ARESETn && !(s60)))};
  always @(posedge ACLK) if (`AKRPS reset) ASR_48<=0; else
    ASR_48 <= (s61s[0]);

  //---------------
  //ASR_49 : assert property ( @(posedge ACLK) ( ARESETn & ARVALID & ! ARREADY ##1 ARESETn |-> $stable(ARCACHE) ) );
  //---------------
  always @(posedge ACLK)
    s62<=ARCACHE;
  assign s63 = s62 == ARCACHE;
  always @(posedge ACLK) if (`AKRPS reset) s64sq<=3'h4; else
    s64sq<=s64s;
  assign s64s={1'b1,
    ((ARESETn & ARVALID) & (! ARREADY)),
    (s64sq[1] && (ARESETn && !(s63)))};
  always @(posedge ACLK) if (`AKRPS reset) ASR_49<=0; else
    ASR_49 <= (s64s[0]);

  //---------------
  //ASR_50 : assert property ( @(posedge ACLK) ( ARESETn & ARVALID & ! ARREADY ##1 ARESETn |-> $stable(ARID) ) );
  //---------------
  always @(posedge ACLK)
    s65<=ARID;
  assign s66 = s65 == ARID;
  always @(posedge ACLK) if (`AKRPS reset) s67sq<=3'h4; else
    s67sq<=s67s;
  assign s67s={1'b1,
    ((ARESETn & ARVALID) & (! ARREADY)),
    (s67sq[1] && (ARESETn && !(s66)))};
  always @(posedge ACLK) if (`AKRPS reset) ASR_50<=0; else
    ASR_50 <= (s67s[0]);

  //---------------
  //ASR_51 : assert property ( @(posedge ACLK) ( ARESETn & ARVALID & ! ARREADY ##1 ARESETn |-> $stable(ARLEN) ) );
  //---------------
  always @(posedge ACLK)
    s68<=ARLEN;
  assign s69 = s68 == ARLEN;
  always @(posedge ACLK) if (`AKRPS reset) s70sq<=3'h4; else
    s70sq<=s70s;
  assign s70s={1'b1,
    ((ARESETn & ARVALID) & (! ARREADY)),
    (s70sq[1] && (ARESETn && !(s69)))};
  always @(posedge ACLK) if (`AKRPS reset) ASR_51<=0; else
    ASR_51 <= (s70s[0]);

  //---------------
  //ASR_52 : assert property ( @(posedge ACLK) ( ARESETn & ARVALID & ! ARREADY ##1 ARESETn |-> $stable(ARLOCK) ) );
  //---------------
  always @(posedge ACLK)
    s71<=ARLOCK;
  assign s72 = s71 == ARLOCK;
  always @(posedge ACLK) if (`AKRPS reset) s73sq<=3'h4; else
    s73sq<=s73s;
  assign s73s={1'b1,
    ((ARESETn & ARVALID) & (! ARREADY)),
    (s73sq[1] && (ARESETn && !(s72)))};
  always @(posedge ACLK) if (`AKRPS reset) ASR_52<=0; else
    ASR_52 <= (s73s[0]);

  //---------------
  //ASR_53 : assert property ( @(posedge ACLK) ( ARESETn & ARVALID & ! ARREADY ##1 ARESETn |-> $stable(ARPROT) ) );
  //---------------
  always @(posedge ACLK)
    s74<=ARPROT;
  assign s75 = s74 == ARPROT;
  always @(posedge ACLK) if (`AKRPS reset) s76sq<=3'h4; else
    s76sq<=s76s;
  assign s76s={1'b1,
    ((ARESETn & ARVALID) & (! ARREADY)),
    (s76sq[1] && (ARESETn && !(s75)))};
  always @(posedge ACLK) if (`AKRPS reset) ASR_53<=0; else
    ASR_53 <= (s76s[0]);

  //---------------
  //ASR_54 : assert property ( @(posedge ACLK) ( ARESETn & ARVALID & ! ARREADY ##1 ARESETn |-> $stable(ARSIZE) ) );
  //---------------
  always @(posedge ACLK)
    s77<=ARSIZE;
  assign s78 = s77 == ARSIZE;
  always @(posedge ACLK) if (`AKRPS reset) s79sq<=3'h4; else
    s79sq<=s79s;
  assign s79s={1'b1,
    ((ARESETn & ARVALID) & (! ARREADY)),
    (s79sq[1] && (ARESETn && !(s78)))};
  always @(posedge ACLK) if (`AKRPS reset) ASR_54<=0; else
    ASR_54 <= (s79s[0]);

  //---------------
  //ASR_55 : assert property ( @(posedge ACLK) ( ARESETn & ARVALID & ! ARREADY ##1 ARESETn |-> $stable(ARQOS) ) );
  //---------------
  always @(posedge ACLK)
    s80<=ARQOS;
  assign s81 = s80 == ARQOS;
  always @(posedge ACLK) if (`AKRPS reset) s82sq<=3'h4; else
    s82sq<=s82s;
  assign s82s={1'b1,
    ((ARESETn & ARVALID) & (! ARREADY)),
    (s82sq[1] && (ARESETn && !(s81)))};
  always @(posedge ACLK) if (`AKRPS reset) ASR_55<=0; else
    ASR_55 <= (s82s[0]);

  //---------------
  //ASR_56 : assert property ( @(posedge ACLK) ( ARESETn & ARVALID & ! ARREADY ##1 ARESETn |-> $stable(ARREGION) ) );
  //---------------
  always @(posedge ACLK)
    s83<=ARREGION;
  assign s84 = s83 == ARREGION;
  always @(posedge ACLK) if (`AKRPS reset) s85sq<=3'h4; else
    s85sq<=s85s;
  assign s85s={1'b1,
    ((ARESETn & ARVALID) & (! ARREADY)),
    (s85sq[1] && (ARESETn && !(s84)))};
  always @(posedge ACLK) if (`AKRPS reset) ASR_56<=0; else
    ASR_56 <= (s85s[0]);

  //---------------
  //ASR_57 : assert property ( @(posedge ACLK) ( ARESETn & ARVALID & ! ARREADY ##1 ARESETn |-> ARVALID ) );
  //---------------
  always @(posedge ACLK) if (`AKRPS reset) s86sq<=3'h4; else
    s86sq<=s86s;
  assign s86s={1'b1,
    ((ARESETn & ARVALID) & (! ARREADY)),
    (s86sq[1] && (ARESETn && !(ARVALID)))};
  always @(posedge ACLK) if (`AKRPS reset) ASR_57<=0; else
    ASR_57 <= (s86s[0]);

  //---------------
  //ASR_61 : assert property ( @(posedge ACLK) ( ARESETn & RVALID & RREADY & ( RRESP == 2'b1 ) |-> ( ArExclPending ) ) );
  //---------------
  always @(posedge ACLK) if (`AKRPS reset) ASR_61<=0; else
    ASR_61 <= (((((ARESETn & RVALID) & RREADY) & ( (RRESP == 2'b1) )) && !(ArExclPending)));

  //---------------
  //ASR_62 : assert property ( @(posedge ACLK) ( ! ( ARESETn ) ##1 ARESETn |-> ! RVALID ) );
  //---------------
  always @(posedge ACLK) if (`AKRPS reset) s88sq<=3'h4; else
    s88sq<=s88s;
  assign s88s={1'b1,
    !(ARESETn),
    (s88sq[1] && (ARESETn && RVALID))};
  always @(posedge ACLK) if (`AKRPS reset) ASR_62<=0; else
    ASR_62 <= (s88s[0]);

  //---------------
  //ASR_63 : assert property ( @(posedge ACLK) ( ARESETn & RVALID & ! RREADY ##1 ARESETn |-> $stable(RDATA) ) );
  //---------------
//  always @(posedge ACLK)
//    s89<=RDATA;
//  assign s90 = s89 == RDATA;
//  always @(posedge ACLK) if (`AKRPS reset) s91sq<=3'h4; else
//    s91sq<=s91s;
//  assign s91s={1'b1,
//    ((ARESETn & RVALID) & (! RREADY)),
//    (s91sq[1] && (ARESETn && !(s90)))};
//  always @(posedge ACLK) if (`AKRPS reset) ASR_63<=0; else
//    ASR_63 <= (s91s[0]);
localparam integer L_NUM_RDATA_BYTES       = ((DATA_WIDTH + 7) / 8);
localparam integer L_NUM_RDATA_BYTE_LANES  = ((L_NUM_RDATA_BYTES + 7) / 8) * 8;
localparam integer L_NUM_RDATA_EQ_LANES    = (L_NUM_RDATA_BYTE_LANES / 8);
localparam integer L_NUM_RDATA_AND1_LANES  = (L_NUM_RDATA_EQ_LANES + 7) / 8;
localparam integer L_NUM_RDATA_AND2_LANES  = (L_NUM_RDATA_AND1_LANES + 7) / 8;

reg   [DATA_WIDTH - 1:0]  RDATA_q;
reg   [4:0]               s_RDATA_sq;
wire  [4:0]               s_RDATA_s;
wire                      s_RDATA_sqaa;

reg [(8*L_NUM_RDATA_EQ_LANES)-1:0]    RDATA_eq;
reg [(8*L_NUM_RDATA_AND1_LANES)-1:0]  RDATA_stage_1_eq;
reg [(8*L_NUM_RDATA_AND2_LANES)-1:0]  RDATA_stage_2_eq;

always @(posedge ACLK) begin
  if (`AKRPS reset) begin
    s_RDATA_sq<=5'h00; 
    ASR_63 <=0;
  end else begin
    s_RDATA_sq<=s_RDATA_s;
    ASR_63 <= (s_RDATA_s[0]);
  end
end

assign s_RDATA_s={
  (((ARESETn & RVALID) & (! RREADY))),
  (s_RDATA_sq[4] && ARESETn),
  (s_RDATA_sq[3]),
  (s_RDATA_sq[2]),
  (s_RDATA_sq[1] & !(s_RDATA_sqaa))
  };

assign s_RDATA_sqaa = &RDATA_stage_2_eq;

integer RDATA_bc;
integer RDATA_stage_1;
integer RDATA_stage_2;

always @(posedge ACLK) begin
  RDATA_q<=RDATA;

  for (RDATA_bc = 0; RDATA_bc < L_NUM_RDATA_EQ_LANES*8; RDATA_bc = RDATA_bc + 1) begin : RDATA_BC_LOOP
    if (RDATA_bc < L_NUM_RDATA_BYTES) begin
      RDATA_eq[RDATA_bc] <= RDATA_q[RDATA_bc*8 +:8] == RDATA[RDATA_bc*8 +: 8];
    end else begin
      RDATA_eq[RDATA_bc] <= 1'b1;
    end
  end

  for (RDATA_stage_1 = 0; RDATA_stage_1 < L_NUM_RDATA_AND1_LANES * 8;RDATA_stage_1 = RDATA_stage_1 + 1) begin : RDATA_S1
    if (RDATA_stage_1 < L_NUM_RDATA_EQ_LANES) begin
      RDATA_stage_1_eq[RDATA_stage_1] <= &RDATA_eq[RDATA_stage_1*8 +:8];
    end else begin
      RDATA_stage_1_eq[RDATA_stage_1] <= 1'b1;
    end
  end

  for (RDATA_stage_2 = 0; RDATA_stage_2 < L_NUM_RDATA_AND2_LANES * 8;RDATA_stage_2 = RDATA_stage_2 + 1) begin : RDATA_S2
    if (RDATA_stage_2 < L_NUM_RDATA_AND1_LANES) begin
      RDATA_stage_2_eq[RDATA_stage_2] <= &RDATA_stage_1_eq[RDATA_stage_2*8 +:8];
    end else begin
      RDATA_stage_2_eq[RDATA_stage_2] <= 1'b1;
    end
  end

end

  //---------------
  //ASR_64 : assert property ( @(posedge ACLK) ( ARESETn & RVALID & ! RREADY ##1 ARESETn |-> $stable(RID) ) );
  //---------------
  always @(posedge ACLK)
    s92<=RID;
  assign s93 = s92 == RID;
  always @(posedge ACLK) if (`AKRPS reset) s94sq<=3'h4; else
    s94sq<=s94s;
  assign s94s={1'b1,
    ((ARESETn & RVALID) & (! RREADY)),
    (s94sq[1] && (ARESETn && !(s93)))};
  always @(posedge ACLK) if (`AKRPS reset) ASR_64<=0; else
    ASR_64 <= (s94s[0]);

  //---------------
  //ASR_65 : assert property ( @(posedge ACLK) ( ARESETn & RVALID & ! RREADY ##1 ARESETn |-> $stable(RLAST) ) );
  //---------------
  always @(posedge ACLK)
    s95<=RLAST;
  assign s96 = s95 == RLAST;
  always @(posedge ACLK) if (`AKRPS reset) s97sq<=3'h4; else
    s97sq<=s97s;
  assign s97s={1'b1,
    ((ARESETn & RVALID) & (! RREADY)),
    (s97sq[1] && (ARESETn && !(s96)))};
  always @(posedge ACLK) if (`AKRPS reset) ASR_65<=0; else
    ASR_65 <= (s97s[0]);

  //---------------
  //ASR_66 : assert property ( @(posedge ACLK) ( ARESETn & RVALID & ! RREADY ##1 ARESETn |-> $stable(RRESP) ) );
  //---------------
  always @(posedge ACLK)
    s98<=RRESP;
  assign s99 = s98 == RRESP;
  always @(posedge ACLK) if (`AKRPS reset) s100sq<=3'h4; else
    s100sq<=s100s;
  assign s100s={1'b1,
    ((ARESETn & RVALID) & (! RREADY)),
    (s100sq[1] && (ARESETn && !(s99)))};
  always @(posedge ACLK) if (`AKRPS reset) ASR_66<=0; else
    ASR_66 <= (s100s[0]);

  //---------------
  //ASR_67 : assert property ( @(posedge ACLK) ( ARESETn & RVALID & ! RREADY ##1 ARESETn |-> RVALID ) );
  //---------------
  always @(posedge ACLK) if (`AKRPS reset) s101sq<=3'h4; else
    s101sq<=s101s;
  assign s101s={1'b1,
    ((ARESETn & RVALID) & (! RREADY)),
    (s101sq[1] && (ARESETn && !(RVALID)))};
  always @(posedge ACLK) if (`AKRPS reset) ASR_67<=0; else
    ASR_67 <= (s101s[0]);

  //---------------
  //ASR_69 : assert property ( @(posedge ACLK) ( ( ARVALID & ( ARLOCK == 1'b1 ) & ( ARLEN == 8'b0 || ARLEN == 8'b1 || ARLEN == 8'b11 || ARLEN == 8'b111 || ARLEN == 8'b1111 ) ) |-> ( ( ARADDR[10:0] & ExclMask ) == ARADDR[10:0] ) ) );
  //---------------
  always @(posedge ACLK) if (`AKRPS reset) ASR_69<=0; else
    ASR_69 <= ((((ARVALID & ( (ARLOCK == 1'b1) )) & ( (((((ARLEN == 8'b0) || (ARLEN == 8'b1)) || (ARLEN == 8'b11)) || (ARLEN == 8'b111)) || (ARLEN == 8'b1111)) )) && !((( (ARADDR[10:0] & ExclMask) ) == ARADDR[10:0]))));

  //---------------
  //ASR_70 : assert property ( @(posedge ACLK) ( ARVALID & ( ARLOCK == 1'b1 ) |-> ( ( ARLEN == 8'b0 ) || ( ARLEN == 8'b1 ) || ( ARLEN == 8'b11 ) || ( ARLEN == 8'b111 ) || ( ARLEN == 8'b1111 ) ) ) );
  //---------------
  always @(posedge ACLK) if (`AKRPS reset) ASR_70<=0; else
    ASR_70 <= (((ARVALID & ( (ARLOCK == 1'b1) )) && !(((((( (ARLEN == 8'b0) ) || ( (ARLEN == 8'b1) )) || ( (ARLEN == 8'b11) )) || ( (ARLEN == 8'b111) )) || ( (ARLEN == 8'b1111) )))));

  //---------------
  //ASR_71 : assert property ( @(posedge ACLK) ( i_RecommendOn & AWVALID & AWREADY & ( AWLOCK == 1'b1 ) & ExclReadAddr[ExclAwId] & ExclAwMatch |-> ( ( ExclAddr[ExclAwId] == AWADDR ) & ( ExclSize[ExclAwId] == AWSIZE ) & ( ExclLen[ExclAwId] == AWLEN ) & ( ExclBurst[ExclAwId] == AWBURST ) & ( ExclCache[ExclAwId] == AWCACHE ) & ( ExclProt[ExclAwId] == AWPROT ) & ( ExclRegion[ExclAwId] == AWREGION ) ) ) );
  //---------------
  always @(posedge ACLK) if (`AKRPS reset) ASR_71<=0; else
    ASR_71 <= (((((((i_RecommendOn & AWVALID) & AWREADY) & ( (AWLOCK == 1'b1) )) & ExclReadAddr) & ExclAwMatch) && !(((((((( (ExclAddr == AWADDR) ) & ( (ExclSize == AWSIZE) )) & ( (ExclLen == AWLEN) )) & ( (ExclBurst == AWBURST) )) & ( (ExclCache == AWCACHE) )) & ( (ExclProt == AWPROT) )) & ( (ExclRegion == AWREGION) ))))); // ###MBAC###

  //---------------
  //ASR_72 : assert property ( @(posedge ACLK) ( ( ARVALID & ( ARLOCK == 1'b1 ) & ( ARLEN == 8'b1 || ARLEN == 8'b11 || ARLEN == 8'b111 || ARLEN == 8'b1111 ) ) |-> ( ArLenInBytes <= 128 ) ) );
  //---------------
  always @(posedge ACLK) if (`AKRPS reset) ASR_72<=0; else
    ASR_72 <= ((((ARVALID & ( (ARLOCK == 1'b1) )) & ( ((((ARLEN == 8'b1) || (ARLEN == 8'b11)) || (ARLEN == 8'b111)) || (ARLEN == 8'b1111)) )) && !((ArLenInBytes <= 128))));

  //---------------
  //ASR_73 : assert property ( @(posedge ACLK) ( i_RecommendOn & AWVALID & AWREADY & ( AWLOCK == 1'b1 ) |-> ( ExclAwMatch && ExclReadAddr[ExclAwId] && ExclReadData[ExclAwId] ) ) );
  //---------------
  always @(posedge ACLK) if (`AKRPS reset) ASR_73<=0; else
    ASR_73 <= (((((i_RecommendOn & AWVALID) & AWREADY) & ( (AWLOCK == 1'b1) )) && !(((ExclAwMatch && ExclReadAddr) && ExclReadData)))); // ###MBAC###

  //---------------
  //ASR_74 : assert property ( @(posedge ACLK) ( ARESETn & AWVALID & ! AWREADY ##1 ARESETn |-> $stable(AWUSER) ) );
  //---------------
//  always @(posedge ACLK)
//    s103<=AWUSER;
//  assign s104 = s103 == AWUSER;
//  always @(posedge ACLK) if (`AKRPS reset) s105sq<=3'h4; else
//    s105sq<=s105s;
//  assign s105s={1'b1,
//    ((ARESETn & AWVALID) & (! AWREADY)),
//    (s105sq[1] && (ARESETn && !(s104)))};
//  always @(posedge ACLK) if (`AKRPS reset) ASR_74<=0; else
//    ASR_74 <= (s105s[0]);
localparam integer L_NUM_AWUSER_BYTES       = ((AWUSER_WIDTH + 7) / 8);
localparam integer L_NUM_AWUSER_BYTE_LANES  = ((L_NUM_AWUSER_BYTES + 7) / 8) * 8;
localparam integer L_NUM_AWUSER_EQ_LANES    = (L_NUM_AWUSER_BYTE_LANES / 8);
localparam integer L_NUM_AWUSER_AND1_LANES  = (L_NUM_AWUSER_EQ_LANES + 7) / 8;
localparam integer L_NUM_AWUSER_AND2_LANES  = (L_NUM_AWUSER_AND1_LANES + 7) / 8;

reg   [AWUSER_WIDTH - 1:0] AWUSER_q;
reg   [4:0]               s_AWUSER_sq;
wire  [4:0]               s_AWUSER_s;
wire                      s_AWUSER_sqaa;

reg [(8*L_NUM_AWUSER_EQ_LANES)-1:0]    AWUSER_eq;
reg [(8*L_NUM_AWUSER_AND1_LANES)-1:0]  AWUSER_stage_1_eq;
reg [(8*L_NUM_AWUSER_AND2_LANES)-1:0]  AWUSER_stage_2_eq;

always @(posedge ACLK) begin
  if (`AKRPS reset) begin
    s_AWUSER_sq<=5'h00; 
    ASR_74 <=0;
  end else begin
    s_AWUSER_sq<=s_AWUSER_s;
    ASR_74 <= (s_AWUSER_s[0]);
  end
end

assign s_AWUSER_s={
  (((ARESETn & AWVALID) & (! AWREADY))),
  (s_AWUSER_sq[4] && ARESETn),
  (s_AWUSER_sq[3]),
  (s_AWUSER_sq[2]),
  (s_AWUSER_sq[1] & !(s_AWUSER_sqaa))
  };

assign s_AWUSER_sqaa = &AWUSER_stage_2_eq;

wire  [(L_NUM_AWUSER_BYTES*8)-1:0]      AWUSER_expand;
wire  [(L_NUM_AWUSER_BYTES*8)-1:0]      AWUSERsqa_expand;
  ///////////////////////////////////////////////////////////////////////////////////////////
  //Expand the AWUSER up to the nearest byte
  for (AWUSER_bit = 0; AWUSER_bit < (L_NUM_AWUSER_BYTES * 8); AWUSER_bit = AWUSER_bit + 1) begin : AWUSER_BIT_LOOP
    if (AWUSER_bit < AWUSER_WIDTH) begin : VAL
      assign AWUSER_expand[AWUSER_bit] = AWUSER[AWUSER_bit];
      assign AWUSERsqa_expand[AWUSER_bit] = AWUSER_q[AWUSER_bit];
    end else begin
      assign AWUSER_expand[AWUSER_bit] = 1'b0;
      assign AWUSERsqa_expand[AWUSER_bit] = 1'b0;
    end
  end

integer AWUSER_bc;
integer AWUSER_stage_1;
integer AWUSER_stage_2;

always @(posedge ACLK) begin
  AWUSER_q<=AWUSER;

  for (AWUSER_bc = 0; AWUSER_bc < L_NUM_AWUSER_EQ_LANES*8; AWUSER_bc = AWUSER_bc + 1) begin : AWUSER_BC_LOOP
    if (AWUSER_bc < L_NUM_AWUSER_BYTES) begin
      AWUSER_eq[AWUSER_bc] <= AWUSER_expand[AWUSER_bc*8 +:8] == AWUSERsqa_expand[AWUSER_bc*8 +: 8];
    end else begin
      AWUSER_eq[AWUSER_bc] <= 1'b1;
    end
  end

  for (AWUSER_stage_1 = 0; AWUSER_stage_1 < L_NUM_AWUSER_AND1_LANES * 8;AWUSER_stage_1 = AWUSER_stage_1 + 1) begin : AWUSER_S1
    if (AWUSER_stage_1 < L_NUM_AWUSER_EQ_LANES) begin
      AWUSER_stage_1_eq[AWUSER_stage_1] <= &AWUSER_eq[AWUSER_stage_1*8 +:8];
    end else begin
      AWUSER_stage_1_eq[AWUSER_stage_1] <= 1'b1;
    end
  end

  for (AWUSER_stage_2 = 0; AWUSER_stage_2 < L_NUM_AWUSER_AND2_LANES * 8;AWUSER_stage_2 = AWUSER_stage_2 + 1) begin : AWUSER_S2
    if (AWUSER_stage_2 < L_NUM_AWUSER_AND1_LANES) begin
      AWUSER_stage_2_eq[AWUSER_stage_2] <= &AWUSER_stage_1_eq[AWUSER_stage_2*8 +:8];
    end else begin
      AWUSER_stage_2_eq[AWUSER_stage_2] <= 1'b1;
    end
  end

end


  //---------------
  //ASR_75 : assert property ( @(posedge ACLK) ( ARESETn & WVALID & ! WREADY ##1 ARESETn |-> $stable(WUSER) ) );
  //---------------
//  always @(posedge ACLK)
//    s106<=WUSER;
//  assign s107 = s106 == WUSER;
//  always @(posedge ACLK) if (`AKRPS reset) s108sq<=3'h4; else
//    s108sq<=s108s;
//  assign s108s={1'b1,
//    ((ARESETn & WVALID) & (! WREADY)),
//    (s108sq[1] && (ARESETn && !(s107)))};
//  always @(posedge ACLK) if (`AKRPS reset) ASR_75<=0; else
//    ASR_75 <= (s108s[0]);
localparam integer L_NUM_WUSER_BYTES       = ((WUSER_WIDTH + 7) / 8);
localparam integer L_NUM_WUSER_BYTE_LANES  = ((L_NUM_WUSER_BYTES + 7) / 8) * 8;
localparam integer L_NUM_WUSER_EQ_LANES    = (L_NUM_WUSER_BYTE_LANES / 8);
localparam integer L_NUM_WUSER_AND1_LANES  = (L_NUM_WUSER_EQ_LANES + 7) / 8;
localparam integer L_NUM_WUSER_AND2_LANES  = (L_NUM_WUSER_AND1_LANES + 7) / 8;

reg   [WUSER_WIDTH - 1:0] WUSER_q;
reg   [4:0]               s_WUSER_sq;
wire  [4:0]               s_WUSER_s;
wire                      s_WUSER_sqaa;

reg [(8*L_NUM_WUSER_EQ_LANES)-1:0]    WUSER_eq;
reg [(8*L_NUM_WUSER_AND1_LANES)-1:0]  WUSER_stage_1_eq;
reg [(8*L_NUM_WUSER_AND2_LANES)-1:0]  WUSER_stage_2_eq;

always @(posedge ACLK) begin
  if (`AKRPS reset) begin
    s_WUSER_sq<=5'h00; 
    ASR_75 <=0;
  end else begin
    s_WUSER_sq<=s_WUSER_s;
    ASR_75 <= (s_WUSER_s[0]);
  end
end

assign s_WUSER_s={
  (((ARESETn & WVALID) & (! WREADY))),
  (s_WUSER_sq[4] && ARESETn),
  (s_WUSER_sq[3]),
  (s_WUSER_sq[2]),
  (s_WUSER_sq[1] & !(s_WUSER_sqaa))
  };

assign s_WUSER_sqaa = &WUSER_stage_2_eq;

wire  [(L_NUM_WUSER_BYTES*8)-1:0]      WUSER_expand;
wire  [(L_NUM_WUSER_BYTES*8)-1:0]      WUSERsqa_expand;
  ///////////////////////////////////////////////////////////////////////////////////////////
  //Expand the WUSER up to the nearest byte
  for (WUSER_bit = 0; WUSER_bit < (L_NUM_WUSER_BYTES * 8); WUSER_bit = WUSER_bit + 1) begin : WUSER_BIT_LOOP
    if (WUSER_bit < WUSER_WIDTH) begin : VAL
      assign WUSER_expand[WUSER_bit] = WUSER[WUSER_bit];
      assign WUSERsqa_expand[WUSER_bit] = WUSER_q[WUSER_bit];
    end else begin
      assign WUSER_expand[WUSER_bit] = 1'b0;
      assign WUSERsqa_expand[WUSER_bit] = 1'b0;
    end
  end

integer WUSER_bc;
integer WUSER_stage_1;
integer WUSER_stage_2;

always @(posedge ACLK) begin
  WUSER_q<=WUSER;

  for (WUSER_bc = 0; WUSER_bc < L_NUM_WUSER_EQ_LANES*8; WUSER_bc = WUSER_bc + 1) begin : WUSER_BC_LOOP
    if (WUSER_bc < L_NUM_WUSER_BYTES) begin
      WUSER_eq[WUSER_bc] <= WUSER_expand[WUSER_bc*8 +:8] == WUSERsqa_expand[WUSER_bc*8 +: 8];
    end else begin
      WUSER_eq[WUSER_bc] <= 1'b1;
    end
  end

  for (WUSER_stage_1 = 0; WUSER_stage_1 < L_NUM_WUSER_AND1_LANES * 8;WUSER_stage_1 = WUSER_stage_1 + 1) begin : WUSER_S1
    if (WUSER_stage_1 < L_NUM_WUSER_EQ_LANES) begin
      WUSER_stage_1_eq[WUSER_stage_1] <= &WUSER_eq[WUSER_stage_1*8 +:8];
    end else begin
      WUSER_stage_1_eq[WUSER_stage_1] <= 1'b1;
    end
  end

  for (WUSER_stage_2 = 0; WUSER_stage_2 < L_NUM_WUSER_AND2_LANES * 8;WUSER_stage_2 = WUSER_stage_2 + 1) begin : WUSER_S2
    if (WUSER_stage_2 < L_NUM_WUSER_AND1_LANES) begin
      WUSER_stage_2_eq[WUSER_stage_2] <= &WUSER_stage_1_eq[WUSER_stage_2*8 +:8];
    end else begin
      WUSER_stage_2_eq[WUSER_stage_2] <= 1'b1;
    end
  end

end


  //---------------
  //ASR_76 : assert property ( @(posedge ACLK) ( ARESETn & BVALID & ! BREADY ##1 ARESETn |-> $stable(BUSER) ) );
  //---------------
//  always @(posedge ACLK)
//    s109<=BUSER;
//  assign s110 = s109 == BUSER;
//  always @(posedge ACLK) if (`AKRPS reset) s111sq<=3'h4; else
//    s111sq<=s111s;
//  assign s111s={1'b1,
//    ((ARESETn & BVALID) & (! BREADY)),
//    (s111sq[1] && (ARESETn && !(s110)))};
//  always @(posedge ACLK) if (`AKRPS reset) ASR_76<=0; else
//    ASR_76 <= (s111s[0]);
localparam integer L_NUM_BUSER_BYTES       = ((BUSER_WIDTH + 7) / 8);
localparam integer L_NUM_BUSER_BYTE_LANES  = ((L_NUM_BUSER_BYTES + 7) / 8) * 8;
localparam integer L_NUM_BUSER_EQ_LANES    = (L_NUM_BUSER_BYTE_LANES / 8);
localparam integer L_NUM_BUSER_AND1_LANES  = (L_NUM_BUSER_EQ_LANES + 7) / 8;
localparam integer L_NUM_BUSER_AND2_LANES  = (L_NUM_BUSER_AND1_LANES + 7) / 8;

reg   [BUSER_WIDTH - 1:0] BUSER_q;
reg   [4:0]               s_BUSER_sq;
wire  [4:0]               s_BUSER_s;
wire                      s_BUSER_sqaa;

reg [(8*L_NUM_BUSER_EQ_LANES)-1:0]    BUSER_eq;
reg [(8*L_NUM_BUSER_AND1_LANES)-1:0]  BUSER_stage_1_eq;
reg [(8*L_NUM_BUSER_AND2_LANES)-1:0]  BUSER_stage_2_eq;

always @(posedge ACLK) begin
  if (`AKRPS reset) begin
    s_BUSER_sq<=5'h00; 
    ASR_76 <=0;
  end else begin
    s_BUSER_sq<=s_BUSER_s;
    ASR_76 <= (s_BUSER_s[0]);
  end
end

assign s_BUSER_s={
  (((ARESETn & BVALID) & (! BREADY))),
  (s_BUSER_sq[4] && ARESETn),
  (s_BUSER_sq[3]),
  (s_BUSER_sq[2]),
  (s_BUSER_sq[1] & !(s_BUSER_sqaa))
  };

assign s_BUSER_sqaa = &BUSER_stage_2_eq;

wire  [(L_NUM_BUSER_BYTES*8)-1:0]      BUSER_expand;
wire  [(L_NUM_BUSER_BYTES*8)-1:0]      BUSERsqa_expand;
  ///////////////////////////////////////////////////////////////////////////////////////////
  //Expand the BUSER up to the nearest byte
  for (BUSER_bit = 0; BUSER_bit < (L_NUM_BUSER_BYTES * 8); BUSER_bit = BUSER_bit + 1) begin : BUSER_BIT_LOOP
    if (BUSER_bit < BUSER_WIDTH) begin : VAL
      assign BUSER_expand[BUSER_bit] = BUSER[BUSER_bit];
      assign BUSERsqa_expand[BUSER_bit] = BUSER_q[BUSER_bit];
    end else begin
      assign BUSER_expand[BUSER_bit] = 1'b0;
      assign BUSERsqa_expand[BUSER_bit] = 1'b0;
    end
  end

integer BUSER_bc;
integer BUSER_stage_1;
integer BUSER_stage_2;

always @(posedge ACLK) begin
  BUSER_q<=BUSER;

  for (BUSER_bc = 0; BUSER_bc < L_NUM_BUSER_EQ_LANES*8; BUSER_bc = BUSER_bc + 1) begin : BUSER_BC_LOOP
    if (BUSER_bc < L_NUM_BUSER_BYTES) begin
      BUSER_eq[BUSER_bc] <= BUSER_expand[BUSER_bc*8 +:8] == BUSERsqa_expand[BUSER_bc*8 +: 8];
    end else begin
      BUSER_eq[BUSER_bc] <= 1'b1;
    end
  end

  for (BUSER_stage_1 = 0; BUSER_stage_1 < L_NUM_BUSER_AND1_LANES * 8;BUSER_stage_1 = BUSER_stage_1 + 1) begin : BUSER_S1
    if (BUSER_stage_1 < L_NUM_BUSER_EQ_LANES) begin
      BUSER_stage_1_eq[BUSER_stage_1] <= &BUSER_eq[BUSER_stage_1*8 +:8];
    end else begin
      BUSER_stage_1_eq[BUSER_stage_1] <= 1'b1;
    end
  end

  for (BUSER_stage_2 = 0; BUSER_stage_2 < L_NUM_BUSER_AND2_LANES * 8;BUSER_stage_2 = BUSER_stage_2 + 1) begin : BUSER_S2
    if (BUSER_stage_2 < L_NUM_BUSER_AND1_LANES) begin
      BUSER_stage_2_eq[BUSER_stage_2] <= &BUSER_stage_1_eq[BUSER_stage_2*8 +:8];
    end else begin
      BUSER_stage_2_eq[BUSER_stage_2] <= 1'b1;
    end
  end

end

  //---------------
  //ASR_77 : assert property ( @(posedge ACLK) ( ARESETn & ARVALID & ! ARREADY ##1 ARESETn |-> $stable(ARUSER) ) );
  //---------------
//  always @(posedge ACLK)
//    s112<=ARUSER;
//  assign s113 = s112 == ARUSER;
//  always @(posedge ACLK) if (`AKRPS reset) s114sq<=3'h4; else
//    s114sq<=s114s;
//  assign s114s={1'b1,
//    ((ARESETn & ARVALID) & (! ARREADY)),
//    (s114sq[1] && (ARESETn && !(s113)))};
//  always @(posedge ACLK) if (`AKRPS reset) ASR_77<=0; else
//    ASR_77 <= (s114s[0]);
localparam integer L_NUM_ARUSER_BYTES       = ((ARUSER_WIDTH + 7) / 8);
localparam integer L_NUM_ARUSER_BYTE_LANES  = ((L_NUM_ARUSER_BYTES + 7) / 8) * 8;
localparam integer L_NUM_ARUSER_EQ_LANES    = (L_NUM_ARUSER_BYTE_LANES / 8);
localparam integer L_NUM_ARUSER_AND1_LANES  = (L_NUM_ARUSER_EQ_LANES + 7) / 8;
localparam integer L_NUM_ARUSER_AND2_LANES  = (L_NUM_ARUSER_AND1_LANES + 7) / 8;

reg   [ARUSER_WIDTH - 1:0] ARUSER_q;
reg   [4:0]               s_ARUSER_sq;
wire  [4:0]               s_ARUSER_s;
wire                      s_ARUSER_sqaa;

reg [(8*L_NUM_ARUSER_EQ_LANES)-1:0]    ARUSER_eq;
reg [(8*L_NUM_ARUSER_AND1_LANES)-1:0]  ARUSER_stage_1_eq;
reg [(8*L_NUM_ARUSER_AND2_LANES)-1:0]  ARUSER_stage_2_eq;

always @(posedge ACLK) begin
  if (`AKRPS reset) begin
    s_ARUSER_sq<=5'h00; 
    ASR_77 <=0;
  end else begin
    s_ARUSER_sq<=s_ARUSER_s;
    ASR_77 <= (s_ARUSER_s[0]);
  end
end

assign s_ARUSER_s={
  (((ARESETn & ARVALID) & (! ARREADY))),
  (s_ARUSER_sq[4] && ARESETn),
  (s_ARUSER_sq[3]),
  (s_ARUSER_sq[2]),
  (s_ARUSER_sq[1] & !(s_ARUSER_sqaa))
  };

assign s_ARUSER_sqaa = &ARUSER_stage_2_eq;

wire  [(L_NUM_ARUSER_BYTES*8)-1:0]      ARUSER_expand;
wire  [(L_NUM_ARUSER_BYTES*8)-1:0]      ARUSERsqa_expand;
  ///////////////////////////////////////////////////////////////////////////////////////////
  //Expand the ARUSER up to the nearest byte
  for (ARUSER_bit = 0; ARUSER_bit < (L_NUM_ARUSER_BYTES * 8); ARUSER_bit = ARUSER_bit + 1) begin : ARUSER_BIT_LOOP
    if (ARUSER_bit < ARUSER_WIDTH) begin : VAL
      assign ARUSER_expand[ARUSER_bit] = ARUSER[ARUSER_bit];
      assign ARUSERsqa_expand[ARUSER_bit] = ARUSER_q[ARUSER_bit];
    end else begin
      assign ARUSER_expand[ARUSER_bit] = 1'b0;
      assign ARUSERsqa_expand[ARUSER_bit] = 1'b0;
    end
  end

integer ARUSER_bc;
integer ARUSER_stage_1;
integer ARUSER_stage_2;

always @(posedge ACLK) begin
  ARUSER_q<=ARUSER;

  for (ARUSER_bc = 0; ARUSER_bc < L_NUM_ARUSER_EQ_LANES*8; ARUSER_bc = ARUSER_bc + 1) begin : ARUSER_BC_LOOP
    if (ARUSER_bc < L_NUM_ARUSER_BYTES) begin
      ARUSER_eq[ARUSER_bc] <= ARUSER_expand[ARUSER_bc*8 +:8] == ARUSERsqa_expand[ARUSER_bc*8 +: 8];
    end else begin
      ARUSER_eq[ARUSER_bc] <= 1'b1;
    end
  end

  for (ARUSER_stage_1 = 0; ARUSER_stage_1 < L_NUM_ARUSER_AND1_LANES * 8;ARUSER_stage_1 = ARUSER_stage_1 + 1) begin : ARUSER_S1
    if (ARUSER_stage_1 < L_NUM_ARUSER_EQ_LANES) begin
      ARUSER_stage_1_eq[ARUSER_stage_1] <= &ARUSER_eq[ARUSER_stage_1*8 +:8];
    end else begin
      ARUSER_stage_1_eq[ARUSER_stage_1] <= 1'b1;
    end
  end

  for (ARUSER_stage_2 = 0; ARUSER_stage_2 < L_NUM_ARUSER_AND2_LANES * 8;ARUSER_stage_2 = ARUSER_stage_2 + 1) begin : ARUSER_S2
    if (ARUSER_stage_2 < L_NUM_ARUSER_AND1_LANES) begin
      ARUSER_stage_2_eq[ARUSER_stage_2] <= &ARUSER_stage_1_eq[ARUSER_stage_2*8 +:8];
    end else begin
      ARUSER_stage_2_eq[ARUSER_stage_2] <= 1'b1;
    end
  end

end

  //---------------
  //ASR_78 : assert property ( @(posedge ACLK) ( ARESETn & RVALID & ! RREADY ##1 ARESETn |-> $stable(RUSER) ) );
  //---------------
//  always @(posedge ACLK)
//    s115<=RUSER;
//  assign s116 = s115 == RUSER;
//  always @(posedge ACLK) if (`AKRPS reset) s117sq<=3'h4; else
//    s117sq<=s117s;
//  assign s117s={1'b1,
//    ((ARESETn & RVALID) & (! RREADY)),
//    (s117sq[1] && (ARESETn && !(s116)))};
//  always @(posedge ACLK) if (`AKRPS reset) ASR_78<=0; else
//    ASR_78 <= (s117s[0]);
localparam integer L_NUM_RUSER_BYTES       = ((RUSER_WIDTH + 7) / 8);
localparam integer L_NUM_RUSER_BYTE_LANES  = ((L_NUM_RUSER_BYTES + 7) / 8) * 8;
localparam integer L_NUM_RUSER_EQ_LANES    = (L_NUM_RUSER_BYTE_LANES / 8);
localparam integer L_NUM_RUSER_AND1_LANES  = (L_NUM_RUSER_EQ_LANES + 7) / 8;
localparam integer L_NUM_RUSER_AND2_LANES  = (L_NUM_RUSER_AND1_LANES + 7) / 8;

reg   [RUSER_WIDTH - 1:0] RUSER_q;
reg   [4:0]               s_RUSER_sq;
wire  [4:0]               s_RUSER_s;
wire                      s_RUSER_sqaa;

reg [(8*L_NUM_RUSER_EQ_LANES)-1:0]    RUSER_eq;
reg [(8*L_NUM_RUSER_AND1_LANES)-1:0]  RUSER_stage_1_eq;
reg [(8*L_NUM_RUSER_AND2_LANES)-1:0]  RUSER_stage_2_eq;

always @(posedge ACLK) begin
  if (`AKRPS reset) begin
    s_RUSER_sq<=5'h00; 
    ASR_78 <=0;
  end else begin
    s_RUSER_sq<=s_RUSER_s;
    ASR_78 <= (s_RUSER_s[0]);
  end
end

assign s_RUSER_s={
  (((ARESETn & RVALID) & (! RREADY))),
  (s_RUSER_sq[4] && ARESETn),
  (s_RUSER_sq[3]),
  (s_RUSER_sq[2]),
  (s_RUSER_sq[1] & !(s_RUSER_sqaa))
  };

assign s_RUSER_sqaa = &RUSER_stage_2_eq;

wire  [(L_NUM_RUSER_BYTES*8)-1:0]      RUSER_expand;
wire  [(L_NUM_RUSER_BYTES*8)-1:0]      RUSERsqa_expand;
  ///////////////////////////////////////////////////////////////////////////////////////////
  //Expand the RUSER up to the nearest byte
  for (RUSER_bit = 0; RUSER_bit < (L_NUM_RUSER_BYTES * 8); RUSER_bit = RUSER_bit + 1) begin : RUSER_BIT_LOOP
    if (RUSER_bit < RUSER_WIDTH) begin : VAL
      assign RUSER_expand[RUSER_bit] = RUSER[RUSER_bit];
      assign RUSERsqa_expand[RUSER_bit] = RUSER_q[RUSER_bit];
    end else begin
      assign RUSER_expand[RUSER_bit] = 1'b0;
      assign RUSERsqa_expand[RUSER_bit] = 1'b0;
    end
  end

integer RUSER_bc;
integer RUSER_stage_1;
integer RUSER_stage_2;

always @(posedge ACLK) begin
  RUSER_q<=RUSER;

  for (RUSER_bc = 0; RUSER_bc < L_NUM_RUSER_EQ_LANES*8; RUSER_bc = RUSER_bc + 1) begin : RUSER_BC_LOOP
    if (RUSER_bc < L_NUM_RUSER_BYTES) begin
      RUSER_eq[RUSER_bc] <= RUSER_expand[RUSER_bc*8 +:8] == RUSERsqa_expand[RUSER_bc*8 +: 8];
    end else begin
      RUSER_eq[RUSER_bc] <= 1'b1;
    end
  end

  for (RUSER_stage_1 = 0; RUSER_stage_1 < L_NUM_RUSER_AND1_LANES * 8;RUSER_stage_1 = RUSER_stage_1 + 1) begin : RUSER_S1
    if (RUSER_stage_1 < L_NUM_RUSER_EQ_LANES) begin
      RUSER_stage_1_eq[RUSER_stage_1] <= &RUSER_eq[RUSER_stage_1*8 +:8];
    end else begin
      RUSER_stage_1_eq[RUSER_stage_1] <= 1'b1;
    end
  end

  for (RUSER_stage_2 = 0; RUSER_stage_2 < L_NUM_RUSER_AND2_LANES * 8;RUSER_stage_2 = RUSER_stage_2 + 1) begin : RUSER_S2
    if (RUSER_stage_2 < L_NUM_RUSER_AND1_LANES) begin
      RUSER_stage_2_eq[RUSER_stage_2] <= &RUSER_stage_1_eq[RUSER_stage_2*8 +:8];
    end else begin
      RUSER_stage_2_eq[RUSER_stage_2] <= 1'b1;
    end
  end

end

  //---------------
  //ASR_79 : assert property ( @(posedge ACLK) ( ARESETn & ( AWUSER_WIDTH == 0 ) |-> $stable(AWUSER) ) );
  //---------------
  always @(posedge ACLK)
    s118<=AWUSER;
  assign s119 = s118 == AWUSER;
  always @(posedge ACLK) if (`AKRPS reset) ASR_79<=0; else
    ASR_79 <= (((ARESETn & ( (AWUSER_WIDTH == 0) )) && !(s119)));

  //---------------
  //ASR_80 : assert property ( @(posedge ACLK) ( ARESETn & ( WUSER_WIDTH == 0 ) |-> $stable(WUSER) ) );
  //---------------
  always @(posedge ACLK)
    s120<=WUSER;
  assign s121 = s120 == WUSER;
  always @(posedge ACLK) if (`AKRPS reset) ASR_80<=0; else
    ASR_80 <= (((ARESETn & ( (WUSER_WIDTH == 0) )) && !(s121)));

  //---------------
  //ASR_81 : assert property ( @(posedge ACLK) ( ARESETn & ( BUSER_WIDTH == 0 ) |-> $stable(BUSER) ) );
  //---------------
  always @(posedge ACLK)
    s122<=BUSER;
  assign s123 = s122 == BUSER;
  always @(posedge ACLK) if (`AKRPS reset) ASR_81<=0; else
    ASR_81 <= (((ARESETn & ( (BUSER_WIDTH == 0) )) && !(s123)));

  //---------------
  //ASR_82 : assert property ( @(posedge ACLK) ( ARESETn & ( ARUSER_WIDTH == 0 ) |-> $stable(ARUSER) ) );
  //---------------
  always @(posedge ACLK)
    s124<=ARUSER;
  assign s125 = s124 == ARUSER;
  always @(posedge ACLK) if (`AKRPS reset) ASR_82<=0; else
    ASR_82 <= (((ARESETn & ( (ARUSER_WIDTH == 0) )) && !(s125)));

  //---------------
  //ASR_83 : assert property ( @(posedge ACLK) ( ARESETn & ( RUSER_WIDTH == 0 ) |-> $stable(RUSER) ) );
  //---------------
  always @(posedge ACLK)
    s126<=RUSER;
  assign s127 = s126 == RUSER;
  always @(posedge ACLK) if (`AKRPS reset) ASR_83<=0; else
    ASR_83 <= (((ARESETn & ( (RUSER_WIDTH == 0) )) && !(s127)));

  //---------------
  //ASR_84 : assert property ( @(posedge ACLK) ( ARESETn & ( ID_WIDTH == 0 ) |-> $stable(AWID) ) );
  //---------------
  always @(posedge ACLK)
    s128<=AWID;
  assign s129 = s128 == AWID;
  always @(posedge ACLK) if (`AKRPS reset) ASR_84<=0; else
    ASR_84 <= (((ARESETn & ( (ID_WIDTH == 0) )) && !(s129)));

  //---------------
  //ASR_85 : assert property ( @(posedge ACLK) ( ARESETn & ( ID_WIDTH == 0 ) |-> $stable(BID) ) );
  //---------------
  always @(posedge ACLK)
    s130<=BID;
  assign s131 = s130 == BID;
  always @(posedge ACLK) if (`AKRPS reset) ASR_85<=0; else
    ASR_85 <= (((ARESETn & ( (ID_WIDTH == 0) )) && !(s131)));

  //---------------
  //ASR_86 : assert property ( @(posedge ACLK) ( ARESETn & ( ID_WIDTH == 0 ) |-> $stable(ARID) ) );
  //---------------
  always @(posedge ACLK)
    s132<=ARID;
  assign s133 = s132 == ARID;
  always @(posedge ACLK) if (`AKRPS reset) ASR_86<=0; else
    ASR_86 <= (((ARESETn & ( (ID_WIDTH == 0) )) && !(s133)));

  //---------------
  //ASR_87 : assert property ( @(posedge ACLK) ( ARESETn & ( ID_WIDTH == 0 ) |-> $stable(RID) ) );
  //---------------
  always @(posedge ACLK)
    s134<=RID;
  assign s135 = s134 == RID;
  always @(posedge ACLK) if (`AKRPS reset) ASR_87<=0; else
    ASR_87 <= (((ARESETn & ( (ID_WIDTH == 0) )) && !(s135)));

end else begin : gen_ltwt_chks
  
  always @(posedge ACLK) begin
    ASR_1  <= 1'b0;
    ASR_2  <= 1'b0;
    ASR_3  <= 1'b0;
    ASR_4  <= 1'b0;
    ASR_5  <= 1'b0;
    ASR_6  <= 1'b0;
    ASR_7  <= 1'b0;
    ASR_9  <= 1'b0;
    ASR_10 <= 1'b0;
    ASR_11 <= 1'b0;
    ASR_12 <= 1'b0;
    ASR_13 <= 1'b0;
    ASR_14 <= 1'b0;
    ASR_15 <= 1'b0;
    ASR_16 <= 1'b0;
    ASR_17 <= 1'b0;
    ASR_18 <= 1'b0;
    ASR_19 <= 1'b0;
    ASR_20 <= 1'b0;
    ASR_23 <= 1'b0;
    ASR_24 <= 1'b0;
    ASR_25 <= 1'b0;
    ASR_26 <= 1'b0;
    ASR_27 <= 1'b0;
    ASR_28 <= 1'b0;
    ASR_31 <= 1'b0;
    ASR_32 <= 1'b0;
    ASR_34 <= 1'b0;
    ASR_35 <= 1'b0;
    ASR_36 <= 1'b0;
    ASR_38 <= 1'b0;
    ASR_39 <= 1'b0;
    ASR_40 <= 1'b0;
    ASR_41 <= 1'b0;
    ASR_42 <= 1'b0;
    ASR_43 <= 1'b0;
    ASR_44 <= 1'b0;
    ASR_46 <= 1'b0;
    ASR_47 <= 1'b0;
    ASR_48 <= 1'b0;
    ASR_49 <= 1'b0;
    ASR_50 <= 1'b0;
    ASR_51 <= 1'b0;
    ASR_52 <= 1'b0;
    ASR_53 <= 1'b0;
    ASR_54 <= 1'b0;
    ASR_55 <= 1'b0;
    ASR_56 <= 1'b0;
    ASR_57 <= 1'b0;
    ASR_61 <= 1'b0;
    ASR_62 <= 1'b0;
    ASR_63 <= 1'b0;
    ASR_64 <= 1'b0;
    ASR_65 <= 1'b0;
    ASR_66 <= 1'b0;
    ASR_67 <= 1'b0;
    ASR_69 <= 1'b0;
    ASR_70 <= 1'b0;
    ASR_71 <= 1'b0;
    ASR_72 <= 1'b0;
    ASR_73 <= 1'b0;
    ASR_74 <= 1'b0;
    ASR_75 <= 1'b0;
    ASR_76 <= 1'b0;
    ASR_77 <= 1'b0;
    ASR_78 <= 1'b0;
    ASR_79 <= 1'b0;
    ASR_80 <= 1'b0;
    ASR_81 <= 1'b0;
    ASR_82 <= 1'b0;
    ASR_83 <= 1'b0;
    ASR_84 <= 1'b0;
    ASR_85 <= 1'b0;
    ASR_86 <= 1'b0;
    ASR_87 <= 1'b0;
  end
end
endgenerate
endmodule //Axi4PC_asr_inline


// (c) Copyright 2010 - 2013 Xilinx, Inc. All rights reserved.
//
// This file contains confidential and proprietary information
// of Xilinx, Inc. and is protected under U.S. and
// international copyright and other intellectual property
// laws.
//
// DISCLAIMER
// This disclaimer is not a license and does not grant any
// rights to the materials distributed herewith. Except as
// otherwise provided in a valid license issued to you by
// Xilinx, and to the maximum extent permitted by applicable
// law: (1) THESE MATERIALS ARE MADE AVAILABLE "AS IS" AND
// WITH ALL FAULTS, AND XILINX HEREBY DISCLAIMS ALL WARRANTIES
// AND CONDITIONS, EXPRESS, IMPLIED, OR STATUTORY, INCLUDING
// BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, NON-
// INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE; and
// (2) Xilinx shall not be liable (whether in contract or tort,
// including negligence, or under any other theory of
// liability) for any loss or damage of any kind or nature
// related to, arising under or in connection with these
// materials, including for any direct, or any indirect,
// special, incidental, or consequential loss or damage
// (including loss of data, profits, goodwill, or any type of
// loss or damage suffered as a result of any action brought
// by a third party) even if such damage or loss was
// reasonably foreseeable or Xilinx had been advised of the
// possibility of the same.
//
// CRITICAL APPLICATIONS
// Xilinx products are not designed or intended to be fail-
// safe, or for use in any application requiring fail-safe
// performance, such as life-support or safety devices or
// systems, Class III medical devices, nuclear facilities,
// applications related to the deployment of airbags, or any
// other applications that could lead to death, personal
// injury, or severe property or environmental damage
// (individually and collectively, "Critical
// Applications"). Customer assumes the sole risk and
// liability of any use of Xilinx products in Critical
// Applications, subject only to applicable laws and
// regulations governing limitations on product liability.
//
// THIS COPYRIGHT NOTICE AND DISCLAIMER MUST BE RETAINED AS
// PART OF THIS FILE AT ALL TIMES.
//*****************************************************************************
// Notes            : The assertion ASR_23 is not implemented for WDATA before
//                    AWADDR, since that would require storing all WSTRB in a
//                    burst.
//
//                    The following assertions use FIFOs to store AW and W
//                    signals, and can be disabled to improve frequency and
//                    reduce area: ASR_22, ASR_23, ASR_30, ASR_31, ASR_33.
//
//                    The following assertions use FIFOs to store AW and W
//                    signals, and can be disabled to improve frequency and
//                    reduce area: ASR_59, ASR_60, ASR_61, ASR_63, ASR_73.
//                    In particular, ASR_59 is timing critical.
//*****************************************************************************

`timescale 1ps/1ps
`default_nettype none

`define AXI4PC_TYPES
// ALEN Encoding
`define AXI4PC_ALEN_1            8'b00000000
`define AXI4PC_ALEN_2            8'b00000001
`define AXI4PC_ALEN_3            8'b00000010
`define AXI4PC_ALEN_4            8'b00000011
`define AXI4PC_ALEN_5            8'b00000100
`define AXI4PC_ALEN_6            8'b00000101
`define AXI4PC_ALEN_7            8'b00000110
`define AXI4PC_ALEN_8            8'b00000111
`define AXI4PC_ALEN_9            8'b00001000
`define AXI4PC_ALEN_10           8'b00001001
`define AXI4PC_ALEN_11           8'b00001010
`define AXI4PC_ALEN_12           8'b00001011
`define AXI4PC_ALEN_13           8'b00001100
`define AXI4PC_ALEN_14           8'b00001101
`define AXI4PC_ALEN_15           8'b00001110
`define AXI4PC_ALEN_16           8'b00001111

// ASIZE Encoding
`define AXI4PC_ASIZE_8           3'b000
`define AXI4PC_ASIZE_16          3'b001
`define AXI4PC_ASIZE_32          3'b010
`define AXI4PC_ASIZE_64          3'b011
`define AXI4PC_ASIZE_128         3'b100
`define AXI4PC_ASIZE_256         3'b101
`define AXI4PC_ASIZE_512         3'b110
`define AXI4PC_ASIZE_1024        3'b111

// ABURST Encoding
`define AXI4PC_ABURST_FIXED      2'b00
`define AXI4PC_ABURST_INCR       2'b01 
`define AXI4PC_ABURST_WRAP       2'b10 

// ALOCK Encoding
`define AXI4PC_ALOCK_EXCL        1'b1

// RRESP / BRESP Encoding
`define AXI4PC_RESP_OKAY         2'b00
`define AXI4PC_RESP_EXOKAY       2'b01
`define AXI4PC_RESP_SLVERR       2'b10
`define AXI4PC_RESP_DECERR       2'b11

(* DowngradeIPIdentifiedWarnings="yes" *) 
module axi_protocol_checker_v1_1_14_core #(
  parameter integer C_ERROR_COUNT = 97,
  parameter integer C_AXI_ID_WIDTH = 1,
  parameter integer C_AXI_DATA_WIDTH = 32,
  parameter integer C_AXI_ADDR_WIDTH = 32,
  parameter integer C_AXI_AWUSER_WIDTH = 1,
  parameter integer C_AXI_WUSER_WIDTH  = 1,
  parameter integer C_AXI_BUSER_WIDTH  = 1,
  parameter integer C_AXI_ARUSER_WIDTH = 1,
  parameter integer C_AXI_RUSER_WIDTH  = 1,
  parameter integer C_AXI_PROTOCOL = 0,
  parameter integer MAXRBURSTS = 16,
  parameter integer MAXWBURSTS = 16,
  parameter integer EXMON_WIDTH = 4,
  parameter integer RecommendOn = 1,
  parameter integer RecommendWaitOn = 1,
  parameter integer MAX_AW_WAITS = 16,
  parameter integer MAX_AR_WAITS = 16,
  parameter integer MAX_W_WAITS = 16,
  parameter integer MAX_R_WAITS = 16,
  parameter integer MAX_B_WAITS = 16,
  parameter integer MAX_CONTINUOUS_RTRANSFERS_WAITS  = 16,
  parameter integer MAX_CONTINUOUS_WTRANSFERS_WAITS = 16,
  parameter integer MAX_WLAST_TO_AWVALID_WAITS  = 16,
  parameter integer MAX_WRITE_TO_BVALID_WAITS  = 16,
  parameter integer LIGHT_WEIGHT  = 0,
  parameter integer C_PC_SUPPORTS_NARROW_BURST     = 1,
  parameter integer C_PC_HAS_SYSTEM_RESET = 0,
  parameter integer C_PC_MAX_BURST_LENGTH          = 256,
  parameter integer C_INDEX_WIDTH       = 1 ,
  parameter integer C_NUM_RTHREADS       = 1 ,
  parameter integer C_NUM_WTHREADS       = 1 
) (
   output wire [C_ERROR_COUNT-1:0]     pc_status,
   input wire                          resetn,

   input wire [C_INDEX_WIDTH-1:0]      arid_index,
   input wire [C_INDEX_WIDTH-1:0]      rid_index,
   input wire                          rid_mismatch,
   input wire                          rcam_overflow,
   input wire [C_INDEX_WIDTH-1:0]      awid_index,
   input wire [C_INDEX_WIDTH-1:0]      bid_index,
   input wire                          bid_mismatch,
   input wire                          wcam_overflow,

   input wire                          ACLK,
   input wire                          ARST_N,
   input wire [C_AXI_ID_WIDTH-1:0]     AWID,
   input wire [C_AXI_ADDR_WIDTH-1:0]   AWADDR,
   input wire [7:0]                    AWLEN,
   input wire [2:0]                    AWSIZE,
   input wire [1:0]                    AWBURST,
   input wire [0:0]                    AWLOCK,
   input wire [3:0]                    AWCACHE,
   input wire [2:0]                    AWPROT,
   input wire [3:0]                    AWQOS,
   input wire [3:0]                    AWREGION,
   input wire [C_AXI_AWUSER_WIDTH-1:0] AWUSER,
   input wire                          AWVALID,
   input wire                          AWREADY,
   input wire                          WLAST,
   input wire [C_AXI_DATA_WIDTH-1:0]   WDATA,
   input wire [C_AXI_DATA_WIDTH/8-1:0] WSTRB,
   input wire [C_AXI_WUSER_WIDTH-1:0]  WUSER,
   input wire                          WVALID,
   input wire                          WREADY,
   input wire [C_AXI_ID_WIDTH-1:0]     BID,
   input wire [1:0]                    BRESP,
   input wire [C_AXI_BUSER_WIDTH-1:0]  BUSER,
   input wire                          BVALID,
   input wire                          BREADY,
   input wire [C_AXI_ID_WIDTH-1:0]     ARID,
   input wire [C_AXI_ADDR_WIDTH-1:0]   ARADDR,
   input wire [7:0]                    ARLEN,
   input wire [2:0]                    ARSIZE,
   input wire [1:0]                    ARBURST,
   input wire [0:0]                    ARLOCK,
   input wire [3:0]                    ARCACHE,
   input wire [2:0]                    ARPROT,
   input wire [3:0]                    ARQOS,
   input wire [3:0]                    ARREGION,
   input wire [C_AXI_ARUSER_WIDTH-1:0] ARUSER,
   input wire                          ARVALID,
   input wire                          ARREADY,
   input wire [C_AXI_ID_WIDTH-1:0]     RID,
   input wire                          RLAST,
   input wire [C_AXI_DATA_WIDTH-1:0]   RDATA,
   input wire [1:0]                    RRESP,
   input wire [C_AXI_RUSER_WIDTH-1:0]  RUSER,
   input wire                          RVALID,
   input wire                          RREADY
  );


  /////////////////////////////////////////////////////////////////////////////
  // Functions
  /////////////////////////////////////////////////////////////////////////////
  
  // Log2.
  function integer log2;
    input integer value;
    integer a;
    begin
      a = value;
      
      for (log2=0; a>1; log2=log2+1) begin
        a = a >> 1;
      end
    end
  endfunction

  function integer f_ceil_log2
    (
     input integer x
     );
    integer acc;
    begin
      acc=0;
      while ((2**acc) < x)
        acc = acc + 1;
      f_ceil_log2 = acc;
    end
  endfunction

  /////////////////////////////////////////////////////////////////////////////
  // Local params
  /////////////////////////////////////////////////////////////////////////////

  localparam WEXCL           = 0;
  localparam WALENLO         = WEXCL + 1;
  localparam WALENHI         = WALENLO + 7;

  localparam WADDRLO         = 0;
  localparam WADDRHI         = 6;
  localparam WASIZELO        = WADDRHI + 1;
  localparam WASIZEHI        = WASIZELO + 2;

  localparam STRB_WIDTH      = C_AXI_DATA_WIDTH/8;
  localparam LOG2_STRB_WIDTH = log2(STRB_WIDTH);
  localparam ID_MAX          = C_AXI_ID_WIDTH? C_AXI_ID_WIDTH-1:0;
    
  localparam integer P_RTHREAD_SIZE = f_ceil_log2(C_NUM_RTHREADS);
  localparam integer P_MAXRBURSTS_LOG = f_ceil_log2(MAXRBURSTS);
  localparam integer P_WTHREAD_SIZE = f_ceil_log2(C_NUM_WTHREADS);
  localparam integer P_MAXWBURSTS_LOG = f_ceil_log2(MAXWBURSTS);

  localparam ADDRLO          = 0;
  localparam ADDRHI          = 6;
  localparam EXCL            = ADDRHI + 1;
  localparam ALENLO          = EXCL + 1;
  localparam ALENHI          = ALENLO + 7;
  localparam ASIZELO         = ALENHI + 1;
  localparam ASIZEHI         = ASIZELO + 2;
  localparam BURSTLO         = ASIZEHI + 1;
  localparam BURSTHI         = BURSTLO + 1;
  localparam LP_ADDR_WIDTH   = (C_AXI_ADDR_WIDTH > 12) ? C_AXI_ADDR_WIDTH : 13;
  localparam LP_EXMON_WIDTH  = (EXMON_WIDTH == 0) ? 1 : EXMON_WIDTH;

  wire internal_AWLOCK;
  wire internal_ARLOCK;
  
  assign internal_AWLOCK = (EXMON_WIDTH == 0) ? 1'b0 : AWLOCK;
  assign internal_ARLOCK = (EXMON_WIDTH == 0) ? 1'b0 : ARLOCK;



  /////////////////////////////////////////////////////////////////////////////
  // Internal signals
  /////////////////////////////////////////////////////////////////////////////

  wire [91:1]                 Axi4PC_asr_inline_out;
  wire [3:1]                  Axi4LitePC_asr_inline_out;
  reg  [11:1]                 xilinx_inline_out;
  wire [5:1]                  Axi4PC_aux;

  reg  [6:0]                  AlignMaskR;
  reg  [6:0]                  AlignMaskW;
  reg  [14:0]                 ExclMask;
  reg  [LP_ADDR_WIDTH-1:0]    ArAddrIncr;
  reg  [LP_ADDR_WIDTH-1:0]    AwAddrIncr;
  reg  [15:0]                 ArLenInBytes;
  reg  [10:0]                 ArSizeInBits;
  reg  [10:0]                 AwSizeInBits;
  wire                        ArExclPending;
  wire                        WriteDataNumError;
  reg                         BStrbError;
  wire [8:0]                  ArCountPending;
  wire [8:0]                  ArLenPending;
  reg                         RidMatch_index;
  wire [31:0]                 RidMatch;
  wire                        i_RecommendOn;
  wire                        i_RecMaxWaitOn;
  reg  [LP_EXMON_WIDTH-1:0]   ExclAwId;
  wire                        ExclIdOverflow;
  wire [LP_ADDR_WIDTH-1:0]    ExclAddr_indexed;
  wire [2:0]                  ExclSize_indexed;
  wire [7:0]                  ExclLen_indexed;
  wire [1:0]                  ExclBurst_indexed;
  wire [3:0]                  ExclCache_indexed;
  wire [2:0]                  ExclProt_indexed;
  wire [3:0]                  ExclRegion_indexed;
  wire                        ExclReadAddr_indexed;
  wire                        ExclReadData_indexed;

  genvar                      i;                    // FIFO generation variable

  // Write FIFO signals
  reg  [8:0]                  WCountIn;
  reg                         WDataNumError1;
  reg                         BrespErrorLead;

  // Read FIFO signals
  reg  [BURSTHI:0]            RBurstCam_index;
  wire [BURSTHI:0]            RBurstCam;
//  reg  [BURSTHI:0]            RBurstCam1;
  reg  [8:0]                  RCountCam_index;
  wire [8:0]                  RCountCam;
  reg  [8:0]                  RCountCam1;

  reg  [8:0]                  RCount[0:C_NUM_RTHREADS-1];
  reg  [0:C_NUM_RTHREADS-1]    RCountIncr;
  reg  [BURSTHI:0]            Burst;
  wire [(LIGHT_WEIGHT?7:BURSTHI):0] RDataOut[0:C_NUM_RTHREADS-1];
  wire [C_NUM_RTHREADS-1:0]    REmpty;
  wire [C_NUM_RTHREADS-1:0]    RFull;
//  reg  [11:0]                 Bcount1;
//  reg  [11:0]                 Bcount;
//  reg  [16:0]                 Bshift1;
//  reg  [15:0]                 Bshift;
  wire [LP_ADDR_WIDTH-1:0] lp_awaddr = {LP_ADDR_WIDTH{1'b0}} | AWADDR[C_AXI_ADDR_WIDTH-1:0];
  wire [LP_ADDR_WIDTH-1:0] lp_araddr = {LP_ADDR_WIDTH{1'b0}} | ARADDR[C_AXI_ADDR_WIDTH-1:0];

  wire [P_WTHREAD_SIZE-1:0]       AWIDOut;
  wire [7:0]                      AWLENOut;
  wire [6:0]                      AWStrbAddrOut;
  wire [2:0]                      AWStrbsizeOut;
  wire                            AWEmpty;
  wire                            AWFull;
  wire [8:0]                      WCheckCountOut;
  wire [C_AXI_DATA_WIDTH/8-1:0]   WCheckstrbOut;
  wire                            WCheckEmpty;
  wire                            WCheckFull;
  reg  [C_AXI_DATA_WIDTH/8-1:0]   WSTRBq;
  wire [C_AXI_DATA_WIDTH/8-1:0]   WstrbIn;
  reg                             first_strb;
  wire                            wcheckPop;
  reg  [log2(MAXWBURSTS):0]       AWXferCount[C_NUM_WTHREADS-1:0];
  reg                             AWXferCountOverflow;
  wire                            AWPush;
  wire                            WLastPush;
  
  wire [C_NUM_RTHREADS-1:0]       cmd_push;
  wire [C_NUM_RTHREADS-1:0]       cmd_pop;

  wire  reset_i;
  wire  resetn_out;
  wire  checker_main_resetn;
  (* shreg_extract="no", iob="false", equivalent_register_removal = "no" *) reg [2:0] reset_resync;

  assign reset_i = ~resetn;
  assign resetn_out = (C_PC_HAS_SYSTEM_RESET == 1) ? reset_resync[2] : ARST_N;
  
  always @(posedge ACLK or posedge reset_i) begin
    if (reset_i) begin
      reset_resync <= 3'b000;
    end else begin
      reset_resync <= {reset_resync[1:0], 1'b1};
    end
  end

  assign checker_main_resetn = resetn_out & ARST_N;

  /////////////////////////////////////////////////////////////////////////////
  // Rewritten auxillary code to meet timing derived from Axi4PC.sv
  /////////////////////////////////////////////////////////////////////////////

  //---------------------------------------------------------------------------
  // RDataMask
  //---------------------------------------------------------------------------
//  always @(posedge ACLK)
//  begin : p_ByteCountShiftSeq
//    if (!checker_main_resetn) begin
//      Bcount1    <= 12'b0;
//      Bcount     <= 12'b0;
//      Bshift1    <= 17'b0;
//      RBurstCam1 <= {BURSTHI+1{1'b0}};
//      RCountCam1 <= 9'b0;
//      Bshift     <= 16'b0;
//    end else begin
//      Bcount1    <= ByteCount(RBurstCam, RCountCam);
//      Bcount     <= Bcount1;
//      Bshift1    <= ByteShift1(RBurstCam, RCountCam);
//      RBurstCam1 <= RBurstCam;
//      RCountCam1 <= RCountCam;
//      Bshift     <= ByteShift2(RBurstCam1, RCountCam1, Bshift1);
//    end
//  end

  always @(lp_araddr or internal_ARLOCK or ARBURST or ARLEN or ARSIZE) begin
    if (LIGHT_WEIGHT==0) begin
      Burst[ADDRHI:ADDRLO]     = lp_araddr[ADDRHI:ADDRLO];
      Burst[EXCL]              = (internal_ARLOCK == `AXI4PC_ALOCK_EXCL);
      Burst[BURSTHI:BURSTLO]   = ARBURST;
      Burst[ALENHI:ALENLO]     = ARLEN;
      Burst[ASIZEHI:ASIZELO]   = ARSIZE;
    end else begin
      Burst                    = ARLEN;
    end
  end

genvar gen_thread;
generate
  for (gen_thread=0; gen_thread<C_NUM_RTHREADS; gen_thread=gen_thread+1) begin : gen_rthread_loop
    assign cmd_push[gen_thread] = (arid_index == gen_thread) && ARVALID & ARREADY;
    assign cmd_pop[gen_thread]  = (rid_index == gen_thread) && RVALID & RREADY & RLAST;
    
    axi_protocol_checker_v1_1_14_syn_fifo #(
      .C_DATA_WIDTH (LIGHT_WEIGHT?8:(BURSTHI+1)),
      .C_ADDR_WIDTH (P_MAXRBURSTS_LOG)
    ) RDCAM (
      .clk      (ACLK),
      .rst      (!checker_main_resetn),
      .data_in  (Burst[(LIGHT_WEIGHT?7:BURSTHI):0]),
      .rd       (cmd_pop[gen_thread]),
      .wr       (cmd_push[gen_thread]),
      .data_out (RDataOut[gen_thread]),
      .empty    (REmpty[gen_thread]),
      .full     (RFull[gen_thread])
    );
  
    // One Counter per ID
    always @(posedge ACLK) begin : p_RCountSeq
      if (!checker_main_resetn | cmd_pop[gen_thread] | (cmd_push[gen_thread] & REmpty[gen_thread])) begin
        RCount[gen_thread] <= 9'h000;
      end else if ((rid_index == gen_thread) && (RVALID & RREADY & !RLAST)) begin
        RCount[gen_thread] <= RCount[gen_thread] + 9'h001;
      end
    end
  end
  
endgenerate

integer gen_match;

always@( * ) begin : MUX_OUT
  RBurstCam_index = {BURSTHI+1{1'b0}};
  RCountCam_index = {9{1'b0}};
  for (gen_match = 0; gen_match < C_NUM_RTHREADS; gen_match = gen_match + 1) begin : GEN_MATCH
    if (rid_index == gen_match) begin : RID_MATCH
      RBurstCam_index = RDataOut[gen_match];
      RCountCam_index = RCount[gen_match];
    end
  end
end

  assign RBurstCam     = RBurstCam_index;
  assign RCountCam     = RCountCam_index;
  assign RidMatch      = !rid_mismatch;

  //---------------------------------------------------------------------------
  // Write CAMs: One FIFO per ID instead of true CAMs to improve timing.
  // Write bursts are not stored in single structure for checking when complete.
  // This prevents checking of write strobes for write data before address.
  //---------------------------------------------------------------------------
  always @(posedge ACLK) begin : p_WCountInSeq
    if (!checker_main_resetn | (WVALID & WREADY & WLAST)) begin
      WCountIn <= 9'h000;
    end else if (WVALID & WREADY & !WLAST) begin
      WCountIn <= WCountIn + 9'h001;
    end
  end

  //---------------------------------------------------------------------------
  // Auxillary logic assertions
  //---------------------------------------------------------------------------
  assign Axi4PC_aux[1] = (|(RFull  & cmd_push) | rcam_overflow) & ARST_N; // Rd CAM overflow
  assign Axi4PC_aux[2] = |(REmpty & cmd_pop) & ARST_N; // Rd CAM underflow should never occur; ERRS_RID should occur instead


  assign Axi4PC_aux[3] = ((AWFull & AWPush) | AWXferCountOverflow | wcam_overflow) & ARST_N; // Wr CAM overflow
  assign Axi4PC_aux[4] = (WCheckFull & WLastPush)  & ARST_N; // Wr CAM underflow
  assign Axi4PC_aux[5] = (LIGHT_WEIGHT==0) & (C_AXI_PROTOCOL != 2) & ExclIdOverflow & ARST_N;  // Excl overflow


  /////////////////////////////////////////////////////////////////////////////
  // Code from Axi4PC.sv (modifications indicated with ###)
  /////////////////////////////////////////////////////////////////////////////

  localparam DATA_MAX    = C_AXI_DATA_WIDTH-1;
  localparam EXMON_HI    = {LP_EXMON_WIDTH{1'b1}};
  localparam AWUSER_MAX  = C_AXI_AWUSER_WIDTH ? C_AXI_AWUSER_WIDTH-1:0;
  localparam WUSER_MAX   = C_AXI_WUSER_WIDTH ? C_AXI_WUSER_WIDTH-1:0;
  localparam BUSER_MAX   = C_AXI_BUSER_WIDTH ? C_AXI_BUSER_WIDTH-1:0;
  localparam ARUSER_MAX  = C_AXI_ARUSER_WIDTH ? C_AXI_ARUSER_WIDTH-1:0;
  localparam RUSER_MAX   = C_AXI_RUSER_WIDTH ? C_AXI_RUSER_WIDTH-1:0;
  localparam STRB_MAX    = C_AXI_DATA_WIDTH/8-1;
  localparam STRB_1      = {{STRB_MAX{1'b0}}, 1'b1};

  wire    [LP_EXMON_WIDTH-1:0] ExclIdWrPtr;
  reg               [ID_MAX:0] ExclId[EXMON_HI:0];
  reg                          ExclIdDelta;
  reg             [EXMON_HI:0] ExclIdValid;
  wire                         ExclIdFull;
  reg     [LP_EXMON_WIDTH-1:0] ExclIdFreePtr;
  reg                          ExclAwMatch;
  reg     [LP_EXMON_WIDTH-1:0] ExclArId;
  reg                          ExclArMatch;
  reg     [LP_EXMON_WIDTH-1:0] ExclRId;
  reg                          ExclRMatch;
  reg                          ExclReadAddr[EXMON_HI:0];
  reg                          ExclReadData[EXMON_HI:0];
  reg      [LP_ADDR_WIDTH-1:0] ExclAddr[EXMON_HI:0];
  reg                    [2:0] ExclSize[EXMON_HI:0];
  reg                    [7:0] ExclLen[EXMON_HI:0];
  reg                    [1:0] ExclBurst[EXMON_HI:0];
  reg                    [3:0] ExclCache[EXMON_HI:0];
  reg                    [2:0] ExclProt[EXMON_HI:0];
  reg                    [3:0] ExclQos[EXMON_HI:0];
  reg                    [3:0] ExclRegion[EXMON_HI:0];
  reg [C_AXI_AWUSER_WIDTH-1:0] ExclUser[EXMON_HI:0];


//------------------------------------------------------------------------------
// INDEX:   2) Combinatorial Logic
//------------------------------------------------------------------------------

  //----------------------------------------------------------------------------
  // INDEX:      a) Masks
  //----------------------------------------------------------------------------

  // INDEX:           - AlignMaskR
  // =====
  // Calculate wrap mask for read address
  always @(ARSIZE or ARVALID)
  begin
    if (ARVALID)
      case (ARSIZE)
        `AXI4PC_ASIZE_1024:  AlignMaskR = 7'b0000000;
        `AXI4PC_ASIZE_512:   AlignMaskR = 7'b1000000;
        `AXI4PC_ASIZE_256:   AlignMaskR = 7'b1100000;
        `AXI4PC_ASIZE_128:   AlignMaskR = 7'b1110000;
        `AXI4PC_ASIZE_64:    AlignMaskR = 7'b1111000;
        `AXI4PC_ASIZE_32:    AlignMaskR = 7'b1111100;
        `AXI4PC_ASIZE_16:    AlignMaskR = 7'b1111110;
        `AXI4PC_ASIZE_8:     AlignMaskR = 7'b1111111;
        default:             AlignMaskR = 7'b1111111;
      endcase
    else
      AlignMaskR = 7'b1111111;
  end


  // INDEX:           - AlignMaskW
  // =====
  // Calculate wrap mask for write address
  always @(AWSIZE or AWVALID)
  begin
    if (AWVALID)
      case (AWSIZE)
        `AXI4PC_ASIZE_1024:  AlignMaskW = 7'b0000000;
        `AXI4PC_ASIZE_512:   AlignMaskW = 7'b1000000;
        `AXI4PC_ASIZE_256:   AlignMaskW = 7'b1100000;
        `AXI4PC_ASIZE_128:   AlignMaskW = 7'b1110000;
        `AXI4PC_ASIZE_64:    AlignMaskW = 7'b1111000;
        `AXI4PC_ASIZE_32:    AlignMaskW = 7'b1111100;
        `AXI4PC_ASIZE_16:    AlignMaskW = 7'b1111110;
        `AXI4PC_ASIZE_8:     AlignMaskW = 7'b1111111;
        default:             AlignMaskW = 7'b1111111;
      endcase // case(AWSIZE)
    else
      AlignMaskW = 7'b1111111;
  end


  // INDEX:           - ExclMask
  // =====
  always @(ARLEN or ARSIZE)
  begin : p_ExclMaskComb
    ExclMask = ~((({7'b000_0000, ARLEN} + 15'b000_0000_0000_0001) << ARSIZE) - 15'b000_0000_0000_0001);
  end // block: p_ExclMaskComb


  //----------------------------------------------------------------------------
  // INDEX:      b) Increments
  //----------------------------------------------------------------------------

  // INDEX:           - ArAddrIncr
  // =====
  always @(ARSIZE or ARLEN or lp_araddr)
  begin : p_RAddrIncrComb
    ArAddrIncr = lp_araddr + (ARLEN << ARSIZE);  // The final address of the burst
  end


  // INDEX:           - AwAddrIncr
  // =====
  always @(AWSIZE or AWLEN or lp_awaddr)
  begin : p_WAddrIncrComb
    AwAddrIncr = lp_awaddr + (AWLEN << AWSIZE);  // The final address of the burst
  end


  //----------------------------------------------------------------------------
  // INDEX:      c) Conversions
  //----------------------------------------------------------------------------

  // INDEX:           - ArLenInBytes
  // =====
  always @(ARSIZE or ARLEN)
  begin : p_ArLenInBytes
    // bytes = (ARLEN+1) data transfers x ARSIZE bytes
    ArLenInBytes = (({8'h00, ARLEN} + 16'h001) << ARSIZE); 
  end


  // INDEX:           - ArSizeInBits
  // =====
  always @(ARSIZE)
  begin : p_ArSizeInBits
    ArSizeInBits = (11'b000_0000_1000 << ARSIZE); // bits = 8 x ARSIZE bytes
  end


  // INDEX:           - AwSizeInBits
  // =====
  always @(AWSIZE)
  begin : p_AwSizeInBits
    AwSizeInBits = (11'b000_0000_1000 << AWSIZE); // bits = 8 x AWSIZE bytes
  end


  //----------------------------------------------------------------------------
  // INDEX:      d) Other
  //----------------------------------------------------------------------------

  // INDEX:           - ArExclPending
  // =====
  // Avoid putting on assertion directly as index is an integer
  assign ArExclPending = RBurstCam[EXCL]; // ### Rewritten

  // INDEX:           - ArLenPending
  // =====
  // Avoid putting on assertion directly as index is an integer
  assign ArLenPending = {1'b0, (LIGHT_WEIGHT ? RBurstCam[7:0] : RBurstCam[ALENHI:ALENLO])}; // ### Rewritten

  // INDEX:           - ArCountPending
  // =====
  // Avoid putting on assertion directly as index is an integer
  assign ArCountPending = RCountCam; // ### Rewritten


//------------------------------------------------------------------------------
// INDEX:   3) EXCL Accesses
//------------------------------------------------------------------------------

  // INDEX:        - Exclusive Access ID Lookup
  // =====
  // Map transaction IDs to the available exclusive access storage loactions

  // Lookup table for IDs used by the exclusive access monitor
  // Each location in the table has a valid flag to indicate if the ID is in use
  // The location of an ID flagged as valid is used as a virtual ID in the
  // exclusive access monitor checks
  always @(posedge ACLK)
  begin : p_ExclIdSeq
    integer i;  // loop counter
    if (LIGHT_WEIGHT || !checker_main_resetn)
    begin
      ExclIdValid <= {EXMON_HI+1{1'b0}};
      ExclIdDelta <= 1'b0;
      for (i = 0; i <= EXMON_HI; i = i + 1)
      begin
        ExclId[i] <= {ID_MAX+1{1'b0}};
      end
    end else if (EXMON_WIDTH > 0) // clk edge
    begin
      // exclusive read address transfer
      if (ARVALID && ARREADY && (internal_ARLOCK == `AXI4PC_ALOCK_EXCL) &&
          !ExclIdFull)
      begin
        ExclId[ExclIdWrPtr] <= ARID;
        ExclIdValid[ExclIdWrPtr] <= 1'b1;
        ExclIdDelta <= ~ExclIdDelta;
      end
      // exclusive write
      if (AWVALID && AWREADY && (internal_AWLOCK == `AXI4PC_ALOCK_EXCL) &&
          ExclAwMatch)
      begin
        ExclIdValid[ExclAwId] <= 1'b0;
        ExclIdDelta <= ~ExclIdDelta;
      end
    end // else: !if(!checker_main_resetn)
  end // block: p_ExclIdSeq

  // Lookup table is full when all valid bits are set
  assign ExclIdFull = &ExclIdValid;

  // Lookup table overflows when it is full and another exclusive read happens
  // with an ID that does not match any already being monitored
  assign ExclIdOverflow = ExclIdFull &&
                          ARVALID && ARREADY && (internal_ARLOCK == `AXI4PC_ALOCK_EXCL) &&
                          !ExclArMatch;

  // New IDs are written to the highest location
  // that does not have the valid flag set 
  always @(ExclIdValid)
  begin : p_ExclIdFreePtrComb
    integer i;  // loop counter
    ExclIdFreePtr = 0;
    for (i = 0; i <= EXMON_HI; i = i + 1)
    begin
      if (ExclIdValid[i] == 1'b0)
      begin
        ExclIdFreePtr = i;
      end
    end
  end // p_ExclIdFreePtrComb

  // If the ID is already being monitored then reuse the location
  // New IDs are written to the highest location
  // that does not have the valid flag set 
  assign ExclIdWrPtr = ExclArMatch ? ExclArId : ExclIdFreePtr;

  // Write address ID comparator
//  always @(AWVALID or AWID or ExclIdValid or ExclIdDelta or ExclId)
  always @( * )
  begin : p_ExclAwMatchComb
    integer i;  // loop counter
    ExclAwMatch = 1'b0;
    ExclAwId = {LP_EXMON_WIDTH{1'b0}};
    if (AWVALID)
    begin
      for (i = 0; i <= EXMON_HI; i = i + 1)
      begin
        if (ExclIdValid[i] && (AWID == ExclId[i]))
        begin
          ExclAwMatch = 1'b1;
          ExclAwId = i;
        end
      end
    end
  end // p_ExclAwMatchComb

  // Read address ID comparator
//  always @(ARVALID or ARID or ExclIdValid or ExclIdDelta or ExclId)
  always @( * )
  begin : p_ExclArMatchComb
    integer i;  // loop counter
    ExclArMatch = 1'b0;
    ExclArId = {LP_EXMON_WIDTH{1'b0}};
    if (ARVALID)
    begin
      for (i = 0; i <= EXMON_HI; i = i + 1)
      begin
        if (ExclIdValid[i] && (ARID == ExclId[i]))
        begin
          ExclArMatch = 1'b1;
          ExclArId = i;
        end
      end
    end
  end // p_ExclArMatchComb

  // Read data ID comparator
  always @( * )
  begin : p_ExclRMatchComb
    integer i;  // loop counter
    ExclRMatch = 1'b0;
    ExclRId = {LP_EXMON_WIDTH{1'b0}};
    if (RVALID)
    begin
      for (i = 0; i <= EXMON_HI; i = i + 1)
      begin
        if (ExclIdValid[i] && (RID == ExclId[i]))
        begin
          ExclRMatch = 1'b1;
          ExclRId = i;
        end
      end
    end
  end // p_ExclRMatchComb

  // INDEX:        - Exclusive Access Storage
  // =====
  // Store exclusive control info on each read for checking against write

  always @(posedge ACLK)
  begin : p_ExclCtrlSeq
    integer i;  // loop counter

    if (LIGHT_WEIGHT || !checker_main_resetn)
      for (i = 0; i <= EXMON_HI; i = i + 1)
      begin
        ExclReadAddr[i] <= 1'b0;
        ExclReadData[i] <= 1'b0;
        ExclAddr[i]     <= {LP_ADDR_WIDTH{1'b0}};
        ExclSize[i]     <= 3'b000;
        ExclLen[i]      <= {8{1'b0}};
        ExclBurst[i]    <= 2'b00;
        ExclCache[i]    <= {4{1'b0}};
        ExclProt[i]     <= {3{1'b0}};
        ExclQos[i]      <= {4{1'b0}};
        ExclRegion[i]   <= {4{1'b0}};
        ExclUser[i]     <= {ARUSER_MAX+1{1'b0}};
      end
    else if (EXMON_WIDTH > 0) // clk edge
    begin
      // exclusive read address transfer
      if (ARVALID && ARREADY && (internal_ARLOCK == `AXI4PC_ALOCK_EXCL) &&
          !ExclIdFull)
      begin
        ExclReadAddr[ExclIdWrPtr] <= 1'b1; // set exclusive read addr flag for ARID
        ExclReadData[ExclIdWrPtr] <= 1'b0; // reset exclusive read data flag for ARID
        ExclAddr[ExclIdWrPtr]     <= lp_araddr;
        ExclSize[ExclIdWrPtr]     <= ARSIZE;
        ExclLen[ExclIdWrPtr]      <= ARLEN;
        ExclBurst[ExclIdWrPtr]    <= ARBURST;
        ExclCache[ExclIdWrPtr]    <= ARCACHE;
        ExclProt[ExclIdWrPtr]     <= ARPROT;
        ExclQos[ExclIdWrPtr]      <= ARQOS;
        ExclRegion[ExclIdWrPtr]   <= ARREGION;
        ExclUser[ExclIdWrPtr]     <= ARUSER;
      end
      // exclusive write
      if (AWVALID && AWREADY && (internal_AWLOCK == `AXI4PC_ALOCK_EXCL) &&
          ExclAwMatch)
      begin
        ExclReadAddr[ExclAwId] <= 1'b0; // reset exclusive address flag for AWID
        ExclReadData[ExclAwId] <= 1'b0; // reset exclusive read data flag for AWID
      end
      // completion of exclusive read data transaction
      if ((RVALID && RREADY && RLAST && ExclReadAddr[ExclRId] &&
           ExclRMatch) &&
           // check the read CAM that this is part of an exclusive transfer
           RBurstCam[EXCL] // ### Rewritten
         )
        ExclReadData[ExclRId]  <= 1'b1; // set exclusive read data flag for RID
    end // else: !if(!checker_main_resetn)
  end // block: p_ExclCtrlSeq

//------------------------------------------------------------------------------
// INDEX:   4) Content addressable memories (CAMs)
//------------------------------------------------------------------------------

  assign WriteDataNumError = WDataNumError1;

  /////////////////////////////////////////////////////////////////////////////
  // Instantiation
  /////////////////////////////////////////////////////////////////////////////

  assign i_RecommendOn  = (RecommendOn == 0)     ? 1'b0 : 1'b1;
  assign i_RecMaxWaitOn = (RecommendWaitOn == 0) ? 1'b0 : 1'b1;

  assign ExclAddr_indexed     = ExclAddr[ExclAwId];
  assign ExclSize_indexed     = ExclSize[ExclAwId];
  assign ExclLen_indexed      = ExclLen[ExclAwId];
  assign ExclBurst_indexed    = ExclBurst[ExclAwId];
  assign ExclCache_indexed    = ExclCache[ExclAwId];
  assign ExclProt_indexed     = ExclProt[ExclAwId];
  assign ExclRegion_indexed   = ExclRegion[ExclAwId];
  assign ExclReadAddr_indexed = ExclReadAddr[ExclAwId];
  assign ExclReadData_indexed = ExclReadData[ExclAwId];

  axi_protocol_checker_v1_1_14_axi4pc_asr_inline #
  (
     .DATA_WIDTH   (C_AXI_DATA_WIDTH),
     .ID_WIDTH     (C_AXI_ID_WIDTH),
     .AWUSER_WIDTH (C_AXI_AWUSER_WIDTH),
     .WUSER_WIDTH  (C_AXI_WUSER_WIDTH),
     .BUSER_WIDTH  (C_AXI_BUSER_WIDTH),
     .ARUSER_WIDTH (C_AXI_ARUSER_WIDTH),
     .RUSER_WIDTH  (C_AXI_RUSER_WIDTH),
     .MAXRBURSTS   (MAXRBURSTS),
     .MAXWBURSTS   (MAXWBURSTS),
     .ADDR_WIDTH   (LP_ADDR_WIDTH),
     .DATA_MAX     (DATA_MAX),
     .ADDR_MAX     (LP_ADDR_WIDTH - 1),
     .STRB_WIDTH   (STRB_WIDTH),
     .STRB_MAX     (STRB_MAX),
     .ID_MAX       (ID_MAX),
     .AWUSER_MAX   (AWUSER_MAX),
     .WUSER_MAX    (WUSER_MAX),
     .BUSER_MAX    (BUSER_MAX),
     .ARUSER_MAX   (ARUSER_MAX),
     .RUSER_MAX    (RUSER_MAX),
     .MAX_AW_WAITS (MAX_AW_WAITS),
     .MAX_AR_WAITS (MAX_AR_WAITS),
     .MAX_W_WAITS  (MAX_W_WAITS),
     .MAX_R_WAITS  (MAX_R_WAITS),
     .MAX_B_WAITS  (MAX_B_WAITS),
     .MAX_CONTINUOUS_RTRANSFERS_WAITS  (MAX_CONTINUOUS_RTRANSFERS_WAITS),
     .MAX_CONTINUOUS_WTRANSFERS_WAITS  (MAX_CONTINUOUS_WTRANSFERS_WAITS),
     .MAX_WLAST_TO_AWVALID_WAITS  (MAX_WLAST_TO_AWVALID_WAITS),
     .MAX_WRITE_TO_BVALID_WAITS  (MAX_WRITE_TO_BVALID_WAITS),
     .LIGHT_WEIGHT (LIGHT_WEIGHT)
   )
  i_Axi4PC_asr_inline
  (
     .Axi4PC_asr_inline_out (Axi4PC_asr_inline_out),
     .reset                 (resetn_out),
     .AWVALID               (AWVALID),
     .AWBURST               (AWBURST),
     .AwAddrIncr            (AwAddrIncr),
     .AWADDR                (lp_awaddr),
     .ACLK                  (ACLK),
     .AlignMaskW            (AlignMaskW),
     .AWLEN                 (AWLEN),
     .AWLOCK                (internal_AWLOCK),
     .AWCACHE               (AWCACHE),
     .AwSizeInBits          (AwSizeInBits),
     .ARESETn               (ARST_N),
     .AWREADY               (AWREADY),
     .AWID                  (AWID),
     .AWPROT                (AWPROT),
     .AWSIZE                (AWSIZE),
     .AWQOS                 (AWQOS),
     .AWREGION              (AWREGION),
     .i_RecommendOn         (i_RecommendOn),
     .i_RecMaxWaitOn        (i_RecMaxWaitOn),
     .WriteDataNumError     (WriteDataNumError),
     .BStrbError            (BStrbError),
     .WVALID                (WVALID),
     .WREADY                (WREADY),
     .WDATA                 (WDATA),
     .WLAST                 (WLAST),
     .WSTRB                 (WSTRB),
     .BrespErrorLast        (1'b0),
     .BrespExokError        (1'b0),
     .BVALID                (BVALID),
     .BrespErrorLead        (BrespErrorLead),
     .BREADY                (BREADY),
     .BID                   (BID),
     .BRESP                 (BRESP),
     .ARVALID               (ARVALID),
     .ARBURST               (ARBURST),
     .ArAddrIncr            (ArAddrIncr),
     .ARADDR                (lp_araddr),
     .AlignMaskR            (AlignMaskR),
     .ARLEN                 (ARLEN),
     .ARLOCK                (internal_ARLOCK),
     .ARCACHE               (ARCACHE),
     .ArSizeInBits          (ArSizeInBits),
     .ARREADY               (ARREADY),
     .ARID                  (ARID),
     .ARPROT                (ARPROT),
     .ARSIZE                (ARSIZE),
     .ARQOS                 (ARQOS),
     .ARREGION              (ARREGION),
     .RVALID                (RVALID),
     .RREADY                (RREADY),
     .ArCountPending        (ArCountPending),
     .ArLenPending          (ArLenPending),
     .RLAST                 (RLAST),
     .RidMatch              (RidMatch),
     .RRESP                 (RRESP),
     .ArExclPending         (ArExclPending),
     .RDATA                 (RDATA),
     .RID                   (RID),
     .CSYSREQ               (1'b0),
     .CSYSACK               (1'b0),
     .ExclMask              (ExclMask),
     .ExclReadAddr          (ExclReadAddr_indexed),
     .ExclAwMatch           (ExclAwMatch),
     .ExclAddr              (ExclAddr_indexed),
     .ExclSize              (ExclSize_indexed),
     .ExclLen               (ExclLen_indexed),
     .ExclBurst             (ExclBurst_indexed),
     .ExclCache             (ExclCache_indexed),
     .ExclProt              (ExclProt_indexed),
     .ExclRegion            (ExclRegion_indexed),
     .ArLenInBytes          (ArLenInBytes),
     .ExclReadData          (ExclReadData_indexed),
     .AWUSER                (AWUSER),
     .WUSER                 (WUSER),
     .BUSER                 (BUSER),
     .ARUSER                (ARUSER),
     .RUSER                 (RUSER)
   );


  generate
    if (C_AXI_PROTOCOL == 2) begin : LITE
      axi_protocol_checker_v1_1_14_axi4litepc_asr_inline #
      (
         .DATA_WIDTH (C_AXI_DATA_WIDTH)
       )
      i_Axi4LitePC_asr_inline
      (
         .Axi4LitePC_asr_inline_out (Axi4LitePC_asr_inline_out),
         .reset                     (resetn_out),
         .BVALID                    (BVALID),
         .BRESP                     (BRESP),
         .ACLK                      (ACLK),
         .RVALID                    (RVALID),
         .RRESP                     (RRESP)
       );
    end else begin : NO_LITE
      assign Axi4LitePC_asr_inline_out = 3'b000;
    end
  endgenerate
  

  /////////////////////////////////////////////////////////////////////////////
  // Error output masking and latching
  /////////////////////////////////////////////////////////////////////////////

  reg  [C_ERROR_COUNT-1:0] pc_status_i;
  wire [C_ERROR_COUNT-1:0] pc_status_masked;

  assign pc_status_masked = {Axi4PC_asr_inline_out[91:88], xilinx_inline_out, Axi4LitePC_asr_inline_out, Axi4PC_aux, Axi4PC_asr_inline_out[78:1]};

  always @(posedge ACLK)
  begin : p_errorSeq
    if (!checker_main_resetn) begin
      pc_status_i <= {C_ERROR_COUNT {1'b0}};
    end else begin
      pc_status_i <= pc_status_masked | pc_status_i;
    end
  end

  assign pc_status = pc_status_i;

  assign AWPush = AWREADY & AWVALID;
  assign WLastPush = WVALID & WREADY & WLAST;

  /////////////////////////////////////////////////////////////////////////////
  //AW-W checks
  axi_protocol_checker_v1_1_14_syn_fifo # (
    .C_DATA_WIDTH (WASIZEHI+1+8+P_WTHREAD_SIZE),
    .C_ADDR_WIDTH (log2(MAXWBURSTS))
   ) AWCMD (
    .clk      (ACLK),
    .rst      (!checker_main_resetn),
    .data_in  ({awid_index[P_WTHREAD_SIZE-1:0], AWLEN, AWSIZE, ((LIGHT_WEIGHT==0)?lp_awaddr[WADDRHI:WADDRLO]:{WADDRHI-WADDRLO+1{1'b0}})}),
    .rd       (wcheckPop),
    .wr       (AWPush),
    .data_out ({AWIDOut, AWLENOut,AWStrbsizeOut, AWStrbAddrOut}),
    .empty    (AWEmpty),
    .full     (AWFull)
  );
  
  axi_protocol_checker_v1_1_14_syn_fifo # (
    .C_DATA_WIDTH (9+STRB_MAX+1),
    .C_ADDR_WIDTH (log2(MAXWBURSTS))
   ) WCHECK (
    .clk      (ACLK),
    .rst      (!checker_main_resetn),
    .data_in  ({WCountIn, ((LIGHT_WEIGHT==0)?WstrbIn:{C_AXI_DATA_WIDTH/8{1'b0}})}),
    .rd       (wcheckPop),
    .wr       (WLastPush),
    .data_out ({WCheckCountOut, WCheckstrbOut}),
    .empty    (WCheckEmpty),
    .full     (WCheckFull)
  );

  assign WstrbIn = (first_strb) ? WSTRB : WSTRBq;
  assign wcheckPop = (!WCheckEmpty & !AWEmpty);

  always @(posedge ACLK) begin : p_wstrb
    if (LIGHT_WEIGHT || !checker_main_resetn | (WVALID & WREADY & WLAST)) begin
      WSTRBq <= {C_AXI_DATA_WIDTH/8{1'b0}};
      first_strb <= 1'b1;
    end else if (WVALID & WREADY & first_strb) begin
      first_strb <= 1'b0;
      WSTRBq <= WSTRB;
    end
  end

integer id_cnt;

localparam L_CHECK_PIPE_WIDTH = 7;

reg   [STRB_MAX:0] StrbMask_q1;  
reg   [STRB_MAX:0] StrbMask_q2;  
reg   [STRB_MAX:0] StrbMask_q3_n;  

reg          [6:0] StrbAddr_q1;
reg          [6:0] StrbAddr_q2;
reg          [2:0] StrbSize_q1;
reg          [2:0] StrbSize_q2;
reg   [STRB_MAX:0] Strb_q1;
reg   [STRB_MAX:0] Strb_q2;
reg   [STRB_MAX:0] Strb_q3;
reg          [L_CHECK_PIPE_WIDTH-1:0] wchechPop_shift;
reg                CheckStrbAssert;
reg          [6:0] mask_shift_stage_1;
reg          [6:0] mask_shift_stage_2;
reg          [6:0] mask_shift_stage_2_q1;

always @(posedge ACLK) begin
  StrbAddr_q1 <= AWStrbAddrOut;
  StrbAddr_q2 <= StrbAddr_q1;
  StrbSize_q1 <= AWStrbsizeOut;
  StrbSize_q2 <= StrbSize_q1;
  Strb_q1 <= WCheckstrbOut;
  Strb_q2 <= Strb_q1;
  Strb_q3 <= Strb_q2;

  mask_shift_stage_1 <= (AWStrbAddrOut & ((STRB_1 << AWStrbsizeOut) -  STRB_1));
  mask_shift_stage_2 <= (AWStrbAddrOut & ((STRB_MAX << AWStrbsizeOut) & STRB_MAX));
  mask_shift_stage_2_q1 <= mask_shift_stage_2;
  // The basic strobe for an aligned address
  StrbMask_q1 <= (STRB_1 << (STRB_1 << AWStrbsizeOut)) - STRB_1;
  // Zero the unaligned byte lanes
  // Note: the number of unaligned byte lanes is given by:
  // (StrbAddr & ((1 << StrbSize) - 1)), i.e. the unaligned part of the
  // address with respect to the transfer size
  //
  // Note! {{STRB_MAX{1'b0}}, 1'b1} gives 1 in the correct vector length
  StrbMask_q2 <= StrbMask_q1 &                    // Mask off unaligned byte lanes
    (StrbMask_q1 << mask_shift_stage_1);          // shift the strb mask left by the number of unaligned byte lanes

  StrbMask_q3_n <= ~(StrbMask_q2 << mask_shift_stage_2_q1);

end

localparam integer L_NUM_CHKSTRB_NIBS       = (((C_AXI_DATA_WIDTH/8) + 3) / 4);
localparam integer L_NUM_CHKSTRB_NIB_LANES  = ((L_NUM_CHKSTRB_NIBS + 3) / 4) * 4;
localparam integer L_NUM_CHKSTRB_EQ_LANES    = (L_NUM_CHKSTRB_NIB_LANES / 4);
localparam integer L_NUM_CHKSTRB_AND1_LANES  = (L_NUM_CHKSTRB_EQ_LANES + 3) / 4;
localparam integer L_NUM_CHKSTRB_AND2_LANES  = (L_NUM_CHKSTRB_AND1_LANES + 3) / 4;

reg [(4*L_NUM_CHKSTRB_EQ_LANES)-1:0]    CHKSTRB_eq;
reg [(4*L_NUM_CHKSTRB_AND1_LANES)-1:0]  CHKSTRB_stage_1_eq;
reg [(4*L_NUM_CHKSTRB_AND2_LANES)-1:0]  CHKSTRB_stage_2_eq;

//assign s_CHKSTRB_sqaa = &CHKSTRB_stage_2_eq;

integer CHKSTRB_bc;
integer CHKSTRB_stage_1;
integer CHKSTRB_stage_2;

always @(posedge ACLK) begin
  for (CHKSTRB_bc = 0; CHKSTRB_bc < L_NUM_CHKSTRB_EQ_LANES*4; CHKSTRB_bc = CHKSTRB_bc + 1) begin : CHKSTRB_BC_LOOP
    if (CHKSTRB_bc < ((C_AXI_DATA_WIDTH/8)/4)) begin
      CHKSTRB_eq[CHKSTRB_bc] <= |(Strb_q3[CHKSTRB_bc*4 +:4] & StrbMask_q3_n[CHKSTRB_bc*4 +: 4]);
    end else begin
      CHKSTRB_eq[CHKSTRB_bc] <= 1'b0;
    end
  end

  for (CHKSTRB_stage_1 = 0; CHKSTRB_stage_1 < L_NUM_CHKSTRB_AND1_LANES * 4;CHKSTRB_stage_1 = CHKSTRB_stage_1 + 1) begin : CHKSTRB_S1
    if (CHKSTRB_stage_1 < L_NUM_CHKSTRB_EQ_LANES) begin
      CHKSTRB_stage_1_eq[CHKSTRB_stage_1] <= |CHKSTRB_eq[CHKSTRB_stage_1*4 +:4];
    end else begin
      CHKSTRB_stage_1_eq[CHKSTRB_stage_1] <= 1'b0;
    end
  end

  for (CHKSTRB_stage_2 = 0; CHKSTRB_stage_2 < L_NUM_CHKSTRB_AND2_LANES * 4;CHKSTRB_stage_2 = CHKSTRB_stage_2 + 1) begin : CHKSTRB_S2
    if (CHKSTRB_stage_2 < L_NUM_CHKSTRB_AND1_LANES) begin
      CHKSTRB_stage_2_eq[CHKSTRB_stage_2] <= |CHKSTRB_stage_1_eq[CHKSTRB_stage_2*4 +:4];
    end else begin
      CHKSTRB_stage_2_eq[CHKSTRB_stage_2] <= 1'b0;
    end
  end

end


always @(posedge ACLK) begin : bstrb_check
  if (LIGHT_WEIGHT || !checker_main_resetn) begin
    BStrbError <= 1'b0;
    wchechPop_shift <= {L_CHECK_PIPE_WIDTH{1'b0}};
    CheckStrbAssert <= 1'b0;
  end else begin
    wchechPop_shift <= {wchechPop_shift[(L_CHECK_PIPE_WIDTH-2):0], wcheckPop};
    BStrbError <= wchechPop_shift[(L_CHECK_PIPE_WIDTH-1)] & CheckStrbAssert;
    CheckStrbAssert <= |CHKSTRB_stage_2_eq;
  end
end

  always @(posedge ACLK) begin : p_check
    if (!checker_main_resetn) begin
      WDataNumError1 <= 1'b0;
      for (id_cnt = 0; id_cnt <= C_NUM_WTHREADS; id_cnt = id_cnt + 1) begin
        AWXferCount[id_cnt] <= {log2(MAXWBURSTS) + 1{1'b0}};
      end
      BrespErrorLead <= 1'b0;
      AWXferCountOverflow <= 1'b0;
    end else begin
      WDataNumError1 <= 1'b0;
      AWXferCountOverflow <= 1'b0;
      //Trigger Error of B->{AW or W}
      if (BVALID & !(wcheckPop & (bid_index == AWIDOut) & !bid_mismatch)) begin
        BrespErrorLead <= bid_mismatch | (AWXferCount[bid_index] == 0);
      end else begin
        BrespErrorLead <= 1'b0;
      end
      ////////////////////////////////////////////////////////////////
      //Count the number of AWID's and BID's
      if (wcheckPop) begin
        WDataNumError1 <= (WCheckCountOut != {1'b0,AWLENOut});
      end
      if (wcheckPop & !(BVALID & BREADY & (bid_index == AWIDOut))) begin
        AWXferCount[AWIDOut] <= AWXferCount[AWIDOut] + 1;
        AWXferCountOverflow <= AWXferCount[AWIDOut] == {1'b1,{log2(MAXWBURSTS){1'b0}}};
      end
      if (BVALID & BREADY & !(wcheckPop & (bid_index == AWIDOut))) begin
        AWXferCount[bid_index] <= AWXferCount[bid_index] - 1;
      end
    end
  end

//////////////////////////////////////////////////////////////////////////////////////////////////
//Xilinx Checks
wire [2:0]  awready_s;
wire [2:0]  wready_s;
wire [2:0]  bready_s;
wire [2:0]  arready_s;
wire [2:0]  rready_s;

reg  [2:0]  awready_sq;
reg  [2:0]  wready_sq;
reg  [2:0]  bready_sq;
reg  [2:0]  arready_sq;
reg  [2:0]  rready_sq;

always @(posedge ACLK) begin : xil_check
  if (LIGHT_WEIGHT || !resetn_out) begin
    xilinx_inline_out <= 11'h000;
    awready_sq <= 3'h4;
    wready_sq <= 3'h4;
    bready_sq <= 3'h4;
    arready_sq <= 3'h4;
    rready_sq <= 3'h4;
  end else begin
    xilinx_inline_out[1] <= (C_PC_SUPPORTS_NARROW_BURST == 0) && (AWVALID && (AWLEN > 0) && (AwSizeInBits < C_AXI_DATA_WIDTH));
    xilinx_inline_out[2] <= (C_PC_SUPPORTS_NARROW_BURST == 0) && (ARVALID && (ARLEN > 0) && (ArSizeInBits < C_AXI_DATA_WIDTH));
    xilinx_inline_out[3] <= (C_PC_SUPPORTS_NARROW_BURST == 0) && (AWVALID && (AWLEN > 0) && !(AWCACHE[1]));
    xilinx_inline_out[4] <= (C_PC_SUPPORTS_NARROW_BURST == 0) && (ARVALID && (ARLEN > 0) && !(ARCACHE[1]));
    xilinx_inline_out[5] <= (AWVALID && !(AWLEN <= (C_PC_MAX_BURST_LENGTH - 1)));
    xilinx_inline_out[6] <= (ARVALID && !(ARLEN <= (C_PC_MAX_BURST_LENGTH - 1)));

    //////////////////////////////////////////////////////////////////////////////////////////////////
    //Xilinx xREADY checks : xREADY is LOW for the first cycle after ARESETn goes HIGH.
    awready_sq  <= awready_s;
    wready_sq   <= wready_s;
    bready_sq   <= bready_s;
    arready_sq  <= arready_s;
    rready_sq   <= rready_s;

    xilinx_inline_out[7] <= (awready_s[0]);
    xilinx_inline_out[8] <= ( wready_s[0]);
    xilinx_inline_out[9] <= ( bready_s[0]);
    xilinx_inline_out[10] <= (arready_s[0]);
    xilinx_inline_out[11] <= ( rready_s[0]);
  end
end

assign awready_s  = {1'b1, !(ARST_N), (awready_sq[1] && (ARST_N && AWREADY))};
assign wready_s   = {1'b1, !(ARST_N), ( wready_sq[1] && (ARST_N &&  WREADY))};
assign bready_s   = {1'b1, !(ARST_N), ( bready_sq[1] && (ARST_N &&  BREADY))};
assign arready_s  = {1'b1, !(ARST_N), (arready_sq[1] && (ARST_N && ARREADY))};
assign rready_s   = {1'b1, !(ARST_N), ( rready_sq[1] && (ARST_N &&  RREADY))};

endmodule
`default_nettype wire



//*****************************************************************************
// (c) Copyright 2011-2012 Xilinx, Inc. All rights reserved.
//
// This file contains confidential and proprietary information
// of Xilinx, Inc. and is protected under U.S. and
// international copyright and other intellectual property
// laws.
//
// DISCLAIMER
// This disclaimer is not a license and does not grant any
// rights to the materials distributed herewith. Except as
// otherwise provided in a valid license issued to you by
// Xilinx, and to the maximum extent permitted by applicable
// law: (1) THESE MATERIALS ARE MADE AVAILABLE "AS IS" AND
// WITH ALL FAULTS, AND XILINX HEREBY DISCLAIMS ALL WARRANTIES
// AND CONDITIONS, EXPRESS, IMPLIED, OR STATUTORY, INCLUDING
// BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, NON-
// INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE; and
// (2) Xilinx shall not be liable (whether in contract or tort,
// including negligence, or under any other theory of
// liability) for any loss or damage of any kind or nature
// related to, arising under or in connection with these
// materials, including for any direct, or any indirect,
// special, incidental, or consequential loss or damage
// (including loss of data, profits, goodwill, or any type of
// loss or damage suffered as a result of any action brought
// by a third party) even if such damage or loss was
// reasonably foreseeable or Xilinx had been advised of the
// possibility of the same.
//
// CRITICAL APPLICATIONS
// Xilinx products are not designed or intended to be fail-
// safe, or for use in any application requiring fail-safe
// performance, such as life-support or safety devices or
// systems, Class III medical devices, nuclear facilities,
// applications related to the deployment of airbags, or any
// other applications that could lead to death, personal
// injury, or severe property or environmental damage
// (individually and collectively, "Critical
// Applications"). Customer assumes the sole risk and
// liability of any use of Xilinx products in Critical
// Applications, subject only to applicable laws and
// regulations governing limitations on product liability.
//
// THIS COPYRIGHT NOTICE AND DISCLAIMER MUST BE RETAINED AS
// PART OF THIS FILE AT ALL TIMES.
//
//*****************************************************************************
// Design Name      : axi_protocol_checker_v1_1_14_syn_fifo
// Function         : synchronous FIFO
// Reference        : None
// Revision History : Initial version
//*****************************************************************************

`timescale 1ps/1ps
`default_nettype none

(* DowngradeIPIdentifiedWarnings="yes" *) 
module axi_protocol_checker_v1_1_14_syn_fifo #
  (
   parameter C_DATA_WIDTH = 8,
   parameter C_ADDR_WIDTH = 4
   )
  (
   input  wire                    clk,
   input  wire                    rst,

   input  wire [C_DATA_WIDTH-1:0] data_in,
   input  wire                    rd,
   input  wire                    wr,
   output wire [C_DATA_WIDTH-1:0] data_out,
   output wire                    empty,
   output wire                    full
  );

  /////////////////////////////////////////////////////////////////////////////
  // Local params
  /////////////////////////////////////////////////////////////////////////////

  localparam RAM_SIZE = (1 << C_ADDR_WIDTH);

  /////////////////////////////////////////////////////////////////////////////
  // Internal signals
  /////////////////////////////////////////////////////////////////////////////

  reg [C_ADDR_WIDTH-1:0] wr_ptr;
  reg [C_ADDR_WIDTH-1:0] rd_ptr;
  reg [C_ADDR_WIDTH:0]   cnt;

  (* ram_style="distributed" *)
  reg [C_DATA_WIDTH-1:0] data_ram[RAM_SIZE-1:0];

  /////////////////////////////////////////////////////////////////////////////
  // Code
  /////////////////////////////////////////////////////////////////////////////

  assign full  = (cnt == RAM_SIZE);
  assign empty = (cnt == 0);

  always @(posedge clk)
  begin : COUNTER
    if (rst) begin
      cnt <= 0;
    end else if (rd && !wr && (cnt != 0)) begin
      cnt <= cnt - 1; // Just read: decrement
    end else if (wr && !rd && (cnt != RAM_SIZE)) begin
      cnt <= cnt + 1; // Just write: increment
    end
  end

  always @(posedge clk)
  begin : WRITE_PTR
    if (rst) begin
      wr_ptr <= 0;
    end else if (wr) begin
      wr_ptr <= wr_ptr + 1;
    end
  end

  always @(posedge clk)
  begin : READ_PTR
    if (rst) begin
      rd_ptr <= 0;
    end else if (rd) begin
      rd_ptr <= rd_ptr + 1;
    end
  end

  // Distributed RAM
  always @(posedge clk)
  begin
    if (wr)
      data_ram[wr_ptr] <= data_in;
  end

  assign data_out = data_ram[rd_ptr];

endmodule

`default_nettype wire


// (c) Copyright 2010 - 2012 Xilinx, Inc. All rights reserved.
//
// This file contains confidential and proprietary information
// of Xilinx, Inc. and is protected under U.S. and
// international copyright and other intellectual property
// laws.
//
// DISCLAIMER
// This disclaimer is not a license and does not grant any
// rights to the materials distributed herewith. Except as
// otherwise provided in a valid license issued to you by
// Xilinx, and to the maximum extent permitted by applicable
// law: (1) THESE MATERIALS ARE MADE AVAILABLE "AS IS" AND
// WITH ALL FAULTS, AND XILINX HEREBY DISCLAIMS ALL WARRANTIES
// AND CONDITIONS, EXPRESS, IMPLIED, OR STATUTORY, INCLUDING
// BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, NON-
// INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE; and
// (2) Xilinx shall not be liable (whether in contract or tort,
// including negligence, or under any other theory of
// liability) for any loss or damage of any kind or nature
// related to, arising under or in connection with these
// materials, including for any direct, or any indirect,
// special, incidental, or consequential loss or damage
// (including loss of data, profits, goodwill, or any type of
// loss or damage suffered as a result of any action brought
// by a third party) even if such damage or loss was
// reasonably foreseeable or Xilinx had been advised of the
// possibility of the same.
//
// CRITICAL APPLICATIONS
// Xilinx products are not designed or intended to be fail-
// safe, or for use in any application requiring fail-safe
// performance, such as life-support or safety devices or
// systems, Class III medical devices, nuclear facilities,
// applications related to the deployment of airbags, or any
// other applications that could lead to death, personal
// injury, or severe property or environmental damage
// (individually and collectively, "Critical
// Applications"). Customer assumes the sole risk and
// liability of any use of Xilinx products in Critical
// Applications, subject only to applicable laws and
// regulations governing limitations on product liability.
//
// THIS COPYRIGHT NOTICE AND DISCLAIMER MUST BE RETAINED AS
// PART OF THIS FILE AT ALL TIMES.


`timescale 1ps/1ps
`default_nettype none
`ifndef AXI4PC_MESSAGES
  `define AXI4PC_MESSAGES
  `define AUXM_ADDR_WIDTH           "AXI_AUXM_ADDR_WIDTH. Parameter ADDR_WIDTH must be between 32 and 64 bits inclusive"
  `define AUXM_AXI4LITE_DATA_WIDTH  "AXI4LITE_AUXM_DATA_WIDTH. Parameter DATA_WIDTH must be either 32 or 64."
  `define AUXM_DATA_WIDTH           "AXI_AUXM_DATA_WIDTH. Parameter DATA_WIDTH must be 32, 64, 128, 256, 512 or 1024"
  `define AUXM_EXCL_OVERFLOW        "AXI_AUXM_EXCL_OVERFLOW. Exclusive access monitor overflow, increase EXMON_WIDTH parameter."
  `define AUXM_EXMON_WIDTH          "AXI_AUXM_EXMON_WIDTH. Parameter EXMON_WIDTH must be greater than or equal to 1"
  `define AUXM_MAXRBURSTS           "AXI_AUXM_MAXRBURSTS. Parameter MAXRBURSTS must be greater than or equal to 1"
  `define AUXM_MAXWBURSTS           "AXI_AUXM_MAXWBURSTS. Parameter MAXWBURSTS must be greater than or equal to 1"
  `define AUXM_RCAM_OVERFLOW        "AXI_AUXM_RCAM_OVERFLOW. Read CAM overflow, increase Maximum outstanding READ Transactions per ID (MAX_RD_BURSTS) parameter."
  `define AUXM_RCAM_UNDERFLOW       "AXI_AUXM_RCAM_UNDERFLOW. Read CAM underflow."
  `define AUXM_WCAM_OVERFLOW        "AXI_AUXM_WCAM_OVERFLOW. Write CAM overflow, increase Maximum outstanding WRITE Transactions per ID (MAX_WR_BURSTS) parameter."
  `define AUXM_WCAM_UNDERFLOW       "AXI_AUXM_WCAM_UNDERFLOW. Write CAM underflow"
  `define ERRL_CACTIVE_X            "AXI_ERRL_CACTIVE_X: When not in reset, a value of X on CACTIVE is not permitted. Spec: section A9.2."
  `define ERRL_CSYSACK_FALL         "AXI_ERRL_CSYSACK_FALL: When CSYSACK transitions from high to low, CSYSREQ must be low. Spec: figure A9-1."
  `define ERRL_CSYSACK_RISE         "AXI_ERRL_CSYSACK_RISE: When CSYSACK transitions from low to high, CSYSREQ must be high. Spec: figure A9-1."
  `define ERRL_CSYSACK_X            "AXI_ERRL_CSYSACK_X: When not in reset, a value of X on CSYSACK is not permitted. Spec: section A9.2."
  `define ERRL_CSYSREQ_FALL         "AXI_ERRL_CSYSREQ_FALL: When CSYSREQ transitions from high to low, CSYSACK must be high. Spec: figure A9-1."
  `define ERRL_CSYSREQ_RISE         "AXI_ERRL_CSYSREQ_RISE: When CSYSREQ transitions from low to high, CSYSACK must be low. Spec: figure A9-1."
  `define ERRL_CSYSREQ_X            "AXI_ERRL_CSYSREQ_X: When not in reset, a value of X on CSYSREQ is not permitted. Spec: section A9.2."
  `define ERRM_ARADDR_BOUNDARY      "AXI_ERRM_ARADDR_BOUNDARY: A burst must not cross a 4kbyte boundary. Spec: section A3.4.1."
  `define ERRM_ARADDR_STABLE        "AXI_ERRM_ARADDR_STABLE: ARADDR must remain stable when ARVALID is asserted and ARREADY low. Spec: section A3.2.1."
  `define ERRM_ARADDR_WRAP_ALIGN    "AXI_ERRM_ARADDR_WRAP_ALIGN: For a wrapping burst, the start address must be aligned to the size of each transfer. Spec: section A3.4.1."
  `define ERRM_ARADDR_X             "AXI_ERRM_ARADDR_X: When ARVALID is high, a value of X on ARADDR is not permitted. Spec: section A3.2.2."
  `define ERRM_ARBURST              "AXI_ERRM_ARBURST: When ARVALID is high, a value of 2'b11 on ARBURST is not permitted. Spec: table A3-3."
  `define ERRM_ARBURST_STABLE       "AXI_ERRM_ARBURST_STABLE: ARBURST must remain stable when ARVALID is asserted and ARREADY low. Spec: section A3.2.1."
  `define ERRM_ARBURST_X            "AXI_ERRM_ARBURST_X: When ARVALID is high, a value of X on ARBURST is not permitted. Spec: section A3.2.2."
  `define ERRM_ARCACHE              "AXI_ERRM_ARCACHE: When AWVALID is high, a reserved value on ARCACHE is not allowed. Spec: table A4-5."
  `define ERRM_ARCACHE_STABLE       "AXI_ERRM_ARCACHE_STABLE: ARCACHE must remain stable when ARVALID is asserted and ARREADY low. Spec: section A3.2.1."
  `define ERRM_ARCACHE_X            "AXI_ERRM_ARCACHE_X: When ARVALID is high, a value of X on ARCACHE is not permitted. Spec: section A3.2.2."
  `define ERRM_ARID_STABLE          "AXI_ERRM_ARID_STABLE: ARID must remain stable when ARVALID is asserted and ARREADY low. Spec: section A3.2.1."
  `define ERRM_ARID_TIEOFF          "AXI_ERRM_ARID_TIEOFF: ARID must be stable when ID_WIDTH is set to 0." 
  `define ERRM_ARID_X               "AXI_ERRM_ARID_X: When ARVALID is high, a value of X on ARID is not permitted. Spec: section A3.2.2."
  `define ERRM_ARLEN_FIXED          "AXI_ERRM_ARLEN_FIXED: Transactions of burst type FIXED cannot have a length greater than 16 beats. Spec: section A3.4.1."
  `define ERRM_ARLEN_LOCK           "AXI_ERRM_ARLEN_LOCK: Exclusive access transactions cannot have a length greater than 16 beats. Spec: section A7.2.4."
  `define ERRM_ARLEN_STABLE         "AXI_ERRM_ARLEN_STABLE: ARLEN must remain stable when ARVALID is asserted and ARREADY low. Spec: section A3.2.1."
  `define ERRM_ARLEN_WRAP           "AXI_ERRM_ARLEN_WRAP: For a wrapping burst, the length of the burst must be 2, 4, 8 or 16 transfers. Spec: section A3.4.1."
  `define ERRM_ARLEN_X              "AXI_ERRM_ARLEN_X: When ARVALID is high, a value of X on ARLEN is not permitted. Spec: section A3.2.2."
  `define ERRM_ARLOCK_STABLE        "AXI_ERRM_ARLOCK_STABLE: ARLOCK must remain stable when ARVALID is asserted and ARREADY low. Spec: section A3.2.1."
  `define ERRM_ARLOCK_X             "AXI_ERRM_ARLOCK_X: When ARVALID is high, a value of X on ARLOCK is not permitted. Spec: section A3.2.2."
  `define ERRM_ARPROT_STABLE        "AXI_ERRM_ARPROT_STABLE: ARPROT must remain stable when ARVALID is asserted and ARREADY low. Spec: section A3.2.1."
  `define ERRM_ARPROT_X             "AXI_ERRM_ARPROT_X: When ARVALID is high, a value of X on ARPROT is not permitted. Spec: section A3.2.2."
  `define ERRM_ARQOS_STABLE         "AXI_ERRM_ARQOS_STABLE: ARQOS must remain stable when ARVALID is asserted and ARREADY low. Spec: section A3.2.1."
  `define ERRM_ARQOS_X              "AXI_ERRM_ARQOS_X: When ARVALID is high, a value of X on ARQOS is not permitted. Spec: section A3.2.2."
  `define ERRM_ARREGION_STABLE      "AXI_ERRM_ARREGION_STABLE: ARREGION must remain stable when ARVALID is asserted and ARREADY low. Spec: section A3.2.1."
  `define ERRM_ARREGION_X           "AXI_ERRM_ARREGION_X: When ARVALID is high, a value of X on ARREGION is not permitted. Spec: section A3.2.2."
  `define ERRM_ARSIZE               "AXI_ERRM_ARSIZE: The size of any transfer must not exceed the data bus width of either agent in the transaction. Spec: section A3.4.1."
  `define ERRM_ARSIZE_STABLE        "AXI_ERRM_ARSIZE_STABLE: ARSIZE must remain stable when ARVALID is asserted and ARREADY low. Spec: section A3.2.1."
  `define ERRM_ARSIZE_X             "AXI_ERRM_ARSIZE_X: When ARVALID is high, a value of X on ARSIZE is not permitted. Spec: section A3.2.2."
  `define ERRM_ARUSER_STABLE        "AXI_ERRM_ARUSER_STABLE: ARUSER must remain stable when ARVALID is asserted and ARREADY low. Spec: section A3.2.1."
  `define ERRM_ARUSER_TIEOFF        "AXI_ERRM_ARUSER_TIEOFF: ARUSER must be stable when ARUSER_WIDTH is set to 0." 
  `define ERRM_ARUSER_X             "AXI_ERRM_ARUSER_X: When ARVALID is high, a value of X on ARUSER is not permitted. Spec: section A3.2.2."
  `define ERRM_ARVALID_RESET        "AXI_ERRM_ARVALID_RESET: The earliest point after reset that a master is permitted to begin driving ARVALID, AWVALID, or WVALID HIGH is at a rising ACLK edge after ARESETn is HIGH. Spec: Figure A3-1."
  `define ERRM_ARVALID_STABLE       "AXI_ERRM_ARVALID_STABLE: Once ARVALID is asserted, it must remain asserted until ARREADY is high. Spec: section A3.2.1."
  `define ERRM_ARVALID_X            "AXI_ERRM_ARVALID_X: When not in reset, a value of X on ARVALID is not permitted. Spec: section A3.1.2."
  `define ERRM_AWADDR_BOUNDARY      "AXI_ERRM_AWADDR_BOUNDARY: A burst must not cross a 4kbyte boundary. Spec: section A3.4.1."
  `define ERRM_AWADDR_STABLE        "AXI_ERRM_AWADDR_STABLE: AWADDR must remain stable when AWVALID is asserted and AWREADY low. Spec: section A3.2.1."
  `define ERRM_AWADDR_WRAP_ALIGN    "AXI_ERRM_AWADDR_WRAP_ALIGN: For a wrapping burst, the start address must be aligned to the size of each transfer. Spec: section A3.4.1."
  `define ERRM_AWADDR_X             "AXI_ERRM_AWADDR_X: When AWVALID is high, a value of X on AWADDR is not permitted. Spec: section A3.2.2."
  `define ERRM_AWBURST              "AXI_ERRM_AWBURST: When AWVALID is high, a value of 2'b11 on AWBURST is reserved. Spec: table A3-3."
  `define ERRM_AWBURST_STABLE       "AXI_ERRM_AWBURST_STABLE: AWBURST must remain stable when AWVALID is asserted and AWREADY low. Spec: section A3.2.1."
  `define ERRM_AWBURST_X            "AXI_ERRM_AWBURST_X: When AWVALID is high, a value of X on AWBURST is not permitted. Spec: section A3.2.2."
  `define ERRM_AWCACHE              "AXI_ERRM_AWCACHE: When AWVALID is high, a reserved value on AWCACHE is not allowed. Spec: table A4-5."
  `define ERRM_AWCACHE_STABLE       "AXI_ERRM_AWCACHE_STABLE: AWCACHE must remain stable when AWVALID is asserted and AWREADY low. Spec: section A3.2.1."
  `define ERRM_AWCACHE_X            "AXI_ERRM_AWCACHE_X: When AWVALID is high, a value of X on AWCACHE is not permitted. Spec: section A3.2.2."
  `define ERRM_AWID_STABLE          "AXI_ERRM_AWID_STABLE: AWID must remain stable when AWVALID is asserted and AWREADY low. Spec: section A3.2.1."
  `define ERRM_AWID_TIEOFF          "AXI_ERRM_AWID_TIEOFF: AWID must be stable when ID_WIDTH is set to 0." 
  `define ERRM_AWID_X               "AXI_ERRM_AWID_X: When AWVALID is high, a value of X on AWID is not permitted. Spec: section A3.2.2."
  `define ERRM_AWLEN_FIXED          "AXI_ERRM_AWLEN_FIXED: Transactions of burst type FIXED cannot have a length greater than 16 beats. Spec: section A3.4.1."
  `define ERRM_AWLEN_LOCK           "AXI_ERRM_AWLEN_LOCK: Exclusive access transactions cannot have a length greater than 16 beats. Spec: section A7.2.4."
  `define ERRM_AWLEN_STABLE         "AXI_ERRM_AWLEN_STABLE: AWLEN must remain stable when AWVALID is asserted and AWREADY low. Spec: section A3.2.1."
  `define ERRM_AWLEN_WRAP           "AXI_ERRM_AWLEN_WRAP: For a wrapping burst, the length of the burst must be 2, 4, 8 or 16 transfers. Spec: section A3.4.1."
  `define ERRM_AWLEN_X              "AXI_ERRM_AWLEN_X: When AWVALID is high, a value of X on AWLEN is not permitted. Spec: section A3.2.2."
  `define ERRM_AWLOCK_STABLE        "AXI_ERRM_AWLOCK_STABLE: AWLOCK must remain stable when AWVALID is asserted and AWREADY low. Spec: section A3.2.1."
  `define ERRM_AWLOCK_X             "AXI_ERRM_AWLOCK_X: When AWVALID is high, a value of X on AWLOCK is not permitted. Spec: section A3.2.2."
  `define ERRM_AWPROT_STABLE        "AXI_ERRM_AWPROT_STABLE: AWPROT must remain stable when AWVALID is asserted and AWREADY low. Spec: section A3.2.1."
  `define ERRM_AWPROT_X             "AXI_ERRM_AWPROT_X: When AWVALID is high, a value of X on AWPROT is not permitted. Spec: section A3.2.2."
  `define ERRM_AWQOS_STABLE         "AXI_ERRM_AWQOS_STABLE: AWQOS must remain stable when AWVALID is asserted and AWREADY low. Spec: section A3.2.1."
  `define ERRM_AWQOS_X              "AXI_ERRM_AWQOS_X: When AWVALID is high, a value of X on AWQOS is not permitted. Spec: section A3.2.2."
  `define ERRM_AWREGION_STABLE      "AXI_ERRM_AWREGION_STABLE: AWREGION must remain stable when ARVALID is asserted and AWREADY low. Spec: section A3.2.1."
  `define ERRM_AWREGION_X           "AXI_ERRM_AWREGION_X: When AWVALID is high, a value of X on AWREGION is not permitted. Spec: section A3.2.2."
  `define ERRM_AWSIZE               "AXI_ERRM_AWSIZE: The size of any transfer must not exceed the data bus width of either agent in the transaction. Spec: section A3.4.1."
  `define ERRM_AWSIZE_STABLE        "AXI_ERRM_AWSIZE_STABLE: AWSIZE must remain stable when AWVALID is asserted and AWREADY low. Spec: section A3.2.1."
  `define ERRM_AWSIZE_X             "AXI_ERRM_AWSIZE_X: When AWVALID is high, a value of X on AWSIZE is not permitted. Spec: section A3.2.2."
  `define ERRM_AWUSER_STABLE        "AXI_ERRM_AWUSER_STABLE: AWUSER must remain stable when AWVALID is asserted and AWREADY low. Spec: section A3.2.1."
  `define ERRM_AWUSER_TIEOFF        "AXI_ERRM_AWUSER_TIEOFF: AWUSER must be stable when AWUSER_WIDTH is set to 0." 
  `define ERRM_AWUSER_X             "AXI_ERRM_AWUSER_X: When AWVALID is high, a value of X on AWUSER is not permitted. Spec: section A3.2.2."
  `define ERRM_AWVALID_RESET        "AXI_ERRM_AWVALID_RESET: The earliest point after reset that a master is permitted to begin driving ARVALID, AWVALID, or WVALID HIGH is at a rising ACLK edge after ARESETn is HIGH. Spec: Figure A3-1."
  `define ERRM_AWVALID_STABLE       "AXI_ERRM_AWVALID_STABLE: Once AWVALID is asserted, it must remain asserted until AWREADY is high. Spec: section A3.2.2."
  `define ERRM_AWVALID_X            "AXI_ERRM_AWVALID_X: When not in reset, a value of X on AWVALID is not permitted. Spec: section A3.1.2."
  `define ERRM_BREADY_X             "AXI_ERRM_BREADY_X: When not in reset, a value of X on BREADY is not permitted. Spec: section A3.1.2."
  `define ERRM_EXCL_ALIGN           "AXI_ERRM_EXCL_ALIGN: The address of an exclusive access must be aligned to the total number of bytes in the transaction. Spec: section A7.2.4."
  `define ERRM_EXCL_LEN             "AXI_ERRM_EXCL_LEN: The number of bytes to be transferred in an exclusive access burst must be a power of 2. Spec: section A7.2.4."
  `define ERRM_EXCL_MAX             "AXI_ERRM_EXCL_MAX: The maximum number of bytes that can be transferred in an exclusive burst is 128. Spec: section A7.2.4."
  `define ERRM_RREADY_X             "AXI_ERRM_RREADY_X: When not in reset, a value of X on RREADY is not permitted. Spec: section A3.1.2."
  `define ERRM_WDATA_NUM            "AXI_ERRM_WDATA_NUM: The number of write data items must match AWLEN for the corresponding address. Spec: section A3.4.1."
  `define ERRM_WDATA_STABLE         "AXI_ERRM_WDATA_STABLE: WDATA must remain stable when WVALID is asserted and WREADY low. Spec: section A3.2.1."
  `define ERRM_WDATA_X              "AXI_ERRM_WDATA_X: When WVALID is high, a value of X on active byte lanes of WDATA is not permitted. Spec: section A3.2.2."
  `define ERRM_WLAST_STABLE         "AXI_ERRM_WLAST_STABLE: WLAST must remain stable when WVALID is asserted and WREADY low. Spec: section A3.2.1."
  `define ERRM_WLAST_X              "AXI_ERRM_WLAST_X: When WVALID is high, a value of X on WLAST is not permitted. Spec: section A3.2.2."
  `define ERRM_WSTRB                "AXI_ERRM_WSTRB: Write strobes must only be asserted for the correct byte lanes as determined from start address, transfer size and beat number. Spec: section A3.4.3."
  `define ERRM_WSTRB_STABLE         "AXI_ERRM_WSTRB_STABLE: WSTRB must remain stable when WVALID is asserted and WREADY low. Spec: section A3.2.1."
  `define ERRM_WSTRB_X              "AXI_ERRM_WSTRB_X: When WVALID is high, a value of X on WSTRB is not permitted. Spec: section A3.2.2."
  `define ERRM_WUSER_STABLE         "AXI_ERRM_WUSER_STABLE: WUSER must remain stable when WVALID is asserted and WREADY low. Spec: section A3.2.1."
  `define ERRM_WUSER_TIEOFF         "AXI_ERRM_WUSER_TIEOFF: WUSER must be stable when WUSER_WIDTH is set to 0." 
  `define ERRM_WUSER_X              "AXI_ERRM_WUSER_X: When WVALID is high, a value of X on WUSER is not permitted. Spec: section A3.2.2."
  `define ERRM_WVALID_RESET         "AXI_ERRM_WVALID_RESET: The earliest point after reset that a master is permitted to begin driving ARVALID, AWVALID, or WVALID HIGH is at a rising ACLK edge after ARESETn is HIGH. Spec: Figure A3-1."
  `define ERRM_WVALID_STABLE        "AXI_ERRM_WVALID_STABLE: Once WVALID is asserted, it must remain asserted until WREADY is high. Spec: section A3.2.2."
  `define ERRM_WVALID_X             "AXI_ERRM_WVALID_X: When not in reset, a value of X on WVALID is not permitted. Spec: section A3.2.2."
  `define ERRS_ARREADY_X            "AXI_ERRS_ARREADY_X: When not in reset, a value of X on ARREADY is not permitted. Spec: section A3.1.2."
  `define ERRS_AWREADY_X            "AXI_ERRS_AWREADY_X: When not in reset, a value of X on AWREADY is not permitted. Spec: section A3.1.2."
  `define ERRS_AXI4LITE_BRESP_EXOKAY   "AXI4LITE_ERRS_BRESP_EXOKAY: A slave must not give an EXOKAY response on an Axi4Lite interface. Spec: section B1.1.1."
  `define ERRS_AXI4LITE_RRESP_EXOKAY   "AXI4LITE_ERRS_RRESP_EXOKAY: A slave must not give an EXOKAY response on an Axi4Lite interface. Spec: section B1.1.1."
  `define ERRS_BID_STABLE           "AXI_ERRS_BID_STABLE: BID must remain stable when BVALID is asserted and BREADY low. Spec: section A3.2.1."
  `define ERRS_BID_TIEOFF           "AXI_ERRS_BID_TIEOFF: BID must be stable when ID_WIDTH is set to 0." 
  `define ERRS_BID_X                "AXI_ERRS_BID_X: When BVALID is high, a value of X on BID is not permitted. Spec: section A3.2.2."
  `define ERRS_BRESP_ALL_DONE_EOS   "AXI_ERRS_BRESP_ALL_DONE_EOS: All write transaction addresses must have been matched with corresponding write response."
  `define ERRS_BRESP_AW             "AXI_ERRS_BRESP_AW: A slave must not give a write response before the write address. Spec: section A3.3.1 and figure A3-7."
  `define ERRS_BRESP_EXOKAY         "AXI_ERRS_BRESP_EXOKAY: An EXOKAY write response can only be given to an exclusive write access. Spec: section A7.2."
  `define ERRS_BRESP_STABLE         "AXI_ERRS_BRESP_STABLE: BRESP must remain stable when BVALID is asserted and BREADY low. Spec: section A3.2.1."
  `define ERRS_BRESP_WLAST          "AXI_ERRS_BRESP_WLAST: A slave must only give a write response after the last write data item is transferred. Spec: section A3.3.1 and figure A3-7."
  `define ERRS_BRESP_X              "AXI_ERRS_BRESP_X: When BVALID is high, a value of X on BRESP is not permitted.  Spec: section A3.2.2."
  `define ERRS_BUSER_STABLE         "AXI_ERRS_BUSER_STABLE: BUSER must remain stable when BVALID is asserted and BREADY low. Spec: section A3.2.1."
  `define ERRS_BUSER_TIEOFF         "AXI_ERRS_BUSER_TIEOFF: BUSER must be stable when BUSER_WIDTH is set to 0." 
  `define ERRS_BUSER_X              "AXI_ERRS_BUSER_X: When BVALID is high, a value of X on BUSER is not permitted. Spec: section A3.2.2."
  `define ERRS_BVALID_RESET         "AXI_ERRS_BVALID_RESET: The earliest point after reset that a master is permitted to begin driving ARVALID, AWVALID, or WVALID HIGH is at a rising ACLK edge after ARESETn is HIGH. Spec: Figure A3-1."
  `define ERRS_BVALID_STABLE        "AXI_ERRS_BVALID_STABLE: Once BVALID is asserted, it must remain asserted until BREADY is high. Spec: section A3.2.2."
  `define ERRS_BVALID_X             "AXI_ERRS_BVALID_X: When not in reset, a value of X on BVALID is not permitted. Spec: section A3.2.2."
  `define ERRS_RDATA_NUM            "AXI_ERRS_RDATA_NUM: The number of read data items must match the corresponding ARLEN. Spec: section A3.4.1."
  `define ERRS_RDATA_STABLE         "AXI_ERRS_RDATA_STABLE: RDATA must remain stable when RVALID is asserted and RREADY low. Spec: section A3.2.1."
  `define ERRS_RDATA_X              "AXI_ERRS_RDATA_X: When RVALID is high, a value of X on RDATA valid byte lanes is not permitted. Spec: section A3.2.2."
  `define ERRS_RID                  "AXI_ERRS_RID: A slave can only give read data with an ID to match an outstanding read transaction. Spec: section A5.3.1."
  `define ERRS_RID_STABLE           "AXI_ERRS_RID_STABLE: RID must remain stable when RVALID is asserted and RREADY low. Spec: section A3.2.1."
  `define ERRS_RID_TIEOFF           "AXI_ERRS_RID_TIEOFF: RID must be stable when ID_WIDTH is set to 0." 
  `define ERRS_RID_X                "AXI_ERRS_RID_X: When RVALID is high, a value of X on RID is not permitted. Spec: section A3.2.2."
  `define ERRS_RLAST_ALL_DONE_EOS   "AXI_ERRS_RLAST_ALL_DONE_EOS: All outstanding read bursts must have completed a the end of the simulation."
  `define ERRS_RLAST_STABLE         "AXI_ERRS_RLAST_STABLE: RLAST must remain stable when RVALID is asserted and RREADY low. Spec: section A3.2.1."
  `define ERRS_RLAST_X              "AXI_ERRS_RLAST_X: When RVALID is high, a value of X on RLAST is not permitted. Spec: section A3.2.2."
  `define ERRS_RRESP_EXOKAY         "AXI_ERRS_RRESP_EXOKAY: An EXOKAY read response can only be given to an exclusive read access. Spec: section A7.2.3."
  `define ERRS_RRESP_STABLE         "AXI_ERRS_RRESP_STABLE: RRESP must remain stable when RVALID is asserted and RREADY low. Spec: section A3.2.1."
  `define ERRS_RRESP_X              "AXI_ERRS_RRESP_X: When RVALID is high, a value of X on RRESP is not permitted. Spec: section A3.2.2."
  `define ERRS_RUSER_STABLE         "AXI_ERRS_RUSER_STABLE: RUSER must remain stable when RVALID is asserted and RREADY low. Spec: section A3.2.1."
  `define ERRS_RUSER_TIEOFF         "AXI_ERRS_RUSER_TIEOFF: RUSER must be stable when RUSER_WIDTH is set to 0." 
  `define ERRS_RUSER_X              "AXI_ERRS_RUSER_X: When RVALID is high, a value of X on RUSER is not permitted.  Spec: section A3.2.2."
  `define ERRS_RVALID_RESET         "AXI_ERRS_RVALID_RESET: The earliest point after reset that a master is permitted to begin driving ARVALID, AWVALID, or WVALID HIGH is at a rising ACLK edge after ARESETn is HIGH. Spec: Figure A3-1."
  `define ERRS_RVALID_STABLE        "AXI_ERRS_RVALID_STABLE: Once RVALID is asserted, it must remain asserted until RREADY is high. Spec: section A3.2.1."
  `define ERRS_RVALID_X             "AXI_ERRS_RVALID_X: When not in reset, a value of X on RVALID is not permitted. Spec: section A3.1.2."
  `define ERRS_WREADY_X             "AXI_ERRS_WREADY_X: When not in reset, a value of X on WREADY is not permitted. Spec: section A3.2.2."
  `define RECM_BREADY_MAX_WAIT      "AXI_RECM_BREADY_MAX_WAIT: BREADY should be asserted within MAXWAITS cycles of BVALID being asserted."
  `define RECM_EXCL_MATCH           "AXI_RECM_EXCL_MATCH: The address payload of an exclusive write should be the same as the preceding exclusive read with the same ID. Spec: section A7.2.4."
  `define RECM_EXCL_PAIR            "AXI_RECM_EXCL_PAIR: An exclusive write should have an earlier outstanding completed exclusive read with the same ID. Spec: section A7.2.2."
  `define RECM_RREADY_MAX_WAIT      "AXI_RECM_RREADY_MAX_WAIT. RREADY should be asserted within MAXWAITS cycles of RVALID being asserted."
  `define RECS_ARREADY_MAX_WAIT     "AXI_RECS_ARREADY_MAX_WAIT. ARREADY should be asserted within MAXWAITS cycles of ARVALID being asserted."
  `define RECS_AWREADY_MAX_WAIT     "AXI_RECS_AWREADY_MAX_WAIT. AWREADY should be asserted within MAXWAITS cycles of AWVALID being asserted."
  `define RECS_WREADY_MAX_WAIT      "AXI_RECS_WREADY_MAX_WAIT. WREADY should be asserted within MAXWAITS cycles of WVALID being asserted."
  `define XILINX_ARREADY_RESET               "XILINX_ARREADY_RESET. ARREADY must be low for the first clock edge that ARESETn goes high."
  `define XILINX_AR_MAX_BURST                "XILINX_AR_MAX_BURST. AR MASTER has issued a burst longer than the declared MAXIMUM."
  `define XILINX_AR_SUPPORTS_NARROW_BURST    "XILINX_AR_SUPPORTS_NARROW_BURST. AR Narrow burst issued from MASTER. Connection has been declared to NOT support narrow bursts."
  `define XILINX_AR_SUPPORTS_NARROW_CACHE    "XILINX_AR_SUPPORTS_NARROW_CACHE. AR Non-modifiable burst issued from MASTER. Connection has been declared to NOT support narrow bursts."
  `define XILINX_AWREADY_RESET               "XILINX_AWREADY_RESET. AWREADY must be low for the first clock edge that ARESETn goes high."
  `define XILINX_AW_MAX_BURST                "XILINX_AW_MAX_BURST. AW MASTER has issued a burst longer than the declared MAXIMUM."
  `define XILINX_AW_SUPPORTS_NARROW_BURST    "XILINX_AW_SUPPORTS_NARROW_BURST. AW Narrow burst issued from MASTER. Connection has been declared to NOT support narrow bursts."
  `define XILINX_AW_SUPPORTS_NARROW_CACHE    "XILINX_AW_SUPPORTS_NARROW_CACHE. AW Non-modifiable burst issued from MASTER. Connection has been declared to NOT support narrow bursts."
  `define XILINX_BREADY_RESET                "XILINX_BREADY_RESET. BREADY must be low for the first clock edge that ARESETn goes high."
  `define XILINX_RECM_CONTINUOUS_WTRANSFERS_MAX_WAIT  "XILINX_RECM_CONTINUOUS_WTRANSFERS_MAX_WAIT. WVALID should be asserted within MAXWAITS cycles of either AW command transfer or previous W transfer while there are outstanding AW commands."
  `define XILINX_RECM_WLAST_TO_AWVALID_MAX_WAIT       "XILINX_RECM_WLAST_TO_AWVALID_MAX_WAIT. AWVALID should be asserted within MAXWAITS cycles of WLAST transfer or previous AW transfer if there are yet more WLAST transfers outstanding."
  `define XILINX_RECS_CONTINUOUS_RTRANSFERS_MAX_WAIT  "XILINX_RECS_CONTINUOUS_RTRANSFERS_MAX_WAIT. RVALID should be asserted within MAXWAITS cycles of either AR command transfer or previous R transfer while there are outstanding AR commands."
  `define XILINX_RECS_WRITE_TO_BVALID_MAX_WAIT        "XILINX_RECS_WRITE_TO_BVALID_MAX_WAIT. BVALID should be asserted within MAXWAITS cycles of AW command transfer or WLAST transfer (whichever is later), or previous B transfer if there are yet more AW and WLAST transfers outstanding."
  `define XILINX_RREADY_RESET                "XILINX_RREADY_RESET. RREADY must be low for the first clock edge that ARESETn goes high."
  `define XILINX_WREADY_RESET                "XILINX_WREADY_RESET. WREADY must be low for the first clock edge that ARESETn goes high."
`endif

`define REPORTER_MACRO(ERR_BIT, NET_NAME, MSG_TEXT, SEV_NUM) \
  always@(posedge NET_NAME) begin \
    if ((SEV_NUM != 0) && (NET_NAME === 1'b1)) begin \
      $display("%t : %m : BIT(%d) : %s : %s", $time, ERR_BIT, (SEV_NUM == 0) ? "INFO" : (SEV_NUM == 1) ? "WARNING" : "ERROR" , MSG_TEXT); \
      if (SEV_NUM == 3) $stop;\
      if (SEV_NUM == 4) $finish;\
    end else if ((NET_NAME !== 1'b1) && (NET_NAME !== 1'b0)) begin \
      $display("%t : %m : BIT(%d) :   ERROR : Invalid state %b", $time, ERR_BIT, NET_NAME); \
    end \
  end

`define REPORT_XCHECK(MSG,SEV_NUM) \
      if(SEV_NUM == 1) $info(MSG); \
      else if (SEV_NUM == 2) $warning(MSG); \
      else if (SEV_NUM == 3) $error(MSG); \
      else if (SEV_NUM == 4) $fatal(1,MSG); \



`define ASSIGN_MARKED_DEBUG(ERR_BIT, DISPLAY_NETNAME) \
  (* mark_debug = "true" *) reg DISPLAY_NETNAME;\
  always@(posedge aclk) DISPLAY_NETNAME <= pc_status[ERR_BIT];

(* DowngradeIPIdentifiedWarnings="yes" *) 
module axi_protocol_checker_v1_1_14_reporter #(
  parameter integer C_PC_MESSAGE_LEVEL             = 2,
  parameter integer C_PC_STATUS_WIDTH              = 101,
  parameter integer C_AXI_PROTOCOL                 = 0,
  parameter integer C_AXI_ID_WIDTH                 = 1,
  parameter integer C_AXI_DATA_WIDTH               = 32,
  parameter integer C_AXI_ADDR_WIDTH               = 32,
  parameter integer C_AXI_AWUSER_WIDTH             = 1,
  parameter integer C_AXI_WUSER_WIDTH              = 1,
  parameter integer C_AXI_BUSER_WIDTH              = 1,
  parameter integer C_AXI_ARUSER_WIDTH             = 1,
  parameter integer C_AXI_RUSER_WIDTH              = 1,
  parameter integer C_PC_MAXRBURSTS                = 8,
  parameter integer C_PC_MAXWBURSTS                = 8
) (
  input  wire                             aclk,
  input  wire [C_PC_STATUS_WIDTH-1:0]     pc_status,
  ///
  input wire                                        ARST_N,
  input wire [C_AXI_ID_WIDTH-1:0]                   AWID,
  input wire [C_AXI_ADDR_WIDTH-1:0]                 AWADDR,
  input wire [7:0]                                  AWLEN,
  input wire [2:0]                                  AWSIZE,
  input wire [1:0]                                  AWBURST,
  input wire [0:0]                                  AWLOCK,
  input wire [3:0]                                  AWCACHE,
  input wire [2:0]                                  AWPROT,
  input wire [3:0]                                  AWQOS,
  input wire [3:0]                                  AWREGION,
  input wire [C_AXI_AWUSER_WIDTH-1:0]               AWUSER,
  input wire                                        AWVALID,
  input wire                                        AWREADY,
  input wire                                        WLAST,
  input wire [C_AXI_DATA_WIDTH-1:0]                 WDATA,
  input wire [C_AXI_DATA_WIDTH/8-1:0]               WSTRB,
  input wire [C_AXI_WUSER_WIDTH-1:0]                WUSER,
  input wire                                        WVALID,
  input wire                                        WREADY,
  input wire [C_AXI_ID_WIDTH-1:0]                   BID,
  input wire [1:0]                                  BRESP,
  input wire [C_AXI_BUSER_WIDTH-1:0]                BUSER,
  input wire                                        BVALID,
  input wire                                        BREADY,
  input wire [C_AXI_ID_WIDTH-1:0]                   ARID,
  input wire [C_AXI_ADDR_WIDTH-1:0]                 ARADDR,
  input wire [7:0]                                  ARLEN,
  input wire [2:0]                                  ARSIZE,
  input wire [1:0]                                  ARBURST,
  input wire [0:0]                                  ARLOCK,
  input wire [3:0]                                  ARCACHE,
  input wire [2:0]                                  ARPROT,
  input wire [3:0]                                  ARQOS,
  input wire [3:0]                                  ARREGION,
  input wire [C_AXI_ARUSER_WIDTH-1:0]               ARUSER,
  input wire                                        ARVALID,
  input wire                                        ARREADY,
  input wire [C_AXI_ID_WIDTH-1:0]                   RID,
  input wire                                        RLAST,
  input wire [C_AXI_DATA_WIDTH-1:0]                 RDATA,
  input wire [1:0]                                  RRESP,
  input wire [C_AXI_RUSER_WIDTH-1:0]                RUSER,
  input wire                                        RVALID,
  input wire                                        RREADY
);

 typedef struct packed {
   bit [7-1:0]     addr;
   bit             excl;
   bit [8-1:0]     len ;
   bit [3-1:0]     size;
   bit [2-1:0]     burst;
   bit [C_AXI_ID_WIDTH-1:0]  id;
 } t_cmd_message;

  // Read CAMs
  typedef struct packed {
    t_cmd_message       cmd;
    bit          [8:0]  Count;
  } t_rburst_xfer;
  
  t_rburst_xfer RCam[0:C_PC_MAXRBURSTS];

 reg  [C_AXI_DATA_WIDTH-1:0] WdataMask;
 wire [C_AXI_DATA_WIDTH-1:0] RdataMask;

  integer unsigned   RIndex = 1;
  integer unsigned   RIndexNext = 1;
  integer unsigned   RidMatch;
  wire               RPop;
  wire               RPush;
  wire               nROutstanding;  // flag for an empty cmd
  reg                RIdCamDelta;    // flag indicates that RidCam has changed

  wire ACLKEN = 1;


`ASSIGN_MARKED_DEBUG(00, PC_00_AXI_ERRM_AWADDR_BOUNDARY          )
`ASSIGN_MARKED_DEBUG(01, PC_01_AXI_ERRM_AWADDR_WRAP_ALIGN        )
`ASSIGN_MARKED_DEBUG(02, PC_02_AXI_ERRM_AWBURST                  )
`ASSIGN_MARKED_DEBUG(03, PC_03_AXI_ERRM_AWLEN_LOCK               )
`ASSIGN_MARKED_DEBUG(04, PC_04_AXI_ERRM_AWCACHE                  )
`ASSIGN_MARKED_DEBUG(05, PC_05_AXI_ERRM_AWLEN_FIXED              )
`ASSIGN_MARKED_DEBUG(06, PC_06_AXI_ERRM_AWLEN_WRAP               )
`ASSIGN_MARKED_DEBUG(07, PC_07_AXI_ERRM_AWSIZE                   )
`ASSIGN_MARKED_DEBUG(08, PC_08_AXI_ERRM_AWVALID_RESET            )
`ASSIGN_MARKED_DEBUG(09, PC_09_AXI_ERRM_AWADDR_STABLE            )
`ASSIGN_MARKED_DEBUG(10, PC_10_AXI_ERRM_AWBURST_STABLE           )
`ASSIGN_MARKED_DEBUG(11, PC_11_AXI_ERRM_AWCACHE_STABLE           )
`ASSIGN_MARKED_DEBUG(12, PC_12_AXI_ERRM_AWID_STABLE              )
`ASSIGN_MARKED_DEBUG(13, PC_13_AXI_ERRM_AWLEN_STABLE             )
`ASSIGN_MARKED_DEBUG(14, PC_14_AXI_ERRM_AWLOCK_STABLE            )
`ASSIGN_MARKED_DEBUG(15, PC_15_AXI_ERRM_AWPROT_STABLE            )
`ASSIGN_MARKED_DEBUG(16, PC_16_AXI_ERRM_AWSIZE_STABLE            )
`ASSIGN_MARKED_DEBUG(17, PC_17_AXI_ERRM_AWQOS_STABLE             )
`ASSIGN_MARKED_DEBUG(18, PC_18_AXI_ERRM_AWREGION_STABLE          )
`ASSIGN_MARKED_DEBUG(19, PC_19_AXI_ERRM_AWVALID_STABLE           )
`ASSIGN_MARKED_DEBUG(20, PC_20_AXI_RECS_AWREADY_MAX_WAIT         )
`ASSIGN_MARKED_DEBUG(21, PC_21_AXI_ERRM_WDATA_NUM                )
`ASSIGN_MARKED_DEBUG(22, PC_22_AXI_ERRM_WSTRB                    )
`ASSIGN_MARKED_DEBUG(23, PC_23_AXI_ERRM_WVALID_RESET             )
`ASSIGN_MARKED_DEBUG(24, PC_24_AXI_ERRM_WDATA_STABLE             )
`ASSIGN_MARKED_DEBUG(25, PC_25_AXI_ERRM_WLAST_STABLE             )
`ASSIGN_MARKED_DEBUG(26, PC_26_AXI_ERRM_WSTRB_STABLE             )
`ASSIGN_MARKED_DEBUG(27, PC_27_AXI_ERRM_WVALID_STABLE            )
`ASSIGN_MARKED_DEBUG(28, PC_28_AXI_RECS_WREADY_MAX_WAIT          )
`ASSIGN_MARKED_DEBUG(29, PC_29_AXI_ERRS_BRESP_WLAST              )
`ASSIGN_MARKED_DEBUG(30, PC_30_AXI_ERRS_BRESP_EXOKAY             )
`ASSIGN_MARKED_DEBUG(31, PC_31_AXI_ERRS_BVALID_RESET             )
`ASSIGN_MARKED_DEBUG(32, PC_32_AXI_ERRS_BRESP_AW                 )
`ASSIGN_MARKED_DEBUG(33, PC_33_AXI_ERRS_BID_STABLE               )
`ASSIGN_MARKED_DEBUG(34, PC_34_AXI_ERRS_BRESP_STABLE             )
`ASSIGN_MARKED_DEBUG(35, PC_35_AXI_ERRS_BVALID_STABLE            )
`ASSIGN_MARKED_DEBUG(36, PC_36_AXI_RECM_BREADY_MAX_WAIT          )
`ASSIGN_MARKED_DEBUG(37, PC_37_AXI_ERRM_ARADDR_BOUNDARY          )
`ASSIGN_MARKED_DEBUG(38, PC_38_AXI_ERRM_ARADDR_WRAP_ALIGN        )
`ASSIGN_MARKED_DEBUG(39, PC_39_AXI_ERRM_ARBURST                  )
`ASSIGN_MARKED_DEBUG(40, PC_40_AXI_ERRM_ARLEN_LOCK               )
`ASSIGN_MARKED_DEBUG(41, PC_41_AXI_ERRM_ARCACHE                  )
`ASSIGN_MARKED_DEBUG(42, PC_42_AXI_ERRM_ARLEN_FIXED              )
`ASSIGN_MARKED_DEBUG(43, PC_43_AXI_ERRM_ARLEN_WRAP               )
`ASSIGN_MARKED_DEBUG(44, PC_44_AXI_ERRM_ARSIZE                   )
`ASSIGN_MARKED_DEBUG(45, PC_45_AXI_ERRM_ARVALID_RESET            )
`ASSIGN_MARKED_DEBUG(46, PC_46_AXI_ERRM_ARADDR_STABLE            )
`ASSIGN_MARKED_DEBUG(47, PC_47_AXI_ERRM_ARBURST_STABLE           )
`ASSIGN_MARKED_DEBUG(48, PC_48_AXI_ERRM_ARCACHE_STABLE           )
`ASSIGN_MARKED_DEBUG(49, PC_49_AXI_ERRM_ARID_STABLE              )
`ASSIGN_MARKED_DEBUG(50, PC_50_AXI_ERRM_ARLEN_STABLE             )
`ASSIGN_MARKED_DEBUG(51, PC_51_AXI_ERRM_ARLOCK_STABLE            )
`ASSIGN_MARKED_DEBUG(52, PC_52_AXI_ERRM_ARPROT_STABLE            )
`ASSIGN_MARKED_DEBUG(53, PC_53_AXI_ERRM_ARSIZE_STABLE            )
`ASSIGN_MARKED_DEBUG(54, PC_54_AXI_ERRM_ARQOS_STABLE             )
`ASSIGN_MARKED_DEBUG(55, PC_55_AXI_ERRM_ARREGION_STABLE          )
`ASSIGN_MARKED_DEBUG(56, PC_56_AXI_ERRM_ARVALID_STABLE           )
`ASSIGN_MARKED_DEBUG(57, PC_57_AXI_RECS_ARREADY_MAX_WAIT         )
`ASSIGN_MARKED_DEBUG(58, PC_58_AXI_ERRS_RDATA_NUM                )
`ASSIGN_MARKED_DEBUG(59, PC_59_AXI_ERRS_RID                      )
`ASSIGN_MARKED_DEBUG(60, PC_60_AXI_ERRS_RRESP_EXOKAY             )
`ASSIGN_MARKED_DEBUG(61, PC_61_AXI_ERRS_RVALID_RESET             )
`ASSIGN_MARKED_DEBUG(62, PC_62_AXI_ERRS_RDATA_STABLE             )
`ASSIGN_MARKED_DEBUG(63, PC_63_AXI_ERRS_RID_STABLE               )
`ASSIGN_MARKED_DEBUG(64, PC_64_AXI_ERRS_RLAST_STABLE             )
`ASSIGN_MARKED_DEBUG(65, PC_65_AXI_ERRS_RRESP_STABLE             )
`ASSIGN_MARKED_DEBUG(66, PC_66_AXI_ERRS_RVALID_STABLE            )
`ASSIGN_MARKED_DEBUG(67, PC_67_AXI_RECM_RREADY_MAX_WAIT          )
`ASSIGN_MARKED_DEBUG(68, PC_68_AXI_ERRM_EXCL_ALIGN               )
`ASSIGN_MARKED_DEBUG(69, PC_69_AXI_ERRM_EXCL_LEN                 )
`ASSIGN_MARKED_DEBUG(70, PC_70_AXI_RECM_EXCL_MATCH               )
`ASSIGN_MARKED_DEBUG(71, PC_71_AXI_ERRM_EXCL_MAX                 )
`ASSIGN_MARKED_DEBUG(72, PC_72_AXI_RECM_EXCL_PAIR                )
`ASSIGN_MARKED_DEBUG(73, PC_73_AXI_ERRM_AWUSER_STABLE            )
`ASSIGN_MARKED_DEBUG(74, PC_74_AXI_ERRM_WUSER_STABLE             )
`ASSIGN_MARKED_DEBUG(75, PC_75_AXI_ERRS_BUSER_STABLE             )
`ASSIGN_MARKED_DEBUG(76, PC_76_AXI_ERRM_ARUSER_STABLE            )
`ASSIGN_MARKED_DEBUG(77, PC_77_AXI_ERRS_RUSER_STABLE             )
`ASSIGN_MARKED_DEBUG(78, PC_78_AXI_AUXM_RCAM_OVERFLOW            )
`ASSIGN_MARKED_DEBUG(79, PC_79_AXI_AUXM_RCAM_UNDERFLOW           )
`ASSIGN_MARKED_DEBUG(80, PC_80_AXI_AUXM_WCAM_OVERFLOW            )
`ASSIGN_MARKED_DEBUG(81, PC_81_AXI_AUXM_WCAM_UNDERFLOW           )
`ASSIGN_MARKED_DEBUG(82, PC_82_AXI_AUXM_EXCL_OVERFLOW            )
`ASSIGN_MARKED_DEBUG(83, PC_83_AXI4LITE_ERRS_BRESP_EXOKAY        )
`ASSIGN_MARKED_DEBUG(84, PC_84_AXI4LITE_ERRS_RRESP_EXOKAY        )
`ASSIGN_MARKED_DEBUG(85, PC_85_AXI4LITE_AUXM_DATA_WIDTH          )
`ASSIGN_MARKED_DEBUG(86, PC_86_XILINX_AW_SUPPORTS_NARROW_BURST   )
`ASSIGN_MARKED_DEBUG(87, PC_87_XILINX_AR_SUPPORTS_NARROW_BURST   )
`ASSIGN_MARKED_DEBUG(88, PC_88_XILINX_AW_SUPPORTS_NARROW_CACHE   )
`ASSIGN_MARKED_DEBUG(89, PC_89_XILINX_AR_SUPPORTS_NARROW_CACHE   )
`ASSIGN_MARKED_DEBUG(90, PC_90_XILINX_AW_MAX_BURST               )
`ASSIGN_MARKED_DEBUG(91, PC_91_XILINX_AR_MAX_BURST               )
`ASSIGN_MARKED_DEBUG(92, PC_92_XILINX_AWREADY_RESET              )
`ASSIGN_MARKED_DEBUG(93, PC_93_XILINX_WREADY_RESET               )
`ASSIGN_MARKED_DEBUG(94, PC_94_XILINX_BREADY_RESET               )
`ASSIGN_MARKED_DEBUG(95, PC_95_XILINX_ARREADY_RESET              )
`ASSIGN_MARKED_DEBUG(96, PC_96_XILINX_RREADY_RESET               )
`ASSIGN_MARKED_DEBUG(97, PC_97_XILINX_RECS_CONTINUOUS_RTRANSFERS_MAX_WAIT               )
`ASSIGN_MARKED_DEBUG(98, PC_98_XILINX_RECM_CONTINUOUS_WTRANSFERS_MAX_WAIT               )
`ASSIGN_MARKED_DEBUG(99, PC_99_XILINX_RECM_WLAST_TO_AWVALID_MAX_WAIT               )
`ASSIGN_MARKED_DEBUG(100, PC_100_XILINX_RECS_WRITE_TO_BVALID_MAX_WAIT               )

// synthesis translate_off

  // INDEX:        - ByteCount
  // =====
  // Inputs: Burst (Burst data structure)
  //         Beat  (Data beat number)
  // Returns: Byte Count of valid byte lanes.
  //----------------------------------------------------------------------------
  function [7:0] ByteCount;
    input t_cmd_message Burst;         // burst vector
    input [9:0]        Beat;           // beat number in the burst (1-256)
    reg   [6:0]        axaddr;
    reg   [2:0]        axsize;
    reg   [7:0]        axlen;
    reg   [1:0]        axburst;
    integer bus_data_bytes;
    integer unaligned_byte_shift;
  begin
    axaddr  = Burst.addr;
    axsize  = Burst.size;
    axlen   = Burst.len;
    axburst = Burst.burst;

    bus_data_bytes = C_AXI_DATA_WIDTH/8;

    // Number of bytes that the data needs to be shifted when
    // the address is unaligned
    unaligned_byte_shift =
      axaddr &              // Byte address
      ((1<<axsize)-1);      //   masked by the number of bytes
                            //   in a transfer

    // The number of valid bits depends on the transfer size.
    ByteCount = (1<<axsize);
    // For FIXED bursts or on the first beat of an INCR burst
    // if the address is unaligned modify the number of
    // valid strobe bits
    if ((axburst == 0) || (Beat == 0))
    begin
      // The number of valid bits depends on the transfer size
      // and the offset of the unaligned address.
      ByteCount = ByteCount - unaligned_byte_shift;
    end
  end
  endfunction // ByteCount

  // INDEX:        - ByteShift
  // =====
  // Inputs: Burst (Burst data structure)
  //         Beat  (Data beat number)
  // Returns: Byte Shift for valid byte lanes.
  //------------------------------------------------------------------------------
  function [C_AXI_DATA_WIDTH-1:0] ByteShift;
    input t_cmd_message Burst;         // burst vector
    input [9:0]        Beat;           // beat number in the burst (1-256)
    reg   [6:0]        axaddr;
    reg   [2:0]        axsize;
    reg   [7:0]        axlen;
    reg   [1:0]        axburst;
    integer bus_data_bytes;
    integer length;
    integer unaligned_byte_shift;
    integer beat_addr_inc;
    integer addr_trans_bus;
    integer addr_trans_bus_inc;
    integer wrap_point;
    integer transfer_byte_shift;
  begin
    axaddr  = Burst.addr;
    axsize  = Burst.size;
    axlen   = Burst.len;
    axburst = Burst.burst;

    bus_data_bytes =C_AXI_DATA_WIDTH/8;

    length = axlen + 1;

    // Number of bytes that the data needs to be shifted when
    // the address is unaligned
    unaligned_byte_shift =
      axaddr &                        // Byte address
      ((1<<axsize)-1);                //   masked by the number of bytes
                                      //   in a transfer

    // Burst beat address increment
    beat_addr_inc = 0;
    // For a FIXED burst ther is no increment
    // For INCR and WRAP it is the beat number minus 1
    if (axburst != 0)
    begin
      beat_addr_inc = Beat;
    end

    // Transfer address within data bus
    // The root of the transfer address within the data bus is byte address
    // divided by the number of bytes in each transfer. This is also masked
    // so that the upper bits that do not control the byte shift are not
    // included.
    addr_trans_bus = (axaddr & (bus_data_bytes - 1))>>axsize;

    // The address may increment with each beat. The increment will be zero
    // for a FIXED burst.
    addr_trans_bus_inc = addr_trans_bus + beat_addr_inc;

    // Modify the byte shift for wrapping bursts
    if (axburst == 2)
    begin
      // The upper address of the transfer before wrapping
      wrap_point = length + (addr_trans_bus & ~(length - 1));
      // If adding the beat number to the transfer address causes it to
      // pass the upper wrap address then wrap to the lower address.
      if (addr_trans_bus_inc >= wrap_point)
      begin
        addr_trans_bus_inc = addr_trans_bus_inc - length;
      end
    end

    // Address calculation may exceed the number of transfers that can fit
    // in the data bus for INCR bursts. So the calculation is truncated to
    // make the byte shift wrap round to zero. 
    addr_trans_bus_inc = addr_trans_bus_inc & ((bus_data_bytes-1)>>axsize);

    // Number of bytes that the data needs to be shifted when
    // the transfer size is less than the data bus width
    transfer_byte_shift = (1<<axsize) *      // Number of bytes in a transfer
                          addr_trans_bus_inc;// Transfer address within data bus

    // For a FIXED burst or on the frist beat of an INCR burst
    // shift the data if the address is unaligned
    if ((axburst == 0) || ((axburst == 1) && (Beat == 0)))
    begin
      ByteShift = transfer_byte_shift + unaligned_byte_shift;
    end
    else
    begin
      ByteShift = transfer_byte_shift;
    end
  end
  endfunction // ByteShift
 

  // INDEX:        - ReadDataMask
  // =====
  // Inputs: Burst (Burst data structure)
  //         Beat  (Data beat number)
  // Returns: Read data mask for valid byte lanes.
  //----------------------------------------------------------------------------
  function [C_AXI_DATA_WIDTH-1:0]  ReadDataMask;
    input t_cmd_message  Burst;         // burst vector
    input [9:0]          Beat;          // beat number in the burst (1-256)
    reg   [11:0]         bit_count;
    reg   [C_AXI_DATA_WIDTH:0] byte_mask;
  begin
    bit_count = ByteCount(Burst, Beat) << 3;
    byte_mask = (1'b1 << bit_count) - 1;
    // Result is the valid byte mask shifted by the calculated bit shift
    ReadDataMask = byte_mask[C_AXI_DATA_WIDTH-1:0] << (ByteShift(Burst, Beat)*8);
  end
  endfunction // ReadDataMask




  // INDEX:           - WdataMask
  // =====
  always @(WSTRB)
  begin : p_WdataMaskComb
    integer i;  // data byte loop counter
    integer j;  // data bit loop counter

    for (i = 0; i < C_AXI_DATA_WIDTH/8; i = i + 1)
      for (j = i * 8; j <= (i * 8) + 7; j = j + 1)
        WdataMask[j] = WSTRB[i];
  end


  // INDEX:        - Read CAMSs (CAM+Shift)
  // =====
  // New entries are added at the end of the CAM.
  // Elements may be removed from any location in the CAM, determined by the
  // first matching RID. When an element is removed, remaining elements
  // with a higher index are shifted down to fill the empty space.

  // Read CAMs store all outstanding addresses for read transactions
  assign RPush  = ARVALID & ARREADY;        // Push on address handshake
  assign RPop   = RVALID & RREADY & RLAST;  // Pop on last handshake

  // Flag when there are no outstanding read transactions
  assign nROutstanding = (RIndex == 1);

  // Find the index of the first item in the CAM that matches the current RID
  // (Note that RIdCamDelta is used to determine when RIdCam has changed)
  always @(RID or RIndex or RIdCamDelta)
  begin : p_RidMatch
    integer i;  // loop counter
    RidMatch = '0;
    for (i=C_PC_MAXRBURSTS; i>0; i--)
      if ((i < RIndex) && (RID == RCam[i].cmd.id))
        RidMatch = i;
  end

  // Calculate the index of the next free element in the CAM
  always @(RIndex or RPop or RPush)
  begin : p_RIndexNextComb
    case ({RPush,RPop})
      2'b00   : RIndexNext = RIndex;      // no push, no pop
      2'b01   : RIndexNext = RIndex - 1;  // pop, no push
      2'b10   : RIndexNext = RIndex + 1;  // push, no pop
      2'b11   : RIndexNext = RIndex;      // push and pop
//      default : RIndexNext = 'bX;         // X-propagation
    endcase
  end
  
  // RIndex Register
  always @(negedge ARST_N or posedge aclk)
  begin : p_RIndexSeq
    if (!ARST_N)
      RIndex <= 1;
    else if (ACLKEN == 1)
      RIndex <= RIndexNext;
  end
  
  // CAM Implementation
  always @(negedge ARST_N or posedge aclk)
  begin : p_ReadCam
    t_cmd_message Burst; // temporary store for burst data structure
    if (!ARST_N)
    begin : p_ReadCamReset
      integer i;  // loop counter
      // Reset all the entries in the CAM
      for (i=1; i<=C_PC_MAXRBURSTS; i++)
      begin
        RCam[i].cmd <= '0;
        RCam[i].Count <= 9'h0;
        RIdCamDelta  <= 1'b0;
      end //for (i=1; i<=MAXBURSTS; i++)
    end //p_ReadCamReset 
    else if (ACLKEN == 1)
    begin

      // Pop item from the CAM, at location determined by RidMatch
      if (RPop)
      begin : p_ReadCamPop
        integer i;  // loop counter
        for (i=1; i<C_PC_MAXRBURSTS; i++)
          if (i >= RidMatch)
          begin
              RCam[i].cmd <= RCam[i+1].cmd;
              RCam[i].Count <= RCam[i+1].Count;
              RIdCamDelta  <= ~RIdCamDelta;
          end //for (i=1; i<C_PC_MAXRBURSTS; i++)
      end //p_ReadCamPop
      else if (RVALID & RREADY)
      // if not last data item, increment beat count
      begin
        RCam[RidMatch].Count <= RCam[RidMatch].Count + 9'b0_0000_0001;
      end

      if (ARVALID)
      begin
          Burst.addr             = ARADDR[6:0];
          Burst.burst            = ARBURST;
          Burst.len              = ARLEN;
          Burst.size             = ARSIZE;
          Burst.id               = ARID;

          // Push item at end of the CAM
          // Note that the value of the final index in the CAM is depends on
          // whether another item has been popped
          if (RPush)
          begin
            if (RPop)
            begin
              RCam[RIndex-1].cmd <= Burst;
              RCam[RIndex-1].Count <= 9'h00;
            end
            else
            begin
              RCam[RIndex].cmd   <= Burst;
              RCam[RIndex].Count   <= 9'h00;
            end // else: !if(RPop)
            RIdCamDelta <= ~RIdCamDelta;
          end // if (RPush)
      end // if (ARVALID)
    end // else: if(!ARST_N)
  end // always @(negedge ARST_N or posedge aclk)


  assign RdataMask = ReadDataMask(RCam[RidMatch].cmd, RCam[RidMatch].Count);



  // INDEX:        - AXI4_ERRM_AWADDR_X
  // =====
  property AXI4_ERRM_AWADDR_X;
    @(posedge aclk) ARST_N & AWVALID  |-> ! $isunknown(AWADDR);
  endproperty
  axi4_errm_awaddr_x: assert property (AXI4_ERRM_AWADDR_X) else
   `REPORT_XCHECK(`ERRM_AWADDR_X,C_PC_MESSAGE_LEVEL);


  // INDEX:        - AXI4_ERRM_AWBURST_X
  // =====
  property AXI4_ERRM_AWBURST_X;
    @(posedge aclk) ARST_N & AWVALID  |-> ! $isunknown(AWBURST);
  endproperty
  axi4_errm_awburst_x: assert property (AXI4_ERRM_AWBURST_X) else
   `REPORT_XCHECK(`ERRM_AWBURST_X,C_PC_MESSAGE_LEVEL);


  // INDEX:        - AXI4_ERRM_AWCACHE_X
  // =====
  property AXI4_ERRM_AWCACHE_X;
    @(posedge aclk) ARST_N & AWVALID  |-> ! $isunknown(AWCACHE);
  endproperty
  axi4_errm_awcache_x: assert property (AXI4_ERRM_AWCACHE_X) else
   `REPORT_XCHECK(`ERRM_AWCACHE_X,C_PC_MESSAGE_LEVEL);


  // INDEX:        - AXI4_ERRM_AWID_X
  // =====
  property AXI4_ERRM_AWID_X;
    @(posedge aclk) ARST_N & AWVALID |-> ! $isunknown(AWID);
  endproperty
  axi4_errm_awid_x: assert property (AXI4_ERRM_AWID_X) else
   `REPORT_XCHECK(`ERRM_AWID_X,C_PC_MESSAGE_LEVEL);


  // INDEX:        - AXI4_ERRM_AWLEN_X
  // =====
  property AXI4_ERRM_AWLEN_X;
    @(posedge aclk) ARST_N & AWVALID  |-> ! $isunknown(AWLEN);
  endproperty
  axi4_errm_awlen_x: assert property (AXI4_ERRM_AWLEN_X) else
   `REPORT_XCHECK(`ERRM_AWLEN_X,C_PC_MESSAGE_LEVEL);


  // INDEX:        - AXI4_ERRM_AWLOCK_X
  // =====
  property AXI4_ERRM_AWLOCK_X;
    @(posedge aclk) ARST_N & AWVALID |-> ! $isunknown(AWLOCK);
  endproperty
  axi4_errm_awlock_x: assert property (AXI4_ERRM_AWLOCK_X) else
   `REPORT_XCHECK(`ERRM_AWLOCK_X,C_PC_MESSAGE_LEVEL);


  // INDEX:        - AXI4_ERRM_AWPROT_X
  // =====
  property AXI4_ERRM_AWPROT_X;
    @(posedge aclk) ARST_N & AWVALID |-> ! $isunknown(AWPROT);
  endproperty
  axi4_errm_awprot_x: assert property (AXI4_ERRM_AWPROT_X) else
   `REPORT_XCHECK(`ERRM_AWPROT_X,C_PC_MESSAGE_LEVEL);


  // INDEX:        - AXI4_ERRM_AWSIZE_X
  // =====
  property AXI4_ERRM_AWSIZE_X;
    @(posedge aclk) ARST_N & AWVALID |-> ! $isunknown(AWSIZE);
  endproperty
  axi4_errm_awsize_x: assert property (AXI4_ERRM_AWSIZE_X) else
   `REPORT_XCHECK(`ERRM_AWSIZE_X,C_PC_MESSAGE_LEVEL);


  // INDEX:        - AXI4_ERRM_AWQOS_X
  // =====
  property AXI4_ERRM_AWQOS_X;
    @(posedge aclk) ARST_N & AWVALID |-> ! $isunknown(AWQOS);
  endproperty
  axi4_errm_awqos_x: assert property (AXI4_ERRM_AWQOS_X) else
   `REPORT_XCHECK(`ERRM_AWQOS_X,C_PC_MESSAGE_LEVEL);


  // INDEX:        - AXI4_ERRM_AWREGION_X
  // =====
  property AXI4_ERRM_AWREGION_X;
    @(posedge aclk) 
      ARST_N & AWVALID
      |-> ! $isunknown(AWREGION);
  endproperty
  axi4_errm_awregion_x: assert property (AXI4_ERRM_AWREGION_X) else
   `REPORT_XCHECK(`ERRM_AWREGION_X,C_PC_MESSAGE_LEVEL);


  // INDEX:        - AXI4_ERRM_AWVALID_X
  // =====
  property AXI4_ERRM_AWVALID_X;
    @(posedge aclk) ARST_N |-> ! $isunknown(AWVALID);
  endproperty
  axi4_errm_awvalid_x: assert property (AXI4_ERRM_AWVALID_X) else
   `REPORT_XCHECK(`ERRM_AWVALID_X,C_PC_MESSAGE_LEVEL);


  // INDEX:        - AXI4_ERRS_AWREADY_X
  // =====
  property AXI4_ERRS_AWREADY_X;
    @(posedge aclk) ARST_N |-> ! $isunknown(AWREADY);
  endproperty
  axi4_errs_awready_x: assert property (AXI4_ERRS_AWREADY_X) else
   `REPORT_XCHECK(`ERRS_AWREADY_X,C_PC_MESSAGE_LEVEL);




  // INDEX:        - AXI4_ERRM_WDATA_X
  // =====
  property AXI4_ERRM_WDATA_X;
    @(posedge aclk)
      ARST_N & WVALID & !($isunknown(WdataMask))
      |-> ! $isunknown(WDATA & WdataMask);
  endproperty
  axi4_errm_wdata_x: assert property (AXI4_ERRM_WDATA_X) else
   `REPORT_XCHECK(`ERRM_WDATA_X,C_PC_MESSAGE_LEVEL);


  // INDEX:        - AXI4_ERRM_WLAST_X
  // =====
  property AXI4_ERRM_WLAST_X;
    @(posedge aclk)
      ARST_N & WVALID
      |-> ! $isunknown(WLAST);
  endproperty
  axi4_errm_wlast_x: assert property (AXI4_ERRM_WLAST_X) else
   `REPORT_XCHECK(`ERRM_WLAST_X,C_PC_MESSAGE_LEVEL);


  // INDEX:        - AXI4_ERRM_WSTRB_X
  // =====
  property AXI4_ERRM_WSTRB_X;
    @(posedge aclk)
      ARST_N & WVALID
      |-> ! $isunknown(WSTRB);
  endproperty
  axi4_errm_wstrb_x: assert property (AXI4_ERRM_WSTRB_X) else
   `REPORT_XCHECK(`ERRM_WSTRB_X,C_PC_MESSAGE_LEVEL);


  // INDEX:        - AXI4_ERRM_WVALID_X
  // =====
  property AXI4_ERRM_WVALID_X;
    @(posedge aclk)
      ARST_N
      |-> ! $isunknown(WVALID);
  endproperty
  axi4_errm_wvalid_x: assert property (AXI4_ERRM_WVALID_X) else
   `REPORT_XCHECK(`ERRM_WVALID_X,C_PC_MESSAGE_LEVEL);


  // INDEX:        - AXI4_ERRS_WREADY_X
  // =====
  property AXI4_ERRS_WREADY_X;
    @(posedge aclk)
      ARST_N
      |-> ! $isunknown(WREADY);
  endproperty
  axi4_errs_wready_x: assert property (AXI4_ERRS_WREADY_X) else
   `REPORT_XCHECK(`ERRS_WREADY_X,C_PC_MESSAGE_LEVEL);



  // INDEX:        - AXI4_ERRM_BREADY_X
  // =====
  property AXI4_ERRM_BREADY_X;
    @(posedge aclk)
      ARST_N
      |-> ! $isunknown(BREADY);
  endproperty
  axi4_errm_bready_x: assert property (AXI4_ERRM_BREADY_X) else
   `REPORT_XCHECK(`ERRM_BREADY_X,C_PC_MESSAGE_LEVEL);


  // INDEX:        - AXI4_ERRS_BID_X
  // =====
  property AXI4_ERRS_BID_X;
    @(posedge aclk) 
      ARST_N & BVALID
      |-> ! $isunknown(BID);
  endproperty
  axi4_errs_bid_x: assert property (AXI4_ERRS_BID_X) else
   `REPORT_XCHECK(`ERRS_BID_X,C_PC_MESSAGE_LEVEL);


  // INDEX:        - AXI4_ERRS_BRESP_X
  // =====
  property AXI4_ERRS_BRESP_X;
    @(posedge aclk) 
      ARST_N & BVALID
      |-> ! $isunknown(BRESP);
  endproperty
  axi4_errs_bresp_x: assert property (AXI4_ERRS_BRESP_X) else
   `REPORT_XCHECK(`ERRS_BRESP_X,C_PC_MESSAGE_LEVEL);


  // INDEX:        - AXI4_ERRS_BVALID_X
  // =====
  property AXI4_ERRS_BVALID_X;
    @(posedge aclk) 
      ARST_N
      |-> ! $isunknown(BVALID);
  endproperty
  axi4_errs_bvalid_x: assert property (AXI4_ERRS_BVALID_X) else
   `REPORT_XCHECK(`ERRS_BVALID_X,C_PC_MESSAGE_LEVEL);


  // INDEX:        - AXI4_ERRM_ARADDR_X
  // =====
  property AXI4_ERRM_ARADDR_X;
    @(posedge aclk)
      ARST_N & ARVALID
      |-> ! $isunknown(ARADDR);
  endproperty
  axi4_errm_araddr_x: assert property (AXI4_ERRM_ARADDR_X) else
   `REPORT_XCHECK(`ERRM_ARADDR_X,C_PC_MESSAGE_LEVEL);


  // INDEX:        - AXI4_ERRM_ARBURST_X
  // =====
  property AXI4_ERRM_ARBURST_X;
    @(posedge aclk)
      ARST_N & ARVALID
      |-> ! $isunknown(ARBURST);
  endproperty
  axi4_errm_arburst_x: assert property (AXI4_ERRM_ARBURST_X) else
   `REPORT_XCHECK(`ERRM_ARBURST_X,C_PC_MESSAGE_LEVEL);


  // INDEX:        - AXI4_ERRM_ARCACHE_X
  // =====
  property AXI4_ERRM_ARCACHE_X;
    @(posedge aclk)
      ARST_N & ARVALID
      |-> ! $isunknown(ARCACHE);
  endproperty
  axi4_errm_arcache_x: assert property (AXI4_ERRM_ARCACHE_X) else
   `REPORT_XCHECK(`ERRM_ARCACHE_X,C_PC_MESSAGE_LEVEL);


  // INDEX:        - AXI4_ERRM_ARID_X
  // =====
  property AXI4_ERRM_ARID_X;
    @(posedge aclk)
      ARST_N & ARVALID
      |-> ! $isunknown(ARID);
  endproperty
  axi4_errm_arid_x: assert property (AXI4_ERRM_ARID_X) else
   `REPORT_XCHECK(`ERRM_ARID_X,C_PC_MESSAGE_LEVEL);


  // INDEX:        - AXI4_ERRM_ARLEN_X
  // =====
  property AXI4_ERRM_ARLEN_X;
    @(posedge aclk) 
      ARST_N & ARVALID
      |-> ! $isunknown(ARLEN);
  endproperty
  axi4_errm_arlen_x: assert property (AXI4_ERRM_ARLEN_X) else
   `REPORT_XCHECK(`ERRM_ARLEN_X,C_PC_MESSAGE_LEVEL);


  // INDEX:        - AXI4_ERRM_ARLOCK_X
  // =====
  property AXI4_ERRM_ARLOCK_X;
    @(posedge aclk)
      ARST_N & ARVALID
      |-> ! $isunknown(ARLOCK);
  endproperty
  axi4_errm_arlock_x: assert property (AXI4_ERRM_ARLOCK_X) else
   `REPORT_XCHECK(`ERRM_ARLOCK_X,C_PC_MESSAGE_LEVEL);


  // INDEX:        - AXI4_ERRM_ARPROT_X
  // =====
  property AXI4_ERRM_ARPROT_X;
    @(posedge aclk)
      ARST_N & ARVALID
      |-> ! $isunknown(ARPROT);
  endproperty
  axi4_errm_arprot_x: assert property (AXI4_ERRM_ARPROT_X) else
   `REPORT_XCHECK(`ERRM_ARPROT_X,C_PC_MESSAGE_LEVEL);


  // INDEX:        - AXI4_ERRM_ARSIZE_X
  // =====
  property AXI4_ERRM_ARSIZE_X;
    @(posedge aclk)
      ARST_N & ARVALID
      |-> ! $isunknown(ARSIZE);
  endproperty
  axi4_errm_arsize_x: assert property (AXI4_ERRM_ARSIZE_X) else
   `REPORT_XCHECK(`ERRM_ARSIZE_X,C_PC_MESSAGE_LEVEL);


  // INDEX:        - AXI4_ERRM_ARQOS_X
  // =====
  property AXI4_ERRM_ARQOS_X;
    @(posedge aclk)
      ARST_N & ARVALID
      |-> ! $isunknown(ARQOS);
  endproperty
  axi4_errm_arqos_x: assert property (AXI4_ERRM_ARQOS_X) else
   `REPORT_XCHECK(`ERRM_ARQOS_X,C_PC_MESSAGE_LEVEL);


  // INDEX:        - AXI4_ERRM_ARREGION_X
  // =====
  property AXI4_ERRM_ARREGION_X;
    @(posedge aclk)
      ARST_N & ARVALID
      |-> ! $isunknown(ARREGION);
  endproperty
  axi4_errm_arregion_x: assert property (AXI4_ERRM_ARREGION_X) else
   `REPORT_XCHECK(`ERRM_ARREGION_X,C_PC_MESSAGE_LEVEL);


  // INDEX:        - AXI4_ERRM_ARVALID_X
  // =====
  property AXI4_ERRM_ARVALID_X;
    @(posedge aclk)
      ARST_N
      |-> ! $isunknown(ARVALID);
  endproperty
  axi4_errm_arvalid_x: assert property (AXI4_ERRM_ARVALID_X) else
   `REPORT_XCHECK(`ERRM_ARVALID_X,C_PC_MESSAGE_LEVEL);


  // INDEX:        - AXI4_ERRS_ARREADY_X
  // =====
  property AXI4_ERRS_ARREADY_X;
    @(posedge aclk)
      ARST_N
      |-> ! $isunknown(ARREADY);
  endproperty
  axi4_errs_arready_x: assert property (AXI4_ERRS_ARREADY_X) else
   `REPORT_XCHECK(`ERRS_ARREADY_X,C_PC_MESSAGE_LEVEL);


  // INDEX:        - AXI4_ERRS_RDATA_X
  // =====
  property AXI4_ERRS_RDATA_X;
    @(posedge aclk)
      ARST_N & RVALID
      |-> ! $isunknown(RDATA | ~RdataMask);
  endproperty
  axi4_errs_rdata_x: assert property (AXI4_ERRS_RDATA_X) else
    `REPORT_XCHECK(`ERRS_RDATA_X,C_PC_MESSAGE_LEVEL);


  // INDEX:        - AXI4_ERRM_RREADY_X
  // =====
  property AXI4_ERRM_RREADY_X;
    @(posedge aclk)
      ARST_N
      |-> ! $isunknown(RREADY);
  endproperty
  axi4_errm_rready_x: assert property (AXI4_ERRM_RREADY_X) else
   `REPORT_XCHECK(`ERRM_RREADY_X,C_PC_MESSAGE_LEVEL);


  // INDEX:        - AXI4_ERRS_RID_X
  // =====
  property AXI4_ERRS_RID_X;
    @(posedge aclk)
      ARST_N & RVALID
      |-> ! $isunknown(RID);
  endproperty
  axi4_errs_rid_x: assert property (AXI4_ERRS_RID_X) else
    `REPORT_XCHECK(`ERRS_RID_X,C_PC_MESSAGE_LEVEL);


  // INDEX:        - AXI4_ERRS_RLAST_X
  // =====
  property AXI4_ERRS_RLAST_X;
    @(posedge aclk)
      ARST_N & RVALID
      |-> ! $isunknown(RLAST);
  endproperty
  axi4_errs_rlast_x: assert property (AXI4_ERRS_RLAST_X) else
   `REPORT_XCHECK(`ERRS_RLAST_X,C_PC_MESSAGE_LEVEL);


  // INDEX:        - AXI4_ERRS_RRESP_X
  // =====
  property AXI4_ERRS_RRESP_X;
    @(posedge aclk) 
      ARST_N & RVALID
      |-> ! $isunknown(RRESP);
  endproperty
  axi4_errs_rresp_x: assert property (AXI4_ERRS_RRESP_X) else
   `REPORT_XCHECK(`ERRS_RRESP_X,C_PC_MESSAGE_LEVEL);


  // INDEX:        - AXI4_ERRS_RVALID_X
  // =====
  property AXI4_ERRS_RVALID_X;
    @(posedge aclk)
      ARST_N
      |-> ! $isunknown(RVALID);
  endproperty
  axi4_errs_rvalid_x: assert property (AXI4_ERRS_RVALID_X) else
   `REPORT_XCHECK(`ERRS_RVALID_X,C_PC_MESSAGE_LEVEL);







`REPORTER_MACRO(00, PC_00_AXI_ERRM_AWADDR_BOUNDARY          , `ERRM_AWADDR_BOUNDARY          , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(01, PC_01_AXI_ERRM_AWADDR_WRAP_ALIGN        , `ERRM_AWADDR_WRAP_ALIGN        , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(02, PC_02_AXI_ERRM_AWBURST                  , `ERRM_AWBURST                  , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(03, PC_03_AXI_ERRM_AWLEN_LOCK               , `ERRM_AWLEN_LOCK               , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(04, PC_04_AXI_ERRM_AWCACHE                  , `ERRM_AWCACHE                  , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(05, PC_05_AXI_ERRM_AWLEN_FIXED              , `ERRM_AWLEN_FIXED              , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(06, PC_06_AXI_ERRM_AWLEN_WRAP               , `ERRM_AWLEN_WRAP               , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(07, PC_07_AXI_ERRM_AWSIZE                   , `ERRM_AWSIZE                   , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(08, PC_08_AXI_ERRM_AWVALID_RESET            , `ERRM_AWVALID_RESET            , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(09, PC_09_AXI_ERRM_AWADDR_STABLE            , `ERRM_AWADDR_STABLE            , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(10, PC_10_AXI_ERRM_AWBURST_STABLE           , `ERRM_AWBURST_STABLE           , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(11, PC_11_AXI_ERRM_AWCACHE_STABLE           , `ERRM_AWCACHE_STABLE           , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(12, PC_12_AXI_ERRM_AWID_STABLE              , `ERRM_AWID_STABLE              , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(13, PC_13_AXI_ERRM_AWLEN_STABLE             , `ERRM_AWLEN_STABLE             , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(14, PC_14_AXI_ERRM_AWLOCK_STABLE            , `ERRM_AWLOCK_STABLE            , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(15, PC_15_AXI_ERRM_AWPROT_STABLE            , `ERRM_AWPROT_STABLE            , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(16, PC_16_AXI_ERRM_AWSIZE_STABLE            , `ERRM_AWSIZE_STABLE            , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(17, PC_17_AXI_ERRM_AWQOS_STABLE             , `ERRM_AWQOS_STABLE             , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(18, PC_18_AXI_ERRM_AWREGION_STABLE          , `ERRM_AWREGION_STABLE          , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(19, PC_19_AXI_ERRM_AWVALID_STABLE           , `ERRM_AWVALID_STABLE           , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(20, PC_20_AXI_RECS_AWREADY_MAX_WAIT         , `RECS_AWREADY_MAX_WAIT         , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(21, PC_21_AXI_ERRM_WDATA_NUM                , `ERRM_WDATA_NUM                , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(22, PC_22_AXI_ERRM_WSTRB                    , `ERRM_WSTRB                    , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(23, PC_23_AXI_ERRM_WVALID_RESET             , `ERRM_WVALID_RESET             , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(24, PC_24_AXI_ERRM_WDATA_STABLE             , `ERRM_WDATA_STABLE             , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(25, PC_25_AXI_ERRM_WLAST_STABLE             , `ERRM_WLAST_STABLE             , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(26, PC_26_AXI_ERRM_WSTRB_STABLE             , `ERRM_WSTRB_STABLE             , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(27, PC_27_AXI_ERRM_WVALID_STABLE            , `ERRM_WVALID_STABLE            , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(28, PC_28_AXI_RECS_WREADY_MAX_WAIT          , `RECS_WREADY_MAX_WAIT          , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(29, PC_29_AXI_ERRS_BRESP_WLAST              , `ERRS_BRESP_WLAST              , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(30, PC_30_AXI_ERRS_BRESP_EXOKAY             , `ERRS_BRESP_EXOKAY             , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(31, PC_31_AXI_ERRS_BVALID_RESET             , `ERRS_BVALID_RESET             , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(32, PC_32_AXI_ERRS_BRESP_AW                 , `ERRS_BRESP_AW                 , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(33, PC_33_AXI_ERRS_BID_STABLE               , `ERRS_BID_STABLE               , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(34, PC_34_AXI_ERRS_BRESP_STABLE             , `ERRS_BRESP_STABLE             , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(35, PC_35_AXI_ERRS_BVALID_STABLE            , `ERRS_BVALID_STABLE            , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(36, PC_36_AXI_RECM_BREADY_MAX_WAIT          , `RECM_BREADY_MAX_WAIT          , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(37, PC_37_AXI_ERRM_ARADDR_BOUNDARY          , `ERRM_ARADDR_BOUNDARY          , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(38, PC_38_AXI_ERRM_ARADDR_WRAP_ALIGN        , `ERRM_ARADDR_WRAP_ALIGN        , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(39, PC_39_AXI_ERRM_ARBURST                  , `ERRM_ARBURST                  , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(40, PC_40_AXI_ERRM_ARLEN_LOCK               , `ERRM_ARLEN_LOCK               , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(41, PC_41_AXI_ERRM_ARCACHE                  , `ERRM_ARCACHE                  , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(42, PC_42_AXI_ERRM_ARLEN_FIXED              , `ERRM_ARLEN_FIXED              , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(43, PC_43_AXI_ERRM_ARLEN_WRAP               , `ERRM_ARLEN_WRAP               , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(44, PC_44_AXI_ERRM_ARSIZE                   , `ERRM_ARSIZE                   , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(45, PC_45_AXI_ERRM_ARVALID_RESET            , `ERRM_ARVALID_RESET            , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(46, PC_46_AXI_ERRM_ARADDR_STABLE            , `ERRM_ARADDR_STABLE            , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(47, PC_47_AXI_ERRM_ARBURST_STABLE           , `ERRM_ARBURST_STABLE           , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(48, PC_48_AXI_ERRM_ARCACHE_STABLE           , `ERRM_ARCACHE_STABLE           , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(49, PC_49_AXI_ERRM_ARID_STABLE              , `ERRM_ARID_STABLE              , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(50, PC_50_AXI_ERRM_ARLEN_STABLE             , `ERRM_ARLEN_STABLE             , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(51, PC_51_AXI_ERRM_ARLOCK_STABLE            , `ERRM_ARLOCK_STABLE            , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(52, PC_52_AXI_ERRM_ARPROT_STABLE            , `ERRM_ARPROT_STABLE            , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(53, PC_53_AXI_ERRM_ARSIZE_STABLE            , `ERRM_ARSIZE_STABLE            , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(54, PC_54_AXI_ERRM_ARQOS_STABLE             , `ERRM_ARQOS_STABLE             , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(55, PC_55_AXI_ERRM_ARREGION_STABLE          , `ERRM_ARREGION_STABLE          , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(56, PC_56_AXI_ERRM_ARVALID_STABLE           , `ERRM_ARVALID_STABLE           , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(57, PC_57_AXI_RECS_ARREADY_MAX_WAIT         , `RECS_ARREADY_MAX_WAIT         , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(58, PC_58_AXI_ERRS_RDATA_NUM                , `ERRS_RDATA_NUM                , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(59, PC_59_AXI_ERRS_RID                      , `ERRS_RID                      , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(60, PC_60_AXI_ERRS_RRESP_EXOKAY             , `ERRS_RRESP_EXOKAY             , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(61, PC_61_AXI_ERRS_RVALID_RESET             , `ERRS_RVALID_RESET             , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(62, PC_62_AXI_ERRS_RDATA_STABLE             , `ERRS_RDATA_STABLE             , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(63, PC_63_AXI_ERRS_RID_STABLE               , `ERRS_RID_STABLE               , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(64, PC_64_AXI_ERRS_RLAST_STABLE             , `ERRS_RLAST_STABLE             , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(65, PC_65_AXI_ERRS_RRESP_STABLE             , `ERRS_RRESP_STABLE             , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(66, PC_66_AXI_ERRS_RVALID_STABLE            , `ERRS_RVALID_STABLE            , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(67, PC_67_AXI_RECM_RREADY_MAX_WAIT          , `RECM_RREADY_MAX_WAIT          , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(68, PC_68_AXI_ERRM_EXCL_ALIGN               , `ERRM_EXCL_ALIGN               , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(69, PC_69_AXI_ERRM_EXCL_LEN                 , `ERRM_EXCL_LEN                 , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(70, PC_70_AXI_RECM_EXCL_MATCH               , `RECM_EXCL_MATCH               , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(71, PC_71_AXI_ERRM_EXCL_MAX                 , `ERRM_EXCL_MAX                 , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(72, PC_72_AXI_RECM_EXCL_PAIR                , `RECM_EXCL_PAIR                , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(73, PC_73_AXI_ERRM_AWUSER_STABLE            , `ERRM_AWUSER_STABLE            , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(74, PC_74_AXI_ERRM_WUSER_STABLE             , `ERRM_WUSER_STABLE             , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(75, PC_75_AXI_ERRS_BUSER_STABLE             , `ERRS_BUSER_STABLE             , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(76, PC_76_AXI_ERRM_ARUSER_STABLE            , `ERRM_ARUSER_STABLE            , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(77, PC_77_AXI_ERRS_RUSER_STABLE             , `ERRS_RUSER_STABLE             , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(78, PC_78_AXI_AUXM_RCAM_OVERFLOW            , `AUXM_RCAM_OVERFLOW            , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(79, PC_79_AXI_AUXM_RCAM_UNDERFLOW           , `AUXM_RCAM_UNDERFLOW           , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(80, PC_80_AXI_AUXM_WCAM_OVERFLOW            , `AUXM_WCAM_OVERFLOW            , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(81, PC_81_AXI_AUXM_WCAM_UNDERFLOW           , `AUXM_WCAM_UNDERFLOW           , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(82, PC_82_AXI_AUXM_EXCL_OVERFLOW            , `AUXM_EXCL_OVERFLOW            , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(83, PC_83_AXI4LITE_ERRS_BRESP_EXOKAY        , `ERRS_AXI4LITE_BRESP_EXOKAY    , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(84, PC_84_AXI4LITE_ERRS_RRESP_EXOKAY        , `ERRS_AXI4LITE_RRESP_EXOKAY    , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(85, PC_85_AXI4LITE_AUXM_DATA_WIDTH          , `AUXM_AXI4LITE_DATA_WIDTH      , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(86, PC_86_XILINX_AW_SUPPORTS_NARROW_BURST   , `XILINX_AW_SUPPORTS_NARROW_BURST, C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(87, PC_87_XILINX_AR_SUPPORTS_NARROW_BURST   , `XILINX_AR_SUPPORTS_NARROW_BURST, C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(88, PC_88_XILINX_AW_SUPPORTS_NARROW_CACHE   , `XILINX_AW_SUPPORTS_NARROW_CACHE, C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(89, PC_89_XILINX_AR_SUPPORTS_NARROW_CACHE   , `XILINX_AR_SUPPORTS_NARROW_CACHE, C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(90, PC_90_XILINX_AW_MAX_BURST               , `XILINX_AW_MAX_BURST            , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(91, PC_91_XILINX_AR_MAX_BURST               , `XILINX_AR_MAX_BURST            , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(92, PC_92_XILINX_AWREADY_RESET              , `XILINX_AWREADY_RESET           , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(93, PC_93_XILINX_WREADY_RESET               , `XILINX_WREADY_RESET            , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(94, PC_94_XILINX_BREADY_RESET               , `XILINX_BREADY_RESET            , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(95, PC_95_XILINX_ARREADY_RESET              , `XILINX_ARREADY_RESET           , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(96, PC_96_XILINX_RREADY_RESET               , `XILINX_RREADY_RESET            , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(97, PC_97_XILINX_RECS_CONTINUOUS_RTRANSFERS_MAX_WAIT               , `XILINX_RECS_CONTINUOUS_RTRANSFERS_MAX_WAIT            , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(98, PC_98_XILINX_RECM_CONTINUOUS_WTRANSFERS_MAX_WAIT               , `XILINX_RECM_CONTINUOUS_WTRANSFERS_MAX_WAIT            , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(99, PC_99_XILINX_RECM_WLAST_TO_AWVALID_MAX_WAIT               , `XILINX_RECM_WLAST_TO_AWVALID_MAX_WAIT            , C_PC_MESSAGE_LEVEL)
`REPORTER_MACRO(100, PC_100_XILINX_RECS_WRITE_TO_BVALID_MAX_WAIT               , `XILINX_RECS_WRITE_TO_BVALID_MAX_WAIT            , C_PC_MESSAGE_LEVEL)

// synthesis translate_on

endmodule
`ifdef AXI4PC_MESSAGES
  `undef AXI4PC_MESSAGES
  `undef ERRM_AWADDR_BOUNDARY      
  `undef ERRM_AWADDR_WRAP_ALIGN    
  `undef ERRM_AWBURST              
  `undef ERRM_AWCACHE              
  `undef ERRM_ARCACHE              
  `undef ERRM_AWLEN_WRAP           
  `undef ERRM_AWSIZE               
  `undef ERRM_AWVALID_RESET        
  `undef ERRM_AWADDR_STABLE        
  `undef ERRM_AWBURST_STABLE       
  `undef ERRM_AWCACHE_STABLE       
  `undef ERRM_AWID_STABLE          
  `undef ERRM_AWLEN_STABLE         
  `undef ERRM_AWLOCK_STABLE        
  `undef ERRM_AWPROT_STABLE        
  `undef ERRM_AWSIZE_STABLE        
  `undef ERRM_AWQOS_STABLE         
  `undef ERRM_AWREGION_STABLE      
  `undef ERRM_AWVALID_STABLE       
  `undef ERRM_AWADDR_X             
  `undef ERRM_AWBURST_X            
  `undef ERRM_AWCACHE_X            
  `undef ERRM_AWID_X               
  `undef ERRM_AWLEN_X              
  `undef ERRM_AWLOCK_X             
  `undef ERRM_AWPROT_X             
  `undef ERRM_AWSIZE_X             
  `undef ERRM_AWQOS_X              
  `undef ERRM_AWREGION_X           
  `undef ERRM_AWVALID_X            
  `undef ERRS_AWREADY_X            
  `undef ERRM_WDATA_NUM            
  `undef ERRM_WSTRB                
  `undef ERRM_WVALID_RESET         
  `undef ERRM_WDATA_STABLE         
  `undef ERRM_WLAST_STABLE         
  `undef ERRM_WSTRB_STABLE         
  `undef ERRM_WVALID_STABLE        
  `undef ERRM_WDATA_X              
  `undef ERRM_WLAST_X              
  `undef ERRM_WSTRB_X              
  `undef ERRM_WVALID_X             
  `undef ERRS_WREADY_X             
  `undef ERRS_BRESP_WLAST          
  `undef ERRS_BRESP_ALL_DONE_EOS   
  `undef ERRS_BRESP_EXOKAY         
  `undef ERRS_BVALID_RESET         
  `undef ERRS_BRESP_AW             
  `undef ERRS_BID_STABLE           
  `undef ERRS_BRESP_STABLE         
  `undef ERRS_BVALID_STABLE        
  `undef ERRM_BREADY_X             
  `undef ERRS_BID_X                
  `undef ERRS_BRESP_X              
  `undef ERRS_BVALID_X             
  `undef ERRM_ARADDR_BOUNDARY      
  `undef ERRM_ARADDR_WRAP_ALIGN    
  `undef ERRM_ARBURST              
  `undef ERRM_ARLEN_FIXED          
  `undef ERRM_AWLEN_FIXED          
  `undef ERRM_AWLEN_LOCK           
  `undef ERRM_ARLEN_LOCK           
  `undef ERRM_ARLEN_WRAP           
  `undef ERRM_ARSIZE               
  `undef ERRM_ARVALID_RESET        
  `undef ERRM_ARADDR_STABLE        
  `undef ERRM_ARBURST_STABLE       
  `undef ERRM_ARCACHE_STABLE       
  `undef ERRM_ARID_STABLE          
  `undef ERRM_ARLEN_STABLE         
  `undef ERRM_ARLOCK_STABLE        
  `undef ERRM_ARPROT_STABLE        
  `undef ERRM_ARSIZE_STABLE        
  `undef ERRM_ARQOS_STABLE         
  `undef ERRM_ARREGION_STABLE      
  `undef ERRM_ARVALID_STABLE       
  `undef ERRM_ARADDR_X             
  `undef ERRM_ARBURST_X            
  `undef ERRM_ARCACHE_X            
  `undef ERRM_ARID_X               
  `undef ERRM_ARLEN_X              
  `undef ERRM_ARLOCK_X             
  `undef ERRM_ARPROT_X             
  `undef ERRM_ARSIZE_X             
  `undef ERRM_ARQOS_X              
  `undef ERRM_ARREGION_X           
  `undef ERRM_ARVALID_X            
  `undef ERRS_ARREADY_X            
  `undef ERRS_RDATA_NUM            
  `undef ERRS_RLAST_ALL_DONE_EOS   
  `undef ERRS_RID                  
  `undef ERRS_RRESP_EXOKAY         
  `undef ERRS_RVALID_RESET         
  `undef ERRS_RDATA_STABLE         
  `undef ERRS_RID_STABLE           
  `undef ERRS_RLAST_STABLE         
  `undef ERRS_RRESP_STABLE         
  `undef ERRS_RVALID_STABLE        
  `undef ERRS_RDATA_X              
  `undef ERRM_RREADY_X             
  `undef ERRS_RID_X                
  `undef ERRS_RLAST_X              
  `undef ERRS_RRESP_X              
  `undef ERRS_RVALID_X             
  `undef ERRL_CSYSACK_FALL         
  `undef ERRL_CSYSACK_RISE         
  `undef ERRL_CSYSREQ_FALL         
  `undef ERRL_CSYSREQ_RISE         
  `undef ERRL_CACTIVE_X            
  `undef ERRL_CSYSACK_X            
  `undef ERRL_CSYSREQ_X            
  `undef ERRM_EXCL_ALIGN           
  `undef ERRM_EXCL_LEN             
  `undef ERRM_EXCL_MAX             
  `undef ERRM_AWUSER_STABLE        
  `undef ERRM_WUSER_STABLE         
  `undef ERRS_BUSER_STABLE         
  `undef ERRM_ARUSER_STABLE        
  `undef ERRS_RUSER_STABLE         
  `undef ERRM_AWUSER_X             
  `undef ERRM_WUSER_X              
  `undef ERRS_BUSER_X              
  `undef ERRM_ARUSER_X             
  `undef ERRS_RUSER_X              
  `undef ERRM_AWUSER_TIEOFF
  `undef ERRM_WUSER_TIEOFF
  `undef ERRS_BUSER_TIEOFF
  `undef ERRM_ARUSER_TIEOFF
  `undef ERRS_RUSER_TIEOFF
  `undef ERRM_AWID_TIEOFF 
  `undef ERRS_BID_TIEOFF 
  `undef ERRM_ARID_TIEOFF 
  `undef ERRS_RID_TIEOFF 
  `undef AUXM_DATA_WIDTH           
  `undef AUXM_ADDR_WIDTH           
  `undef AUXM_EXMON_WIDTH          
  `undef AUXM_MAXRBURSTS           
  `undef AUXM_MAXWBURSTS           
  `undef AUXM_RCAM_OVERFLOW        
  `undef AUXM_RCAM_UNDERFLOW       
  `undef AUXM_WCAM_OVERFLOW        
  `undef AUXM_WCAM_UNDERFLOW       
  `undef AUXM_EXCL_OVERFLOW        
  `undef RECM_EXCL_PAIR            
  `undef RECS_AWREADY_MAX_WAIT     
  `undef RECS_WREADY_MAX_WAIT      
  `undef RECM_BREADY_MAX_WAIT      
  `undef RECS_ARREADY_MAX_WAIT     
  `undef RECM_RREADY_MAX_WAIT      
  `undef RECM_EXCL_MATCH           
  `undef ERRS_AXI4LITE_BRESP_EXOKAY 
  `undef ERRS_AXI4LITE_RRESP_EXOKAY 
  `undef AUXM_AXI4LITE_DATA_WIDTH
  `undef XILINX_AW_SUPPORTS_NARROW_BURST 
  `undef XILINX_AR_SUPPORTS_NARROW_BURST 
  `undef XILINX_AW_SUPPORTS_NARROW_CACHE 
  `undef XILINX_AR_SUPPORTS_NARROW_CACHE 
  `undef XILINX_AW_MAX_BURST
  `undef XILINX_AR_MAX_BURST
  `undef XILINX_AWREADY_RESET
  `undef XILINX_WREADY_RESET 
  `undef XILINX_BREADY_RESET 
  `undef XILINX_ARREADY_RESET
  `undef XILINX_RREADY_RESET 
  `undef XILINX_RECS_CONTINUOUS_RTRANSFERS_MAX_WAIT
  `undef XILINX_RECM_CONTINUOUS_WTRANSFERS_MAX_WAIT
  `undef XILINX_RECM_WLAST_TO_AWVALID_MAX_WAIT
  `undef XILINX_RECS_WRITE_TO_BVALID_MAX_WAIT
`endif

`default_nettype wire



//  (c) Copyright 2017 Xilinx, Inc. All rights reserved.
//
//  This file contains confidential and proprietary information
//  of Xilinx, Inc. and is protected under U.S. and
//  international copyright and other intellectual property
//  laws.
//
//  DISCLAIMER
//  This disclaimer is not a license and does not grant any
//  rights to the materials distributed herewith. Except as
//  otherwise provided in a valid license issued to you by
//  Xilinx, and to the maximum extent permitted by applicable
//  law: (1) THESE MATERIALS ARE MADE AVAILABLE "AS IS" AND
//  WITH ALL FAULTS, AND XILINX HEREBY DISCLAIMS ALL WARRANTIES
//  AND CONDITIONS, EXPRESS, IMPLIED, OR STATUTORY, INCLUDING
//  BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, NON-
//  INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE; and
//  (2) Xilinx shall not be liable (whether in contract or tort,
//  including negligence, or under any other theory of
//  liability) for any loss or damage of any kind or nature
//  related to, arising under or in connection with these
//  materials, including for any direct, or any indirect,
//  special, incidental, or consequential loss or damage
//  (including loss of data, profits, goodwill, or any type of
//  loss or damage suffered as a result of any action brought
//  by a third party) even if such damage or loss was
//  reasonably foreseeable or Xilinx had been advised of the
//  possibility of the same.
//
//  CRITICAL APPLICATIONS
//  Xilinx products are not designed or intended to be fail-
//  safe, or for use in any application requiring fail-safe
//  performance, such as life-support or safety devices or
//  systems, Class III medical devices, nuclear facilities,
//  applications related to the deployment of airbags, or any
//  other applications that could lead to death, personal
//  injury, or severe property or environmental damage
//  (individually and collectively, "Critical
//  Applications"). Customer assumes the sole risk and
//  liability of any use of Xilinx products in Critical
//  Applications, subject only to applicable laws and
//  regulations governing limitations on product liability.
//
//  THIS COPYRIGHT NOTICE AND DISCLAIMER MUST BE RETAINED AS
//  PART OF THIS FILE AT ALL TIMES.
//-----------------------------------------------------------------------------
//
// Verilog-standard:  System Verilog 2012
//--------------------------------------------------------------------------

`timescale 1ps/1ps
`default_nettype none

`include "sc_util_v1_0_2_constants.vh"
  
(* DowngradeIPIdentifiedWarnings="yes" *) 
module axi_protocol_checker_v1_1_14_threadcam # (
  parameter integer C_NUM_THREADS       = 1                ,
  parameter integer C_INDEX_WIDTH       = 1                ,  // = clog2(C_NUM_THREADS)
  parameter integer C_ID_WIDTH          = 0                ,
  parameter integer C_NUM_OUTSTANDING   = 32
) (
  input  wire                                        aclk,
  input  wire                                        aclken,
  input  wire                                        areset,

// Generic address channel SI
  input  wire [(C_ID_WIDTH==0?1:C_ID_WIDTH)-1:0]     s_aid,
  input  wire                                        s_avalid,
  input  wire                                        s_aready,

// Response monitor ports
  input  wire [(C_ID_WIDTH==0?1:C_ID_WIDTH)-1:0]     m_rid,
  input  wire                                        m_rlast,
  input  wire                                        m_rvalid,
  input  wire                                        m_rready,
  
// CAM results
  output wire [C_INDEX_WIDTH-1:0]                    aid_index,
  output wire [C_INDEX_WIDTH-1:0]                    rid_index,
  output wire                                        rid_mismatch,
  output wire                                        cam_overflow,
  
// Reverse ID lookup
  input  wire [C_INDEX_WIDTH-1:0]                    rev_index,
  output wire [(C_ID_WIDTH==0?1:C_ID_WIDTH)-1:0]     rev_id
);

import sc_util_v1_0_2_pkg::*;

localparam integer P_ACCEPTANCE_SIZE = $clog2(C_NUM_OUTSTANDING<2?2:C_NUM_OUTSTANDING);
localparam integer P_BYPASS = 0;
localparam integer P_FULLY_PIPELINED = 1;
localparam integer P_PIPELINED_REG_STALL = 2;
localparam integer P_ID_WIDTH = (C_ID_WIDTH==0) ? 1 : C_ID_WIDTH;

function [P_ID_WIDTH-1:0] f_mux_id
  (
   input [C_NUM_THREADS*P_ID_WIDTH-1:0] id_array,
   input [C_INDEX_WIDTH-1:0] sel
   );
  integer i;
  reg [C_NUM_THREADS*P_ID_WIDTH-1:0] carry;
  begin
    carry[P_ID_WIDTH-1:0] = {P_ID_WIDTH{(sel==0)?1'b1:1'b0}} & id_array[P_ID_WIDTH-1:0];
    if (C_NUM_THREADS>1) begin
      for (i=1;i<C_NUM_THREADS;i=i+1) begin
        carry[i*P_ID_WIDTH +: P_ID_WIDTH] = 
          carry[(i-1)*P_ID_WIDTH +: P_ID_WIDTH] |
          ({P_ID_WIDTH{(sel==i)?1'b1:1'b0}} & id_array[i*P_ID_WIDTH +: P_ID_WIDTH]);
      end
    end
    f_mux_id = carry[P_ID_WIDTH*C_NUM_THREADS-1 : P_ID_WIDTH*(C_NUM_THREADS-1)];
  end
endfunction

genvar gen_thread;
generate
  
  if (C_ID_WIDTH==0) begin : gen_no_cam
    logic [P_ACCEPTANCE_SIZE:0]                                       trans_count = {P_ACCEPTANCE_SIZE+1{1'b0}} ;
    logic                                                             max_count = 1'b0;
    logic                                                             any_push;
    logic                                                             any_pop;
    
    assign any_push      = s_avalid & s_aready & ~max_count;
    assign any_pop       = m_rvalid & m_rready & m_rlast;
    assign rid_mismatch  = trans_count == 0;
    assign cam_overflow  = s_avalid & max_count;
    assign aid_index     = 0;
    assign rid_index     = 0;
    assign rev_id        = 0;
    
    always @(posedge aclk) begin
      if (areset) begin
        trans_count <= 0;
        max_count <= 1'b0;
      end else if (aclken) begin
        if (any_push & ~any_pop) begin
          max_count <= trans_count == (C_NUM_OUTSTANDING<1?1:C_NUM_OUTSTANDING)-1;
          trans_count <= trans_count + 1;
        end else if (~any_push & any_pop & |trans_count) begin
          max_count <= 1'b0;
          trans_count <= trans_count - 1;
        end
      end
    end
    
  end else begin : gen_cam
  
    logic                                                             areset_d;
    logic                                                             areset_leading;
    logic                                                             s_a_xfer;
    logic                                                             match_thread;
    logic                                                             push_si_thread;
    logic                                                             use_saved_thread;
    logic                                                             push_saved_thread;
    logic                                                             use_new_thread;
    logic                                                             push_new_thread;
    logic                                                             free_push;
    logic                                                             free_ready;
    logic                                                             init_push = 1'b1;
    logic                                                             allocate_available;
    logic                                                             max_count = 1'b0;
    logic                                                             set_overflow;
    logic                                                             cam_overflow_i = 1'b0;
    logic                                                             any_push;
    logic                                                             any_pop;
    (* max_fanout = 40 *) logic [C_NUM_THREADS-1:0]                   thread_last = {C_NUM_THREADS{1'b0}};
    (* max_fanout = 40 *) logic [C_NUM_THREADS-1:0]                   thread_valid = {C_NUM_THREADS{1'b0}};
    logic [C_NUM_THREADS-1:0]                                         thread_complete;
    logic [C_NUM_THREADS-1:0]                                         expire_thread = {C_NUM_THREADS{1'b0}};
    logic [C_NUM_THREADS-1:0]                                         thread_init;
    logic [C_NUM_THREADS-1:0]                                         thread_push;
    logic [C_NUM_THREADS-1:0]                                         thread_pop;
    logic [C_NUM_THREADS-1:0]                                         aid_match;
    logic [C_NUM_THREADS-1:0]                                         aid_match_d;
    logic [C_NUM_THREADS-1:0]                                         rid_match;
    logic [C_NUM_THREADS-1:0]                                         aid_index_hot;
    logic [C_NUM_THREADS-1:0]                                         allocate_next;
    logic [C_NUM_THREADS-1:0]                                         free_thread;
    logic [C_NUM_THREADS-1:0]                                         allocate_cntr = 1'b1;  // LSB set
    logic [C_NUM_THREADS*P_ID_WIDTH-1:0]                              active_id ;
    logic [C_NUM_THREADS-1:0][P_ACCEPTANCE_SIZE:0]                    active_cnt = {C_NUM_THREADS{{P_ACCEPTANCE_SIZE+1{1'b0}}}} ;
    logic [P_ACCEPTANCE_SIZE:0]                                       trans_count = {P_ACCEPTANCE_SIZE+1{1'b0}} ;
    
    typedef enum {IDLE, ALLOCATE, OVERFLOW, PENDING} t_state;
      t_state state = IDLE;
      t_state next;
    
    always @ * begin
      next = state;  // Default: hold state unless re-assigned
      match_thread = 1'b0;  // default
      push_si_thread = 1'b0;  // default
      use_saved_thread = 1'b0;  // default
      push_saved_thread = 1'b0;  // default
      use_new_thread = 1'b0;  // default
      push_new_thread = 1'b0;  // default
      set_overflow = 1'b0;  // default
      
      case (state)
        IDLE: begin  // Waiting for SI transfer
          if (s_avalid) begin
            if (|aid_match) begin  // a*id matches an active thread
              match_thread = 1'b1;  // Currently matching thread index will be used (save it in case of stall)
              if (max_count) begin  // Active transaction counter at maximum?
                next = OVERFLOW;
                set_overflow = 1'b1;
              end else begin  // Successful thread match
                if (s_aready) begin
                  push_si_thread = 1'b1;
                  next = IDLE;
                end else begin  // Wait for completed handshake
                  next = PENDING;
                end
              end
            end else begin  // SI mismatched all threads
              if (allocate_available) begin
                use_new_thread = 1'b1;  // Propagate index of new thread
                if (s_aready) begin  // Wait for completed handshake (continue to loop to this test)
                  next = IDLE;
                  push_new_thread = aclken;  // Initialize new thread in CAM (CAM is not enabled by aclken)
                end else begin
                  next = ALLOCATE;  // Wait for completed handshake
                end
              end else begin
                next = OVERFLOW;
                set_overflow = 1'b1;
              end
            end
          end
        end  // IDLE
        
        PENDING: begin  // Waiting for completed handshake after match
          match_thread = 1'b0;  // Save matching thread index (in case thread pops to 0 before aready)
          use_saved_thread = 1'b1;  // Don't let saved thread get de-allocated
          if (s_aready) begin
            push_saved_thread = 1'b1;
            next = IDLE;
          end
        end  // PENDING
                  
        ALLOCATE: begin  // Waiting for completed handshake after allocate
          use_new_thread = 1'b1;  // Propagate index of new thread
          if (s_aready) begin  // Wait for completed handshake (continue to loop to this test)
            next = IDLE;
            push_new_thread = aclken;  // Initialize new thread in CAM (CAM is not enabled by aclken)
          end
        end  // ALLOCATE
        
        OVERFLOW: begin  // CAM overflow error
          set_overflow = 1'b1;  // Trap state until reset
        end  // OVERFLOW
      endcase
    end
    
    always @(posedge aclk) begin
      if (areset) begin
        state <= IDLE;
      end else begin
        if (aclken) begin
          state <= next;
        end
      end
    end
    
    always @(posedge aclk) begin
      areset_d <= areset;
      if (areset_leading) begin  // leading-edge of reset
        allocate_cntr <= 1'b1;  // 1-hot counter (shifter), set LSB
        init_push <= 1'b1;  // Enable initializing free-thread queue
      end else begin
        if (init_push) begin
          if (free_ready & ~(|expire_thread)) begin  // Not freeing an expired thread
            if (allocate_cntr[C_NUM_THREADS-1]) begin  // Highest thread being initialized
              init_push <= 1'b0;
            end else begin
              allocate_cntr <= allocate_cntr << 1;  // Next thread to be initialized
            end
          end
        end
      end
    end
    
    always @(posedge aclk) begin
      if (areset) begin
        trans_count <= 0;
        max_count <= 1'b0;
        cam_overflow_i <= 1'b0;
      end else if (aclken) begin
        if (any_push & ~any_pop) begin
          max_count <= trans_count == (C_NUM_OUTSTANDING<1?1:C_NUM_OUTSTANDING)-1;
          trans_count <= trans_count + 1;
        end else if (~any_push & any_pop & |trans_count) begin
          max_count <= 1'b0;
          trans_count <= trans_count - 1;
        end
        if (set_overflow) begin
          cam_overflow_i <= 1'b1;
        end
      end
    end
    
    always @(posedge aclk) begin
      if (aclken) begin
        if (match_thread) begin
          aid_match_d <= aid_match;  // Save currently matching thread until stall, if any, is resolved
        end
      end
    end
    
    assign areset_leading = areset & ~areset_d;  // leading-edge of reset
    assign s_a_xfer      = s_avalid & s_aready;
    assign free_push     = init_push | (aclken & |expire_thread);  // Push a vacated or initialized thread into free queue
    assign free_thread   = (aclken & |expire_thread) ? expire_thread : allocate_cntr;
    assign aid_index_hot = use_new_thread ? allocate_next : use_saved_thread ? aid_match_d : aid_match;  // Thread index to propagate
    assign rid_mismatch  = ~|rid_match;
    assign cam_overflow  = cam_overflow_i;
    assign any_push      = push_new_thread | push_si_thread | push_saved_thread;
    assign any_pop       = m_rvalid & m_rready & m_rlast;
    assign rev_id        = f_mux_id(active_id, rev_index);
    
    for (gen_thread=0; gen_thread<C_NUM_THREADS; gen_thread=gen_thread+1) begin : gen_thread_loop
      assign aid_match[gen_thread]       = thread_valid[gen_thread] && (s_aid == active_id[gen_thread*P_ID_WIDTH +: P_ID_WIDTH]);  // Current command ID matches this thread
      assign rid_match[gen_thread]       = thread_valid[gen_thread] && (m_rid == active_id[gen_thread*P_ID_WIDTH +: P_ID_WIDTH]);  // Response ID matches this thread
      assign thread_init[gen_thread]     = push_new_thread & allocate_next[gen_thread];  // Initialize thread
      assign thread_push[gen_thread]     = (push_si_thread & aid_match[gen_thread]) | (push_saved_thread & aid_match_d[gen_thread]);  // Increment existing thread
      assign thread_pop[gen_thread]      = any_pop & rid_match[gen_thread];  // Decrement response thread
      assign thread_complete[gen_thread] = ~thread_push[gen_thread] & thread_pop[gen_thread] & thread_last[gen_thread];
    
      always @(posedge aclk) begin
        if (areset) begin
          thread_valid[gen_thread] <= 1'b0;
          active_cnt[gen_thread] <= 0; 
          thread_last[gen_thread] <= 1'b0;
          expire_thread[gen_thread] <= 1'b0;
        end else if (aclken) begin
          expire_thread[gen_thread] <= thread_complete[gen_thread] &   // Last pop
            ~((match_thread & aid_match[gen_thread]) | (use_saved_thread & aid_match_d[gen_thread]));  // But don't de-allocate a pending thread push
          if (thread_init[gen_thread]) begin
            thread_valid[gen_thread] <= 1'b1;
            thread_last[gen_thread] <= 1'b1;
            active_cnt[gen_thread] <= 1;
          end else begin
            if (thread_push[gen_thread] & ~thread_pop[gen_thread]) begin
              thread_valid[gen_thread] <= 1'b1;
              thread_last[gen_thread] <= (active_cnt[gen_thread]==0);
              active_cnt[gen_thread] <= active_cnt[gen_thread] + 1;
            end else if (~thread_push[gen_thread] & thread_pop[gen_thread]) begin
              thread_valid[gen_thread] <= ~thread_last[gen_thread];
              thread_last[gen_thread] <= (active_cnt[gen_thread]==2);
              active_cnt[gen_thread] <= active_cnt[gen_thread] - 1;
            end
          end
        end 
      end
    
      always @(posedge aclk) begin
        if (aclken) begin
          if (thread_init[gen_thread]) begin
            active_id[gen_thread*P_ID_WIDTH +: P_ID_WIDTH] <= s_aid;
          end
        end 
      end 
    end  // gen_thread loop ///////////
    
    sc_util_v1_0_2_onehot_to_binary # (
       .C_BIN_WIDTH(C_INDEX_WIDTH),
       .C_OH_WIDTH(C_NUM_THREADS) 
      ) 
      aid_encode (
       .din(aid_index_hot),
       .dout(aid_index)
      );
    
    sc_util_v1_0_2_onehot_to_binary # (
       .C_BIN_WIDTH(C_INDEX_WIDTH),
       .C_OH_WIDTH(C_NUM_THREADS) 
      ) 
      rid_encode (
       .din(rid_match),
       .dout(rid_index)
      );
    
    sc_util_v1_0_2_axic_reg_srl_fifo #(
       .C_FIFO_SIZE(C_INDEX_WIDTH<2?2:C_INDEX_WIDTH),
       .C_FIFO_WIDTH(C_NUM_THREADS),
       .C_REG_CONFIG(2)  // Fully pipelined
      ) 
      allocate_queue (
       .aclk    (aclk),
       .aclken  (1'b1),
       .areset  (areset_leading),
       .s_mesg  (free_thread),
       .s_valid (free_push),
       .s_ready (free_ready),
       .s_afull (),
       .m_mesg  (allocate_next),
       .m_valid (allocate_available),
       .m_ready (push_new_thread)
      );
      
  end : gen_cam      
endgenerate
endmodule  // axi_protocol_checker_v1_1_14_threadcam

`default_nettype wire



// (c) Copyright 2010 - 2013 Xilinx, Inc. All rights reserved.
//
// This file contains confidential and proprietary information
// of Xilinx, Inc. and is protected under U.S. and
// international copyright and other intellectual property
// laws.
//
// DISCLAIMER
// This disclaimer is not a license and does not grant any
// rights to the materials distributed herewith. Except as
// otherwise provided in a valid license issued to you by
// Xilinx, and to the maximum extent permitted by applicable
// law: (1) THESE MATERIALS ARE MADE AVAILABLE "AS IS" AND
// WITH ALL FAULTS, AND XILINX HEREBY DISCLAIMS ALL WARRANTIES
// AND CONDITIONS, EXPRESS, IMPLIED, OR STATUTORY, INCLUDING
// BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, NON-
// INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE; and
// (2) Xilinx shall not be liable (whether in contract or tort,
// including negligence, or under any other theory of
// liability) for any loss or damage of any kind or nature
// related to, arising under or in connection with these
// materials, including for any direct, or any indirect,
// special, incidental, or consequential loss or damage
// (including loss of data, profits, goodwill, or any type of
// loss or damage suffered as a result of any action brought
// by a third party) even if such damage or loss was
// reasonably foreseeable or Xilinx had been advised of the
// possibility of the same.
//
// CRITICAL APPLICATIONS
// Xilinx products are not designed or intended to be fail-
// safe, or for use in any application requiring fail-safe
// performance, such as life-support or safety devices or
// systems, Class III medical devices, nuclear facilities,
// applications related to the deployment of airbags, or any
// other applications that could lead to death, personal
// injury, or severe property or environmental damage
// (individually and collectively, "Critical
// Applications"). Customer assumes the sole risk and
// liability of any use of Xilinx products in Critical
// Applications, subject only to applicable laws and
// regulations governing limitations on product liability.
//
// THIS COPYRIGHT NOTICE AND DISCLAIMER MUST BE RETAINED AS
// PART OF THIS FILE AT ALL TIMES.


`timescale 1ps/1ps
`default_nettype none

(* DowngradeIPIdentifiedWarnings="yes" *)
 module axi_protocol_checker_v1_1_14_top #(
  //Core Level Generics
  parameter integer C_AXI_PROTOCOL                 = 0,
  parameter integer C_AXI_ID_WIDTH                 = 1,
  parameter integer C_AXI_DATA_WIDTH               = 32,
  parameter integer C_AXI_ADDR_WIDTH               = 32,
  parameter integer C_AXI_AWUSER_WIDTH             = 1,
  parameter integer C_AXI_ARUSER_WIDTH             = 1,
  parameter integer C_AXI_WUSER_WIDTH              = 1,
  parameter integer C_AXI_RUSER_WIDTH              = 1,
  parameter integer C_AXI_BUSER_WIDTH              = 1,
  
  parameter integer C_PC_MAXRBURSTS                = 8,
  parameter integer C_PC_MAXWBURSTS                = 8,
  parameter integer C_PC_EXMON_WIDTH               = 0,
  parameter integer C_PC_AW_MAXWAITS               = 0,
  parameter integer C_PC_AR_MAXWAITS               = 0,
  parameter integer C_PC_W_MAXWAITS                = 0,
  parameter integer C_PC_R_MAXWAITS                = 0,
  parameter integer C_PC_B_MAXWAITS                = 0,
  parameter integer C_PC_MAX_CONTINUOUS_RTRANSFERS_WAITS  = 0,
  parameter integer C_PC_MAX_CONTINUOUS_WTRANSFERS_WAITS = 0,
  parameter integer C_PC_MAX_WLAST_TO_AWVALID_WAITS  = 0,
  parameter integer C_PC_MAX_WRITE_TO_BVALID_WAITS  = 0,
  parameter integer C_PC_LIGHT_WEIGHT                = 0,
  parameter integer C_PC_MESSAGE_LEVEL             = 2,
  parameter integer C_PC_SUPPORTS_NARROW_BURST     = 1,
  parameter integer C_PC_MAX_BURST_LENGTH          = 256,
  parameter integer C_PC_HAS_SYSTEM_RESET          = 0,
  parameter integer C_ENABLE_CONTROL               = 0,
  parameter integer C_PC_STATUS_WIDTH              = 97
) (
  //Protocol Checker Specific Signals
  output wire [C_PC_STATUS_WIDTH - 1:0]               pc_status,
  output wire                                         pc_asserted,
  
  input wire                                          system_resetn,
  //AXI CLK
  input wire                                          aclk,
  //AXI Reset
  input wire                                          aresetn,
  //AXI Write Address
  input wire [C_AXI_ID_WIDTH-1:0]                     pc_axi_awid,
  input wire [C_AXI_ADDR_WIDTH-1:0]                   pc_axi_awaddr,
  input wire [((C_AXI_PROTOCOL == 1) ? 4 : 8)-1:0]    pc_axi_awlen,
  input wire [2:0]                                    pc_axi_awsize,
  input wire [1:0]                                    pc_axi_awburst,
  input wire [((C_AXI_PROTOCOL == 1) ? 2 : 1)-1:0]    pc_axi_awlock,
  input wire [3:0]                                    pc_axi_awcache,
  input wire [2:0]                                    pc_axi_awprot,
  input wire [3:0]                                    pc_axi_awqos,
  input wire [3:0]                                    pc_axi_awregion,
  input wire [C_AXI_AWUSER_WIDTH-1:0]                 pc_axi_awuser,
  input wire                                          pc_axi_awvalid,
  input wire                                          pc_axi_awready,
  //AXI Write Data
  input wire [C_AXI_ID_WIDTH-1:0]                     pc_axi_wid,
  input wire                                          pc_axi_wlast,
  input wire [C_AXI_DATA_WIDTH-1:0]                   pc_axi_wdata,
  input wire [C_AXI_DATA_WIDTH/8-1:0]                 pc_axi_wstrb,
  input wire [C_AXI_WUSER_WIDTH-1:0]                  pc_axi_wuser,
  input wire                                          pc_axi_wvalid,
  input wire                                          pc_axi_wready,
  //AXI Write Response
  input wire [C_AXI_ID_WIDTH-1:0]                     pc_axi_bid,
  input wire [1:0]                                    pc_axi_bresp,
  input wire [C_AXI_BUSER_WIDTH-1:0]                  pc_axi_buser,
  input wire                                          pc_axi_bvalid,
  input wire                                          pc_axi_bready,
  //AXI Read Address
  input wire [C_AXI_ID_WIDTH-1:0]                     pc_axi_arid,
  input wire [C_AXI_ADDR_WIDTH-1:0]                   pc_axi_araddr,
  input wire [((C_AXI_PROTOCOL == 1) ? 4 : 8)-1:0]    pc_axi_arlen,
  input wire [2:0]                                    pc_axi_arsize,
  input wire [1:0]                                    pc_axi_arburst,
  input wire [((C_AXI_PROTOCOL == 1) ? 2 : 1)-1:0]    pc_axi_arlock,
  input wire [3:0]                                    pc_axi_arcache,
  input wire [2:0]                                    pc_axi_arprot,
  input wire [3:0]                                    pc_axi_arqos,
  input wire [3:0]                                    pc_axi_arregion,
  input wire [C_AXI_ARUSER_WIDTH-1:0]                 pc_axi_aruser,
  input wire                                          pc_axi_arvalid,
  input wire                                          pc_axi_arready,
  //AXI Read Data
  input wire [C_AXI_ID_WIDTH-1:0]                     pc_axi_rid,
  input wire                                          pc_axi_rlast,
  input wire [C_AXI_DATA_WIDTH-1:0]                   pc_axi_rdata,
  input wire [1:0]                                    pc_axi_rresp,
  input wire [C_AXI_RUSER_WIDTH-1:0]                  pc_axi_ruser,
  input wire                                          pc_axi_rvalid,
  input wire                                          pc_axi_rready,
  // AXI Status Interface (read-only)
  input  wire [10-1:0]                                s_axi_araddr,
  input  wire                                         s_axi_arvalid,
  output wire                                         s_axi_arready,
  output wire [32-1:0]                                s_axi_rdata,
  output wire [1:0]                                   s_axi_rresp,
  output wire                                         s_axi_rvalid,
  input  wire                                         s_axi_rready
);

localparam integer P_NUM_REPORTED_CHECKS = 101;  // Number of defined messages/attributes in reported module
localparam LP_AXI_SIZE = (C_AXI_DATA_WIDTH == 32) ? 3'b010 : 3'b011;
localparam integer P_NUM_RTHREADS = (2**(C_AXI_ID_WIDTH>16?16:C_AXI_ID_WIDTH) > C_PC_MAXRBURSTS) ? (C_PC_MAXRBURSTS+1) : 2**C_AXI_ID_WIDTH;
localparam integer P_NUM_WTHREADS = (2**(C_AXI_ID_WIDTH>16?16:C_AXI_ID_WIDTH) > C_PC_MAXWBURSTS) ? (C_PC_MAXWBURSTS+1) : 2**C_AXI_ID_WIDTH;
localparam integer P_INDEX_WIDTH = f_ceil_log2(P_NUM_RTHREADS>P_NUM_WTHREADS ? P_NUM_RTHREADS : P_NUM_WTHREADS);

  function integer f_ceil_log2
    (
     input integer x
     );
    integer acc;
    begin
      acc=0;
      while ((2**acc) < x)
        acc = acc + 1;
      f_ceil_log2 = acc;
    end
  endfunction

  reg   resetn_q;
  wire  reset_i;
  wire  resetn_out;
  wire  thread_cam_reset;
  (* shreg_extract="no", iob="false", equivalent_register_removal = "no" *) reg [2:0] reset_resync;

  assign reset_i = ~system_resetn;
  assign resetn_out = (C_PC_HAS_SYSTEM_RESET == 1) ? reset_resync[2] : resetn_q;
  
  always @(posedge aclk or posedge reset_i) begin
    if (reset_i) begin
      reset_resync <= 3'b000;
    end else begin
      reset_resync <= {reset_resync[1:0], 1'b1};
    end
  end

  assign thread_cam_reset = !(resetn_out & resetn_q);

reg  [C_AXI_ID_WIDTH-1:0]     awid_q;
reg  [C_AXI_ADDR_WIDTH-1:0]   awaddr_q;
reg  [7:0]                    awlen_q;
reg  [2:0]                    awsize_q;
reg  [1:0]                    awburst_q;
reg  [0:0]                    awlock_q;
reg  [3:0]                    awcache_q;
reg  [2:0]                    awprot_q;
reg  [3:0]                    awqos_q;
reg  [3:0]                    awregion_q;
reg  [C_AXI_AWUSER_WIDTH-1:0] awuser_q;
reg                           awvalid_q;
reg                           awready_q;
reg                           wlast_q;
reg  [C_AXI_DATA_WIDTH-1:0]   wdata_q;
reg  [C_AXI_DATA_WIDTH/8-1:0] wstrb_q;
reg  [C_AXI_WUSER_WIDTH-1:0]  wuser_q;
reg                           wvalid_q;
reg                           wready_q;
reg  [C_AXI_ID_WIDTH-1:0]     bid_q;
reg  [1:0]                    bresp_q;
reg  [C_AXI_BUSER_WIDTH-1:0]  buser_q;
reg                           bvalid_q;
reg                           bready_q;
reg  [C_AXI_ID_WIDTH-1:0]     arid_q;
reg  [C_AXI_ADDR_WIDTH-1:0]   araddr_q;
reg  [7:0]                    arlen_q;
reg  [2:0]                    arsize_q;
reg  [1:0]                    arburst_q;
reg  [0:0]                    arlock_q;
reg  [3:0]                    arcache_q;
reg  [2:0]                    arprot_q;
reg  [3:0]                    arqos_q;
reg  [3:0]                    arregion_q;
reg  [C_AXI_ARUSER_WIDTH-1:0] aruser_q;
reg                           arvalid_q;
reg                           arready_q;
reg  [C_AXI_ID_WIDTH-1:0]     rid_q;
reg                           rlast_q;
reg  [C_AXI_DATA_WIDTH-1:0]   rdata_q;
reg  [1:0]                    rresp_q;
reg  [C_AXI_RUSER_WIDTH-1:0]  ruser_q;
reg                           rvalid_q;
reg                           rready_q;

reg                           resetn_qq;
reg  [C_AXI_ID_WIDTH-1:0]     awid_qq;
reg  [C_AXI_ADDR_WIDTH-1:0]   awaddr_qq;
reg  [7:0]                    awlen_qq;
reg  [2:0]                    awsize_qq;
reg  [1:0]                    awburst_qq;
reg  [0:0]                    awlock_qq;
reg  [3:0]                    awcache_qq;
reg  [2:0]                    awprot_qq;
reg  [3:0]                    awqos_qq;
reg  [3:0]                    awregion_qq;
reg  [C_AXI_AWUSER_WIDTH-1:0] awuser_qq;
reg                           awvalid_qq;
reg                           awready_qq;
reg                           wlast_qq;
reg  [C_AXI_DATA_WIDTH-1:0]   wdata_qq;
reg  [C_AXI_DATA_WIDTH/8-1:0] wstrb_qq;
reg  [C_AXI_WUSER_WIDTH-1:0]  wuser_qq;
reg                           wvalid_qq;
reg                           wready_qq;
reg  [C_AXI_ID_WIDTH-1:0]     bid_qq;
reg  [1:0]                    bresp_qq;
reg  [C_AXI_BUSER_WIDTH-1:0]  buser_qq;
reg                           bvalid_qq;
reg                           bready_qq;
reg  [C_AXI_ID_WIDTH-1:0]     arid_qq;
reg  [C_AXI_ADDR_WIDTH-1:0]   araddr_qq;
reg  [7:0]                    arlen_qq;
reg  [2:0]                    arsize_qq;
reg  [1:0]                    arburst_qq;
reg  [0:0]                    arlock_qq;
reg  [3:0]                    arcache_qq;
reg  [2:0]                    arprot_qq;
reg  [3:0]                    arqos_qq;
reg  [3:0]                    arregion_qq;
reg  [C_AXI_ARUSER_WIDTH-1:0] aruser_qq;
reg                           arvalid_qq;
reg                           arready_qq;
reg  [C_AXI_ID_WIDTH-1:0]     rid_qq;
reg                           rlast_qq;
reg  [C_AXI_DATA_WIDTH-1:0]   rdata_qq;
reg  [1:0]                    rresp_qq;
reg  [C_AXI_RUSER_WIDTH-1:0]  ruser_qq;
reg                           rvalid_qq;
reg                           rready_qq;

wire [P_INDEX_WIDTH-1:0] arid_index    ;
wire [P_INDEX_WIDTH-1:0] rid_index     ;
wire                     rid_mismatch  ;
wire                     rcam_overflow ;
wire [P_INDEX_WIDTH-1:0] awid_index    ;
wire [P_INDEX_WIDTH-1:0] bid_index     ;
wire                     bid_mismatch  ;
wire                     wcam_overflow ;
reg  [P_INDEX_WIDTH-1:0] arid_index_q;
reg  [P_INDEX_WIDTH-1:0] rid_index_q;
reg                      rid_mismatch_q;
reg                      rcam_overflow_q;
reg  [P_INDEX_WIDTH-1:0] awid_index_q;
reg  [P_INDEX_WIDTH-1:0] bid_index_q;
reg                      bid_mismatch_q;
reg                      wcam_overflow_q;

reg                           pc_asserted_i;
reg [127:0]                   pc_snapshot;
wire [C_PC_STATUS_WIDTH-1:0]  pc_status_i;

always @(posedge aclk) begin
  resetn_q    <= aresetn;
  awid_q      <= (C_AXI_PROTOCOL != 2) ? pc_axi_awid     : {C_AXI_ID_WIDTH{1'b0}};
  awaddr_q    <= (C_PC_LIGHT_WEIGHT == 0) ? pc_axi_awaddr : {C_AXI_ADDR_WIDTH{1'b0}};
  awlen_q     <= (C_AXI_PROTOCOL == 0) ? pc_axi_awlen : (C_AXI_PROTOCOL == 1) ? (pc_axi_awlen | 8'h00) : 8'h00;
  awsize_q    <= (C_AXI_PROTOCOL != 2) ? pc_axi_awsize   : LP_AXI_SIZE;
  awburst_q   <= (C_PC_LIGHT_WEIGHT == 0 && C_AXI_PROTOCOL != 2) ? pc_axi_awburst  : 2'b01;
  awlock_q    <= (C_PC_LIGHT_WEIGHT == 0 && C_AXI_PROTOCOL != 2) ? pc_axi_awlock[0] : 1'b0;
  awcache_q   <= (C_PC_LIGHT_WEIGHT == 0 && C_AXI_PROTOCOL != 2) ? pc_axi_awcache  : 4'h0;
  awprot_q    <= (C_PC_LIGHT_WEIGHT == 0) ? pc_axi_awprot : {3{1'b0}};
  awqos_q     <= (C_PC_LIGHT_WEIGHT == 0 && C_AXI_PROTOCOL != 2) ? pc_axi_awqos    : 4'h0;
  awregion_q  <= (C_PC_LIGHT_WEIGHT == 0 && C_AXI_PROTOCOL != 2) ? pc_axi_awregion : 4'h0;
  awuser_q    <= (C_PC_LIGHT_WEIGHT == 0 && C_AXI_PROTOCOL != 2) ? pc_axi_awuser   : {C_AXI_AWUSER_WIDTH{1'b0}};
  awvalid_q   <= pc_axi_awvalid;
  awready_q   <= pc_axi_awready;
  wlast_q     <= (C_AXI_PROTOCOL != 2) ? pc_axi_wlast    : 1'b1;
  wdata_q     <= (C_PC_LIGHT_WEIGHT == 0) ? pc_axi_wdata : {C_AXI_DATA_WIDTH{1'b0}};
  wstrb_q     <= (C_PC_LIGHT_WEIGHT == 0) ? pc_axi_wstrb : {C_AXI_DATA_WIDTH/8{1'b0}};
  wuser_q     <= (C_PC_LIGHT_WEIGHT == 0 && C_AXI_PROTOCOL != 2) ? pc_axi_wuser    : {C_AXI_WUSER_WIDTH{1'b0}};
  wvalid_q    <= pc_axi_wvalid;
  wready_q    <= pc_axi_wready;
  bid_q       <= (C_AXI_PROTOCOL != 2) ? pc_axi_bid      : {C_AXI_ID_WIDTH{1'b0}};
  bresp_q     <= (C_PC_LIGHT_WEIGHT == 0) ? pc_axi_bresp : {2{1'b0}};
  buser_q     <= (C_PC_LIGHT_WEIGHT == 0 && C_AXI_PROTOCOL != 2) ? pc_axi_buser    : {C_AXI_BUSER_WIDTH{1'b0}};
  bvalid_q    <= pc_axi_bvalid;
  bready_q    <= pc_axi_bready;
  arid_q      <= (C_AXI_PROTOCOL != 2) ? pc_axi_arid     : {C_AXI_ID_WIDTH{1'b0}};
  araddr_q    <= (C_PC_LIGHT_WEIGHT == 0) ? pc_axi_araddr : {C_AXI_ADDR_WIDTH{1'b0}};
  arlen_q     <= (C_AXI_PROTOCOL == 0) ? pc_axi_arlen : (C_AXI_PROTOCOL == 1) ? (pc_axi_arlen| 8'h00) : 8'h00;
  arsize_q    <= (C_AXI_PROTOCOL != 2) ? pc_axi_arsize   : LP_AXI_SIZE;
  arburst_q   <= (C_PC_LIGHT_WEIGHT == 0 && C_AXI_PROTOCOL != 2) ? pc_axi_arburst  : 2'b01;
  arlock_q    <= (C_PC_LIGHT_WEIGHT == 0 && C_AXI_PROTOCOL != 2) ? pc_axi_arlock[0] : 1'b0;
  arcache_q   <= (C_PC_LIGHT_WEIGHT == 0 && C_AXI_PROTOCOL != 2) ? pc_axi_arcache  : 4'h0;
  arprot_q    <= (C_PC_LIGHT_WEIGHT == 0) ? pc_axi_arprot : {3{1'b0}};
  arqos_q     <= (C_PC_LIGHT_WEIGHT == 0 && C_AXI_PROTOCOL != 2) ? pc_axi_arqos    : 4'h0;
  arregion_q  <= (C_PC_LIGHT_WEIGHT == 0 && C_AXI_PROTOCOL != 2) ? pc_axi_arregion : 4'h0;
  aruser_q    <= (C_AXI_PROTOCOL != 2) ? pc_axi_aruser   : {C_AXI_ARUSER_WIDTH{1'b0}};
  arvalid_q   <= pc_axi_arvalid;
  arready_q   <= pc_axi_arready;
  rid_q       <= (C_AXI_PROTOCOL != 2) ? pc_axi_rid      : {C_AXI_ID_WIDTH{1'b0}};
  rlast_q     <= (C_AXI_PROTOCOL != 2) ? pc_axi_rlast    : 1'b1;
  rdata_q     <= (C_PC_LIGHT_WEIGHT == 0) ? pc_axi_rdata : {C_AXI_DATA_WIDTH{1'b0}};
  rresp_q     <= (C_PC_LIGHT_WEIGHT == 0) ? pc_axi_rresp : {2{1'b0}};
  ruser_q     <= (C_PC_LIGHT_WEIGHT == 0 && C_AXI_PROTOCOL != 2) ? pc_axi_ruser    : {C_AXI_RUSER_WIDTH{1'b0}};
  rvalid_q    <= pc_axi_rvalid;
  rready_q    <= pc_axi_rready;
  
  resetn_qq    <= resetn_q   ;
  awid_qq      <= awid_q     ;
  awaddr_qq    <= awaddr_q   ;
  awlen_qq     <= awlen_q    ;
  awsize_qq    <= awsize_q   ;
  awburst_qq   <= awburst_q  ;
  awlock_qq    <= awlock_q   ;
  awcache_qq   <= awcache_q  ;
  awprot_qq    <= awprot_q   ;
  awqos_qq     <= awqos_q    ;
  awregion_qq  <= awregion_q ;
  awuser_qq    <= awuser_q   ;
  awvalid_qq   <= awvalid_q  ;
  awready_qq   <= awready_q  ;
  wlast_qq     <= wlast_q    ;
  wdata_qq     <= wdata_q    ;
  wstrb_qq     <= wstrb_q    ;
  wuser_qq     <= wuser_q    ;
  wvalid_qq    <= wvalid_q   ;
  wready_qq    <= wready_q   ;
  bid_qq       <= bid_q      ;
  bresp_qq     <= bresp_q    ;
  buser_qq     <= buser_q    ;
  bvalid_qq    <= bvalid_q   ;
  bready_qq    <= bready_q   ;
  arid_qq      <= arid_q     ;
  araddr_qq    <= araddr_q   ;
  arlen_qq     <= arlen_q    ;
  arsize_qq    <= arsize_q   ;
  arburst_qq   <= arburst_q  ;
  arlock_qq    <= arlock_q   ;
  arcache_qq   <= arcache_q  ;
  arprot_qq    <= arprot_q   ;
  arqos_qq     <= arqos_q    ;
  arregion_qq  <= arregion_q ;
  aruser_qq    <= aruser_q   ;
  arvalid_qq   <= arvalid_q  ;
  arready_qq   <= arready_q  ;
  rid_qq       <= rid_q      ;
  rlast_qq     <= rlast_q    ;
  rdata_qq     <= rdata_q    ;
  rresp_qq     <= rresp_q    ;
  ruser_qq     <= ruser_q    ;
  rvalid_qq    <= rvalid_q   ;
  rready_qq    <= rready_q   ;
  
  arid_index_q    <= arid_index     ;
  rid_index_q     <= rid_index      ;
  rid_mismatch_q  <= rid_mismatch   ;
  rcam_overflow_q <= rcam_overflow  ;
  awid_index_q    <= awid_index     ;
  bid_index_q     <= bid_index      ;
  bid_mismatch_q  <= bid_mismatch   ;
  wcam_overflow_q <= wcam_overflow  ;
  
  pc_asserted_i <= |pc_status_i;
  if (~pc_asserted_i) begin  // Capture first asserted check(s)
    pc_snapshot <= pc_status_i;
  end
end

assign pc_status = pc_status_i;
assign pc_asserted = pc_asserted_i;

  axi_protocol_checker_v1_1_14_threadcam #( 
    .C_NUM_THREADS   (P_NUM_RTHREADS      ) ,
    .C_INDEX_WIDTH   (P_INDEX_WIDTH  ) ,
    .C_ID_WIDTH      (C_AXI_ID_WIDTH       ) ,
    .C_NUM_OUTSTANDING (C_PC_MAXRBURSTS       ) 
  )
  r_threadcam ( 
    .aclk       (aclk  ),
    .aclken     (1'b1 ),
    .areset     (thread_cam_reset ),
    .s_aid      ( arid_q ) ,
    .s_avalid   ( arvalid_q   ) ,
    .s_aready   ( arready_q   ) ,
    .m_rid      ( rid_q ) ,
    .m_rlast    ( rlast_q  ) ,
    .m_rvalid   ( rvalid_q ) ,
    .m_rready   ( rready_q ) ,
    .aid_index  (arid_index),
    .rid_index  (rid_index),
    .rid_mismatch (rid_mismatch),
    .cam_overflow (rcam_overflow ),
    .rev_index  ({P_INDEX_WIDTH{1'b0}}),
    .rev_id     ( )
  );

  axi_protocol_checker_v1_1_14_threadcam #( 
    .C_NUM_THREADS   (P_NUM_WTHREADS      ) ,
    .C_INDEX_WIDTH   (P_INDEX_WIDTH  ) ,
    .C_ID_WIDTH      (C_AXI_ID_WIDTH       ) ,
    .C_NUM_OUTSTANDING (C_PC_MAXWBURSTS       ) 
  )
  w_threadcam ( 
    .aclk       (aclk  ),
    .aclken     (1'b1 ),
    .areset     (thread_cam_reset ),
    .s_aid      ( awid_q ) ,
    .s_avalid   ( awvalid_q   ) ,
    .s_aready   ( awready_q   ) ,
    .m_rid      ( bid_q ) ,
    .m_rlast    ( 1'b1  ) ,
    .m_rvalid   ( bvalid_q ) ,
    .m_rready   ( bready_q ) ,
    .aid_index  (awid_index),
    .rid_index  (bid_index),
    .rid_mismatch (bid_mismatch),
    .cam_overflow (wcam_overflow ),
    .rev_index  ({P_INDEX_WIDTH{1'b0}}),
    .rev_id     ( )
  );

axi_protocol_checker_v1_1_14_core #(
  .C_AXI_PROTOCOL             (C_AXI_PROTOCOL),
  .C_AXI_ID_WIDTH             (C_AXI_ID_WIDTH),
  .C_AXI_DATA_WIDTH           (C_AXI_DATA_WIDTH),
  .C_AXI_ADDR_WIDTH           (C_AXI_ADDR_WIDTH),
  .C_AXI_AWUSER_WIDTH         (C_AXI_AWUSER_WIDTH),
  .C_AXI_WUSER_WIDTH          (C_AXI_WUSER_WIDTH),
  .C_AXI_BUSER_WIDTH          (C_AXI_BUSER_WIDTH),
  .C_AXI_ARUSER_WIDTH         (C_AXI_ARUSER_WIDTH),
  .C_AXI_RUSER_WIDTH          (C_AXI_RUSER_WIDTH),
  .C_PC_SUPPORTS_NARROW_BURST (C_PC_SUPPORTS_NARROW_BURST),
  .C_PC_MAX_BURST_LENGTH      (C_PC_MAX_BURST_LENGTH),
  .MAXRBURSTS                 (C_PC_MAXRBURSTS),
  .MAXWBURSTS                 (C_PC_MAXWBURSTS),
  .EXMON_WIDTH                (C_PC_EXMON_WIDTH),
  .MAX_AW_WAITS               (C_PC_AW_MAXWAITS),
  .MAX_AR_WAITS               (C_PC_AR_MAXWAITS),
  .MAX_W_WAITS                (C_PC_W_MAXWAITS),
  .MAX_R_WAITS                (C_PC_R_MAXWAITS),
  .MAX_B_WAITS                (C_PC_B_MAXWAITS),
  .MAX_CONTINUOUS_RTRANSFERS_WAITS  (C_PC_MAX_CONTINUOUS_RTRANSFERS_WAITS),
  .MAX_CONTINUOUS_WTRANSFERS_WAITS  (C_PC_MAX_CONTINUOUS_WTRANSFERS_WAITS),
  .MAX_WLAST_TO_AWVALID_WAITS       (C_PC_MAX_WLAST_TO_AWVALID_WAITS),
  .MAX_WRITE_TO_BVALID_WAITS        (C_PC_MAX_WRITE_TO_BVALID_WAITS),
  .LIGHT_WEIGHT               (C_PC_LIGHT_WEIGHT),
  .C_PC_HAS_SYSTEM_RESET      (C_PC_HAS_SYSTEM_RESET),
  .C_ERROR_COUNT              (C_PC_STATUS_WIDTH),
  .C_INDEX_WIDTH              (P_INDEX_WIDTH) ,
  .C_NUM_RTHREADS             (P_NUM_RTHREADS) ,
  .C_NUM_WTHREADS             (P_NUM_WTHREADS) 
  ) CORE (
    .pc_status        (pc_status_i),
    .resetn           (system_resetn),
    
    .arid_index    (arid_index_q),
    .rid_index     (rid_index_q),
    .rid_mismatch  (rid_mismatch_q),
    .rcam_overflow (rcam_overflow_q),
    .awid_index    (awid_index_q),
    .bid_index     (bid_index_q),
    .bid_mismatch  (bid_mismatch_q),
    .wcam_overflow (wcam_overflow_q),
    
    .ACLK      (aclk),
    .ARST_N    ( resetn_qq   ),
    .AWID      ( awid_qq     ),
    .AWADDR    ( awaddr_qq   ),
    .AWLEN     ( awlen_qq    ),
    .AWSIZE    ( awsize_qq   ),
    .AWBURST   ( awburst_qq  ),
    .AWLOCK    ( awlock_qq   ),
    .AWCACHE   ( awcache_qq  ),
    .AWPROT    ( awprot_qq   ),
    .AWQOS     ( awqos_qq    ),
    .AWREGION  ( awregion_qq ),
    .AWUSER    ( awuser_qq   ),
    .AWVALID   ( awvalid_qq  ),
    .AWREADY   ( awready_qq  ),
    .WLAST     ( wlast_qq    ),
    .WDATA     ( wdata_qq    ),
    .WSTRB     ( wstrb_qq    ),
    .WUSER     ( wuser_qq    ),
    .WVALID    ( wvalid_qq   ),
    .WREADY    ( wready_qq   ),
    .BID       ( bid_qq      ),
    .BRESP     ( bresp_qq    ),
    .BUSER     ( buser_qq    ),
    .BVALID    ( bvalid_qq   ),
    .BREADY    ( bready_qq   ),
    .ARID      ( arid_qq     ),
    .ARADDR    ( araddr_qq   ),
    .ARLEN     ( arlen_qq    ),
    .ARSIZE    ( arsize_qq   ),
    .ARBURST   ( arburst_qq  ),
    .ARLOCK    ( arlock_qq   ),
    .ARCACHE   ( arcache_qq  ),
    .ARPROT    ( arprot_qq   ),
    .ARQOS     ( arqos_qq    ),
    .ARREGION  ( arregion_qq ),
    .ARUSER    ( aruser_qq   ),
    .ARVALID   ( arvalid_qq  ),
    .ARREADY   ( arready_qq  ),
    .RID       ( rid_qq      ),
    .RLAST     ( rlast_qq    ),
    .RDATA     ( rdata_qq    ),
    .RRESP     ( rresp_qq    ),
    .RUSER     ( ruser_qq    ),
    .RVALID    ( rvalid_qq   ),
    .RREADY    ( rready_qq   )
);

wire [P_NUM_REPORTED_CHECKS-1:0] pc_status_ii;
assign pc_status_ii = pc_status_i;
axi_protocol_checker_v1_1_14_reporter #(
  .C_PC_MESSAGE_LEVEL         (C_PC_MESSAGE_LEVEL),
  .C_PC_STATUS_WIDTH          (P_NUM_REPORTED_CHECKS),
  .C_AXI_PROTOCOL             (C_AXI_PROTOCOL),
  .C_AXI_ID_WIDTH             (C_AXI_ID_WIDTH),
  .C_AXI_DATA_WIDTH           (C_AXI_DATA_WIDTH),
  .C_AXI_ADDR_WIDTH           (C_AXI_ADDR_WIDTH),
  .C_AXI_AWUSER_WIDTH         (C_AXI_AWUSER_WIDTH),
  .C_AXI_WUSER_WIDTH          (C_AXI_WUSER_WIDTH),
  .C_AXI_BUSER_WIDTH          (C_AXI_BUSER_WIDTH),
  .C_AXI_ARUSER_WIDTH         (C_AXI_ARUSER_WIDTH),
  .C_AXI_RUSER_WIDTH          (C_AXI_RUSER_WIDTH),
  .C_PC_MAXRBURSTS            (C_PC_MAXRBURSTS),
  .C_PC_MAXWBURSTS            (C_PC_MAXWBURSTS)
) REP (
  .aclk         (aclk),
  .pc_status    (pc_status_ii),  // Port width must match number of defined checks
  .ARST_N      ( aresetn   ),
  .AWID         ( awid_q ),
  .AWADDR       ( awaddr_q ),
  .AWLEN        ( awlen_q ),
  .AWSIZE       ( awsize_q ),
  .AWBURST      ( awburst_q ),
  .AWLOCK       ( awlock_q ),
  .AWCACHE      ( awcache_q ),
  .AWPROT       ( awprot_q ),
  .AWQOS        ( awqos_q ),
  .AWREGION     ( awregion_q ),
  .AWUSER       ( awuser_q ),
  .AWVALID      ( awvalid_q ),
  .AWREADY      ( awready_q ),
  .WLAST        ( wlast_q ),
  .WDATA        ( wdata_q ),
  .WSTRB        ( wstrb_q ),
  .WUSER        ( wuser_q ),
  .WVALID       ( wvalid_q ),
  .WREADY       ( wready_q ),
  .BID          ( bid_q ),
  .BRESP        ( bresp_q ),
  .BUSER        ( buser_q ),
  .BVALID       ( bvalid_q ),
  .BREADY       ( bready_q ),
  .ARID         ( arid_q ),
  .ARADDR       ( araddr_q ),
  .ARLEN        ( arlen_q ),
  .ARSIZE       ( arsize_q ),
  .ARBURST      ( arburst_q ),
  .ARLOCK       ( arlock_q ),
  .ARCACHE      ( arcache_q ),
  .ARPROT       ( arprot_q ),
  .ARQOS        ( arqos_q ),
  .ARREGION     ( arregion_q ),
  .ARUSER       ( aruser_q ),
  .ARVALID      ( arvalid_q ),
  .ARREADY      ( arready_q ),
  .RID          ( rid_q ),
  .RLAST        ( rlast_q ),
  .RDATA        ( rdata_q ),
  .RRESP        ( rresp_q ),
  .RUSER        ( ruser_q ),
  .RVALID       ( rvalid_q ),
  .RREADY       ( rready_q   )
);

// AXI Status Interface
  
  reg s_axi_arready_i;
  reg s_axi_rvalid_i;
  reg [31:0] s_axi_rdata_i;
  assign s_axi_arready = s_axi_arready_i;
  assign s_axi_rvalid  = s_axi_rvalid_i;
  assign s_axi_rdata   = s_axi_rdata_i;
  assign s_axi_rresp   = 2'b0;
  
  always @(posedge aclk) begin
    if (~aresetn) begin
      s_axi_arready_i <= 1'b0;
      s_axi_rvalid_i <= 1'b0;
    end else if (C_ENABLE_CONTROL!=0) begin
      if (s_axi_rready & s_axi_rvalid_i) begin
        s_axi_rvalid_i <= 1'b0;
      end else if (s_axi_arready_i & s_axi_arvalid) begin
        s_axi_arready_i <= 1'b0;
        s_axi_rvalid_i <= 1'b1;
      end else if (~s_axi_rvalid_i) begin
        s_axi_arready_i <= 1'b1;
      end
    end
  end

  always @(posedge aclk) begin
    if (C_ENABLE_CONTROL!=0 && ~s_axi_rvalid_i) begin
      casex (s_axi_araddr)
        10'b01_xxxx_00xx: s_axi_rdata_i <= pc_status_i[31:0];
        10'b01_xxxx_01xx: s_axi_rdata_i <= pc_status_i[63:32];
        10'b01_xxxx_10xx: s_axi_rdata_i <= pc_status_i[95:64];
        10'b01_xxxx_11xx: s_axi_rdata_i <= pc_status_i[C_PC_STATUS_WIDTH-1:96];
        10'b10_xxxx_00xx: s_axi_rdata_i <= pc_snapshot[31:0];
        10'b10_xxxx_01xx: s_axi_rdata_i <= pc_snapshot[63:32];
        10'b10_xxxx_10xx: s_axi_rdata_i <= pc_snapshot[95:64];
        10'b10_xxxx_11xx: s_axi_rdata_i <= pc_snapshot[C_PC_STATUS_WIDTH-1:96];
        default:          s_axi_rdata_i <= pc_asserted_i;  // s_axi_araddr==0x0
      endcase
    end
  end

endmodule // axi_protocol_checker_v1_1_14_top

`default_nettype wire




