// ==============================================================
// File generated by Vivado(TM) HLS - High-Level Synthesis from C, C++ and SystemC
// Version: 2017.1
// Copyright (C) 1986-2017 Xilinx, Inc. All Rights Reserved.
//
// ==============================================================

#ifndef XV_FRMBUFRD_H
#define XV_FRMBUFRD_H

#ifdef __cplusplus
extern "C" {
#endif

/***************************** Include Files *********************************/
#ifndef __linux__
#include "xil_types.h"
#include "xil_assert.h"
#include "xstatus.h"
#include "xil_io.h"
#else
#include <stdint.h>
#include <assert.h>
#include <dirent.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/mman.h>
#include <unistd.h>
#include <stddef.h>
#endif
#include "xv_frmbufrd_hw.h"

/**************************** Type Definitions ******************************/
#ifdef __linux__
typedef uint8_t u8;
typedef uint16_t u16;
typedef uint32_t u32;
#else

/**
* This typedef contains configuration information for the frame buffer read core
* Each core instance should have a configuration structure associated.
*/
typedef struct {
  u16 DeviceId;             /**< Unique ID of device */
  UINTPTR BaseAddress;      /**< The base address of the core instance. */
  u16 PixPerClk;            /**< Samples Per Clock */
  u16 MaxWidth;             /**< Maximum columns supported by core instance */
  u16 MaxHeight;            /**< Maximum rows supported by core instance */
  u16 MaxDataWidth;         /**< Maximum Data width of each channel */
  u16 AXIMMDataWidth;       /**< AXI-MM data width */
  u16 RGBX8En;              /**< RGBX8      support */
  u16 YUVX8En;              /**< YUVX8      support */
  u16 YUYV8En;              /**< YUYV8      support */
  u16 RGBX10En;             /**< RGBX10     support */
  u16 YUVX10En;             /**< YUVX10     support */
  u16 Y_UV8En;              /**< Y_UV8      support */
  u16 Y_UV8_420En;          /**< Y_UV8_420  support */
  u16 RGB8En;               /**< RGB8       support */
  u16 YUV8En;               /**< YUV8       support */
  u16 Y_UV10En;             /**< Y_UV10     support */
  u16 Y_UV10_420En;         /**< Y_UV10_420 support */
  u16 Y8En;                 /**< Y8         support */
  u16 Y10En;                /**< Y10        support */
} XV_frmbufrd_Config;
#endif

/**
* Driver instance data. An instance must be allocated for each core in use.
*/
typedef struct {
  XV_frmbufrd_Config Config;   /**< Hardware Configuration */
  u32 IsReady;                  /**< Device is initialized and ready */
} XV_frmbufrd;

/***************** Macros (Inline Functions) Definitions *********************/
#ifndef __linux__
#define XV_frmbufrd_WriteReg(BaseAddress, RegOffset, Data) \
    Xil_Out32((BaseAddress) + (RegOffset), (u32)(Data))
#define XV_frmbufrd_ReadReg(BaseAddress, RegOffset) \
    Xil_In32((BaseAddress) + (RegOffset))
#else
#define XV_frmbufrd_WriteReg(BaseAddress, RegOffset, Data) \
    *(volatile u32*)((BaseAddress) + (RegOffset)) = (u32)(Data)
#define XV_frmbufrd_ReadReg(BaseAddress, RegOffset) \
    *(volatile u32*)((BaseAddress) + (RegOffset))

#define Xil_AssertVoid(expr)    assert(expr)
#define Xil_AssertNonvoid(expr) assert(expr)

#define XST_SUCCESS             0
#define XST_DEVICE_NOT_FOUND    2
#define XST_OPEN_DEVICE_FAILED  3
#define XIL_COMPONENT_IS_READY  1
#endif

/************************** Function Prototypes *****************************/
#ifndef __linux__
int XV_frmbufrd_Initialize(XV_frmbufrd *InstancePtr, u16 DeviceId);
XV_frmbufrd_Config* XV_frmbufrd_LookupConfig(u16 DeviceId);
int XV_frmbufrd_CfgInitialize(XV_frmbufrd *InstancePtr,
                               XV_frmbufrd_Config *ConfigPtr,
                               UINTPTR EffectiveAddr);
#else
int XV_frmbufrd_Initialize(XV_frmbufrd *InstancePtr, const char* InstanceName);
int XV_frmbufrd_Release(XV_frmbufrd *InstancePtr);
#endif

void XV_frmbufrd_Start(XV_frmbufrd *InstancePtr);
u32 XV_frmbufrd_IsDone(XV_frmbufrd *InstancePtr);
u32 XV_frmbufrd_IsIdle(XV_frmbufrd *InstancePtr);
u32 XV_frmbufrd_IsReady(XV_frmbufrd *InstancePtr);
void XV_frmbufrd_EnableAutoRestart(XV_frmbufrd *InstancePtr);
void XV_frmbufrd_DisableAutoRestart(XV_frmbufrd *InstancePtr);

void XV_frmbufrd_Set_HwReg_width(XV_frmbufrd *InstancePtr, u32 Data);
u32 XV_frmbufrd_Get_HwReg_width(XV_frmbufrd *InstancePtr);
void XV_frmbufrd_Set_HwReg_height(XV_frmbufrd *InstancePtr, u32 Data);
u32 XV_frmbufrd_Get_HwReg_height(XV_frmbufrd *InstancePtr);
void XV_frmbufrd_Set_HwReg_stride(XV_frmbufrd *InstancePtr, u32 Data);
u32 XV_frmbufrd_Get_HwReg_stride(XV_frmbufrd *InstancePtr);
void XV_frmbufrd_Set_HwReg_video_format(XV_frmbufrd *InstancePtr, u32 Data);
u32 XV_frmbufrd_Get_HwReg_video_format(XV_frmbufrd *InstancePtr);
void XV_frmbufrd_Set_HwReg_frm_buffer_V(XV_frmbufrd *InstancePtr, u32 Data);
u32 XV_frmbufrd_Get_HwReg_frm_buffer_V(XV_frmbufrd *InstancePtr);

void XV_frmbufrd_InterruptGlobalEnable(XV_frmbufrd *InstancePtr);
void XV_frmbufrd_InterruptGlobalDisable(XV_frmbufrd *InstancePtr);
void XV_frmbufrd_InterruptEnable(XV_frmbufrd *InstancePtr, u32 Mask);
void XV_frmbufrd_InterruptDisable(XV_frmbufrd *InstancePtr, u32 Mask);
void XV_frmbufrd_InterruptClear(XV_frmbufrd *InstancePtr, u32 Mask);
u32 XV_frmbufrd_InterruptGetEnabled(XV_frmbufrd *InstancePtr);
u32 XV_frmbufrd_InterruptGetStatus(XV_frmbufrd *InstancePtr);

#ifdef __cplusplus
}
#endif

#endif
