/*
 * servoPWM.cpp
 *
 *  Created on: Nov 30, 2017
 *      Author: KP Lee
 */


#include "servoPWM.h"

float Duty_val( float Degree)
{

	float Duty_val = ( (Degree / 90.0) + 0.5 ) /1000 ;
	return Duty_val;

}


void PWM_Freq_Duty( u32 PWM_ADDRESS, float CLOCK_PERIOD, float Freq, float Duty)
{
	XTmrCtr_SetLoadReg(PWM_ADDRESS,0,(Freq / CLOCK_PERIOD) - 2); //PWM Frequency
	XTmrCtr_SetLoadReg(PWM_ADDRESS,1,(Duty / CLOCK_PERIOD) - 2); //PWM Duty
}


void PWM_START( u32 PWM_ADDRESS)
{
	XTmrCtr_SetControlStatusReg(PWM_ADDRESS,0,XTC_CSR_ENABLE_ALL_MASK| XTC_CSR_ENABLE_PWM_MASK | XTC_CSR_EXT_GENERATE_MASK | XTC_CSR_DOWN_COUNT_MASK);
	XTmrCtr_SetControlStatusReg(PWM_ADDRESS,1,XTC_CSR_ENABLE_ALL_MASK| XTC_CSR_ENABLE_PWM_MASK | XTC_CSR_EXT_GENERATE_MASK | XTC_CSR_DOWN_COUNT_MASK);

}

void PWM_STOP(u32 PWM_ADDRESS)
{
	XTmrCtr_SetControlStatusReg(PWM_ADDRESS,0,0);
	XTmrCtr_SetControlStatusReg(PWM_ADDRESS,1,0);
}
