-- ==============================================================
-- RTL generated by Vivado(TM) HLS - High-Level Synthesis from C, C++ and SystemC
-- Version: 2017.2
-- Copyright (C) 1986-2017 Xilinx, Inc. All Rights Reserved.
-- 
-- ===========================================================

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;

entity image_filter is
generic (
    C_S_AXI_CONTROL_BUS_ADDR_WIDTH : INTEGER := 6;
    C_S_AXI_CONTROL_BUS_DATA_WIDTH : INTEGER := 32 );
port (
    s_axi_CONTROL_BUS_AWVALID : IN STD_LOGIC;
    s_axi_CONTROL_BUS_AWREADY : OUT STD_LOGIC;
    s_axi_CONTROL_BUS_AWADDR : IN STD_LOGIC_VECTOR (C_S_AXI_CONTROL_BUS_ADDR_WIDTH-1 downto 0);
    s_axi_CONTROL_BUS_WVALID : IN STD_LOGIC;
    s_axi_CONTROL_BUS_WREADY : OUT STD_LOGIC;
    s_axi_CONTROL_BUS_WDATA : IN STD_LOGIC_VECTOR (C_S_AXI_CONTROL_BUS_DATA_WIDTH-1 downto 0);
    s_axi_CONTROL_BUS_WSTRB : IN STD_LOGIC_VECTOR (C_S_AXI_CONTROL_BUS_DATA_WIDTH/8-1 downto 0);
    s_axi_CONTROL_BUS_ARVALID : IN STD_LOGIC;
    s_axi_CONTROL_BUS_ARREADY : OUT STD_LOGIC;
    s_axi_CONTROL_BUS_ARADDR : IN STD_LOGIC_VECTOR (C_S_AXI_CONTROL_BUS_ADDR_WIDTH-1 downto 0);
    s_axi_CONTROL_BUS_RVALID : OUT STD_LOGIC;
    s_axi_CONTROL_BUS_RREADY : IN STD_LOGIC;
    s_axi_CONTROL_BUS_RDATA : OUT STD_LOGIC_VECTOR (C_S_AXI_CONTROL_BUS_DATA_WIDTH-1 downto 0);
    s_axi_CONTROL_BUS_RRESP : OUT STD_LOGIC_VECTOR (1 downto 0);
    s_axi_CONTROL_BUS_BVALID : OUT STD_LOGIC;
    s_axi_CONTROL_BUS_BREADY : IN STD_LOGIC;
    s_axi_CONTROL_BUS_BRESP : OUT STD_LOGIC_VECTOR (1 downto 0);
    ap_clk : IN STD_LOGIC;
    ap_rst_n : IN STD_LOGIC;
    video_in_TDATA : IN STD_LOGIC_VECTOR (23 downto 0);
    video_in_TKEEP : IN STD_LOGIC_VECTOR (2 downto 0);
    video_in_TSTRB : IN STD_LOGIC_VECTOR (2 downto 0);
    video_in_TUSER : IN STD_LOGIC_VECTOR (0 downto 0);
    video_in_TLAST : IN STD_LOGIC_VECTOR (0 downto 0);
    video_in_TID : IN STD_LOGIC_VECTOR (0 downto 0);
    video_in_TDEST : IN STD_LOGIC_VECTOR (0 downto 0);
    video_out_TDATA : OUT STD_LOGIC_VECTOR (23 downto 0);
    video_out_TKEEP : OUT STD_LOGIC_VECTOR (2 downto 0);
    video_out_TSTRB : OUT STD_LOGIC_VECTOR (2 downto 0);
    video_out_TUSER : OUT STD_LOGIC_VECTOR (0 downto 0);
    video_out_TLAST : OUT STD_LOGIC_VECTOR (0 downto 0);
    video_out_TID : OUT STD_LOGIC_VECTOR (0 downto 0);
    video_out_TDEST : OUT STD_LOGIC_VECTOR (0 downto 0);
    ap_start : IN STD_LOGIC;
    video_in_TVALID : IN STD_LOGIC;
    video_in_TREADY : OUT STD_LOGIC;
    video_out_TVALID : OUT STD_LOGIC;
    video_out_TREADY : IN STD_LOGIC;
    ap_done : OUT STD_LOGIC;
    ap_ready : OUT STD_LOGIC;
    ap_idle : OUT STD_LOGIC );
end;


architecture behav of image_filter is 
    attribute CORE_GENERATION_INFO : STRING;
    attribute CORE_GENERATION_INFO of behav : architecture is
    "image_filter,hls_ip_2017_2,{HLS_INPUT_TYPE=cxx,HLS_INPUT_FLOAT=0,HLS_INPUT_FIXED=0,HLS_INPUT_PART=xc7z010clg400-1,HLS_INPUT_CLOCK=10.000000,HLS_INPUT_ARCH=dataflow,HLS_SYN_CLOCK=9.400000,HLS_SYN_LAT=-1,HLS_SYN_TPT=-1,HLS_SYN_MEM=15,HLS_SYN_DSP=57,HLS_SYN_FF=9903,HLS_SYN_LUT=5885}";
    constant C_S_AXI_DATA_WIDTH : INTEGER range 63 downto 0 := 20;
    constant C_S_AXI_WSTRB_WIDTH : INTEGER range 63 downto 0 := 4;
    constant C_S_AXI_ADDR_WIDTH : INTEGER range 63 downto 0 := 20;
    constant ap_const_logic_1 : STD_LOGIC := '1';
    constant ap_const_lv24_0 : STD_LOGIC_VECTOR (23 downto 0) := "000000000000000000000000";
    constant ap_const_lv3_0 : STD_LOGIC_VECTOR (2 downto 0) := "000";
    constant ap_const_lv1_0 : STD_LOGIC_VECTOR (0 downto 0) := "0";
    constant ap_const_lv32_0 : STD_LOGIC_VECTOR (31 downto 0) := "00000000000000000000000000000000";
    constant ap_const_logic_0 : STD_LOGIC := '0';
    constant ap_const_lv8_0 : STD_LOGIC_VECTOR (7 downto 0) := "00000000";
    constant ap_const_lv8_1 : STD_LOGIC_VECTOR (7 downto 0) := "00000001";
    constant ap_const_boolean_1 : BOOLEAN := true;

    signal ap_rst_n_inv : STD_LOGIC;
    signal Block_proc_U0_ap_start : STD_LOGIC;
    signal Block_proc_U0_ap_done : STD_LOGIC;
    signal Block_proc_U0_ap_continue : STD_LOGIC;
    signal Block_proc_U0_ap_idle : STD_LOGIC;
    signal Block_proc_U0_ap_ready : STD_LOGIC;
    signal Block_proc_U0_img_in_rows_V_out_din : STD_LOGIC_VECTOR (9 downto 0);
    signal Block_proc_U0_img_in_rows_V_out_write : STD_LOGIC;
    signal Block_proc_U0_img_in_cols_V_out_din : STD_LOGIC_VECTOR (10 downto 0);
    signal Block_proc_U0_img_in_cols_V_out_write : STD_LOGIC;
    signal AXIvideo2Mat_U0_ap_start : STD_LOGIC;
    signal AXIvideo2Mat_U0_start_full_n : STD_LOGIC;
    signal AXIvideo2Mat_U0_ap_ready : STD_LOGIC;
    signal AXIvideo2Mat_U0_ap_done : STD_LOGIC;
    signal AXIvideo2Mat_U0_ap_continue : STD_LOGIC;
    signal AXIvideo2Mat_U0_ap_idle : STD_LOGIC;
    signal AXIvideo2Mat_U0_start_out : STD_LOGIC;
    signal AXIvideo2Mat_U0_start_write : STD_LOGIC;
    signal AXIvideo2Mat_U0_video_in_TREADY : STD_LOGIC;
    signal AXIvideo2Mat_U0_img_rows_V_read : STD_LOGIC;
    signal AXIvideo2Mat_U0_img_cols_V_read : STD_LOGIC;
    signal AXIvideo2Mat_U0_img_data_stream_0_V_din : STD_LOGIC_VECTOR (7 downto 0);
    signal AXIvideo2Mat_U0_img_data_stream_0_V_write : STD_LOGIC;
    signal AXIvideo2Mat_U0_img_data_stream_1_V_din : STD_LOGIC_VECTOR (7 downto 0);
    signal AXIvideo2Mat_U0_img_data_stream_1_V_write : STD_LOGIC;
    signal AXIvideo2Mat_U0_img_data_stream_2_V_din : STD_LOGIC_VECTOR (7 downto 0);
    signal AXIvideo2Mat_U0_img_data_stream_2_V_write : STD_LOGIC;
    signal AXIvideo2Mat_U0_img_rows_V_out_din : STD_LOGIC_VECTOR (9 downto 0);
    signal AXIvideo2Mat_U0_img_rows_V_out_write : STD_LOGIC;
    signal AXIvideo2Mat_U0_img_cols_V_out_din : STD_LOGIC_VECTOR (10 downto 0);
    signal AXIvideo2Mat_U0_img_cols_V_out_write : STD_LOGIC;
    signal GaussianBlur_U0_ap_start : STD_LOGIC;
    signal GaussianBlur_U0_start_full_n : STD_LOGIC;
    signal GaussianBlur_U0_ap_ready : STD_LOGIC;
    signal GaussianBlur_U0_ap_done : STD_LOGIC;
    signal GaussianBlur_U0_ap_continue : STD_LOGIC;
    signal GaussianBlur_U0_ap_idle : STD_LOGIC;
    signal GaussianBlur_U0_start_out : STD_LOGIC;
    signal GaussianBlur_U0_start_write : STD_LOGIC;
    signal GaussianBlur_U0_p_src_rows_V_read : STD_LOGIC;
    signal GaussianBlur_U0_p_src_cols_V_read : STD_LOGIC;
    signal GaussianBlur_U0_p_src_data_stream_0_V_read : STD_LOGIC;
    signal GaussianBlur_U0_p_src_data_stream_1_V_read : STD_LOGIC;
    signal GaussianBlur_U0_p_src_data_stream_2_V_read : STD_LOGIC;
    signal GaussianBlur_U0_p_dst_data_stream_0_V_din : STD_LOGIC_VECTOR (7 downto 0);
    signal GaussianBlur_U0_p_dst_data_stream_0_V_write : STD_LOGIC;
    signal GaussianBlur_U0_p_dst_data_stream_1_V_din : STD_LOGIC_VECTOR (7 downto 0);
    signal GaussianBlur_U0_p_dst_data_stream_1_V_write : STD_LOGIC;
    signal GaussianBlur_U0_p_dst_data_stream_2_V_din : STD_LOGIC_VECTOR (7 downto 0);
    signal GaussianBlur_U0_p_dst_data_stream_2_V_write : STD_LOGIC;
    signal Duplicate130_U0_ap_start : STD_LOGIC;
    signal Duplicate130_U0_start_full_n : STD_LOGIC;
    signal Duplicate130_U0_ap_ready : STD_LOGIC;
    signal Duplicate130_U0_ap_done : STD_LOGIC;
    signal Duplicate130_U0_ap_continue : STD_LOGIC;
    signal Duplicate130_U0_ap_idle : STD_LOGIC;
    signal Duplicate130_U0_start_out : STD_LOGIC;
    signal Duplicate130_U0_start_write : STD_LOGIC;
    signal Duplicate130_U0_src_data_stream_V_read : STD_LOGIC;
    signal Duplicate130_U0_src_data_stream_V1_read : STD_LOGIC;
    signal Duplicate130_U0_src_data_stream_V2_read : STD_LOGIC;
    signal Duplicate130_U0_dst1_data_stream_V : STD_LOGIC_VECTOR (7 downto 0);
    signal Duplicate130_U0_dst1_data_stream_V_ap_vld : STD_LOGIC;
    signal Duplicate130_U0_dst1_data_stream_V3 : STD_LOGIC_VECTOR (7 downto 0);
    signal Duplicate130_U0_dst1_data_stream_V3_ap_vld : STD_LOGIC;
    signal Duplicate130_U0_dst1_data_stream_V4 : STD_LOGIC_VECTOR (7 downto 0);
    signal Duplicate130_U0_dst1_data_stream_V4_ap_vld : STD_LOGIC;
    signal Duplicate130_U0_dst2_data_stream_V_din : STD_LOGIC_VECTOR (7 downto 0);
    signal Duplicate130_U0_dst2_data_stream_V_write : STD_LOGIC;
    signal Duplicate130_U0_dst2_data_stream_V5_din : STD_LOGIC_VECTOR (7 downto 0);
    signal Duplicate130_U0_dst2_data_stream_V5_write : STD_LOGIC;
    signal Duplicate130_U0_dst2_data_stream_V6_din : STD_LOGIC_VECTOR (7 downto 0);
    signal Duplicate130_U0_dst2_data_stream_V6_write : STD_LOGIC;
    signal Duplicate_U0_ap_start : STD_LOGIC;
    signal Duplicate_U0_ap_done : STD_LOGIC;
    signal Duplicate_U0_ap_continue : STD_LOGIC;
    signal Duplicate_U0_ap_idle : STD_LOGIC;
    signal Duplicate_U0_ap_ready : STD_LOGIC;
    signal Duplicate_U0_src_data_stream_0_V_read : STD_LOGIC;
    signal Duplicate_U0_src_data_stream_1_V_read : STD_LOGIC;
    signal Duplicate_U0_src_data_stream_2_V_read : STD_LOGIC;
    signal Duplicate_U0_dst1_data_stream_0_V : STD_LOGIC_VECTOR (7 downto 0);
    signal Duplicate_U0_dst1_data_stream_0_V_ap_vld : STD_LOGIC;
    signal Duplicate_U0_dst1_data_stream_1_V : STD_LOGIC_VECTOR (7 downto 0);
    signal Duplicate_U0_dst1_data_stream_1_V_ap_vld : STD_LOGIC;
    signal Duplicate_U0_dst1_data_stream_2_V : STD_LOGIC_VECTOR (7 downto 0);
    signal Duplicate_U0_dst1_data_stream_2_V_ap_vld : STD_LOGIC;
    signal Duplicate_U0_dst2_data_stream_0_V_din : STD_LOGIC_VECTOR (7 downto 0);
    signal Duplicate_U0_dst2_data_stream_0_V_write : STD_LOGIC;
    signal Duplicate_U0_dst2_data_stream_1_V_din : STD_LOGIC_VECTOR (7 downto 0);
    signal Duplicate_U0_dst2_data_stream_1_V_write : STD_LOGIC;
    signal Duplicate_U0_dst2_data_stream_2_V_din : STD_LOGIC_VECTOR (7 downto 0);
    signal Duplicate_U0_dst2_data_stream_2_V_write : STD_LOGIC;
    signal PaintMask_U0_ap_start : STD_LOGIC;
    signal PaintMask_U0_start_full_n : STD_LOGIC;
    signal PaintMask_U0_ap_ready : STD_LOGIC;
    signal PaintMask_U0_ap_done : STD_LOGIC;
    signal PaintMask_U0_ap_continue : STD_LOGIC;
    signal PaintMask_U0_ap_idle : STD_LOGIC;
    signal PaintMask_U0_start_out : STD_LOGIC;
    signal PaintMask_U0_start_write : STD_LOGIC;
    signal PaintMask_U0_p_src_data_stream_0_V_read : STD_LOGIC;
    signal PaintMask_U0_p_src_data_stream_1_V_read : STD_LOGIC;
    signal PaintMask_U0_p_src_data_stream_2_V_read : STD_LOGIC;
    signal PaintMask_U0_p_dst_data_stream_0_V_din : STD_LOGIC_VECTOR (7 downto 0);
    signal PaintMask_U0_p_dst_data_stream_0_V_write : STD_LOGIC;
    signal PaintMask_U0_p_dst_data_stream_1_V_din : STD_LOGIC_VECTOR (7 downto 0);
    signal PaintMask_U0_p_dst_data_stream_1_V_write : STD_LOGIC;
    signal PaintMask_U0_p_dst_data_stream_2_V_din : STD_LOGIC_VECTOR (7 downto 0);
    signal PaintMask_U0_p_dst_data_stream_2_V_write : STD_LOGIC;
    signal Mat2AXIvideo_U0_ap_start : STD_LOGIC;
    signal Mat2AXIvideo_U0_ap_done : STD_LOGIC;
    signal Mat2AXIvideo_U0_ap_continue : STD_LOGIC;
    signal Mat2AXIvideo_U0_ap_idle : STD_LOGIC;
    signal Mat2AXIvideo_U0_ap_ready : STD_LOGIC;
    signal Mat2AXIvideo_U0_img_data_stream_0_V_read : STD_LOGIC;
    signal Mat2AXIvideo_U0_img_data_stream_1_V_read : STD_LOGIC;
    signal Mat2AXIvideo_U0_img_data_stream_2_V_read : STD_LOGIC;
    signal Mat2AXIvideo_U0_video_out_TDATA : STD_LOGIC_VECTOR (23 downto 0);
    signal Mat2AXIvideo_U0_video_out_TVALID : STD_LOGIC;
    signal Mat2AXIvideo_U0_video_out_TKEEP : STD_LOGIC_VECTOR (2 downto 0);
    signal Mat2AXIvideo_U0_video_out_TSTRB : STD_LOGIC_VECTOR (2 downto 0);
    signal Mat2AXIvideo_U0_video_out_TUSER : STD_LOGIC_VECTOR (0 downto 0);
    signal Mat2AXIvideo_U0_video_out_TLAST : STD_LOGIC_VECTOR (0 downto 0);
    signal Mat2AXIvideo_U0_video_out_TID : STD_LOGIC_VECTOR (0 downto 0);
    signal Mat2AXIvideo_U0_video_out_TDEST : STD_LOGIC_VECTOR (0 downto 0);
    signal ap_sync_continue : STD_LOGIC;
    signal Block_proc154_U0_ap_start : STD_LOGIC;
    signal Block_proc154_U0_ap_done : STD_LOGIC;
    signal Block_proc154_U0_ap_continue : STD_LOGIC;
    signal Block_proc154_U0_ap_idle : STD_LOGIC;
    signal Block_proc154_U0_ap_ready : STD_LOGIC;
    signal Block_proc154_U0_x : STD_LOGIC_VECTOR (31 downto 0);
    signal Block_proc154_U0_x_ap_vld : STD_LOGIC;
    signal Block_proc154_U0_y : STD_LOGIC_VECTOR (31 downto 0);
    signal Block_proc154_U0_y_ap_vld : STD_LOGIC;
    signal img_in_rows_V_channe_1_full_n : STD_LOGIC;
    signal img_in_rows_V_channe_1_dout : STD_LOGIC_VECTOR (9 downto 0);
    signal img_in_rows_V_channe_1_empty_n : STD_LOGIC;
    signal img_in_cols_V_channe_1_full_n : STD_LOGIC;
    signal img_in_cols_V_channe_1_dout : STD_LOGIC_VECTOR (10 downto 0);
    signal img_in_cols_V_channe_1_empty_n : STD_LOGIC;
    signal img_in_data_stream_0_full_n : STD_LOGIC;
    signal img_in_data_stream_0_dout : STD_LOGIC_VECTOR (7 downto 0);
    signal img_in_data_stream_0_empty_n : STD_LOGIC;
    signal img_in_data_stream_1_full_n : STD_LOGIC;
    signal img_in_data_stream_1_dout : STD_LOGIC_VECTOR (7 downto 0);
    signal img_in_data_stream_1_empty_n : STD_LOGIC;
    signal img_in_data_stream_2_full_n : STD_LOGIC;
    signal img_in_data_stream_2_dout : STD_LOGIC_VECTOR (7 downto 0);
    signal img_in_data_stream_2_empty_n : STD_LOGIC;
    signal img_in_rows_V_channe_full_n : STD_LOGIC;
    signal img_in_rows_V_channe_dout : STD_LOGIC_VECTOR (9 downto 0);
    signal img_in_rows_V_channe_empty_n : STD_LOGIC;
    signal img_in_cols_V_channe_full_n : STD_LOGIC;
    signal img_in_cols_V_channe_dout : STD_LOGIC_VECTOR (10 downto 0);
    signal img_in_cols_V_channe_empty_n : STD_LOGIC;
    signal img_0_data_stream_0_full_n : STD_LOGIC;
    signal img_0_data_stream_0_dout : STD_LOGIC_VECTOR (7 downto 0);
    signal img_0_data_stream_0_empty_n : STD_LOGIC;
    signal img_0_data_stream_1_full_n : STD_LOGIC;
    signal img_0_data_stream_1_dout : STD_LOGIC_VECTOR (7 downto 0);
    signal img_0_data_stream_1_empty_n : STD_LOGIC;
    signal img_0_data_stream_2_full_n : STD_LOGIC;
    signal img_0_data_stream_2_dout : STD_LOGIC_VECTOR (7 downto 0);
    signal img_0_data_stream_2_empty_n : STD_LOGIC;
    signal img_in2_data_stream_s_full_n : STD_LOGIC;
    signal img_in2_data_stream_s_dout : STD_LOGIC_VECTOR (7 downto 0);
    signal img_in2_data_stream_s_empty_n : STD_LOGIC;
    signal img_in2_data_stream_1_full_n : STD_LOGIC;
    signal img_in2_data_stream_1_dout : STD_LOGIC_VECTOR (7 downto 0);
    signal img_in2_data_stream_1_empty_n : STD_LOGIC;
    signal img_in2_data_stream_2_full_n : STD_LOGIC;
    signal img_in2_data_stream_2_dout : STD_LOGIC_VECTOR (7 downto 0);
    signal img_in2_data_stream_2_empty_n : STD_LOGIC;
    signal img_3_data_stream_0_full_n : STD_LOGIC;
    signal img_3_data_stream_0_dout : STD_LOGIC_VECTOR (7 downto 0);
    signal img_3_data_stream_0_empty_n : STD_LOGIC;
    signal img_3_data_stream_1_full_n : STD_LOGIC;
    signal img_3_data_stream_1_dout : STD_LOGIC_VECTOR (7 downto 0);
    signal img_3_data_stream_1_empty_n : STD_LOGIC;
    signal img_3_data_stream_2_full_n : STD_LOGIC;
    signal img_3_data_stream_2_dout : STD_LOGIC_VECTOR (7 downto 0);
    signal img_3_data_stream_2_empty_n : STD_LOGIC;
    signal img_out_data_stream_s_full_n : STD_LOGIC;
    signal img_out_data_stream_s_dout : STD_LOGIC_VECTOR (7 downto 0);
    signal img_out_data_stream_s_empty_n : STD_LOGIC;
    signal img_out_data_stream_1_full_n : STD_LOGIC;
    signal img_out_data_stream_1_dout : STD_LOGIC_VECTOR (7 downto 0);
    signal img_out_data_stream_1_empty_n : STD_LOGIC;
    signal img_out_data_stream_2_full_n : STD_LOGIC;
    signal img_out_data_stream_2_dout : STD_LOGIC_VECTOR (7 downto 0);
    signal img_out_data_stream_2_empty_n : STD_LOGIC;
    signal ap_sync_done : STD_LOGIC;
    signal ap_reg_Mat2AXIvideo_U0_ap_done : STD_LOGIC := '0';
    signal ap_reg_Block_proc154_U0_ap_done : STD_LOGIC := '0';
    signal ap_sync_ready : STD_LOGIC;
    signal Block_proc_U0_start_full_n : STD_LOGIC;
    signal Block_proc_U0_start_write : STD_LOGIC;
    signal start_for_GaussianBlur_U0_din : STD_LOGIC_VECTOR (0 downto 0);
    signal start_for_GaussianBlur_U0_full_n : STD_LOGIC;
    signal start_for_GaussianBlur_U0_dout : STD_LOGIC_VECTOR (0 downto 0);
    signal start_for_GaussianBlur_U0_empty_n : STD_LOGIC;
    signal start_for_Duplicate130_U0_din : STD_LOGIC_VECTOR (0 downto 0);
    signal start_for_Duplicate130_U0_full_n : STD_LOGIC;
    signal start_for_Duplicate130_U0_dout : STD_LOGIC_VECTOR (0 downto 0);
    signal start_for_Duplicate130_U0_empty_n : STD_LOGIC;
    signal start_for_Duplicate_U0_din : STD_LOGIC_VECTOR (0 downto 0);
    signal start_for_Duplicate_U0_full_n : STD_LOGIC;
    signal start_for_Duplicate_U0_dout : STD_LOGIC_VECTOR (0 downto 0);
    signal start_for_Duplicate_U0_empty_n : STD_LOGIC;
    signal Duplicate_U0_start_full_n : STD_LOGIC;
    signal Duplicate_U0_start_write : STD_LOGIC;
    signal start_for_Mat2AXIvideo_U0_din : STD_LOGIC_VECTOR (0 downto 0);
    signal start_for_Mat2AXIvideo_U0_full_n : STD_LOGIC;
    signal start_for_Mat2AXIvideo_U0_dout : STD_LOGIC_VECTOR (0 downto 0);
    signal start_for_Mat2AXIvideo_U0_empty_n : STD_LOGIC;
    signal Mat2AXIvideo_U0_start_full_n : STD_LOGIC;
    signal Mat2AXIvideo_U0_start_write : STD_LOGIC;
    signal Block_proc154_U0_start_full_n : STD_LOGIC;
    signal Block_proc154_U0_start_write : STD_LOGIC;

    component Block_proc IS
    port (
        ap_clk : IN STD_LOGIC;
        ap_rst : IN STD_LOGIC;
        ap_start : IN STD_LOGIC;
        ap_done : OUT STD_LOGIC;
        ap_continue : IN STD_LOGIC;
        ap_idle : OUT STD_LOGIC;
        ap_ready : OUT STD_LOGIC;
        img_in_rows_V_out_din : OUT STD_LOGIC_VECTOR (9 downto 0);
        img_in_rows_V_out_full_n : IN STD_LOGIC;
        img_in_rows_V_out_write : OUT STD_LOGIC;
        img_in_cols_V_out_din : OUT STD_LOGIC_VECTOR (10 downto 0);
        img_in_cols_V_out_full_n : IN STD_LOGIC;
        img_in_cols_V_out_write : OUT STD_LOGIC );
    end component;


    component AXIvideo2Mat IS
    port (
        ap_clk : IN STD_LOGIC;
        ap_rst : IN STD_LOGIC;
        ap_start : IN STD_LOGIC;
        start_full_n : IN STD_LOGIC;
        ap_ready : OUT STD_LOGIC;
        ap_done : OUT STD_LOGIC;
        ap_continue : IN STD_LOGIC;
        ap_idle : OUT STD_LOGIC;
        start_out : OUT STD_LOGIC;
        start_write : OUT STD_LOGIC;
        video_in_TDATA : IN STD_LOGIC_VECTOR (23 downto 0);
        video_in_TVALID : IN STD_LOGIC;
        video_in_TREADY : OUT STD_LOGIC;
        video_in_TKEEP : IN STD_LOGIC_VECTOR (2 downto 0);
        video_in_TSTRB : IN STD_LOGIC_VECTOR (2 downto 0);
        video_in_TUSER : IN STD_LOGIC_VECTOR (0 downto 0);
        video_in_TLAST : IN STD_LOGIC_VECTOR (0 downto 0);
        video_in_TID : IN STD_LOGIC_VECTOR (0 downto 0);
        video_in_TDEST : IN STD_LOGIC_VECTOR (0 downto 0);
        img_rows_V_dout : IN STD_LOGIC_VECTOR (9 downto 0);
        img_rows_V_empty_n : IN STD_LOGIC;
        img_rows_V_read : OUT STD_LOGIC;
        img_cols_V_dout : IN STD_LOGIC_VECTOR (10 downto 0);
        img_cols_V_empty_n : IN STD_LOGIC;
        img_cols_V_read : OUT STD_LOGIC;
        img_data_stream_0_V_din : OUT STD_LOGIC_VECTOR (7 downto 0);
        img_data_stream_0_V_full_n : IN STD_LOGIC;
        img_data_stream_0_V_write : OUT STD_LOGIC;
        img_data_stream_1_V_din : OUT STD_LOGIC_VECTOR (7 downto 0);
        img_data_stream_1_V_full_n : IN STD_LOGIC;
        img_data_stream_1_V_write : OUT STD_LOGIC;
        img_data_stream_2_V_din : OUT STD_LOGIC_VECTOR (7 downto 0);
        img_data_stream_2_V_full_n : IN STD_LOGIC;
        img_data_stream_2_V_write : OUT STD_LOGIC;
        img_rows_V_out_din : OUT STD_LOGIC_VECTOR (9 downto 0);
        img_rows_V_out_full_n : IN STD_LOGIC;
        img_rows_V_out_write : OUT STD_LOGIC;
        img_cols_V_out_din : OUT STD_LOGIC_VECTOR (10 downto 0);
        img_cols_V_out_full_n : IN STD_LOGIC;
        img_cols_V_out_write : OUT STD_LOGIC );
    end component;


    component GaussianBlur IS
    port (
        ap_clk : IN STD_LOGIC;
        ap_rst : IN STD_LOGIC;
        ap_start : IN STD_LOGIC;
        start_full_n : IN STD_LOGIC;
        ap_ready : OUT STD_LOGIC;
        ap_done : OUT STD_LOGIC;
        ap_continue : IN STD_LOGIC;
        ap_idle : OUT STD_LOGIC;
        start_out : OUT STD_LOGIC;
        start_write : OUT STD_LOGIC;
        p_src_rows_V_dout : IN STD_LOGIC_VECTOR (9 downto 0);
        p_src_rows_V_empty_n : IN STD_LOGIC;
        p_src_rows_V_read : OUT STD_LOGIC;
        p_src_cols_V_dout : IN STD_LOGIC_VECTOR (10 downto 0);
        p_src_cols_V_empty_n : IN STD_LOGIC;
        p_src_cols_V_read : OUT STD_LOGIC;
        p_src_data_stream_0_V_dout : IN STD_LOGIC_VECTOR (7 downto 0);
        p_src_data_stream_0_V_empty_n : IN STD_LOGIC;
        p_src_data_stream_0_V_read : OUT STD_LOGIC;
        p_src_data_stream_1_V_dout : IN STD_LOGIC_VECTOR (7 downto 0);
        p_src_data_stream_1_V_empty_n : IN STD_LOGIC;
        p_src_data_stream_1_V_read : OUT STD_LOGIC;
        p_src_data_stream_2_V_dout : IN STD_LOGIC_VECTOR (7 downto 0);
        p_src_data_stream_2_V_empty_n : IN STD_LOGIC;
        p_src_data_stream_2_V_read : OUT STD_LOGIC;
        p_dst_data_stream_0_V_din : OUT STD_LOGIC_VECTOR (7 downto 0);
        p_dst_data_stream_0_V_full_n : IN STD_LOGIC;
        p_dst_data_stream_0_V_write : OUT STD_LOGIC;
        p_dst_data_stream_1_V_din : OUT STD_LOGIC_VECTOR (7 downto 0);
        p_dst_data_stream_1_V_full_n : IN STD_LOGIC;
        p_dst_data_stream_1_V_write : OUT STD_LOGIC;
        p_dst_data_stream_2_V_din : OUT STD_LOGIC_VECTOR (7 downto 0);
        p_dst_data_stream_2_V_full_n : IN STD_LOGIC;
        p_dst_data_stream_2_V_write : OUT STD_LOGIC );
    end component;


    component Duplicate130 IS
    port (
        ap_clk : IN STD_LOGIC;
        ap_rst : IN STD_LOGIC;
        ap_start : IN STD_LOGIC;
        start_full_n : IN STD_LOGIC;
        ap_ready : OUT STD_LOGIC;
        ap_done : OUT STD_LOGIC;
        ap_continue : IN STD_LOGIC;
        ap_idle : OUT STD_LOGIC;
        start_out : OUT STD_LOGIC;
        start_write : OUT STD_LOGIC;
        src_data_stream_V_dout : IN STD_LOGIC_VECTOR (7 downto 0);
        src_data_stream_V_empty_n : IN STD_LOGIC;
        src_data_stream_V_read : OUT STD_LOGIC;
        src_data_stream_V1_dout : IN STD_LOGIC_VECTOR (7 downto 0);
        src_data_stream_V1_empty_n : IN STD_LOGIC;
        src_data_stream_V1_read : OUT STD_LOGIC;
        src_data_stream_V2_dout : IN STD_LOGIC_VECTOR (7 downto 0);
        src_data_stream_V2_empty_n : IN STD_LOGIC;
        src_data_stream_V2_read : OUT STD_LOGIC;
        dst1_data_stream_V : OUT STD_LOGIC_VECTOR (7 downto 0);
        dst1_data_stream_V_ap_vld : OUT STD_LOGIC;
        dst1_data_stream_V3 : OUT STD_LOGIC_VECTOR (7 downto 0);
        dst1_data_stream_V3_ap_vld : OUT STD_LOGIC;
        dst1_data_stream_V4 : OUT STD_LOGIC_VECTOR (7 downto 0);
        dst1_data_stream_V4_ap_vld : OUT STD_LOGIC;
        dst2_data_stream_V_din : OUT STD_LOGIC_VECTOR (7 downto 0);
        dst2_data_stream_V_full_n : IN STD_LOGIC;
        dst2_data_stream_V_write : OUT STD_LOGIC;
        dst2_data_stream_V5_din : OUT STD_LOGIC_VECTOR (7 downto 0);
        dst2_data_stream_V5_full_n : IN STD_LOGIC;
        dst2_data_stream_V5_write : OUT STD_LOGIC;
        dst2_data_stream_V6_din : OUT STD_LOGIC_VECTOR (7 downto 0);
        dst2_data_stream_V6_full_n : IN STD_LOGIC;
        dst2_data_stream_V6_write : OUT STD_LOGIC );
    end component;


    component Duplicate IS
    port (
        ap_clk : IN STD_LOGIC;
        ap_rst : IN STD_LOGIC;
        ap_start : IN STD_LOGIC;
        ap_done : OUT STD_LOGIC;
        ap_continue : IN STD_LOGIC;
        ap_idle : OUT STD_LOGIC;
        ap_ready : OUT STD_LOGIC;
        src_data_stream_0_V_dout : IN STD_LOGIC_VECTOR (7 downto 0);
        src_data_stream_0_V_empty_n : IN STD_LOGIC;
        src_data_stream_0_V_read : OUT STD_LOGIC;
        src_data_stream_1_V_dout : IN STD_LOGIC_VECTOR (7 downto 0);
        src_data_stream_1_V_empty_n : IN STD_LOGIC;
        src_data_stream_1_V_read : OUT STD_LOGIC;
        src_data_stream_2_V_dout : IN STD_LOGIC_VECTOR (7 downto 0);
        src_data_stream_2_V_empty_n : IN STD_LOGIC;
        src_data_stream_2_V_read : OUT STD_LOGIC;
        dst1_data_stream_0_V : OUT STD_LOGIC_VECTOR (7 downto 0);
        dst1_data_stream_0_V_ap_vld : OUT STD_LOGIC;
        dst1_data_stream_1_V : OUT STD_LOGIC_VECTOR (7 downto 0);
        dst1_data_stream_1_V_ap_vld : OUT STD_LOGIC;
        dst1_data_stream_2_V : OUT STD_LOGIC_VECTOR (7 downto 0);
        dst1_data_stream_2_V_ap_vld : OUT STD_LOGIC;
        dst2_data_stream_0_V_din : OUT STD_LOGIC_VECTOR (7 downto 0);
        dst2_data_stream_0_V_full_n : IN STD_LOGIC;
        dst2_data_stream_0_V_write : OUT STD_LOGIC;
        dst2_data_stream_1_V_din : OUT STD_LOGIC_VECTOR (7 downto 0);
        dst2_data_stream_1_V_full_n : IN STD_LOGIC;
        dst2_data_stream_1_V_write : OUT STD_LOGIC;
        dst2_data_stream_2_V_din : OUT STD_LOGIC_VECTOR (7 downto 0);
        dst2_data_stream_2_V_full_n : IN STD_LOGIC;
        dst2_data_stream_2_V_write : OUT STD_LOGIC );
    end component;


    component PaintMask IS
    port (
        ap_clk : IN STD_LOGIC;
        ap_rst : IN STD_LOGIC;
        ap_start : IN STD_LOGIC;
        start_full_n : IN STD_LOGIC;
        ap_ready : OUT STD_LOGIC;
        ap_done : OUT STD_LOGIC;
        ap_continue : IN STD_LOGIC;
        ap_idle : OUT STD_LOGIC;
        start_out : OUT STD_LOGIC;
        start_write : OUT STD_LOGIC;
        p_src_data_stream_0_V_dout : IN STD_LOGIC_VECTOR (7 downto 0);
        p_src_data_stream_0_V_empty_n : IN STD_LOGIC;
        p_src_data_stream_0_V_read : OUT STD_LOGIC;
        p_src_data_stream_1_V_dout : IN STD_LOGIC_VECTOR (7 downto 0);
        p_src_data_stream_1_V_empty_n : IN STD_LOGIC;
        p_src_data_stream_1_V_read : OUT STD_LOGIC;
        p_src_data_stream_2_V_dout : IN STD_LOGIC_VECTOR (7 downto 0);
        p_src_data_stream_2_V_empty_n : IN STD_LOGIC;
        p_src_data_stream_2_V_read : OUT STD_LOGIC;
        p_mask_data_stream_V : IN STD_LOGIC_VECTOR (7 downto 0);
        p_dst_data_stream_0_V_din : OUT STD_LOGIC_VECTOR (7 downto 0);
        p_dst_data_stream_0_V_full_n : IN STD_LOGIC;
        p_dst_data_stream_0_V_write : OUT STD_LOGIC;
        p_dst_data_stream_1_V_din : OUT STD_LOGIC_VECTOR (7 downto 0);
        p_dst_data_stream_1_V_full_n : IN STD_LOGIC;
        p_dst_data_stream_1_V_write : OUT STD_LOGIC;
        p_dst_data_stream_2_V_din : OUT STD_LOGIC_VECTOR (7 downto 0);
        p_dst_data_stream_2_V_full_n : IN STD_LOGIC;
        p_dst_data_stream_2_V_write : OUT STD_LOGIC );
    end component;


    component Mat2AXIvideo IS
    port (
        ap_clk : IN STD_LOGIC;
        ap_rst : IN STD_LOGIC;
        ap_start : IN STD_LOGIC;
        ap_done : OUT STD_LOGIC;
        ap_continue : IN STD_LOGIC;
        ap_idle : OUT STD_LOGIC;
        ap_ready : OUT STD_LOGIC;
        img_data_stream_0_V_dout : IN STD_LOGIC_VECTOR (7 downto 0);
        img_data_stream_0_V_empty_n : IN STD_LOGIC;
        img_data_stream_0_V_read : OUT STD_LOGIC;
        img_data_stream_1_V_dout : IN STD_LOGIC_VECTOR (7 downto 0);
        img_data_stream_1_V_empty_n : IN STD_LOGIC;
        img_data_stream_1_V_read : OUT STD_LOGIC;
        img_data_stream_2_V_dout : IN STD_LOGIC_VECTOR (7 downto 0);
        img_data_stream_2_V_empty_n : IN STD_LOGIC;
        img_data_stream_2_V_read : OUT STD_LOGIC;
        video_out_TDATA : OUT STD_LOGIC_VECTOR (23 downto 0);
        video_out_TVALID : OUT STD_LOGIC;
        video_out_TREADY : IN STD_LOGIC;
        video_out_TKEEP : OUT STD_LOGIC_VECTOR (2 downto 0);
        video_out_TSTRB : OUT STD_LOGIC_VECTOR (2 downto 0);
        video_out_TUSER : OUT STD_LOGIC_VECTOR (0 downto 0);
        video_out_TLAST : OUT STD_LOGIC_VECTOR (0 downto 0);
        video_out_TID : OUT STD_LOGIC_VECTOR (0 downto 0);
        video_out_TDEST : OUT STD_LOGIC_VECTOR (0 downto 0) );
    end component;


    component Block_proc154 IS
    port (
        ap_clk : IN STD_LOGIC;
        ap_rst : IN STD_LOGIC;
        ap_start : IN STD_LOGIC;
        ap_done : OUT STD_LOGIC;
        ap_continue : IN STD_LOGIC;
        ap_idle : OUT STD_LOGIC;
        ap_ready : OUT STD_LOGIC;
        x : OUT STD_LOGIC_VECTOR (31 downto 0);
        x_ap_vld : OUT STD_LOGIC;
        y : OUT STD_LOGIC_VECTOR (31 downto 0);
        y_ap_vld : OUT STD_LOGIC );
    end component;


    component fifo_w10_d1_A IS
    port (
        clk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        if_read_ce : IN STD_LOGIC;
        if_write_ce : IN STD_LOGIC;
        if_din : IN STD_LOGIC_VECTOR (9 downto 0);
        if_full_n : OUT STD_LOGIC;
        if_write : IN STD_LOGIC;
        if_dout : OUT STD_LOGIC_VECTOR (9 downto 0);
        if_empty_n : OUT STD_LOGIC;
        if_read : IN STD_LOGIC );
    end component;


    component fifo_w11_d1_A IS
    port (
        clk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        if_read_ce : IN STD_LOGIC;
        if_write_ce : IN STD_LOGIC;
        if_din : IN STD_LOGIC_VECTOR (10 downto 0);
        if_full_n : OUT STD_LOGIC;
        if_write : IN STD_LOGIC;
        if_dout : OUT STD_LOGIC_VECTOR (10 downto 0);
        if_empty_n : OUT STD_LOGIC;
        if_read : IN STD_LOGIC );
    end component;


    component fifo_w8_d1_A IS
    port (
        clk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        if_read_ce : IN STD_LOGIC;
        if_write_ce : IN STD_LOGIC;
        if_din : IN STD_LOGIC_VECTOR (7 downto 0);
        if_full_n : OUT STD_LOGIC;
        if_write : IN STD_LOGIC;
        if_dout : OUT STD_LOGIC_VECTOR (7 downto 0);
        if_empty_n : OUT STD_LOGIC;
        if_read : IN STD_LOGIC );
    end component;


    component start_for_GaussiaGfk IS
    port (
        clk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        if_read_ce : IN STD_LOGIC;
        if_write_ce : IN STD_LOGIC;
        if_din : IN STD_LOGIC_VECTOR (0 downto 0);
        if_full_n : OUT STD_LOGIC;
        if_write : IN STD_LOGIC;
        if_dout : OUT STD_LOGIC_VECTOR (0 downto 0);
        if_empty_n : OUT STD_LOGIC;
        if_read : IN STD_LOGIC );
    end component;


    component start_for_DuplicaHfu IS
    port (
        clk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        if_read_ce : IN STD_LOGIC;
        if_write_ce : IN STD_LOGIC;
        if_din : IN STD_LOGIC_VECTOR (0 downto 0);
        if_full_n : OUT STD_LOGIC;
        if_write : IN STD_LOGIC;
        if_dout : OUT STD_LOGIC_VECTOR (0 downto 0);
        if_empty_n : OUT STD_LOGIC;
        if_read : IN STD_LOGIC );
    end component;


    component start_for_DuplicaIfE IS
    port (
        clk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        if_read_ce : IN STD_LOGIC;
        if_write_ce : IN STD_LOGIC;
        if_din : IN STD_LOGIC_VECTOR (0 downto 0);
        if_full_n : OUT STD_LOGIC;
        if_write : IN STD_LOGIC;
        if_dout : OUT STD_LOGIC_VECTOR (0 downto 0);
        if_empty_n : OUT STD_LOGIC;
        if_read : IN STD_LOGIC );
    end component;


    component start_for_Mat2AXIJfO IS
    port (
        clk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        if_read_ce : IN STD_LOGIC;
        if_write_ce : IN STD_LOGIC;
        if_din : IN STD_LOGIC_VECTOR (0 downto 0);
        if_full_n : OUT STD_LOGIC;
        if_write : IN STD_LOGIC;
        if_dout : OUT STD_LOGIC_VECTOR (0 downto 0);
        if_empty_n : OUT STD_LOGIC;
        if_read : IN STD_LOGIC );
    end component;


    component image_filter_CONTROL_BUS_s_axi IS
    generic (
        C_S_AXI_ADDR_WIDTH : INTEGER;
        C_S_AXI_DATA_WIDTH : INTEGER );
    port (
        AWVALID : IN STD_LOGIC;
        AWREADY : OUT STD_LOGIC;
        AWADDR : IN STD_LOGIC_VECTOR (C_S_AXI_ADDR_WIDTH-1 downto 0);
        WVALID : IN STD_LOGIC;
        WREADY : OUT STD_LOGIC;
        WDATA : IN STD_LOGIC_VECTOR (C_S_AXI_DATA_WIDTH-1 downto 0);
        WSTRB : IN STD_LOGIC_VECTOR (C_S_AXI_DATA_WIDTH/8-1 downto 0);
        ARVALID : IN STD_LOGIC;
        ARREADY : OUT STD_LOGIC;
        ARADDR : IN STD_LOGIC_VECTOR (C_S_AXI_ADDR_WIDTH-1 downto 0);
        RVALID : OUT STD_LOGIC;
        RREADY : IN STD_LOGIC;
        RDATA : OUT STD_LOGIC_VECTOR (C_S_AXI_DATA_WIDTH-1 downto 0);
        RRESP : OUT STD_LOGIC_VECTOR (1 downto 0);
        BVALID : OUT STD_LOGIC;
        BREADY : IN STD_LOGIC;
        BRESP : OUT STD_LOGIC_VECTOR (1 downto 0);
        ACLK : IN STD_LOGIC;
        ARESET : IN STD_LOGIC;
        ACLK_EN : IN STD_LOGIC;
        x : IN STD_LOGIC_VECTOR (31 downto 0);
        x_ap_vld : IN STD_LOGIC;
        y : IN STD_LOGIC_VECTOR (31 downto 0);
        y_ap_vld : IN STD_LOGIC );
    end component;



begin
    image_filter_CONTROL_BUS_s_axi_U : component image_filter_CONTROL_BUS_s_axi
    generic map (
        C_S_AXI_ADDR_WIDTH => C_S_AXI_CONTROL_BUS_ADDR_WIDTH,
        C_S_AXI_DATA_WIDTH => C_S_AXI_CONTROL_BUS_DATA_WIDTH)
    port map (
        AWVALID => s_axi_CONTROL_BUS_AWVALID,
        AWREADY => s_axi_CONTROL_BUS_AWREADY,
        AWADDR => s_axi_CONTROL_BUS_AWADDR,
        WVALID => s_axi_CONTROL_BUS_WVALID,
        WREADY => s_axi_CONTROL_BUS_WREADY,
        WDATA => s_axi_CONTROL_BUS_WDATA,
        WSTRB => s_axi_CONTROL_BUS_WSTRB,
        ARVALID => s_axi_CONTROL_BUS_ARVALID,
        ARREADY => s_axi_CONTROL_BUS_ARREADY,
        ARADDR => s_axi_CONTROL_BUS_ARADDR,
        RVALID => s_axi_CONTROL_BUS_RVALID,
        RREADY => s_axi_CONTROL_BUS_RREADY,
        RDATA => s_axi_CONTROL_BUS_RDATA,
        RRESP => s_axi_CONTROL_BUS_RRESP,
        BVALID => s_axi_CONTROL_BUS_BVALID,
        BREADY => s_axi_CONTROL_BUS_BREADY,
        BRESP => s_axi_CONTROL_BUS_BRESP,
        ACLK => ap_clk,
        ARESET => ap_rst_n_inv,
        ACLK_EN => ap_const_logic_1,
        x => Block_proc154_U0_x,
        x_ap_vld => Block_proc154_U0_x_ap_vld,
        y => Block_proc154_U0_y,
        y_ap_vld => Block_proc154_U0_y_ap_vld);

    Block_proc_U0 : component Block_proc
    port map (
        ap_clk => ap_clk,
        ap_rst => ap_rst_n_inv,
        ap_start => Block_proc_U0_ap_start,
        ap_done => Block_proc_U0_ap_done,
        ap_continue => Block_proc_U0_ap_continue,
        ap_idle => Block_proc_U0_ap_idle,
        ap_ready => Block_proc_U0_ap_ready,
        img_in_rows_V_out_din => Block_proc_U0_img_in_rows_V_out_din,
        img_in_rows_V_out_full_n => img_in_rows_V_channe_1_full_n,
        img_in_rows_V_out_write => Block_proc_U0_img_in_rows_V_out_write,
        img_in_cols_V_out_din => Block_proc_U0_img_in_cols_V_out_din,
        img_in_cols_V_out_full_n => img_in_cols_V_channe_1_full_n,
        img_in_cols_V_out_write => Block_proc_U0_img_in_cols_V_out_write);

    AXIvideo2Mat_U0 : component AXIvideo2Mat
    port map (
        ap_clk => ap_clk,
        ap_rst => ap_rst_n_inv,
        ap_start => AXIvideo2Mat_U0_ap_start,
        start_full_n => AXIvideo2Mat_U0_start_full_n,
        ap_ready => AXIvideo2Mat_U0_ap_ready,
        ap_done => AXIvideo2Mat_U0_ap_done,
        ap_continue => AXIvideo2Mat_U0_ap_continue,
        ap_idle => AXIvideo2Mat_U0_ap_idle,
        start_out => AXIvideo2Mat_U0_start_out,
        start_write => AXIvideo2Mat_U0_start_write,
        video_in_TDATA => video_in_TDATA,
        video_in_TVALID => video_in_TVALID,
        video_in_TREADY => AXIvideo2Mat_U0_video_in_TREADY,
        video_in_TKEEP => video_in_TKEEP,
        video_in_TSTRB => video_in_TSTRB,
        video_in_TUSER => video_in_TUSER,
        video_in_TLAST => video_in_TLAST,
        video_in_TID => video_in_TID,
        video_in_TDEST => video_in_TDEST,
        img_rows_V_dout => img_in_rows_V_channe_1_dout,
        img_rows_V_empty_n => img_in_rows_V_channe_1_empty_n,
        img_rows_V_read => AXIvideo2Mat_U0_img_rows_V_read,
        img_cols_V_dout => img_in_cols_V_channe_1_dout,
        img_cols_V_empty_n => img_in_cols_V_channe_1_empty_n,
        img_cols_V_read => AXIvideo2Mat_U0_img_cols_V_read,
        img_data_stream_0_V_din => AXIvideo2Mat_U0_img_data_stream_0_V_din,
        img_data_stream_0_V_full_n => img_in_data_stream_0_full_n,
        img_data_stream_0_V_write => AXIvideo2Mat_U0_img_data_stream_0_V_write,
        img_data_stream_1_V_din => AXIvideo2Mat_U0_img_data_stream_1_V_din,
        img_data_stream_1_V_full_n => img_in_data_stream_1_full_n,
        img_data_stream_1_V_write => AXIvideo2Mat_U0_img_data_stream_1_V_write,
        img_data_stream_2_V_din => AXIvideo2Mat_U0_img_data_stream_2_V_din,
        img_data_stream_2_V_full_n => img_in_data_stream_2_full_n,
        img_data_stream_2_V_write => AXIvideo2Mat_U0_img_data_stream_2_V_write,
        img_rows_V_out_din => AXIvideo2Mat_U0_img_rows_V_out_din,
        img_rows_V_out_full_n => img_in_rows_V_channe_full_n,
        img_rows_V_out_write => AXIvideo2Mat_U0_img_rows_V_out_write,
        img_cols_V_out_din => AXIvideo2Mat_U0_img_cols_V_out_din,
        img_cols_V_out_full_n => img_in_cols_V_channe_full_n,
        img_cols_V_out_write => AXIvideo2Mat_U0_img_cols_V_out_write);

    GaussianBlur_U0 : component GaussianBlur
    port map (
        ap_clk => ap_clk,
        ap_rst => ap_rst_n_inv,
        ap_start => GaussianBlur_U0_ap_start,
        start_full_n => GaussianBlur_U0_start_full_n,
        ap_ready => GaussianBlur_U0_ap_ready,
        ap_done => GaussianBlur_U0_ap_done,
        ap_continue => GaussianBlur_U0_ap_continue,
        ap_idle => GaussianBlur_U0_ap_idle,
        start_out => GaussianBlur_U0_start_out,
        start_write => GaussianBlur_U0_start_write,
        p_src_rows_V_dout => img_in_rows_V_channe_dout,
        p_src_rows_V_empty_n => img_in_rows_V_channe_empty_n,
        p_src_rows_V_read => GaussianBlur_U0_p_src_rows_V_read,
        p_src_cols_V_dout => img_in_cols_V_channe_dout,
        p_src_cols_V_empty_n => img_in_cols_V_channe_empty_n,
        p_src_cols_V_read => GaussianBlur_U0_p_src_cols_V_read,
        p_src_data_stream_0_V_dout => img_in_data_stream_0_dout,
        p_src_data_stream_0_V_empty_n => img_in_data_stream_0_empty_n,
        p_src_data_stream_0_V_read => GaussianBlur_U0_p_src_data_stream_0_V_read,
        p_src_data_stream_1_V_dout => img_in_data_stream_1_dout,
        p_src_data_stream_1_V_empty_n => img_in_data_stream_1_empty_n,
        p_src_data_stream_1_V_read => GaussianBlur_U0_p_src_data_stream_1_V_read,
        p_src_data_stream_2_V_dout => img_in_data_stream_2_dout,
        p_src_data_stream_2_V_empty_n => img_in_data_stream_2_empty_n,
        p_src_data_stream_2_V_read => GaussianBlur_U0_p_src_data_stream_2_V_read,
        p_dst_data_stream_0_V_din => GaussianBlur_U0_p_dst_data_stream_0_V_din,
        p_dst_data_stream_0_V_full_n => img_0_data_stream_0_full_n,
        p_dst_data_stream_0_V_write => GaussianBlur_U0_p_dst_data_stream_0_V_write,
        p_dst_data_stream_1_V_din => GaussianBlur_U0_p_dst_data_stream_1_V_din,
        p_dst_data_stream_1_V_full_n => img_0_data_stream_1_full_n,
        p_dst_data_stream_1_V_write => GaussianBlur_U0_p_dst_data_stream_1_V_write,
        p_dst_data_stream_2_V_din => GaussianBlur_U0_p_dst_data_stream_2_V_din,
        p_dst_data_stream_2_V_full_n => img_0_data_stream_2_full_n,
        p_dst_data_stream_2_V_write => GaussianBlur_U0_p_dst_data_stream_2_V_write);

    Duplicate130_U0 : component Duplicate130
    port map (
        ap_clk => ap_clk,
        ap_rst => ap_rst_n_inv,
        ap_start => Duplicate130_U0_ap_start,
        start_full_n => Duplicate130_U0_start_full_n,
        ap_ready => Duplicate130_U0_ap_ready,
        ap_done => Duplicate130_U0_ap_done,
        ap_continue => Duplicate130_U0_ap_continue,
        ap_idle => Duplicate130_U0_ap_idle,
        start_out => Duplicate130_U0_start_out,
        start_write => Duplicate130_U0_start_write,
        src_data_stream_V_dout => img_0_data_stream_0_dout,
        src_data_stream_V_empty_n => img_0_data_stream_0_empty_n,
        src_data_stream_V_read => Duplicate130_U0_src_data_stream_V_read,
        src_data_stream_V1_dout => img_0_data_stream_1_dout,
        src_data_stream_V1_empty_n => img_0_data_stream_1_empty_n,
        src_data_stream_V1_read => Duplicate130_U0_src_data_stream_V1_read,
        src_data_stream_V2_dout => img_0_data_stream_2_dout,
        src_data_stream_V2_empty_n => img_0_data_stream_2_empty_n,
        src_data_stream_V2_read => Duplicate130_U0_src_data_stream_V2_read,
        dst1_data_stream_V => Duplicate130_U0_dst1_data_stream_V,
        dst1_data_stream_V_ap_vld => Duplicate130_U0_dst1_data_stream_V_ap_vld,
        dst1_data_stream_V3 => Duplicate130_U0_dst1_data_stream_V3,
        dst1_data_stream_V3_ap_vld => Duplicate130_U0_dst1_data_stream_V3_ap_vld,
        dst1_data_stream_V4 => Duplicate130_U0_dst1_data_stream_V4,
        dst1_data_stream_V4_ap_vld => Duplicate130_U0_dst1_data_stream_V4_ap_vld,
        dst2_data_stream_V_din => Duplicate130_U0_dst2_data_stream_V_din,
        dst2_data_stream_V_full_n => img_in2_data_stream_s_full_n,
        dst2_data_stream_V_write => Duplicate130_U0_dst2_data_stream_V_write,
        dst2_data_stream_V5_din => Duplicate130_U0_dst2_data_stream_V5_din,
        dst2_data_stream_V5_full_n => img_in2_data_stream_1_full_n,
        dst2_data_stream_V5_write => Duplicate130_U0_dst2_data_stream_V5_write,
        dst2_data_stream_V6_din => Duplicate130_U0_dst2_data_stream_V6_din,
        dst2_data_stream_V6_full_n => img_in2_data_stream_2_full_n,
        dst2_data_stream_V6_write => Duplicate130_U0_dst2_data_stream_V6_write);

    Duplicate_U0 : component Duplicate
    port map (
        ap_clk => ap_clk,
        ap_rst => ap_rst_n_inv,
        ap_start => Duplicate_U0_ap_start,
        ap_done => Duplicate_U0_ap_done,
        ap_continue => Duplicate_U0_ap_continue,
        ap_idle => Duplicate_U0_ap_idle,
        ap_ready => Duplicate_U0_ap_ready,
        src_data_stream_0_V_dout => img_in2_data_stream_s_dout,
        src_data_stream_0_V_empty_n => img_in2_data_stream_s_empty_n,
        src_data_stream_0_V_read => Duplicate_U0_src_data_stream_0_V_read,
        src_data_stream_1_V_dout => img_in2_data_stream_1_dout,
        src_data_stream_1_V_empty_n => img_in2_data_stream_1_empty_n,
        src_data_stream_1_V_read => Duplicate_U0_src_data_stream_1_V_read,
        src_data_stream_2_V_dout => img_in2_data_stream_2_dout,
        src_data_stream_2_V_empty_n => img_in2_data_stream_2_empty_n,
        src_data_stream_2_V_read => Duplicate_U0_src_data_stream_2_V_read,
        dst1_data_stream_0_V => Duplicate_U0_dst1_data_stream_0_V,
        dst1_data_stream_0_V_ap_vld => Duplicate_U0_dst1_data_stream_0_V_ap_vld,
        dst1_data_stream_1_V => Duplicate_U0_dst1_data_stream_1_V,
        dst1_data_stream_1_V_ap_vld => Duplicate_U0_dst1_data_stream_1_V_ap_vld,
        dst1_data_stream_2_V => Duplicate_U0_dst1_data_stream_2_V,
        dst1_data_stream_2_V_ap_vld => Duplicate_U0_dst1_data_stream_2_V_ap_vld,
        dst2_data_stream_0_V_din => Duplicate_U0_dst2_data_stream_0_V_din,
        dst2_data_stream_0_V_full_n => img_3_data_stream_0_full_n,
        dst2_data_stream_0_V_write => Duplicate_U0_dst2_data_stream_0_V_write,
        dst2_data_stream_1_V_din => Duplicate_U0_dst2_data_stream_1_V_din,
        dst2_data_stream_1_V_full_n => img_3_data_stream_1_full_n,
        dst2_data_stream_1_V_write => Duplicate_U0_dst2_data_stream_1_V_write,
        dst2_data_stream_2_V_din => Duplicate_U0_dst2_data_stream_2_V_din,
        dst2_data_stream_2_V_full_n => img_3_data_stream_2_full_n,
        dst2_data_stream_2_V_write => Duplicate_U0_dst2_data_stream_2_V_write);

    PaintMask_U0 : component PaintMask
    port map (
        ap_clk => ap_clk,
        ap_rst => ap_rst_n_inv,
        ap_start => PaintMask_U0_ap_start,
        start_full_n => PaintMask_U0_start_full_n,
        ap_ready => PaintMask_U0_ap_ready,
        ap_done => PaintMask_U0_ap_done,
        ap_continue => PaintMask_U0_ap_continue,
        ap_idle => PaintMask_U0_ap_idle,
        start_out => PaintMask_U0_start_out,
        start_write => PaintMask_U0_start_write,
        p_src_data_stream_0_V_dout => img_3_data_stream_0_dout,
        p_src_data_stream_0_V_empty_n => img_3_data_stream_0_empty_n,
        p_src_data_stream_0_V_read => PaintMask_U0_p_src_data_stream_0_V_read,
        p_src_data_stream_1_V_dout => img_3_data_stream_1_dout,
        p_src_data_stream_1_V_empty_n => img_3_data_stream_1_empty_n,
        p_src_data_stream_1_V_read => PaintMask_U0_p_src_data_stream_1_V_read,
        p_src_data_stream_2_V_dout => img_3_data_stream_2_dout,
        p_src_data_stream_2_V_empty_n => img_3_data_stream_2_empty_n,
        p_src_data_stream_2_V_read => PaintMask_U0_p_src_data_stream_2_V_read,
        p_mask_data_stream_V => ap_const_lv8_0,
        p_dst_data_stream_0_V_din => PaintMask_U0_p_dst_data_stream_0_V_din,
        p_dst_data_stream_0_V_full_n => img_out_data_stream_s_full_n,
        p_dst_data_stream_0_V_write => PaintMask_U0_p_dst_data_stream_0_V_write,
        p_dst_data_stream_1_V_din => PaintMask_U0_p_dst_data_stream_1_V_din,
        p_dst_data_stream_1_V_full_n => img_out_data_stream_1_full_n,
        p_dst_data_stream_1_V_write => PaintMask_U0_p_dst_data_stream_1_V_write,
        p_dst_data_stream_2_V_din => PaintMask_U0_p_dst_data_stream_2_V_din,
        p_dst_data_stream_2_V_full_n => img_out_data_stream_2_full_n,
        p_dst_data_stream_2_V_write => PaintMask_U0_p_dst_data_stream_2_V_write);

    Mat2AXIvideo_U0 : component Mat2AXIvideo
    port map (
        ap_clk => ap_clk,
        ap_rst => ap_rst_n_inv,
        ap_start => Mat2AXIvideo_U0_ap_start,
        ap_done => Mat2AXIvideo_U0_ap_done,
        ap_continue => Mat2AXIvideo_U0_ap_continue,
        ap_idle => Mat2AXIvideo_U0_ap_idle,
        ap_ready => Mat2AXIvideo_U0_ap_ready,
        img_data_stream_0_V_dout => img_out_data_stream_s_dout,
        img_data_stream_0_V_empty_n => img_out_data_stream_s_empty_n,
        img_data_stream_0_V_read => Mat2AXIvideo_U0_img_data_stream_0_V_read,
        img_data_stream_1_V_dout => img_out_data_stream_1_dout,
        img_data_stream_1_V_empty_n => img_out_data_stream_1_empty_n,
        img_data_stream_1_V_read => Mat2AXIvideo_U0_img_data_stream_1_V_read,
        img_data_stream_2_V_dout => img_out_data_stream_2_dout,
        img_data_stream_2_V_empty_n => img_out_data_stream_2_empty_n,
        img_data_stream_2_V_read => Mat2AXIvideo_U0_img_data_stream_2_V_read,
        video_out_TDATA => Mat2AXIvideo_U0_video_out_TDATA,
        video_out_TVALID => Mat2AXIvideo_U0_video_out_TVALID,
        video_out_TREADY => video_out_TREADY,
        video_out_TKEEP => Mat2AXIvideo_U0_video_out_TKEEP,
        video_out_TSTRB => Mat2AXIvideo_U0_video_out_TSTRB,
        video_out_TUSER => Mat2AXIvideo_U0_video_out_TUSER,
        video_out_TLAST => Mat2AXIvideo_U0_video_out_TLAST,
        video_out_TID => Mat2AXIvideo_U0_video_out_TID,
        video_out_TDEST => Mat2AXIvideo_U0_video_out_TDEST);

    Block_proc154_U0 : component Block_proc154
    port map (
        ap_clk => ap_clk,
        ap_rst => ap_rst_n_inv,
        ap_start => Block_proc154_U0_ap_start,
        ap_done => Block_proc154_U0_ap_done,
        ap_continue => Block_proc154_U0_ap_continue,
        ap_idle => Block_proc154_U0_ap_idle,
        ap_ready => Block_proc154_U0_ap_ready,
        x => Block_proc154_U0_x,
        x_ap_vld => Block_proc154_U0_x_ap_vld,
        y => Block_proc154_U0_y,
        y_ap_vld => Block_proc154_U0_y_ap_vld);

    img_in_rows_V_channe_1_U : component fifo_w10_d1_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => Block_proc_U0_img_in_rows_V_out_din,
        if_full_n => img_in_rows_V_channe_1_full_n,
        if_write => Block_proc_U0_img_in_rows_V_out_write,
        if_dout => img_in_rows_V_channe_1_dout,
        if_empty_n => img_in_rows_V_channe_1_empty_n,
        if_read => AXIvideo2Mat_U0_img_rows_V_read);

    img_in_cols_V_channe_1_U : component fifo_w11_d1_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => Block_proc_U0_img_in_cols_V_out_din,
        if_full_n => img_in_cols_V_channe_1_full_n,
        if_write => Block_proc_U0_img_in_cols_V_out_write,
        if_dout => img_in_cols_V_channe_1_dout,
        if_empty_n => img_in_cols_V_channe_1_empty_n,
        if_read => AXIvideo2Mat_U0_img_cols_V_read);

    img_in_data_stream_0_U : component fifo_w8_d1_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => AXIvideo2Mat_U0_img_data_stream_0_V_din,
        if_full_n => img_in_data_stream_0_full_n,
        if_write => AXIvideo2Mat_U0_img_data_stream_0_V_write,
        if_dout => img_in_data_stream_0_dout,
        if_empty_n => img_in_data_stream_0_empty_n,
        if_read => GaussianBlur_U0_p_src_data_stream_0_V_read);

    img_in_data_stream_1_U : component fifo_w8_d1_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => AXIvideo2Mat_U0_img_data_stream_1_V_din,
        if_full_n => img_in_data_stream_1_full_n,
        if_write => AXIvideo2Mat_U0_img_data_stream_1_V_write,
        if_dout => img_in_data_stream_1_dout,
        if_empty_n => img_in_data_stream_1_empty_n,
        if_read => GaussianBlur_U0_p_src_data_stream_1_V_read);

    img_in_data_stream_2_U : component fifo_w8_d1_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => AXIvideo2Mat_U0_img_data_stream_2_V_din,
        if_full_n => img_in_data_stream_2_full_n,
        if_write => AXIvideo2Mat_U0_img_data_stream_2_V_write,
        if_dout => img_in_data_stream_2_dout,
        if_empty_n => img_in_data_stream_2_empty_n,
        if_read => GaussianBlur_U0_p_src_data_stream_2_V_read);

    img_in_rows_V_channe_U : component fifo_w10_d1_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => AXIvideo2Mat_U0_img_rows_V_out_din,
        if_full_n => img_in_rows_V_channe_full_n,
        if_write => AXIvideo2Mat_U0_img_rows_V_out_write,
        if_dout => img_in_rows_V_channe_dout,
        if_empty_n => img_in_rows_V_channe_empty_n,
        if_read => GaussianBlur_U0_p_src_rows_V_read);

    img_in_cols_V_channe_U : component fifo_w11_d1_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => AXIvideo2Mat_U0_img_cols_V_out_din,
        if_full_n => img_in_cols_V_channe_full_n,
        if_write => AXIvideo2Mat_U0_img_cols_V_out_write,
        if_dout => img_in_cols_V_channe_dout,
        if_empty_n => img_in_cols_V_channe_empty_n,
        if_read => GaussianBlur_U0_p_src_cols_V_read);

    img_0_data_stream_0_U : component fifo_w8_d1_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => GaussianBlur_U0_p_dst_data_stream_0_V_din,
        if_full_n => img_0_data_stream_0_full_n,
        if_write => GaussianBlur_U0_p_dst_data_stream_0_V_write,
        if_dout => img_0_data_stream_0_dout,
        if_empty_n => img_0_data_stream_0_empty_n,
        if_read => Duplicate130_U0_src_data_stream_V_read);

    img_0_data_stream_1_U : component fifo_w8_d1_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => GaussianBlur_U0_p_dst_data_stream_1_V_din,
        if_full_n => img_0_data_stream_1_full_n,
        if_write => GaussianBlur_U0_p_dst_data_stream_1_V_write,
        if_dout => img_0_data_stream_1_dout,
        if_empty_n => img_0_data_stream_1_empty_n,
        if_read => Duplicate130_U0_src_data_stream_V1_read);

    img_0_data_stream_2_U : component fifo_w8_d1_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => GaussianBlur_U0_p_dst_data_stream_2_V_din,
        if_full_n => img_0_data_stream_2_full_n,
        if_write => GaussianBlur_U0_p_dst_data_stream_2_V_write,
        if_dout => img_0_data_stream_2_dout,
        if_empty_n => img_0_data_stream_2_empty_n,
        if_read => Duplicate130_U0_src_data_stream_V2_read);

    img_in2_data_stream_s_U : component fifo_w8_d1_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => Duplicate130_U0_dst2_data_stream_V_din,
        if_full_n => img_in2_data_stream_s_full_n,
        if_write => Duplicate130_U0_dst2_data_stream_V_write,
        if_dout => img_in2_data_stream_s_dout,
        if_empty_n => img_in2_data_stream_s_empty_n,
        if_read => Duplicate_U0_src_data_stream_0_V_read);

    img_in2_data_stream_1_U : component fifo_w8_d1_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => Duplicate130_U0_dst2_data_stream_V5_din,
        if_full_n => img_in2_data_stream_1_full_n,
        if_write => Duplicate130_U0_dst2_data_stream_V5_write,
        if_dout => img_in2_data_stream_1_dout,
        if_empty_n => img_in2_data_stream_1_empty_n,
        if_read => Duplicate_U0_src_data_stream_1_V_read);

    img_in2_data_stream_2_U : component fifo_w8_d1_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => Duplicate130_U0_dst2_data_stream_V6_din,
        if_full_n => img_in2_data_stream_2_full_n,
        if_write => Duplicate130_U0_dst2_data_stream_V6_write,
        if_dout => img_in2_data_stream_2_dout,
        if_empty_n => img_in2_data_stream_2_empty_n,
        if_read => Duplicate_U0_src_data_stream_2_V_read);

    img_3_data_stream_0_U : component fifo_w8_d1_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => Duplicate_U0_dst2_data_stream_0_V_din,
        if_full_n => img_3_data_stream_0_full_n,
        if_write => Duplicate_U0_dst2_data_stream_0_V_write,
        if_dout => img_3_data_stream_0_dout,
        if_empty_n => img_3_data_stream_0_empty_n,
        if_read => PaintMask_U0_p_src_data_stream_0_V_read);

    img_3_data_stream_1_U : component fifo_w8_d1_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => Duplicate_U0_dst2_data_stream_1_V_din,
        if_full_n => img_3_data_stream_1_full_n,
        if_write => Duplicate_U0_dst2_data_stream_1_V_write,
        if_dout => img_3_data_stream_1_dout,
        if_empty_n => img_3_data_stream_1_empty_n,
        if_read => PaintMask_U0_p_src_data_stream_1_V_read);

    img_3_data_stream_2_U : component fifo_w8_d1_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => Duplicate_U0_dst2_data_stream_2_V_din,
        if_full_n => img_3_data_stream_2_full_n,
        if_write => Duplicate_U0_dst2_data_stream_2_V_write,
        if_dout => img_3_data_stream_2_dout,
        if_empty_n => img_3_data_stream_2_empty_n,
        if_read => PaintMask_U0_p_src_data_stream_2_V_read);

    img_out_data_stream_s_U : component fifo_w8_d1_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => PaintMask_U0_p_dst_data_stream_0_V_din,
        if_full_n => img_out_data_stream_s_full_n,
        if_write => PaintMask_U0_p_dst_data_stream_0_V_write,
        if_dout => img_out_data_stream_s_dout,
        if_empty_n => img_out_data_stream_s_empty_n,
        if_read => Mat2AXIvideo_U0_img_data_stream_0_V_read);

    img_out_data_stream_1_U : component fifo_w8_d1_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => PaintMask_U0_p_dst_data_stream_1_V_din,
        if_full_n => img_out_data_stream_1_full_n,
        if_write => PaintMask_U0_p_dst_data_stream_1_V_write,
        if_dout => img_out_data_stream_1_dout,
        if_empty_n => img_out_data_stream_1_empty_n,
        if_read => Mat2AXIvideo_U0_img_data_stream_1_V_read);

    img_out_data_stream_2_U : component fifo_w8_d1_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => PaintMask_U0_p_dst_data_stream_2_V_din,
        if_full_n => img_out_data_stream_2_full_n,
        if_write => PaintMask_U0_p_dst_data_stream_2_V_write,
        if_dout => img_out_data_stream_2_dout,
        if_empty_n => img_out_data_stream_2_empty_n,
        if_read => Mat2AXIvideo_U0_img_data_stream_2_V_read);

    start_for_GaussiaGfk_U : component start_for_GaussiaGfk
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => start_for_GaussianBlur_U0_din,
        if_full_n => start_for_GaussianBlur_U0_full_n,
        if_write => AXIvideo2Mat_U0_start_write,
        if_dout => start_for_GaussianBlur_U0_dout,
        if_empty_n => start_for_GaussianBlur_U0_empty_n,
        if_read => GaussianBlur_U0_ap_ready);

    start_for_DuplicaHfu_U : component start_for_DuplicaHfu
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => start_for_Duplicate130_U0_din,
        if_full_n => start_for_Duplicate130_U0_full_n,
        if_write => GaussianBlur_U0_start_write,
        if_dout => start_for_Duplicate130_U0_dout,
        if_empty_n => start_for_Duplicate130_U0_empty_n,
        if_read => Duplicate130_U0_ap_ready);

    start_for_DuplicaIfE_U : component start_for_DuplicaIfE
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => start_for_Duplicate_U0_din,
        if_full_n => start_for_Duplicate_U0_full_n,
        if_write => Duplicate130_U0_start_write,
        if_dout => start_for_Duplicate_U0_dout,
        if_empty_n => start_for_Duplicate_U0_empty_n,
        if_read => Duplicate_U0_ap_ready);

    start_for_Mat2AXIJfO_U : component start_for_Mat2AXIJfO
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => start_for_Mat2AXIvideo_U0_din,
        if_full_n => start_for_Mat2AXIvideo_U0_full_n,
        if_write => PaintMask_U0_start_write,
        if_dout => start_for_Mat2AXIvideo_U0_dout,
        if_empty_n => start_for_Mat2AXIvideo_U0_empty_n,
        if_read => Mat2AXIvideo_U0_ap_ready);





    ap_reg_Block_proc154_U0_ap_done_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_reg_Block_proc154_U0_ap_done <= ap_const_logic_0;
            else
                if ((ap_const_logic_1 = ap_sync_done)) then 
                    ap_reg_Block_proc154_U0_ap_done <= ap_const_logic_0;
                else 
                    ap_reg_Block_proc154_U0_ap_done <= (Block_proc154_U0_ap_done or ap_reg_Block_proc154_U0_ap_done);
                end if; 
            end if;
        end if;
    end process;


    ap_reg_Mat2AXIvideo_U0_ap_done_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_reg_Mat2AXIvideo_U0_ap_done <= ap_const_logic_0;
            else
                if ((ap_const_logic_1 = ap_sync_done)) then 
                    ap_reg_Mat2AXIvideo_U0_ap_done <= ap_const_logic_0;
                else 
                    ap_reg_Mat2AXIvideo_U0_ap_done <= (Mat2AXIvideo_U0_ap_done or ap_reg_Mat2AXIvideo_U0_ap_done);
                end if; 
            end if;
        end if;
    end process;

    AXIvideo2Mat_U0_ap_continue <= ap_const_logic_1;
    AXIvideo2Mat_U0_ap_start <= ap_start;
    AXIvideo2Mat_U0_start_full_n <= (ap_const_logic_0 or start_for_GaussianBlur_U0_full_n);
    Block_proc154_U0_ap_continue <= ap_sync_done;
    Block_proc154_U0_ap_start <= ap_start;
    Block_proc154_U0_start_full_n <= ap_const_logic_0;
    Block_proc154_U0_start_write <= ap_const_logic_0;
    Block_proc_U0_ap_continue <= ap_const_logic_1;
    Block_proc_U0_ap_start <= ap_start;
    Block_proc_U0_start_full_n <= ap_const_logic_0;
    Block_proc_U0_start_write <= ap_const_logic_0;
    Duplicate130_U0_ap_continue <= ap_const_logic_1;
    Duplicate130_U0_ap_start <= start_for_Duplicate130_U0_empty_n;
    Duplicate130_U0_start_full_n <= (ap_const_logic_0 or start_for_Duplicate_U0_full_n);
    Duplicate_U0_ap_continue <= ap_const_logic_1;
    Duplicate_U0_ap_start <= start_for_Duplicate_U0_empty_n;
    Duplicate_U0_start_full_n <= ap_const_logic_0;
    Duplicate_U0_start_write <= ap_const_logic_0;
    GaussianBlur_U0_ap_continue <= ap_const_logic_1;
    GaussianBlur_U0_ap_start <= start_for_GaussianBlur_U0_empty_n;
    GaussianBlur_U0_start_full_n <= (ap_const_logic_0 or start_for_Duplicate130_U0_full_n);
    Mat2AXIvideo_U0_ap_continue <= ap_sync_done;
    Mat2AXIvideo_U0_ap_start <= start_for_Mat2AXIvideo_U0_empty_n;
    Mat2AXIvideo_U0_start_full_n <= ap_const_logic_0;
    Mat2AXIvideo_U0_start_write <= ap_const_logic_0;
    PaintMask_U0_ap_continue <= ap_const_logic_1;
    PaintMask_U0_ap_start <= ap_const_logic_1;
    PaintMask_U0_start_full_n <= (ap_const_logic_0 or start_for_Mat2AXIvideo_U0_full_n);
    ap_done <= ap_sync_done;
    ap_idle <= (Block_proc_U0_ap_idle and AXIvideo2Mat_U0_ap_idle and GaussianBlur_U0_ap_idle and Duplicate130_U0_ap_idle and Duplicate_U0_ap_idle and PaintMask_U0_ap_idle and Mat2AXIvideo_U0_ap_idle and Block_proc154_U0_ap_idle);
    ap_ready <= AXIvideo2Mat_U0_ap_ready;

    ap_rst_n_inv_assign_proc : process(ap_rst_n)
    begin
                ap_rst_n_inv <= not(ap_rst_n);
    end process;

    ap_sync_continue <= ap_sync_done;
    ap_sync_done <= (ap_reg_Mat2AXIvideo_U0_ap_done and ap_reg_Block_proc154_U0_ap_done);
    ap_sync_ready <= AXIvideo2Mat_U0_ap_ready;
    start_for_Duplicate130_U0_din <= (0=>ap_const_logic_1, others=>'-');
    start_for_Duplicate_U0_din <= (0=>ap_const_logic_1, others=>'-');
    start_for_GaussianBlur_U0_din <= (0=>ap_const_logic_1, others=>'-');
    start_for_Mat2AXIvideo_U0_din <= (0=>ap_const_logic_1, others=>'-');
    video_in_TREADY <= AXIvideo2Mat_U0_video_in_TREADY;
    video_out_TDATA <= Mat2AXIvideo_U0_video_out_TDATA;
    video_out_TDEST <= Mat2AXIvideo_U0_video_out_TDEST;
    video_out_TID <= Mat2AXIvideo_U0_video_out_TID;
    video_out_TKEEP <= Mat2AXIvideo_U0_video_out_TKEEP;
    video_out_TLAST <= Mat2AXIvideo_U0_video_out_TLAST;
    video_out_TSTRB <= Mat2AXIvideo_U0_video_out_TSTRB;
    video_out_TUSER <= Mat2AXIvideo_U0_video_out_TUSER;
    video_out_TVALID <= Mat2AXIvideo_U0_video_out_TVALID;
end behav;
